import os
import pickle
import sqlite3


class Database:


    def __init__(self, prefs):
        self.prefs=prefs
        self.sql=None


    def initDatabase(self, fn):
        # If a DB connection is already open, close it first
        if self.sql:
            # should call commit() first?!?
            self.sql.close()
        print "Opening database ",fn
        self.sql=sqlite3.connect(fn)
        self.sql.text_factory=str


    def checkDatabase(self):
        c=self.sql.cursor()
        accountCount=0
        currencyCount=0
        paymentCount=0
        splitCount=0
        for row in c.execute("SELECT id,name,parties FROM account"):
            accountCount+=1
        for row in c.execute("SELECT id,name,exchange_rate FROM currency"):
            currencyCount+=1
        for row in c.execute("SELECT id,timestamp,description,amount,currency_id,account_id FROM payment"):
            paymentCount+=1
        for row in c.execute("SELECT payment_id,account_id,split FROM split"):
            splitCount+=1

        print "Found %d accounts, %d currencies, %d payments, and %d splits" % (accountCount, currencyCount, paymentCount, splitCount)

    def openDatabase(self, fn):
        self.initDatabase(fn)
        self.checkDatabase()

    def createNewDatabase(self, fn):
        if os.path.isfile(fn):
            os.remove(fn)

        self.initDatabase(fn)

        print "Creating database"
        self.sql.execute('''CREATE TABLE account (
        id INTEGER PRIMARY KEY,
        name STRING,
        parties INTEGER
        )''')

        self.sql.execute('''CREATE TABLE currency (
        id INTEGER PRIMARY KEY,
        name STRING,
        exchange_rate FLOAT
        )''')

        self.sql.execute('''CREATE TABLE payment (
        id INTEGER PRIMARY KEY,
        timestamp DATETIME,
        description STRING,
        amount FLOAT,
        currency_id INTEGER,
        account_id INTEGER
        )''')

        self.sql.execute('''CREATE TABLE split (
        payment_id INTEGER,
        account_id INTEGER,
        split INTEGER
        )''')

        self.checkDatabase()

        self.sql.commit()
        

    def getSql(self):
        return self.sql
