#
# This is the detailed report module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#


import gtk
import sqlite3

class Report:


    def createModel(self):
        # ID, date, desc, amount1, currency, amount2, payer, split, (subtotals), (totals)
        cmd="gtk.ListStore(int,str,str,str,str,str,str,str"
        for row in self.accountModel.store:
            cmd+=",str"
        cmd+=")"
        self.store=eval(cmd)


    def getAccounts(self):
        self.accountIds=[]
        self.accountName={}
        for row in self.sql.execute('SELECT id, name FROM account ORDER BY id'):
            id=row[0]
            self.accountIds.append(id)
            self.accountName[id]=row[1]



    def populateModel(self):
        self.accountTotal={}
        for id in self.accountIds:
            self.accountTotal[id]=0.0
	for row in self.sql.execute('SELECT payment.id,payment.timestamp,payment.description,payment.amount,currency.name,currency.exchange_rate,payment.account_id FROM payment,currency WHERE currency.id=payment.currency_id AND payment.isDeleted=0 ORDER BY timestamp'):
            payment_id=row[0]
            timestamp=row[1]
            desc=row[2]
            amount='%4.2f' % row[3]
            currency=row[4]
            rate=row[5]
            amountConv=row[3]*rate
            amountConvFmt='%.2f'% amountConv
            payer_id=row[6]

            accountTrans={}
            for id in self.accountIds:
                accountTrans[id]=0.0

            transSplit={}
            splitTotal=0
            for row2 in self.sql.execute('SELECT account_id,split FROM split WHERE payment_id=?', (payment_id,)):
                account_id=row2[0]
                split=row2[1]
                splitTotal+=split
                transSplit[account_id]=split
                
	    if splitTotal!=0:
                for id in self.accountIds:
                    if id in transSplit:
                        part=amountConv*float(transSplit[id])/splitTotal
                        accountTrans[id]+=part
                        self.accountTotal[id]+=part
            # Credit the payer
            accountTrans[payer_id]-=amountConv
            self.accountTotal[payer_id]-=amountConv

            #values=[payment_id,timestamp,desc,amount,currency,amountConvFmt,self.accountName[payer_id],'%3.1f'%splitTotal]
            values=[payment_id,timestamp,desc,amount,currency,amountConvFmt,self.accountName[payer_id],splitTotal]
            for id in self.accountIds:
                values.append('%.2f'%accountTrans[id])
            #for id in self.accountIds:
            #    values.append('%.2f'%accountTotal[id])

            self.store.append(values)
        values=[-1,'','','','','','', '']
        for id in self.accountIds:
            values.append('%.2f'%self.accountTotal[id])
        self.store.append(values)
        

    def addColumn(self,title, column, xalign=None):
        # create the TreeViewColumn to display the data
        col = gtk.TreeViewColumn(title)
        col.set_resizable(True)
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        if xalign:
            cell.set_property('xalign', xalign)

        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', column)

    def __init__(self, sql, currencyModel, accountModel, paymentModel):
        self.sql=sql
        self.currencyModel=currencyModel
        self.accountModel=accountModel
        self.paymentModel=paymentModel

        self.createModel()
        self.getAccounts()
        self.populateModel()


    def createGui(self, toplevel):

        self.dialog=gtk.Dialog(title='Report',
                               parent=toplevel,
                               flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                               buttons=(gtk.STOCK_CLOSE, gtk.RESPONSE_ACCEPT))
        self.dialog.set_size_request(700, 400)

        # Account list
        vbox=self.dialog.vbox

	scroll=gtk.ScrolledWindow();
        self.treeview = gtk.TreeView(self.store)
	self.treeview.set_rules_hint(True)
	self.treeview.set_headers_visible(True)
	#self.treeview.connect("cursor-changed", self.selectCb)
        self.treeview.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)


        # create the TreeViewColumns to display the data
        self.addColumn('Date', 1)
        self.addColumn('Description', 2)
        self.addColumn('Amount', 3, 1.0)
        self.addColumn('Currency', 4)
        self.addColumn('Converted', 5, 1.0)
        self.addColumn('Payer', 6)
        self.addColumn('Split', 7, 1.0)

        # Add variable number of columns for the accounts
        i=8
        # subtotal 
        for id in self.accountIds:
            self.addColumn(self.accountName[id], i, 1.0)
            i+=1
        # total
#         for id in self.accountIds:
#             self.addColumn(self.accountName[id], i, 1.0)
#             i+=1
        
        # make it searchable
        #treeview.set_search_column(0)

        # Allow sorting on the column
        #self.tvcolumn.set_sort_column_id(0)

        # Allow drag and drop reordering of rows
        #treeview.set_reorderable(True)

        scroll.add(self.treeview)
        #self.window.add(self.scroll)
        vbox.pack_start(scroll, expand=True, fill=True)
        #frame.add(scroll)
        vbox.show_all()
        return self.dialog



    def createSummaryGui(self, toplevel):

        self.dialog=gtk.Dialog(title='Summary',
                               parent=toplevel,
                               flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                               buttons=(gtk.STOCK_CLOSE, gtk.RESPONSE_ACCEPT))
        #self.dialog.set_size_request(700, 400)

        # Account list
        vbox=self.dialog.vbox

        len(self.accountIds)
        grid=gtk.Table(rows=len(self.accountIds), columns=2,
                       homogeneous=False)
        vbox.pack_start(grid, expand=True, fill=True)

        row=0
        for id in self.accountIds:
            name=self.accountName[id]
            total=self.accountTotal[id]
            if total<0:
                name+=" receives "
            else:
                name+=" has to pay "
            label=gtk.Label(name)
            label.set_alignment(0,0)
            grid.attach(label, 0, 1, row, row+1, gtk.FILL, gtk.FILL)
            label=gtk.Label("%.2f" % abs(self.accountTotal[id]))
            label.set_alignment(1,0)
            grid.attach(label, 1, 2, row, row+1, gtk.FILL, gtk.FILL)
            row+=1

        vbox.show_all()
        return self.dialog

