#
# This is the database property module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import pygtk
pygtk.require('2.0')
import gtk

try:
    import hildon
    isHildon=True
except ImportError:
    isHildon=False


def makePair(grid, row, text):
    label=gtk.Label(text)
    label.set_alignment(0,0)
    grid.attach(label, 0, 1, row, row+1, gtk.FILL, gtk.FILL)
    
    if isHildon:
        b=hildon.NumberEditor(0,99)
    else:
        b=gtk.SpinButton()
        b.set_range(0,99)
        b.set_increments(1,1)
        b.set_numeric(True)
    grid.attach(b, 1, 2, row, row+1, gtk.FILL, gtk.FILL)
    return b

def updateProperty(cursor, key, value):
    #print "updateProperty key=",key,", value=",value
    cursor.execute("SELECT value FROM property WHERE name=?", (key,))
    row=cursor.fetchone()
    if row==None:
        #print "sql insert"
        cursor.execute("INSERT INTO property (name, value) VALUES(?,?)",
                       (key, value))
    else:
        #print "sql update"
        cursor.execute("UPDATE property SET value=? WHERE name=?",
                       (value, key))

def getProperties(sql):
    result={}
    cursor=sql.cursor()
    tip1Default=18
    tip2Default=20
    try:
        cursor.execute("SELECT value FROM property WHERE name='tip1'")
        row=cursor.fetchone()
        if row!=None:
            tip1=int(row[0])
        else:
            tip1=tip1Default
    except ValueError:
        tip1=tip1Default
    result['tip1']=tip1

    try:
        cursor.execute("SELECT value FROM property WHERE name='tip2'")
        row=cursor.fetchone()
        if row!=None:
            tip2=int(row[0])
        else:
            tip2=tip2Default
    except ValueError:
        tip2=tip2Default
    result['tip2']=tip2
    return result
    



class PropertyEditor(gtk.Dialog):



#     def initValues(self, sql):
#         cursor=sql.cursor()
#         tip1Default=18
#         tip2Default=20
#         try:
#             cursor.execute("SELECT value FROM property WHERE name='tip1'")
#             row=cursor.fetchone()
#             if row!=None:
#                 tip1=int(row[0])
#             else:
#                 tip1=tip1Default

#             cursor.execute("SELECT value FROM property WHERE name='tip2'")
#             row=cursor.fetchone()
#             if row!=None:
#                 tip2=int(row[0])
#             else:
#                 tip2=tip2Default
#         except ValueError:
#             tip1=tip1Default
#             tip2=tip2Default
#         #print "tip1=",tip1,"   tip2=",tip2

#         self.tip1.set_value(tip1)
#         self.tip2.set_value(tip2)


    def apply(self, sql):
        result=False
        try:
            tip1=int(self.tip1.get_value())
            tip2=int(self.tip2.get_value())
        except ValueError:
            Main.errorPopup('The values must be integer numbers', self.parent)
        else:
            cursor=sql.cursor()
            updateProperty(cursor, 'tip1', tip1)
            updateProperty(cursor, 'tip2', tip2)
            sql.commit()
            result=True
        return result


    def __init__(self, toplevel, sql):

	gtk.Dialog.__init__(self,
	                    title='Properties',
                            parent=toplevel,
                            flags=gtk.DIALOG_DESTROY_WITH_PARENT,
			   buttons=(gtk.STOCK_APPLY, gtk.RESPONSE_ACCEPT,
                                    gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

        grid=gtk.Table(rows=2, columns=2)
        self.tip1=makePair(grid, 0, 'Tip percentage #1')
        self.tip2=makePair(grid, 1, 'Tip percentage #2')

        props=getProperties(sql)
        self.tip1.set_value(props['tip1'])
        self.tip2.set_value(props['tip2'])

        self.vbox.pack_start(grid, fill=True)
        self.show_all()

        while True:
            response=self.run()
            if response==gtk.RESPONSE_CANCEL:
                break
            if self.apply(sql):
                break
        self.destroy()
