#
# This is the database definition module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import os
import pickle
import sqlite3


class Database:


    def __init__(self, prefs):
        self.prefs=prefs
        self.sql=None


    def initDatabase(self, fn):
        # If a DB connection is already open, close it first
        if self.sql:
            # should call commit() first?!?
            self.sql.close()
        print "Opening database ",fn
        self.sql=sqlite3.connect(fn)
        self.sql.text_factory=str


    def checkDatabase(self):
        c=self.sql.cursor()
        accountCount=0
        currencyCount=0
        paymentCount=0
        splitCount=0

        # Retrieve the schema version
        c.execute("PRAGMA user_version;")
        version=c.fetchone()[0]
        print "Database schema version: ", version

        if version==0:
            # Add tables and fields introduced after splitthetab version 0.3
            print "Updating schema version from 0 to 1"
            c.execute("ALTER TABLE payment ADD COLUMN isDeleted INTEGER DEFAULT 0;")
            c.execute('''CREATE TABLE property (
            name STRING PRIMARY KEY,
            value STRING
            )''')
            c.execute("PRAGMA user_version=1;")
        elif version==1:
            pass
        else:
            raise ValueError('Unknown database schema version ',version)


        # Hit all tables with a query to throw an error if this is not
        # the correct schema
        for row in c.execute("SELECT id,name,parties FROM account"):
            accountCount+=1
        for row in c.execute("SELECT id,name,exchange_rate FROM currency"):
            currencyCount+=1
        for row in c.execute("SELECT id,timestamp,description,amount,currency_id,account_id,isDeleted FROM payment"):
            paymentCount+=1
        for row in c.execute("SELECT payment_id,account_id,split FROM split"):
            splitCount+=1
        for row in c.execute("SELECT name,value FROM property"):
            pass

        print "Found %d accounts, %d currencies, %d payments, and %d splits" % (accountCount, currencyCount, paymentCount, splitCount)

    def openDatabase(self, fn):
        self.initDatabase(fn)
        self.checkDatabase()

    def createNewDatabase(self, fn):
        if os.path.isfile(fn):
            os.remove(fn)

        self.initDatabase(fn)

        print "Creating database"
        self.sql.execute('''CREATE TABLE account (
        id INTEGER PRIMARY KEY,
        name STRING,
        parties INTEGER
        )''')

        self.sql.execute('''CREATE TABLE currency (
        id INTEGER PRIMARY KEY,
        name STRING,
        exchange_rate FLOAT
        )''')

        self.sql.execute('''CREATE TABLE payment (
        id INTEGER PRIMARY KEY,
        timestamp DATETIME,
        description STRING,
        amount FLOAT,
        currency_id INTEGER,
        account_id INTEGER,
        isDeleted INTEGER DEFAULT 0
        )''')

        self.sql.execute('''CREATE TABLE split (
        payment_id INTEGER,
        account_id INTEGER,
        split INTEGER
        )''')

        self.sql.execute('''CREATE TABLE property (
        name STRING PRIMARY KEY,
        value STRING
        )''')

        self.sql.execute('PRAGMA user_version=1;')

        self.checkDatabase()

        self.sql.commit()
        

    def getSql(self):
        return self.sql
