#
# This is the account model module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#


#import pygtk
#pygtk.require('2.0')

import gtk
import sqlite3

class AccountModel:

    def __init__(self):
        # ID, name, parties
        self.sql=None
        self.store = gtk.ListStore(int,str,int)

    def getNameById(self,id):
        for row in self.store:
            if row[0]==id:
                return row[1]
        return 'None'

    def updateTotal(self):
        self.total=0
        for row in self.store:
            self.total+=row[2]

    def initFromDb(self, sql):
        self.sql=sql
	self.store.clear()
	for row in self.sql.execute('SELECT id,name,parties FROM account ORDER BY id'):
            id=row[0]
            name=row[1]
            parties=row[2]
            self.store.append([id, name, parties])
        self.updateTotal()

    def setSelection(self, iter):
        self.selectedIter=iter


    def isValidChange(self, name, parties):
	c=self.sql.cursor()
        # get database ID
        id=self.store[self.selectedIter][0]
        c.execute('SELECT * FROM account WHERE name=? AND id<>?', (name,id))
        result=True
        msg=[]
        if c.fetchone()!=None:
            result=False
            msg.append('You must not specify the name of an existing account')
        try:
            dummy=int(parties)
        except ValueError:
            result=False
            msg.append('The specified number of parties is not a valid number')
        if not result:
            d=gtk.MessageDialog(None, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, "\n\n".join(msg))
            d.set_title('Error')
            d.connect('response', lambda dialog, response: dialog.destroy())
            d.show()
            result=False
        return result
        

    def commitChange(self, name, parties):
        iter=self.selectedIter
	id=self.store[iter][0]
	c=self.sql.cursor()
        c.execute('UPDATE account SET name=?, parties=? WHERE id=?', (name, parties, id))
        self.sql.commit()
        # update the model
        self.store[iter][1]=name
        self.store[iter][2]=int(parties)
        self.updateTotal()
        
    def newUniqueName(self):
        c=self.sql.cursor()
        i=1
        while True:
            name='NoName_'+str(i)
            c.execute('SELECT id FROM account where name=?', (name,))
            if c.fetchone()==None:
                break
            i+=1
        return name

    def addNew(self):
        name=self.newUniqueName()
        parties=1
	c=self.sql.cursor()
        c.execute('INSERT INTO account (name, parties) values(?,?)', (name, parties))
        id=c.lastrowid
        self.sql.commit()

        iter=self.store.append([id,name,parties])
        return iter

    def canDelete(self):
        result=True
        c=self.sql.cursor()
        # get database ID
        id=self.store[self.selectedIter][0]
        # see if this ID is used in any transaction splits
        c.execute('SELECT COUNT(*) FROM split WHERE account_id=? AND split!=0', (id,))
        count=c.fetchone()[0]
        # ... or if it used as the payee anywhere
        c.execute('SELECT COUNT(*) FROM payment WHERE account_id=?', (id,))
        count+=c.fetchone()[0]
        
        if count>0:
            msg='This account is still used by '+str(count)+' splits and transactions'
            d=gtk.MessageDialog(None, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, msg)
            d.set_title('Error')
            d.connect('response', lambda dialog, response: dialog.destroy())
            d.show()
            result=False
        return result

    def doDelete(self):
        c=self.sql.cursor()
        # get database ID
        id=self.store[self.selectedIter][0]
        c.execute('DELETE FROM account WHERE id=?', (id,))
        self.store.remove(self.selectedIter)
        self.selectedIter=None
        self.sql.commit()
