/****
	Speedometer, shows your current speed using GPS
	Copyright (C) 2008 Wellu Mäkinen <wellu@wellu.org>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****/

#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <libosso.h>

#include "callbacks.h"
#include "appdata.h"
#include "ui.h"
#include "util.h"

#define PROGNAME "org.wellu.speedometer"

static AppData *appdata;
static osso_context_t* osso_ctx;

/* Requests delay from screen blanking
 * Should be called at least once in every 60 seconds
 * we're not bothered about errors here as dbus calls
 * either succeed or not. Worst case would be dimmed
 * screen anyway.
 */
static gboolean delay_display_blanking(gpointer data) {
	g_print("Requesting not to blank the screen in the next 60 secs.\n");
	osso_display_blanking_pause(data);
	return TRUE;
}

void init_app() {
	appdata = g_new0(AppData, 1);
	appdata->program = HILDON_PROGRAM(hildon_program_get_instance());
	appdata->window = HILDON_WINDOW(hildon_window_new());
	hildon_program_add_window(appdata->program, appdata->window);

	osso_ctx = osso_initialize(PROGNAME, "1.0", FALSE, NULL);

	delay_display_blanking(osso_ctx);
	g_timeout_add(55000, (GSourceFunc) delay_display_blanking, osso_ctx);
}

void deinit_app() {
	osso_deinitialize(osso_ctx);
	stop_gps(appdata);
}

int main(int argc, char** argv) {
	gtk_init(&argc, &argv);

	init_app();

	// loads images from the disk to the image array
	load_graphics(appdata);

	// set display to 000
	set_digits_to_zero(appdata);

	// inits the ui placement
	create_ui(appdata);

	g_thread_init(NULL);

	show_cardware_dialog();

	start_gps(appdata);

	gtk_main();

	// here we cleanup things
	deinit_app();

	return EXIT_SUCCESS;
}

