/****
	Speedometer, shows your current speed using GPS
	Copyright (C) 2008 Wellu Mäkinen <wellu@wellu.org>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****/

#include <math.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>

#include "util.h"
#include "appdata.h"
#include "callbacks.h"
#include "ui.h"

#ifdef __arm__
	static LocationGPSDevice *device = NULL;
	static LocationGPSDControl *control = NULL;
#endif

void start_gps() {
#ifdef __arm__
	if(!device) {
		device = g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);
		g_signal_connect(device, "changed", G_CALLBACK(location_changed), NULL);
	}
	control = location_gpsd_control_get_default();
	location_gpsd_control_request_status(control);
	if(control->can_control) {
		location_gpsd_control_start(control);
	}
#endif // __arm__
}

void stop_gps() {
#ifdef __arm__
	control = location_gpsd_control_get_default();
	location_gpsd_control_request_status(control);
	if(control->can_control) {
		location_gpsd_control_stop(control);
	}
#endif // __arm__
}

/* Loads the settings from GConf
 *
 */
void load_settings() {

}
