/****
	Speedometer, shows your current speed using GPS
	Copyright (C) 2008 Wellu Mäkinen <wellu@wellu.org>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#ifndef UI_H_
#define UI_H_

#include "appdata.h"

// loads all the graphics from the disk
void load_graphics();

// resets the display to 000.00
void set_digits_to_zero();

// creates all the widgets
void create_ui(AppData* appdata);

// signal handlers
void connect_signals(AppData* appdata);

// changes the conversion unit and sets new graphics according
void change_unit();

// converts and sets the speed on display
void interpret_and_set_speed(gdouble speed);

// shows instructions how to send me a postcard
void show_cardware_dialog();

#endif /* UI_H_ */
