/****
	Speedometer, shows your current speed using GPS
	Copyright (C) 2008 Wellu Mäkinen <wellu@wellu.org>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#ifndef CALLBACKS_H_
#define CALLBACKS_H_

#include <hildon/hildon-window.h>
#include <location/location-gps-device.h>
#include <gtk/gtk.h>

// called by GPSD whenever location changes
void location_changed(LocationGPSDevice* device, gpointer data);

// for hardware keys
gboolean key_press_cb(GtkWidget* widget, GdkEventKey* event, HildonWindow* window);

// for handling long tap
gboolean long_tap(GtkWidget* widget, gpointer data);

// middle event box
gboolean middle_event_box_button_press(GtkWidget* widget, GdkEventButton* event, gpointer data);

#endif /* CALLBACKS_H_ */
