/****
	Speedometer, shows your current speed using GPS
	Copyright (C) 2008 Wellu Mäkinen <wellu@wellu.org>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****/

#include <hildon/hildon-banner.h>
#include <math.h>
#include <glib.h>

#include "callbacks.h"
#include "appdata.h"
#include "ui.h"

void location_changed(LocationGPSDevice* device, gpointer data) {
	// check for NaN before passing values
	if(device->fix->fields & LOCATION_GPS_DEVICE_SPEED_SET) {
		if(!isnan(device->fix->speed)) {
			interpret_and_set_speed(device->fix->speed);
		}
	}
}

gboolean key_press_cb(GtkWidget* widget, GdkEventKey* event, HildonWindow* window) {
	switch (event->keyval) {
	case GDK_Up:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Navigation Key Up");
		return TRUE;

	case GDK_Down:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Navigation Key Down");
		return TRUE;

	case GDK_Left:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Navigation Key Left");
		return TRUE;

	case GDK_Right:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Navigation Key Right");
		return TRUE;

	case GDK_Return:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Navigation Key select");
		return TRUE;

	case GDK_F6:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Full screen");
		return TRUE;

	case GDK_F7:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Increase (zoom in)");
		return TRUE;

	case GDK_F8:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Decrease (zoom out)");
		return TRUE;

	case GDK_Escape:
		hildon_banner_show_information(GTK_WIDGET(window), NULL, "Cancel/Close");
		return TRUE;
	}

	return FALSE;
}

gboolean long_tap(GtkWidget* widget, gpointer data) {
	g_assert(data);
	AppData* appdata = (AppData*) data;
	g_signal_emit_by_name(appdata->window, "delete_event");
	return TRUE;
}

gboolean middle_event_box_button_press(GtkWidget* widget, GdkEventButton* event, gpointer data) {
	g_print("Middle event box pressed\n");
	g_print("Changing conversion unit\n");
	change_unit();
	return TRUE;
}
