// --------------------------------------------------------------------------
// ``Advanced Linux Sound Architecture (ALSA)'' specific audio driver interface.
// --------------------------------------------------------------------------

#ifndef AUDIODRV_H
#define AUDIODRV_H


#include <sidplay/emucfg.h>

#include <alsa/asoundlib.h>

class audioDriver
{

  public:
	audioDriver();

	bool IsThere();

	bool InitAlsa(snd_pcm_t *handle, int bits, int freq, int chans);
	
	bool SetFormat(snd_pcm_t *handle, snd_pcm_hw_params_t *hw_params,
			int inPrecision);

	bool Open(udword freq, int precision, int channels,
			int fragments, int fragBase);

	void Close();

	void Play(ubyte* buffer, int bufferSize);

	bool Reset()
	{
		return true;
	}

	snd_pcm_t *GetAudioHandle()
	{
		return alsa;
	}

	udword GetFrequency()
	{
		return frequency;
    	}

	int GetChannels()
    	{
		return channels;
    	}

	int GetSamplePrecision()
    	{
		return precision;
    	}

	int GetSampleEncoding()
    	{
		return encoding;
    	}

	int GetBlockSize()
	{
		return blockSize;
	}

	int GetFragments()
    	{
		return 0;
    	}

	int GetFragSizeBase()
	{
		return 0;
	}

	const char *GetErrorString()
	{
		return errorString;
	}
			
  private:
	static const char AUDIODEVICE[];
	snd_pcm_t *alsa;

	const char *errorString;

	int blockSize;

	udword frequency;

	// These are constants/enums from ``libsidplay/include/emucfg.h''.
	int encoding;
	int precision;
	int channels;
	int bufShift;
	bool swapEndian;
};


#endif  // AUDIODRV_H
