#!/bin/sh

export DEFINE=""
export APPNAME="shishensho"
export OPTIONS="--cc=/bin/echo --save-temps"
export PACKAGES="--thread --pkg gtk+-2.0 --pkg gdk-2.0 --pkg libglade-2.0 --pkg gmodule-2.0"

# Perform preprocessing and output to C directory
# Arguments to this script are "defined" and passed to CPP
for i in $@
do
 DEFINE="$DEFINE -D$i"
 case $i in
  DEV)
   ;;
  MAEMO)
   PACKAGES="$PACKAGES --pkg hildon-1"
   ;;
  PC)
   ;;
 esac
done
if [ ! -d CPP ]; then mkdir CPP; fi
for f in *.vala; do cpp -P $DEFINE $f CPP/$f; done

GCCLINE=`valac -q $OPTIONS $PACKAGES CPP/*.vala -o $APPNAME -X -g -X "-Wl,--export-dynamic -rdynamic"`
#rm -rf CPP

cat > c-compile.sh << END
#!/bin/sh

# Optimized compilation
#gcc -O3 $GCCLINE
#strip $APPNAME

# Debug & profiling compilation
gcc -pg -g $GCCLINE

END
chmod 700 c-compile.sh

./c-compile.sh $@

