
#include "ShishenSho.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Line.h"
#include "Point.h"
#include "GuiGtk.h"




enum  {
	SHISHEN_SHO_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
static gpointer shishen_sho_parent_class = NULL;
static void shishen_sho_dispose (GObject * obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



void shishen_sho_newPlay (ShishenSho* self) {
	Board* _tmp0;
	g_return_if_fail (IS_SHISHEN_SHO (self));
	_tmp0 = NULL;
	self->board = (_tmp0 = board_build_random_board (self->board_size[0], self->board_size[1], self->difficulty, self->gravity), (self->board == NULL ? NULL : (self->board = (g_object_unref (self->board), NULL))), _tmp0);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, ((GFunc) g_object_unref), NULL);
	g_list_free (self);
}


void shishen_sho_run (ShishenSho* self) {
	gboolean exit;
	g_return_if_fail (IS_SHISHEN_SHO (self));
	exit = FALSE;
	shishen_sho_newPlay (self);
	while (!exit) {
		char* _tmp0;
		GList* pairs;
		char* line;
		char* _tmp2;
		const char* _tmp1;
		_tmp0 = NULL;
		fprintf (stdout, (_tmp0 = board_to_string (self->board)));
		_tmp0 = (g_free (_tmp0), NULL);
		pairs = board_get_pairs (self->board, 1);
		if (g_list_length (pairs) == 0) {
			(pairs == NULL ? NULL : (pairs = (_g_list_free_g_object_unref (pairs), NULL)));
			break;
		}
		fprintf (stdout, "\nPOINT: ");
		line = g_new0 (char, 1);
		_tmp2 = NULL;
		_tmp1 = NULL;
		line = (_tmp2 = (_tmp1 = g_strchomp (fgets (line, 1024, stdin)), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (line = (g_free (line), NULL)), _tmp2);
		fprintf (stdout, "\n");
		if (_vala_strcmp0 (line, "exit") == 0) {
			exit = TRUE;
		} else {
			if (_vala_strcmp0 (line, "help") == 0) {
				{
					GList* l_collection;
					GList* l_it;
					l_collection = pairs;
					for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
						Line* _tmp4;
						Line* l;
						_tmp4 = NULL;
						l = (_tmp4 = ((Line*) l_it->data), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
						{
							char* _tmp3;
							_tmp3 = NULL;
							fprintf (stdout, "%s ", (_tmp3 = line_to_string (l)));
							_tmp3 = (g_free (_tmp3), NULL);
							(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
						}
					}
				}
				fprintf (stdout, "\n");
			} else {
				char** _tmp5;
				gint ab_length1;
				char** ab;
				Point* a;
				Point* b;
				GList* path;
				_tmp5 = NULL;
				ab = (_tmp5 = g_strsplit (line, " ", 2), ab_length1 = -1, _tmp5);
				a = point_from_string (ab[0]);
				b = point_from_string (ab[1]);
				if (a == NULL || b == NULL) {
					ab = (_vala_array_free (ab, ab_length1, ((GDestroyNotify) g_free)), NULL);
					(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
					(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
					(pairs == NULL ? NULL : (pairs = (_g_list_free_g_object_unref (pairs), NULL)));
					line = (g_free (line), NULL);
					continue;
				}
				path = board_get_path (self->board, a, b);
				if (g_list_length (path) > 0) {
					board_set_piece (self->board, a, ((guchar) 0));
					board_set_piece (self->board, b, ((guchar) 0));
				}
				ab = (_vala_array_free (ab, ab_length1, ((GDestroyNotify) g_free)), NULL);
				(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
				(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
				(path == NULL ? NULL : (path = (_g_list_free_g_object_unref (path), NULL)));
			}
		}
		(pairs == NULL ? NULL : (pairs = (_g_list_free_g_object_unref (pairs), NULL)));
		line = (g_free (line), NULL);
	}
}


gint shishen_sho_main (char** args, int args_length1) {
	ShishenSho* ss;
	GuiGtk* gui;
	gint _tmp0;
	ss = g_object_ref_sink (shishen_sho_new ());
	ss->board_size[0] = 6 + 2;
	ss->board_size[1] = 16 + 2;
	shishen_sho_newPlay (ss);
	gui_gtk_gui_init (&args_length1, &args);
	gui = gui_gtk_new ();
	gui_gtk_set_app (gui, ss);
	gui_gtk_gui_main ();
	return (_tmp0 = 0, (ss == NULL ? NULL : (ss = (g_object_unref (ss), NULL))), (gui == NULL ? NULL : (gui = (g_object_unref (gui), NULL))), _tmp0);
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return shishen_sho_main (argv, argc);
}


ShishenSho* shishen_sho_new (void) {
	ShishenSho * self;
	self = g_object_newv (TYPE_SHISHEN_SHO, 0, NULL);
	return self;
}


static void shishen_sho_class_init (ShishenShoClass * klass) {
	shishen_sho_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->dispose = shishen_sho_dispose;
}


static void shishen_sho_init (ShishenSho * self) {
	self->board_size = g_new0 (gint, 2);
	self->board_size_length1 = 2;
	self->difficulty = 1;
	self->gravity = TRUE;
	self->time_counter = TRUE;
}


static void shishen_sho_dispose (GObject * obj) {
	ShishenSho * self;
	self = SHISHEN_SHO (obj);
	(self->board == NULL ? NULL : (self->board = (g_object_unref (self->board), NULL)));
	self->board_size = (g_free (self->board_size), NULL);
	G_OBJECT_CLASS (shishen_sho_parent_class)->dispose (obj);
}


GType shishen_sho_get_type (void) {
	static GType shishen_sho_type_id = 0;
	if (G_UNLIKELY (shishen_sho_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShishenShoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shishen_sho_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShishenSho), 0, (GInstanceInitFunc) shishen_sho_init };
		shishen_sho_type_id = g_type_register_static (GTK_TYPE_OBJECT, "ShishenSho", &g_define_type_info, 0);
	}
	return shishen_sho_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




