using GLib;

public class Point : GLib.Object {
  public Point(int i, int j) {
    this.i=i;
    this.j=j;
  }
  
  public bool equals(Point p) {
    return (i==p.i && j==p.j);
  }
  
  public string to_string() {
    return "(%d,%d)".printf(i,j);
  }
    
  public static Point from_string(string s) {
    string[] ij=s.split(",",2);
    int i=ij[0].to_int();
    int j=ij[1].to_int();
    return new Point(i,j);
  }
  
  public int i { get; set; }
  public int j { get; set; }
  
  public Point copy() {
    return new Point(this.i,this.j);
  }
}
