
#ifndef __POINT_H__
#define __POINT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define TYPE_POINT (point_get_type ())
#define POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POINT, Point))
#define POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POINT, PointClass))
#define IS_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POINT))
#define IS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POINT))
#define POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POINT, PointClass))

typedef struct _Point Point;
typedef struct _PointClass PointClass;
typedef struct _PointPrivate PointPrivate;

struct _Point {
	GObject parent_instance;
	PointPrivate * priv;
};

struct _PointClass {
	GObjectClass parent_class;
};


Point* point_new (gint i, gint j);
gboolean point_equals (Point* self, Point* p);
char* point_to_string (Point* self);
Point* point_from_string (const char* s);
Point* point_copy (Point* self);
gint point_get_i (Point* self);
void point_set_i (Point* self, gint value);
gint point_get_j (Point* self);
void point_set_j (Point* self, gint value);
GType point_get_type (void);


G_END_DECLS

#endif
