
#include "Point.h"




struct _PointPrivate {
	gint _i;
	gint _j;
};

#define POINT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POINT, PointPrivate))
enum  {
	POINT_DUMMY_PROPERTY,
	POINT_I,
	POINT_J
};
static gpointer point_parent_class = NULL;
static void point_dispose (GObject * obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



Point* point_new (gint i, gint j) {
	Point * self;
	self = g_object_newv (TYPE_POINT, 0, NULL);
	point_set_i (self, i);
	point_set_j (self, j);
	return self;
}


gboolean point_equals (Point* self, Point* p) {
	g_return_val_if_fail (IS_POINT (self), FALSE);
	g_return_val_if_fail (IS_POINT (p), FALSE);
	return (self->priv->_i == p->priv->_i && self->priv->_j == p->priv->_j);
}


char* point_to_string (Point* self) {
	g_return_val_if_fail (IS_POINT (self), NULL);
	return g_strdup_printf ("(%d,%d)", self->priv->_i, self->priv->_j);
}


Point* point_from_string (const char* s) {
	char** _tmp0;
	gint ij_length1;
	char** ij;
	gint i;
	gint j;
	Point* _tmp1;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0 = NULL;
	ij = (_tmp0 = g_strsplit (s, ",", 2), ij_length1 = -1, _tmp0);
	i = atoi (ij[0]);
	j = atoi (ij[1]);
	_tmp1 = NULL;
	return (_tmp1 = point_new (i, j), (ij = (_vala_array_free (ij, ij_length1, ((GDestroyNotify) g_free)), NULL)), _tmp1);
}


Point* point_copy (Point* self) {
	g_return_val_if_fail (IS_POINT (self), NULL);
	return point_new (self->priv->_i, self->priv->_j);
}


gint point_get_i (Point* self) {
	g_return_val_if_fail (IS_POINT (self), 0);
	return self->priv->_i;
}


void point_set_i (Point* self, gint value) {
	g_return_if_fail (IS_POINT (self));
	self->priv->_i = value;
}


gint point_get_j (Point* self) {
	g_return_val_if_fail (IS_POINT (self), 0);
	return self->priv->_j;
}


void point_set_j (Point* self, gint value) {
	g_return_if_fail (IS_POINT (self));
	self->priv->_j = value;
}


static void point_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Point * self;
	self = POINT (object);
	switch (property_id) {
		case POINT_I:
		g_value_set_int (value, point_get_i (self));
		break;
		case POINT_J:
		g_value_set_int (value, point_get_j (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void point_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Point * self;
	self = POINT (object);
	switch (property_id) {
		case POINT_I:
		point_set_i (self, g_value_get_int (value));
		break;
		case POINT_J:
		point_set_j (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void point_class_init (PointClass * klass) {
	point_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PointPrivate));
	G_OBJECT_CLASS (klass)->get_property = point_get_property;
	G_OBJECT_CLASS (klass)->set_property = point_set_property;
	G_OBJECT_CLASS (klass)->dispose = point_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POINT_I, g_param_spec_int ("i", "i", "i", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POINT_J, g_param_spec_int ("j", "j", "j", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void point_init (Point * self) {
	self->priv = POINT_GET_PRIVATE (self);
}


static void point_dispose (GObject * obj) {
	Point * self;
	self = POINT (obj);
	G_OBJECT_CLASS (point_parent_class)->dispose (obj);
}


GType point_get_type (void) {
	static GType point_type_id = 0;
	if (G_UNLIKELY (point_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (PointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Point), 0, (GInstanceInitFunc) point_init };
		point_type_id = g_type_register_static (G_TYPE_OBJECT, "Point", &g_define_type_info, 0);
	}
	return point_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}




