
#ifndef __MOVE_H__
#define __MOVE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "Point.h"

G_BEGIN_DECLS


#define TYPE_MOVE (move_get_type ())
#define MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOVE, Move))
#define MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOVE, MoveClass))
#define IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOVE))
#define IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOVE))
#define MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOVE, MoveClass))

typedef struct _Move Move;
typedef struct _MoveClass MoveClass;
typedef struct _MovePrivate MovePrivate;

struct _Move {
	GObject parent_instance;
	MovePrivate * priv;
};

struct _MoveClass {
	GObjectClass parent_class;
};


Move* move_new (Point* a, Point* b, guchar piece);
char* move_to_string (Move* self);
Point* move_get_a (Move* self);
void move_set_a (Move* self, Point* value);
Point* move_get_b (Move* self);
void move_set_b (Move* self, Point* value);
guchar move_get_piece (Move* self);
void move_set_piece (Move* self, guchar value);
GType move_get_type (void);


G_END_DECLS

#endif
