
#include "Move.h"
#include "Board.h"




struct _MovePrivate {
	Point* _a;
	Point* _b;
	guchar _piece;
};

#define MOVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOVE, MovePrivate))
enum  {
	MOVE_DUMMY_PROPERTY,
	MOVE_A,
	MOVE_B,
	MOVE_PIECE
};
static gpointer move_parent_class = NULL;
static void move_dispose (GObject * obj);



Move* move_new (Point* a, Point* b, guchar piece) {
	Move * self;
	g_return_val_if_fail (IS_POINT (a), NULL);
	g_return_val_if_fail (IS_POINT (b), NULL);
	self = g_object_newv (TYPE_MOVE, 0, NULL);
	move_set_a (self, a);
	move_set_b (self, b);
	move_set_piece (self, piece);
	return self;
}


char* move_to_string (Move* self) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp3;
	g_return_val_if_fail (IS_MOVE (self), NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = g_strdup_printf ("%s-%s(%s)", (_tmp0 = point_to_string (self->priv->_a)), (_tmp1 = point_to_string (self->priv->_b)), (_tmp2 = board_piece_to_string (self->priv->_piece))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
}


Point* move_get_a (Move* self) {
	g_return_val_if_fail (IS_MOVE (self), NULL);
	return self->priv->_a;
}


void move_set_a (Move* self, Point* value) {
	Point* _tmp2;
	Point* _tmp1;
	g_return_if_fail (IS_MOVE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_a = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_a == NULL ? NULL : (self->priv->_a = (g_object_unref (self->priv->_a), NULL))), _tmp2);
}


Point* move_get_b (Move* self) {
	g_return_val_if_fail (IS_MOVE (self), NULL);
	return self->priv->_b;
}


void move_set_b (Move* self, Point* value) {
	Point* _tmp2;
	Point* _tmp1;
	g_return_if_fail (IS_MOVE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_b = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_b == NULL ? NULL : (self->priv->_b = (g_object_unref (self->priv->_b), NULL))), _tmp2);
}


guchar move_get_piece (Move* self) {
	g_return_val_if_fail (IS_MOVE (self), '\0');
	return self->priv->_piece;
}


void move_set_piece (Move* self, guchar value) {
	g_return_if_fail (IS_MOVE (self));
	self->priv->_piece = value;
}


static void move_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Move * self;
	self = MOVE (object);
	switch (property_id) {
		case MOVE_A:
		g_value_set_object (value, move_get_a (self));
		break;
		case MOVE_B:
		g_value_set_object (value, move_get_b (self));
		break;
		case MOVE_PIECE:
		g_value_set_uchar (value, move_get_piece (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void move_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Move * self;
	self = MOVE (object);
	switch (property_id) {
		case MOVE_A:
		move_set_a (self, g_value_get_object (value));
		break;
		case MOVE_B:
		move_set_b (self, g_value_get_object (value));
		break;
		case MOVE_PIECE:
		move_set_piece (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void move_class_init (MoveClass * klass) {
	move_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MovePrivate));
	G_OBJECT_CLASS (klass)->get_property = move_get_property;
	G_OBJECT_CLASS (klass)->set_property = move_set_property;
	G_OBJECT_CLASS (klass)->dispose = move_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOVE_A, g_param_spec_object ("a", "a", "a", TYPE_POINT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOVE_B, g_param_spec_object ("b", "b", "b", TYPE_POINT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOVE_PIECE, g_param_spec_pointer ("piece", "piece", "piece", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void move_init (Move * self) {
	self->priv = MOVE_GET_PRIVATE (self);
}


static void move_dispose (GObject * obj) {
	Move * self;
	self = MOVE (obj);
	(self->priv->_a == NULL ? NULL : (self->priv->_a = (g_object_unref (self->priv->_a), NULL)));
	(self->priv->_b == NULL ? NULL : (self->priv->_b = (g_object_unref (self->priv->_b), NULL)));
	G_OBJECT_CLASS (move_parent_class)->dispose (obj);
}


GType move_get_type (void) {
	static GType move_type_id = 0;
	if (G_UNLIKELY (move_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (MoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Move), 0, (GInstanceInitFunc) move_init };
		move_type_id = g_type_register_static (G_TYPE_OBJECT, "Move", &g_define_type_info, 0);
	}
	return move_type_id;
}




