using GLib;

public class Line : GLib.Object {
  public Line(Point a, Point b) {
    this.a=a;
    this.b=b;
  }
  
  public bool equals(Line l) {
    return (a.equals(l.a) && b.equals(l.b));
  }
  
  public bool is_horizontal() {
    return (a.i==b.i);
  }
  
  public bool is_vertical() {
    return (a.j==b.j);
  }
  
  public bool contains(Point p) {
    return (p.i==a.i && p.i==b.i && p.j>=get_min().j && p.j<=get_max().j)
      || (p.j==a.j && p.j==b.j && p.i>=get_min().i && p.i<=get_max().i);
  }
  
  public Point? cuts(Line l) {
    if (is_horizontal() && l.is_vertical() 
      && get_min().j<=l.a.j && get_max().j>=l.a.j 
      && l.get_min().i<=a.i && l.get_max().i>=a.i ) {
      return new Point(a.i,l.a.j);
    } else if (is_vertical() && l.is_horizontal()
      && get_min().i<=l.a.i && get_max().i>=l.a.i 
      && l.get_min().j<=a.j && l.get_max().j>=a.j ) {
      return new Point(l.a.i,a.j);
    } else return null;
  }
  
  public Point get_min() {
    if (a.i<b.i || a.j<b.j) return a;
    else return b;
  }
  
  public Point get_max() {
    if (a.i>b.i || a.j>b.j) return a;
    else return b;
  }
  
  public string to_string() {
    return "%s-%s".printf(a.to_string(),b.to_string());
  }
  
  public Point a { get; set; }
  public Point b { get; set; }
}
