
#ifndef __LINE_H__
#define __LINE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "Point.h"

G_BEGIN_DECLS


#define TYPE_LINE (line_get_type ())
#define LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINE, Line))
#define LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINE, LineClass))
#define IS_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINE))
#define IS_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINE))
#define LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINE, LineClass))

typedef struct _Line Line;
typedef struct _LineClass LineClass;
typedef struct _LinePrivate LinePrivate;

struct _Line {
	GObject parent_instance;
	LinePrivate * priv;
};

struct _LineClass {
	GObjectClass parent_class;
};


Line* line_new (Point* a, Point* b);
gboolean line_equals (Line* self, Line* l);
gboolean line_is_horizontal (Line* self);
gboolean line_is_vertical (Line* self);
gboolean line_contains (Line* self, Point* p);
Point* line_cuts (Line* self, Line* l);
Point* line_get_min (Line* self);
Point* line_get_max (Line* self);
char* line_to_string (Line* self);
Point* line_get_a (Line* self);
void line_set_a (Line* self, Point* value);
Point* line_get_b (Line* self);
void line_set_b (Line* self, Point* value);
GType line_get_type (void);


G_END_DECLS

#endif
