
#include "Line.h"




struct _LinePrivate {
	Point* _a;
	Point* _b;
};

#define LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LINE, LinePrivate))
enum  {
	LINE_DUMMY_PROPERTY,
	LINE_A,
	LINE_B
};
static gpointer line_parent_class = NULL;
static void line_dispose (GObject * obj);



Line* line_new (Point* a, Point* b) {
	Line * self;
	g_return_val_if_fail (IS_POINT (a), NULL);
	g_return_val_if_fail (IS_POINT (b), NULL);
	self = g_object_newv (TYPE_LINE, 0, NULL);
	line_set_a (self, a);
	line_set_b (self, b);
	return self;
}


gboolean line_equals (Line* self, Line* l) {
	g_return_val_if_fail (IS_LINE (self), FALSE);
	g_return_val_if_fail (IS_LINE (l), FALSE);
	return (point_equals (self->priv->_a, l->priv->_a) && point_equals (self->priv->_b, l->priv->_b));
}


gboolean line_is_horizontal (Line* self) {
	g_return_val_if_fail (IS_LINE (self), FALSE);
	return (point_get_i (self->priv->_a) == point_get_i (self->priv->_b));
}


gboolean line_is_vertical (Line* self) {
	g_return_val_if_fail (IS_LINE (self), FALSE);
	return (point_get_j (self->priv->_a) == point_get_j (self->priv->_b));
}


gboolean line_contains (Line* self, Point* p) {
	Point* _tmp3;
	Point* _tmp2;
	Point* _tmp1;
	Point* _tmp0;
	gboolean _tmp4;
	g_return_val_if_fail (IS_LINE (self), FALSE);
	g_return_val_if_fail (IS_POINT (p), FALSE);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	return (_tmp4 = (point_get_i (p) == point_get_i (self->priv->_a) && point_get_i (p) == point_get_i (self->priv->_b) && point_get_j (p) >= point_get_j ((_tmp0 = line_get_min (self))) && point_get_j (p) <= point_get_j ((_tmp1 = line_get_max (self)))) || (point_get_j (p) == point_get_j (self->priv->_a) && point_get_j (p) == point_get_j (self->priv->_b) && point_get_i (p) >= point_get_i ((_tmp2 = line_get_min (self))) && point_get_i (p) <= point_get_i ((_tmp3 = line_get_max (self)))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp4);
}


Point* line_cuts (Line* self, Line* l) {
	Point* _tmp3;
	Point* _tmp2;
	Point* _tmp1;
	Point* _tmp0;
	gboolean _tmp4;
	g_return_val_if_fail (IS_LINE (self), NULL);
	g_return_val_if_fail (IS_LINE (l), NULL);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	if ((_tmp4 = line_is_horizontal (self) && line_is_vertical (l) && point_get_j ((_tmp0 = line_get_min (self))) <= point_get_j (l->priv->_a) && point_get_j ((_tmp1 = line_get_max (self))) >= point_get_j (l->priv->_a) && point_get_i ((_tmp2 = line_get_min (l))) <= point_get_i (self->priv->_a) && point_get_i ((_tmp3 = line_get_max (l))) >= point_get_i (self->priv->_a), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp4)) {
		return point_new (point_get_i (self->priv->_a), point_get_j (l->priv->_a));
	} else {
		Point* _tmp9;
		Point* _tmp8;
		Point* _tmp7;
		Point* _tmp6;
		gboolean _tmp10;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		if ((_tmp10 = line_is_vertical (self) && line_is_horizontal (l) && point_get_i ((_tmp6 = line_get_min (self))) <= point_get_i (l->priv->_a) && point_get_i ((_tmp7 = line_get_max (self))) >= point_get_i (l->priv->_a) && point_get_j ((_tmp8 = line_get_min (l))) <= point_get_j (self->priv->_a) && point_get_j ((_tmp9 = line_get_max (l))) >= point_get_j (self->priv->_a), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp10)) {
			return point_new (point_get_i (l->priv->_a), point_get_j (self->priv->_a));
		} else {
			return NULL;
		}
	}
}


Point* line_get_min (Line* self) {
	g_return_val_if_fail (IS_LINE (self), NULL);
	if (point_get_i (self->priv->_a) < point_get_i (self->priv->_b) || point_get_j (self->priv->_a) < point_get_j (self->priv->_b)) {
		Point* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->_a, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	} else {
		Point* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = self->priv->_b, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	}
}


Point* line_get_max (Line* self) {
	g_return_val_if_fail (IS_LINE (self), NULL);
	if (point_get_i (self->priv->_a) > point_get_i (self->priv->_b) || point_get_j (self->priv->_a) > point_get_j (self->priv->_b)) {
		Point* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->_a, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	} else {
		Point* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = self->priv->_b, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	}
}


char* line_to_string (Line* self) {
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	g_return_val_if_fail (IS_LINE (self), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = g_strdup_printf ("%s-%s", (_tmp0 = point_to_string (self->priv->_a)), (_tmp1 = point_to_string (self->priv->_b))), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
}


Point* line_get_a (Line* self) {
	g_return_val_if_fail (IS_LINE (self), NULL);
	return self->priv->_a;
}


void line_set_a (Line* self, Point* value) {
	Point* _tmp2;
	Point* _tmp1;
	g_return_if_fail (IS_LINE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_a = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_a == NULL ? NULL : (self->priv->_a = (g_object_unref (self->priv->_a), NULL))), _tmp2);
}


Point* line_get_b (Line* self) {
	g_return_val_if_fail (IS_LINE (self), NULL);
	return self->priv->_b;
}


void line_set_b (Line* self, Point* value) {
	Point* _tmp2;
	Point* _tmp1;
	g_return_if_fail (IS_LINE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_b = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_b == NULL ? NULL : (self->priv->_b = (g_object_unref (self->priv->_b), NULL))), _tmp2);
}


static void line_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Line * self;
	self = LINE (object);
	switch (property_id) {
		case LINE_A:
		g_value_set_object (value, line_get_a (self));
		break;
		case LINE_B:
		g_value_set_object (value, line_get_b (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void line_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Line * self;
	self = LINE (object);
	switch (property_id) {
		case LINE_A:
		line_set_a (self, g_value_get_object (value));
		break;
		case LINE_B:
		line_set_b (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void line_class_init (LineClass * klass) {
	line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LinePrivate));
	G_OBJECT_CLASS (klass)->get_property = line_get_property;
	G_OBJECT_CLASS (klass)->set_property = line_set_property;
	G_OBJECT_CLASS (klass)->dispose = line_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LINE_A, g_param_spec_object ("a", "a", "a", TYPE_POINT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LINE_B, g_param_spec_object ("b", "b", "b", TYPE_POINT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void line_init (Line * self) {
	self->priv = LINE_GET_PRIVATE (self);
}


static void line_dispose (GObject * obj) {
	Line * self;
	self = LINE (obj);
	(self->priv->_a == NULL ? NULL : (self->priv->_a = (g_object_unref (self->priv->_a), NULL)));
	(self->priv->_b == NULL ? NULL : (self->priv->_b = (g_object_unref (self->priv->_b), NULL)));
	G_OBJECT_CLASS (line_parent_class)->dispose (obj);
}


GType line_get_type (void) {
	static GType line_type_id = 0;
	if (G_UNLIKELY (line_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (LineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Line), 0, (GInstanceInitFunc) line_init };
		line_type_id = g_type_register_static (G_TYPE_OBJECT, "Line", &g_define_type_info, 0);
	}
	return line_type_id;
}




