
#include "GuiGtk.h"
#include <glade/glade.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <hildon/hildon.h>
#include <stdio.h>
#include <gmodule.h>
#include <pango/pango.h>
#include <glib/gstdio.h>
#include "Board.h"
#include "Point.h"
#include "Line.h"
#include <string.h>




struct _GuiGtkPrivate {
	char* BASE_PATH;
	gint SCREEN_WIDTH;
	gint SCREEN_HEIGHT;
	gint TILE_HEIGHT;
	gint TILE_WIDTH;
	GladeXML* xml;
	GtkMenuShell* menu;
	GtkDrawingArea* draw;
	GdkPixbuf* bg;
	GdkPixbuf** tile;
	gint tile_length1;
	GtkWindow* winabout;
	GtkImageMenuItem* undo;
	HildonProgram* hprogram;
	HildonWindow* hwin;
	gboolean fullscreen;
	gint* selection1;
	gint selection1_length1;
	gint* selection2;
	gint selection2_length1;
	GList* path;
	GList* pairs;
	GTimeVal start_time;
	GTimeVal play_time;
	gboolean timer_registered;
	ShishenSho* _app;
};

#define GUI_GTK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GUI_GTK, GuiGtkPrivate))
enum  {
	GUI_GTK_DUMMY_PROPERTY,
	GUI_GTK_APP
};
static void _g_list_free_g_object_unref (GList* self);
static void gui_gtk_paint (GuiGtk* self, gint pstate);
static void gui_gtk_control (GuiGtk* self, gint cstate);
static void gui_gtk_sleep (GuiGtk* self, gint deci_seconds);
static void gui_gtk_load_tileset (GuiGtk* self, const char* filename, GError** error);
static void gui_gtk_load_background (GuiGtk* self, const char* filename, GError** error);
static gboolean _gui_gtk_on_update_time_gsource_func (gpointer self);
static void gui_gtk_initialize_game (GuiGtk* self);
static void _gui_gtk_connect_signals_glade_xml_connect_func (const char* handler_name, GObject* object, const char* signal_name, const char* signal_data, GObject* connect_object, gboolean after, gpointer self);
static GObject * gui_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gui_gtk_parent_class = NULL;
static void gui_gtk_dispose (GObject * obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const char* GUI_GTK_GLADE_FILENAME = "guigtk.glade";
static const char* GUI_GTK_BG_FILENAME = "pixmaps/kshisen_bgnd.png";
static const char* GUI_GTK_TILESET_FILENAME_CLASSIC = "pixmaps/tileset.png";
static const char* GUI_GTK_TILESET_FILENAME_LETTERS = "pixmaps/tileset_letters.png";
static const gint GUI_GTK_STATE_PLAY_UNINITIALIZED = 0;
static const gint GUI_GTK_STATE_PLAY_IDLE = 1;
static const gint GUI_GTK_STATE_PLAY_SELECTED1 = 2;
static const gint GUI_GTK_STATE_PLAY_SELECTED2 = 3;
static const gint GUI_GTK_STATE_PLAY_GAMEOVER = 4;
static const gint GUI_GTK_STATE_PAINT_BOARD = 0;
static const gint GUI_GTK_STATE_PAINT_SELECTED1 = 1;
static const gint GUI_GTK_STATE_PAINT_SELECTED2 = 2;
static const gint GUI_GTK_STATE_PAINT_MATCHED = 3;
static const gint GUI_GTK_STATE_PAINT_WIN = 4;
static const gint GUI_GTK_STATE_PAINT_LOSE = 5;
static const gint GUI_GTK_STATE_PAINT_HINT = 6;
static const gint GUI_GTK_STATE_PAINT_TIME = 7;
static const gint GUI_GTK_NORMAL_SCREEN_WIDTH = 696;
static const gint GUI_GTK_NORMAL_SCREEN_HEIGHT = 396;
static const gint GUI_GTK_FULL_SCREEN_WIDTH = 800;
static const gint GUI_GTK_FULL_SCREEN_HEIGHT = 480;
static const gint GUI_GTK_DCSEC = 100000;
static const gint GUI_GTK_TILESET_ROWS = 4;
static const gint GUI_GTK_TILESET_COLS = 9;


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, ((GFunc) g_object_unref), NULL);
	g_list_free (self);
}


static void gui_gtk_paint (GuiGtk* self, gint pstate) {
	gint _tmp0;
	g_return_if_fail (IS_GUI_GTK (self));
	self->pstate = pstate;
	_tmp0 = pstate;
	if (_tmp0 == GUI_GTK_STATE_PAINT_BOARD || _tmp0 == GUI_GTK_STATE_PAINT_WIN || _tmp0 == GUI_GTK_STATE_PAINT_LOSE || _tmp0 == GUI_GTK_STATE_PAINT_TIME || _tmp0 == GUI_GTK_STATE_PAINT_HINT)
	do {
		gtk_widget_set_double_buffered (GTK_WIDGET (self->priv->draw), TRUE);
		break;
	} while (0); else if (_tmp0 == GUI_GTK_STATE_PAINT_SELECTED1 || _tmp0 == GUI_GTK_STATE_PAINT_SELECTED2 || _tmp0 == GUI_GTK_STATE_PAINT_MATCHED)
	do {
		gtk_widget_set_double_buffered (GTK_WIDGET (self->priv->draw), FALSE);
		break;
	} while (0);
	gtk_widget_queue_draw (GTK_WIDGET (self->priv->draw));
	gdk_window_process_all_updates ();
}


static void gui_gtk_control (GuiGtk* self, gint cstate) {
	g_return_if_fail (IS_GUI_GTK (self));
	self->cstate = cstate;
}


static void gui_gtk_sleep (GuiGtk* self, gint deci_seconds) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_usleep (((gulong) deci_seconds * GUI_GTK_DCSEC));
}


static void gui_gtk_load_tileset (GuiGtk* self, const char* filename, GError** error) {
	GError * inner_error;
	GdkPixbuf** _tmp1;
	gint _tmp0;
	char* _tmp3;
	char* _tmp2;
	GdkPixbuf* _tmp4;
	GdkPixbuf* tiles;
	gint _tmp5;
	gint _tmp6;
	gint k;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (filename != NULL);
	inner_error = NULL;
	_tmp1 = NULL;
	self->priv->tile = (_tmp1 = g_new0 (GdkPixbuf*, (_tmp0 = GUI_GTK_TILESET_ROWS * GUI_GTK_TILESET_COLS) + 1), (self->priv->tile = (_vala_array_free (self->priv->tile, self->priv->tile_length1, ((GDestroyNotify) g_object_unref)), NULL)), self->priv->tile_length1 = _tmp0, _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp4 = NULL;
	tiles = (_tmp4 = gdk_pixbuf_new_from_file ((_tmp3 = g_strconcat ((_tmp2 = g_strconcat (self->priv->BASE_PATH, "/", NULL)), filename, NULL)), &inner_error), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp4);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	self->priv->TILE_HEIGHT = (g_object_get (G_OBJECT (tiles), "height", &_tmp5, NULL), _tmp5) / GUI_GTK_TILESET_ROWS;
	self->priv->TILE_WIDTH = (g_object_get (G_OBJECT (tiles), "width", &_tmp6, NULL), _tmp6) / GUI_GTK_TILESET_COLS;
	k = 0;
	{
		gint i;
		i = 0;
		for (; i < GUI_GTK_TILESET_ROWS; i++) {
			{
				gint j;
				j = 0;
				for (; j < GUI_GTK_TILESET_COLS; j++) {
					GdkPixbuf* _tmp7;
					_tmp7 = NULL;
					self->priv->tile[k] = (_tmp7 = gdk_pixbuf_new_subpixbuf (tiles, j * self->priv->TILE_WIDTH, i * self->priv->TILE_HEIGHT, self->priv->TILE_WIDTH, self->priv->TILE_HEIGHT), (self->priv->tile[k] == NULL ? NULL : (self->priv->tile[k] = (g_object_unref (self->priv->tile[k]), NULL))), _tmp7);
					k++;
				}
			}
		}
	}
	(tiles == NULL ? NULL : (tiles = (g_object_unref (tiles), NULL)));
}


static void gui_gtk_load_background (GuiGtk* self, const char* filename, GError** error) {
	GError * inner_error;
	GdkPixbuf* _tmp2;
	char* _tmp1;
	char* _tmp0;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (filename != NULL);
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->bg = (_tmp2 = gdk_pixbuf_new_from_file ((_tmp1 = g_strconcat ((_tmp0 = g_strconcat (self->priv->BASE_PATH, "/", NULL)), filename, NULL)), &inner_error), (self->priv->bg == NULL ? NULL : (self->priv->bg = (g_object_unref (self->priv->bg), NULL))), _tmp2);
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp0 = (g_free (_tmp0), NULL);
}


static gboolean _gui_gtk_on_update_time_gsource_func (gpointer self) {
	return gui_gtk_on_update_time (self);
}


static void gui_gtk_initialize_game (GuiGtk* self) {
	GList* _tmp0;
	gboolean _tmp1;
	GTimeVal _tmp2 = {0};
	g_return_if_fail (IS_GUI_GTK (self));
	shishen_sho_newPlay (self->priv->_app);
	_tmp0 = NULL;
	self->priv->pairs = (_tmp0 = board_get_pairs (self->priv->_app->board, 1), (self->priv->pairs == NULL ? NULL : (self->priv->pairs = (_g_list_free_g_object_unref (self->priv->pairs), NULL))), _tmp0);
	g_object_set (GTK_WIDGET (self->priv->undo), "sensitive", FALSE, NULL);
	self->priv->start_time = (memset (&_tmp2, 0, sizeof (GTimeVal)), _tmp2);
	g_get_current_time (&self->priv->start_time);
	self->priv->play_time.tv_usec = ((glong) 0);
	self->priv->play_time.tv_sec = ((glong) 0);
	if (self->priv->_app->time_counter && !self->priv->timer_registered) {
		g_timeout_add (((guint) 1000), _gui_gtk_on_update_time_gsource_func, self);
		self->priv->timer_registered = TRUE;
	}
	self->pstate = GUI_GTK_STATE_PAINT_BOARD;
	gui_gtk_control (self, GUI_GTK_STATE_PLAY_IDLE);
}


void gui_gtk_on_wingame_destroy (GtkWidget* widget) {
	g_return_if_fail (GTK_IS_WIDGET (widget));
	gtk_main_quit ();
}


void gui_gtk_on_new_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	gui_gtk_control (self, GUI_GTK_STATE_PLAY_UNINITIALIZED);
	gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
}


void gui_gtk_on_hint_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	if (self->cstate != GUI_GTK_STATE_PLAY_GAMEOVER) {
		gui_gtk_paint (self, GUI_GTK_STATE_PAINT_HINT);
		gui_gtk_sleep (self, 10);
		gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
		gui_gtk_control (self, GUI_GTK_STATE_PLAY_IDLE);
	}
}


void gui_gtk_on_undo_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	if (board_get_can_undo (self->priv->_app->board)) {
		gboolean _tmp0;
		GList* _tmp1;
		if (self->cstate == GUI_GTK_STATE_PLAY_GAMEOVER && self->priv->_app->time_counter && !self->priv->timer_registered) {
			g_timeout_add (((guint) 1000), _gui_gtk_on_update_time_gsource_func, self);
			self->priv->timer_registered = TRUE;
		}
		board_undo (self->priv->_app->board);
		gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
		g_object_set (GTK_WIDGET (self->priv->undo), "sensitive", board_get_can_undo (self->priv->_app->board), NULL);
		_tmp1 = NULL;
		self->priv->pairs = (_tmp1 = board_get_pairs (self->priv->_app->board, 1), (self->priv->pairs == NULL ? NULL : (self->priv->pairs = (_g_list_free_g_object_unref (self->priv->pairs), NULL))), _tmp1);
		gui_gtk_control (self, GUI_GTK_STATE_PLAY_IDLE);
	}
}


void gui_gtk_on_small_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->board_size[0] = 6 + 2;
	self->priv->_app->board_size[1] = 10 + 2;
	gui_gtk_on_new_activate (widget, self);
}


void gui_gtk_on_medium_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->board_size[0] = 6 + 2;
	self->priv->_app->board_size[1] = 12 + 2;
	gui_gtk_on_new_activate (widget, self);
}


void gui_gtk_on_large_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->board_size[0] = 6 + 2;
	self->priv->_app->board_size[1] = 16 + 2;
	gui_gtk_on_new_activate (widget, self);
}


void gui_gtk_on_hard_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->difficulty = 1;
	gui_gtk_on_new_activate (widget, self);
}


void gui_gtk_on_easy_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->difficulty = 2;
	gui_gtk_on_new_activate (widget, self);
}


void gui_gtk_on_classic_activate (GtkWidget* widget, GuiGtk* self) {
	GError * inner_error;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	inner_error = NULL;
	{
		gui_gtk_load_tileset (self, GUI_GTK_TILESET_FILENAME_CLASSIC, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
		}
		gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stderr, "Error loading files\n");
		}
	}
	__finally0:
	;
}


void gui_gtk_on_letters_activate (GtkWidget* widget, GuiGtk* self) {
	GError * inner_error;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	inner_error = NULL;
	{
		gui_gtk_load_tileset (self, GUI_GTK_TILESET_FILENAME_LETTERS, &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
		}
		gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stderr, "Error loading files\n");
		}
	}
	__finally1:
	;
}


void gui_gtk_on_gravity_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->gravity = !self->priv->_app->gravity;
	gui_gtk_on_new_activate (widget, self);
}


void gui_gtk_on_time_counter_activate (GtkWidget* widget, GuiGtk* self) {
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	self->priv->_app->time_counter = !self->priv->_app->time_counter;
	if (self->priv->_app->time_counter && self->cstate != GUI_GTK_STATE_PLAY_GAMEOVER && !self->priv->timer_registered) {
		g_timeout_add (((guint) 1000), _gui_gtk_on_update_time_gsource_func, self);
		self->priv->timer_registered = TRUE;
	}
}


void gui_gtk_on_about_activate (GtkWidget* widget, GuiGtk* self) {
	gboolean _tmp0;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_object_set (GTK_WIDGET (self->priv->winabout), "visible", TRUE, NULL);
}


void gui_gtk_on_aboutok_clicked (GtkWidget* widget, GuiGtk* self) {
	gboolean _tmp0;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_object_set (GTK_WIDGET (self->priv->winabout), "visible", FALSE, NULL);
}


gboolean gui_gtk_on_key_press (GtkWidget* widget, GdkEventKey* key, GuiGtk* self) {
	gboolean result;
	guint _tmp0;
	g_return_val_if_fail (IS_GUI_GTK (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	result = FALSE;
	_tmp0 = (*key).keyval;
	if (_tmp0 == 0xffc3)
	do {
		if (self->priv->fullscreen) {
			gtk_window_unfullscreen (GTK_WINDOW (self->priv->hwin));
			self->priv->SCREEN_HEIGHT = GUI_GTK_NORMAL_SCREEN_HEIGHT;
			self->priv->SCREEN_WIDTH = GUI_GTK_NORMAL_SCREEN_WIDTH;
		} else {
			gtk_window_fullscreen (GTK_WINDOW (self->priv->hwin));
			self->priv->SCREEN_HEIGHT = GUI_GTK_FULL_SCREEN_HEIGHT;
			self->priv->SCREEN_WIDTH = GUI_GTK_FULL_SCREEN_WIDTH;
		}
		self->priv->fullscreen = !self->priv->fullscreen;
		result = TRUE;
		break;
	} while (0); else if (_tmp0 == 0xff1b)
	do {
		gui_gtk_on_undo_activate (widget, self);
		break;
	} while (0); else if (_tmp0 == 0xffc4)
	do {
		gui_gtk_on_hint_activate (widget, self);
		break;
	} while (0);
	return result;
}


gboolean gui_gtk_on_update_time (GuiGtk* self) {
	gint pstate0;
	g_return_val_if_fail (IS_GUI_GTK (self), FALSE);
	pstate0 = self->pstate;
	gui_gtk_paint (self, GUI_GTK_STATE_PAINT_TIME);
	if (pstate0 == GUI_GTK_STATE_PAINT_BOARD) {
		self->pstate = pstate0;
	} else {
		gui_gtk_paint (self, pstate0);
	}
	self->priv->timer_registered = self->priv->_app->time_counter && self->cstate != GUI_GTK_STATE_PLAY_GAMEOVER;
	return self->priv->timer_registered;
}


void gui_gtk_connect_signals (const char* handler_name, GObject* object, const char* signal_name, const char* signal_data, GObject* connect_object, gboolean after, GuiGtk* self) {
	GModule* module;
	void* sym;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (handler_name != NULL);
	g_return_if_fail (G_IS_OBJECT (object));
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (connect_object == NULL || G_IS_OBJECT (connect_object));
	module = g_module_open (NULL, G_MODULE_BIND_LAZY);
	sym = NULL;
	if (!g_module_symbol (module, handler_name, &sym)) {
		fprintf (stdout, "Symbol not found: %s\n", handler_name);
	} else {
		g_signal_connect (object, signal_name, ((GCallback) sym), self);
	}
	(module == NULL ? NULL : (module = (g_module_close (module), NULL)));
}


void gui_gtk_on_draw_expose_event (GtkWidget* widget, GdkEventExpose* event, GuiGtk* self) {
	gint x0;
	gint y0;
	GdkColor _tmp0 = {0};
	GdkColor red;
	GdkColor _tmp1 = {0};
	GdkColor orange;
	GdkGC* gc;
	gint _tmp6;
	gint _tmp7;
	gint _tmp8;
	gint _tmp10;
	gint _tmp14;
	gint _tmp15;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_return_if_fail (widget == GTK_WIDGET (self->priv->draw));
	if (self->cstate == GUI_GTK_STATE_PLAY_UNINITIALIZED) {
		gui_gtk_initialize_game (self);
	}
	x0 = 0;
	y0 = 0;
	if (self->priv->_app != NULL && self->priv->_app->board != NULL) {
		x0 = (self->priv->SCREEN_WIDTH - self->priv->_app->board->board_size[1] * self->priv->TILE_WIDTH) / 2;
		y0 = (self->priv->SCREEN_HEIGHT - self->priv->_app->board->board_size[0] * self->priv->TILE_HEIGHT) / 2;
	}
	red = (memset (&_tmp0, 0, sizeof (GdkColor)), _tmp0);
	gdk_color_parse ("#F00", &red);
	orange = (memset (&_tmp1, 0, sizeof (GdkColor)), _tmp1);
	gdk_color_parse ("#FC0", &orange);
	gc = gdk_gc_new (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window));
	_tmp6 = self->pstate;
	if (_tmp6 == GUI_GTK_STATE_PAINT_BOARD || _tmp6 == GUI_GTK_STATE_PAINT_TIME || _tmp6 == GUI_GTK_STATE_PAINT_WIN || _tmp6 == GUI_GTK_STATE_PAINT_LOSE || _tmp6 == GUI_GTK_STATE_PAINT_HINT)
	do {
		{
			gint i;
			gint _tmp2;
			i = 0;
			for (; i < self->priv->SCREEN_HEIGHT / (g_object_get (G_OBJECT (self->priv->bg), "height", &_tmp2, NULL), _tmp2) + 1; i++) {
				{
					gint j;
					gint _tmp3;
					j = 0;
					for (; j < self->priv->SCREEN_WIDTH / (g_object_get (G_OBJECT (self->priv->bg), "width", &_tmp3, NULL), _tmp3) + 1; j++) {
						gint _tmp5;
						gint _tmp4;
						gdk_draw_pixbuf (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, self->priv->bg, 0, 0, j * (g_object_get (G_OBJECT (self->priv->bg), "width", &_tmp4, NULL), _tmp4), i * (g_object_get (G_OBJECT (self->priv->bg), "height", &_tmp5, NULL), _tmp5), -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
					}
				}
			}
		}
		if (self->priv->_app != NULL && self->priv->_app->board != NULL) {
			{
				gint i;
				i = 0;
				for (; i < self->priv->_app->board->board_size[0]; i++) {
					{
						gint j;
						j = 0;
						for (; j < self->priv->_app->board->board_size[1]; j++) {
							guchar piece;
							piece = self->priv->_app->board->board[(i) * self->priv->_app->board->board_length2 + (j)];
							if (piece != 0) {
								gdk_draw_pixbuf (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, self->priv->tile[piece], 0, 0, x0 + j * self->priv->TILE_WIDTH, y0 + i * self->priv->TILE_HEIGHT, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
							}
						}
					}
				}
			}
		}
		break;
	} while (0);
	_tmp7 = self->pstate;
	if (_tmp7 == GUI_GTK_STATE_PAINT_SELECTED1)
	do {
		gdk_gc_set_rgb_fg_color (gc, &red);
		gdk_gc_set_line_attributes (gc, 3, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
		gdk_draw_rectangle (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, FALSE, x0 + self->priv->selection1[1] * self->priv->TILE_WIDTH - 2, y0 + self->priv->selection1[0] * self->priv->TILE_HEIGHT - 2, self->priv->TILE_WIDTH + 2 * 2, self->priv->TILE_HEIGHT + 2 * 2);
		break;
	} while (0);
	_tmp8 = self->pstate;
	if (_tmp8 == GUI_GTK_STATE_PAINT_SELECTED2)
	do {
		gdk_gc_set_rgb_fg_color (gc, &red);
		gdk_gc_set_line_attributes (gc, 3, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
		gdk_draw_rectangle (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, FALSE, x0 + self->priv->selection2[1] * self->priv->TILE_WIDTH - 2, y0 + self->priv->selection2[0] * self->priv->TILE_HEIGHT - 2, self->priv->TILE_WIDTH + 2 * 2, self->priv->TILE_HEIGHT + 2 * 2);
		break;
	} while (0);
	_tmp10 = self->pstate;
	if (_tmp10 == GUI_GTK_STATE_PAINT_MATCHED)
	do {
		gdk_gc_set_rgb_fg_color (gc, &red);
		gdk_gc_set_line_attributes (gc, 3, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
		if (self->priv->path != NULL) {
			Point* p0;
			p0 = NULL;
			{
				GList* p1_collection;
				GList* p1_it;
				p1_collection = self->priv->path;
				for (p1_it = p1_collection; p1_it != NULL; p1_it = p1_it->next) {
					Point* _tmp9;
					Point* p1;
					_tmp9 = NULL;
					p1 = (_tmp9 = ((Point*) p1_it->data), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
					{
						if (p0 != NULL) {
							gdk_draw_line (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, x0 + point_get_j (p0) * self->priv->TILE_WIDTH - 2 + (self->priv->TILE_WIDTH / 2), y0 + point_get_i (p0) * self->priv->TILE_HEIGHT - 2 + (self->priv->TILE_HEIGHT / 2), x0 + point_get_j (p1) * self->priv->TILE_WIDTH - 2 + (self->priv->TILE_WIDTH / 2), y0 + point_get_i (p1) * self->priv->TILE_HEIGHT - 2 + (self->priv->TILE_HEIGHT / 2));
						}
						p0 = p1;
						(p1 == NULL ? NULL : (p1 = (g_object_unref (p1), NULL)));
					}
				}
			}
		}
		break;
	} while (0);
	_tmp14 = self->pstate;
	if (_tmp14 == GUI_GTK_STATE_PAINT_HINT)
	do {
		if (self->priv->pairs != NULL && g_list_length (self->priv->pairs) > 0) {
			Line* pair;
			Point* a;
			Point* b;
			GList* _tmp11;
			pair = ((Line*) g_list_first (self->priv->pairs)->data);
			a = line_get_a (pair);
			b = line_get_b (pair);
			_tmp11 = NULL;
			self->priv->path = (_tmp11 = board_get_path (self->priv->_app->board, a, b), (self->priv->path == NULL ? NULL : (self->priv->path = (_g_list_free_g_object_unref (self->priv->path), NULL))), _tmp11);
			gdk_gc_set_rgb_fg_color (gc, &orange);
			gdk_gc_set_line_attributes (gc, 3, GDK_LINE_ON_OFF_DASH, GDK_CAP_ROUND, GDK_JOIN_ROUND);
			gdk_draw_rectangle (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, FALSE, x0 + ((gint) point_get_j (a)) * self->priv->TILE_WIDTH - 2, y0 + ((gint) point_get_i (a)) * self->priv->TILE_HEIGHT - 2, self->priv->TILE_WIDTH + 2 * 2, self->priv->TILE_HEIGHT + 2 * 2);
			if (self->priv->path != NULL) {
				Point* p0;
				GList* _tmp13;
				p0 = NULL;
				{
					GList* p1_collection;
					GList* p1_it;
					p1_collection = self->priv->path;
					for (p1_it = p1_collection; p1_it != NULL; p1_it = p1_it->next) {
						Point* _tmp12;
						Point* p1;
						_tmp12 = NULL;
						p1 = (_tmp12 = ((Point*) p1_it->data), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12)));
						{
							if (p0 != NULL) {
								gdk_draw_line (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, x0 + point_get_j (p0) * self->priv->TILE_WIDTH - 2 + (self->priv->TILE_WIDTH / 2), y0 + point_get_i (p0) * self->priv->TILE_HEIGHT - 2 + (self->priv->TILE_HEIGHT / 2), x0 + point_get_j (p1) * self->priv->TILE_WIDTH - 2 + (self->priv->TILE_WIDTH / 2), y0 + point_get_i (p1) * self->priv->TILE_HEIGHT - 2 + (self->priv->TILE_HEIGHT / 2));
							}
							p0 = p1;
							(p1 == NULL ? NULL : (p1 = (g_object_unref (p1), NULL)));
						}
					}
				}
				_tmp13 = NULL;
				self->priv->path = (_tmp13 = NULL, (self->priv->path == NULL ? NULL : (self->priv->path = (_g_list_free_g_object_unref (self->priv->path), NULL))), _tmp13);
			}
			gdk_draw_rectangle (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, FALSE, x0 + ((gint) point_get_j (b)) * self->priv->TILE_WIDTH - 2, y0 + ((gint) point_get_i (b)) * self->priv->TILE_HEIGHT - 2, self->priv->TILE_WIDTH + 2 * 2, self->priv->TILE_HEIGHT + 2 * 2);
		}
		break;
	} while (0);
	_tmp15 = self->pstate;
	if (_tmp15 == GUI_GTK_STATE_PAINT_WIN)
	do {
		gui_gtk_draw_message (self, self->priv->SCREEN_WIDTH / 2, self->priv->SCREEN_HEIGHT / 2, TRUE, "You Win!", "#FFF", "Sans Bold 100");
		break;
	} while (0); else if (_tmp15 == GUI_GTK_STATE_PAINT_LOSE)
	do {
		gui_gtk_draw_message (self, self->priv->SCREEN_WIDTH / 2, self->priv->SCREEN_HEIGHT / 2, TRUE, "Game Over", "#FFF", "Sans Bold 100");
		break;
	} while (0);
	if (self->priv->_app->time_counter) {
		gint _tmp16;
		_tmp16 = self->pstate;
		if (_tmp16 == GUI_GTK_STATE_PAINT_TIME || _tmp16 == GUI_GTK_STATE_PAINT_BOARD || _tmp16 == GUI_GTK_STATE_PAINT_WIN || _tmp16 == GUI_GTK_STATE_PAINT_LOSE || _tmp16 == GUI_GTK_STATE_PAINT_HINT)
		do {
			gint hours;
			gint minutes;
			gint seconds;
			char* time;
			gint TIME_POS_X;
			gint TIME_POS_Y;
			if (self->cstate != GUI_GTK_STATE_PLAY_GAMEOVER) {
				g_get_current_time (&self->priv->play_time);
				self->priv->play_time.tv_usec = ((glong) 0);
				self->priv->play_time.tv_sec = self->priv->play_time.tv_sec - self->priv->start_time.tv_sec;
			}
			hours = ((gint) (self->priv->play_time.tv_sec / (60 * 60)));
			minutes = ((gint) ((self->priv->play_time.tv_sec / 60) % 60));
			seconds = ((gint) (self->priv->play_time.tv_sec % 60));
			time = g_strdup_printf ("%01d:%02d:%02d", hours, minutes, seconds);
			TIME_POS_X = self->priv->SCREEN_WIDTH - 100;
			TIME_POS_Y = self->priv->SCREEN_HEIGHT - 30;
			gui_gtk_draw_message (self, TIME_POS_X + 3, TIME_POS_Y + 3, FALSE, time, "#000", "Sans Bold 15");
			gui_gtk_draw_message (self, TIME_POS_X, TIME_POS_Y, FALSE, time, "#FFF", "Sans Bold 15");
			time = (g_free (time), NULL);
			break;
		} while (0);
	}
	(gc == NULL ? NULL : (gc = (g_object_unref (gc), NULL)));
}


void gui_gtk_on_draw_button_press_event (GtkWidget* widget, GdkEventButton* event, GuiGtk* self) {
	gint x;
	gint y;
	gint i;
	gint j;
	gint _tmp4;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (GTK_IS_WIDGET (widget));
	x = ((gint) (*event).x);
	y = ((gint) (*event).y);
	i = (y - (self->priv->SCREEN_HEIGHT - self->priv->_app->board->board_size[0] * self->priv->TILE_HEIGHT) / 2) / self->priv->TILE_HEIGHT;
	j = (x - (self->priv->SCREEN_WIDTH - self->priv->_app->board->board_size[1] * self->priv->TILE_WIDTH) / 2) / self->priv->TILE_WIDTH;
	_tmp4 = self->cstate;
	if (_tmp4 == GUI_GTK_STATE_PLAY_IDLE)
	do {
		if (i >= 0 && i < self->priv->_app->board->board_size[0] && j >= 0 && j < self->priv->_app->board->board_size[1] && self->priv->_app->board->board[(i) * self->priv->_app->board->board_length2 + (j)] != 0) {
			self->priv->selection1[0] = i;
			self->priv->selection1[1] = j;
			gui_gtk_paint (self, GUI_GTK_STATE_PAINT_SELECTED1);
			gui_gtk_control (self, GUI_GTK_STATE_PLAY_SELECTED1);
		}
		break;
	} while (0); else if (_tmp4 == GUI_GTK_STATE_PLAY_SELECTED1)
	do {
		if (i >= 0 && i < self->priv->_app->board->board_size[0] && j >= 0 && j < self->priv->_app->board->board_size[1] && self->priv->_app->board->board[(i) * self->priv->_app->board->board_length2 + (j)] != 0) {
			if (i == self->priv->selection1[0] && j == self->priv->selection1[1]) {
				gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
				gui_gtk_control (self, GUI_GTK_STATE_PLAY_IDLE);
			} else {
				Point* a;
				Point* b;
				GList* _tmp0;
				GList* _tmp1;
				GList* _tmp2;
				gboolean _tmp3;
				self->priv->selection2[0] = i;
				self->priv->selection2[1] = j;
				gui_gtk_paint (self, GUI_GTK_STATE_PAINT_SELECTED2);
				a = point_new (self->priv->selection1[0], self->priv->selection1[1]);
				b = point_new (self->priv->selection2[0], self->priv->selection2[1]);
				_tmp0 = NULL;
				self->priv->path = (_tmp0 = board_get_path (self->priv->_app->board, a, b), (self->priv->path == NULL ? NULL : (self->priv->path = (_g_list_free_g_object_unref (self->priv->path), NULL))), _tmp0);
				gui_gtk_paint (self, GUI_GTK_STATE_PAINT_MATCHED);
				gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
				if (g_list_length (self->priv->path) > 0) {
					board_play (self->priv->_app->board, a, b);
				}
				_tmp1 = NULL;
				self->priv->path = (_tmp1 = NULL, (self->priv->path == NULL ? NULL : (self->priv->path = (_g_list_free_g_object_unref (self->priv->path), NULL))), _tmp1);
				gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
				_tmp2 = NULL;
				self->priv->pairs = (_tmp2 = board_get_pairs (self->priv->_app->board, 1), (self->priv->pairs == NULL ? NULL : (self->priv->pairs = (_g_list_free_g_object_unref (self->priv->pairs), NULL))), _tmp2);
				if (g_list_length (self->priv->pairs) == 0) {
					if (board_getNumPieces (self->priv->_app->board) == 0) {
						gui_gtk_paint (self, GUI_GTK_STATE_PAINT_WIN);
					} else {
						gui_gtk_paint (self, GUI_GTK_STATE_PAINT_LOSE);
					}
					gui_gtk_control (self, GUI_GTK_STATE_PLAY_GAMEOVER);
				} else {
					gui_gtk_control (self, GUI_GTK_STATE_PLAY_IDLE);
				}
				g_object_set (GTK_WIDGET (self->priv->undo), "sensitive", board_get_can_undo (self->priv->_app->board), NULL);
				(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
				(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
			}
		}
		break;
	} while (0); else if (_tmp4 == GUI_GTK_STATE_PLAY_GAMEOVER)
	do {
		gui_gtk_on_new_activate (GTK_WIDGET (self->priv->draw), self);
		gui_gtk_paint (self, GUI_GTK_STATE_PAINT_BOARD);
		break;
	} while (0);
}


void gui_gtk_draw_message (GuiGtk* self, gint x, gint y, gboolean centered, const char* message, const char* color, const char* font) {
	GdkColor _tmp0 = {0};
	GdkColor c;
	GdkGC* gc;
	PangoContext* _tmp1;
	PangoContext* pc;
	PangoLayout* pl;
	gint width;
	gint height;
	g_return_if_fail (IS_GUI_GTK (self));
	g_return_if_fail (message != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (font != NULL);
	c = (memset (&_tmp0, 0, sizeof (GdkColor)), _tmp0);
	gdk_color_parse (((const char*) color), &c);
	gc = gdk_gc_new (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window));
	gdk_gc_set_rgb_fg_color (gc, &c);
	_tmp1 = NULL;
	pc = (_tmp1 = gdk_pango_context_get_for_screen (gdk_drawable_get_screen (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	pl = pango_layout_new (pc);
	pango_layout_set_text (pl, message, -1);
	pango_layout_set_font_description (pl, pango_font_description_from_string (font));
	width = 0;
	height = 0;
	pango_layout_get_pixel_size (pl, &width, &height);
	if (centered) {
		gdk_draw_layout (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, x - width / 2, y - height / 2, pl);
	} else {
		gdk_draw_layout (GDK_DRAWABLE (GTK_WIDGET (self->priv->draw)->window), gc, x, y, pl);
	}
	(gc == NULL ? NULL : (gc = (g_object_unref (gc), NULL)));
	(pc == NULL ? NULL : (pc = (g_object_unref (pc), NULL)));
	(pl == NULL ? NULL : (pl = (g_object_unref (pl), NULL)));
}


void gui_gtk_gui_init (int* args_length1, char*** args) {
	gtk_init (&(*args_length1), &(*args));
}


void gui_gtk_gui_main (void) {
	gtk_main ();
}


GuiGtk* gui_gtk_new (void) {
	GuiGtk * self;
	self = g_object_newv (TYPE_GUI_GTK, 0, NULL);
	return self;
}


ShishenSho* gui_gtk_get_app (GuiGtk* self) {
	g_return_val_if_fail (IS_GUI_GTK (self), NULL);
	return self->priv->_app;
}


void gui_gtk_set_app (GuiGtk* self, ShishenSho* value) {
	ShishenSho* _tmp2;
	ShishenSho* _tmp1;
	g_return_if_fail (IS_GUI_GTK (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_app = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_app == NULL ? NULL : (self->priv->_app = (g_object_unref (self->priv->_app), NULL))), _tmp2);
}


static void _gui_gtk_connect_signals_glade_xml_connect_func (const char* handler_name, GObject* object, const char* signal_name, const char* signal_data, GObject* connect_object, gboolean after, gpointer self) {
	gui_gtk_connect_signals (handler_name, object, signal_name, signal_data, connect_object, after, self);
}


static GObject * gui_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GuiGtkClass * klass;
	GObjectClass * parent_class;
	GuiGtk * self;
	GError * inner_error;
	klass = GUI_GTK_CLASS (g_type_class_peek (TYPE_GUI_GTK));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GUI_GTK (obj);
	inner_error = NULL;
	{
		{
			char* bp;
			GladeXML* _tmp7;
			char* _tmp6;
			char* _tmp5;
			GtkDrawingArea* _tmp9;
			GtkDrawingArea* _tmp8;
			GtkMenuShell* _tmp11;
			GtkMenuShell* _tmp10;
			GtkWindow* _tmp13;
			GtkWindow* _tmp12;
			GtkVBox* _tmp14;
			GtkVBox* vbox;
			GtkWindow* _tmp15;
			GtkWindow* wingame;
			HildonProgram* _tmp17;
			HildonProgram* _tmp16;
			HildonWindow* _tmp18;
			GtkImageMenuItem* _tmp20;
			GtkImageMenuItem* _tmp19;
			bp = NULL;
			{
				char** dir_collection;
				char** dir_it;
				int dir_collection_length1;
				dir_collection = g_get_system_data_dirs ();
				dir_collection_length1 = -1;
				for (dir_it = dir_collection; *dir_it != NULL; dir_it = dir_it + 1) {
					const char* _tmp3;
					char* dir;
					_tmp3 = NULL;
					dir = (_tmp3 = *dir_it, (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
					{
						char* _tmp0;
						_tmp0 = NULL;
						bp = (_tmp0 = g_strconcat (dir, "shishensho", NULL), (bp = (g_free (bp), NULL)), _tmp0);
						if (g_file_test (bp, G_FILE_TEST_IS_DIR)) {
							char* _tmp2;
							const char* _tmp1;
							_tmp2 = NULL;
							_tmp1 = NULL;
							self->priv->BASE_PATH = (_tmp2 = (_tmp1 = bp, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->BASE_PATH = (g_free (self->priv->BASE_PATH), NULL)), _tmp2);
							dir = (g_free (dir), NULL);
							break;
						}
						dir = (g_free (dir), NULL);
					}
				}
			}
			if (self->priv->BASE_PATH == NULL) {
				char* _tmp4;
				_tmp4 = NULL;
				self->priv->BASE_PATH = (_tmp4 = g_strdup ("/usr/share/shishensho"), (self->priv->BASE_PATH = (g_free (self->priv->BASE_PATH), NULL)), _tmp4);
			}
			fprintf (stderr, self->priv->BASE_PATH);
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			self->priv->xml = (_tmp7 = glade_xml_new ((_tmp6 = g_strconcat ((_tmp5 = g_strconcat (self->priv->BASE_PATH, "/", NULL)), GUI_GTK_GLADE_FILENAME, NULL)), NULL, NULL), (self->priv->xml == NULL ? NULL : (self->priv->xml = (g_object_unref (self->priv->xml), NULL))), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			glade_xml_signal_autoconnect_full (self->priv->xml, _gui_gtk_connect_signals_glade_xml_connect_func, self);
			_tmp9 = NULL;
			_tmp8 = NULL;
			self->priv->draw = (_tmp9 = (_tmp8 = GTK_DRAWING_AREA (glade_xml_get_widget (self->priv->xml, "draw")), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (self->priv->draw == NULL ? NULL : (self->priv->draw = (g_object_unref (self->priv->draw), NULL))), _tmp9);
			_tmp11 = NULL;
			_tmp10 = NULL;
			self->priv->menu = (_tmp11 = (_tmp10 = GTK_MENU_SHELL (glade_xml_get_widget (self->priv->xml, "menu")), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (self->priv->menu == NULL ? NULL : (self->priv->menu = (g_object_unref (self->priv->menu), NULL))), _tmp11);
			_tmp13 = NULL;
			_tmp12 = NULL;
			self->priv->winabout = (_tmp13 = (_tmp12 = GTK_WINDOW (glade_xml_get_widget (self->priv->xml, "winabout")), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (self->priv->winabout == NULL ? NULL : (self->priv->winabout = (g_object_unref (self->priv->winabout), NULL))), _tmp13);
			gui_gtk_load_background (self, GUI_GTK_BG_FILENAME, &inner_error);
			if (inner_error != NULL) {
				goto __catch2_g_error;
			}
			gui_gtk_load_tileset (self, GUI_GTK_TILESET_FILENAME_CLASSIC, &inner_error);
			if (inner_error != NULL) {
				goto __catch2_g_error;
			}
			_tmp14 = NULL;
			vbox = (_tmp14 = GTK_VBOX (glade_xml_get_widget (self->priv->xml, "vbox")), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
			_tmp15 = NULL;
			wingame = (_tmp15 = GTK_WINDOW (glade_xml_get_widget (self->priv->xml, "wingame")), (_tmp15 == NULL ? NULL : g_object_ref (_tmp15)));
			_tmp17 = NULL;
			_tmp16 = NULL;
			self->priv->hprogram = (_tmp17 = (_tmp16 = hildon_program_get_instance (), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16))), (self->priv->hprogram == NULL ? NULL : (self->priv->hprogram = (g_object_unref (self->priv->hprogram), NULL))), _tmp17);
			_tmp18 = NULL;
			self->priv->hwin = (_tmp18 = g_object_ref_sink (hildon_window_new ()), (self->priv->hwin == NULL ? NULL : (self->priv->hwin = (g_object_unref (self->priv->hwin), NULL))), _tmp18);
			g_object_ref (G_OBJECT (self->priv->draw));
			gtk_container_remove (GTK_CONTAINER (vbox), GTK_WIDGET (self->priv->draw));
			gtk_container_add (GTK_CONTAINER (self->priv->hwin), GTK_WIDGET (self->priv->draw));
			g_object_unref (G_OBJECT (self->priv->draw));
			gui_gtk_connect_signals ("gui_gtk_on_wingame_destroy", G_OBJECT (self->priv->hwin), "destroy", NULL, NULL, FALSE, self);
			gui_gtk_connect_signals ("gui_gtk_on_key_press", G_OBJECT (self->priv->hwin), "key_press_event", NULL, NULL, FALSE, self);
			self->priv->fullscreen = FALSE;
			hildon_window_set_menu (self->priv->hwin, GTK_MENU (self->priv->menu));
			hildon_program_add_window (self->priv->hprogram, self->priv->hwin);
			g_set_application_name (gtk_window_get_title (wingame));
			gtk_widget_show_all (GTK_WIDGET (self->priv->hwin));
			_tmp20 = NULL;
			_tmp19 = NULL;
			self->priv->undo = (_tmp20 = (_tmp19 = GTK_IMAGE_MENU_ITEM (glade_xml_get_widget (self->priv->xml, "undo")), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19))), (self->priv->undo == NULL ? NULL : (self->priv->undo = (g_object_unref (self->priv->undo), NULL))), _tmp20);
			self->cstate = GUI_GTK_STATE_PLAY_UNINITIALIZED;
			bp = (g_free (bp), NULL);
			(vbox == NULL ? NULL : (vbox = (g_object_unref (vbox), NULL)));
			(wingame == NULL ? NULL : (wingame = (g_object_unref (wingame), NULL)));
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stderr, "Error loading files\n");
			}
		}
		__finally2:
		;
	}
	return obj;
}


static void gui_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GuiGtk * self;
	self = GUI_GTK (object);
	switch (property_id) {
		case GUI_GTK_APP:
		g_value_set_object (value, gui_gtk_get_app (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gui_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GuiGtk * self;
	self = GUI_GTK (object);
	switch (property_id) {
		case GUI_GTK_APP:
		gui_gtk_set_app (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gui_gtk_class_init (GuiGtkClass * klass) {
	gui_gtk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GuiGtkPrivate));
	G_OBJECT_CLASS (klass)->get_property = gui_gtk_get_property;
	G_OBJECT_CLASS (klass)->set_property = gui_gtk_set_property;
	G_OBJECT_CLASS (klass)->constructor = gui_gtk_constructor;
	G_OBJECT_CLASS (klass)->dispose = gui_gtk_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GUI_GTK_APP, g_param_spec_object ("app", "app", "app", TYPE_SHISHEN_SHO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gui_gtk_init (GuiGtk * self) {
	self->priv = GUI_GTK_GET_PRIVATE (self);
	self->priv->BASE_PATH = NULL;
	self->priv->SCREEN_WIDTH = GUI_GTK_NORMAL_SCREEN_WIDTH;
	self->priv->SCREEN_HEIGHT = GUI_GTK_NORMAL_SCREEN_HEIGHT;
	self->priv->selection1 = g_new0 (gint, 2);
	self->priv->selection1_length1 = 2;
	self->priv->selection2 = g_new0 (gint, 2);
	self->priv->selection2_length1 = 2;
	self->priv->path = NULL;
	self->priv->pairs = NULL;
	self->priv->timer_registered = FALSE;
}


static void gui_gtk_dispose (GObject * obj) {
	GuiGtk * self;
	self = GUI_GTK (obj);
	self->priv->BASE_PATH = (g_free (self->priv->BASE_PATH), NULL);
	(self->priv->xml == NULL ? NULL : (self->priv->xml = (g_object_unref (self->priv->xml), NULL)));
	(self->priv->menu == NULL ? NULL : (self->priv->menu = (g_object_unref (self->priv->menu), NULL)));
	(self->priv->draw == NULL ? NULL : (self->priv->draw = (g_object_unref (self->priv->draw), NULL)));
	(self->priv->bg == NULL ? NULL : (self->priv->bg = (g_object_unref (self->priv->bg), NULL)));
	self->priv->tile = (_vala_array_free (self->priv->tile, self->priv->tile_length1, ((GDestroyNotify) g_object_unref)), NULL);
	(self->priv->winabout == NULL ? NULL : (self->priv->winabout = (g_object_unref (self->priv->winabout), NULL)));
	(self->priv->undo == NULL ? NULL : (self->priv->undo = (g_object_unref (self->priv->undo), NULL)));
	(self->priv->hprogram == NULL ? NULL : (self->priv->hprogram = (g_object_unref (self->priv->hprogram), NULL)));
	(self->priv->hwin == NULL ? NULL : (self->priv->hwin = (g_object_unref (self->priv->hwin), NULL)));
	self->priv->selection1 = (g_free (self->priv->selection1), NULL);
	self->priv->selection2 = (g_free (self->priv->selection2), NULL);
	(self->priv->path == NULL ? NULL : (self->priv->path = (_g_list_free_g_object_unref (self->priv->path), NULL)));
	(self->priv->pairs == NULL ? NULL : (self->priv->pairs = (_g_list_free_g_object_unref (self->priv->pairs), NULL)));
	(self->priv->_app == NULL ? NULL : (self->priv->_app = (g_object_unref (self->priv->_app), NULL)));
	G_OBJECT_CLASS (gui_gtk_parent_class)->dispose (obj);
}


GType gui_gtk_get_type (void) {
	static GType gui_gtk_type_id = 0;
	if (G_UNLIKELY (gui_gtk_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GuiGtkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gui_gtk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GuiGtk), 0, (GInstanceInitFunc) gui_gtk_init };
		gui_gtk_type_id = g_type_register_static (G_TYPE_OBJECT, "GuiGtk", &g_define_type_info, 0);
	}
	return gui_gtk_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}




