using GLib;
using Gtk;

public class ShishenSho : Gtk.Object {
  public Board board;
  public int[] board_size=new int[2];
  public int difficulty=1;
  public bool gravity=true;
  public bool time_counter=true;

  public void newPlay() {
    board = Board.build_random_board(board_size[0],board_size[1],difficulty,gravity);
  }

  public void run() {
    bool exit=false;
    newPlay();
    while (!exit) {
      stdout.printf(board.to_string());

      List<Line> pairs=board.get_pairs(1);

      if (pairs.length()==0) break;

      stdout.printf("\nPOINT: ");

      string line=new string();
      line=stdin.gets(line,1024).chomp();
      stdout.printf("\n");
      if (line=="exit") exit=true;
      else if (line=="help") {
        foreach (Line l in pairs) {
          stdout.printf("%s ",l.to_string());
        }
        stdout.printf("\n");
      } else {
        string[] ab=line.split(" ",2);
        Point a=Point.from_string(ab[0]);
        Point b=Point.from_string(ab[1]);
        if (a==null || b==null) continue;
        List<Point> path=board.get_path(a,b);




        if (path.length()>0) {
          board.set_piece(a,0);
          board.set_piece(b,0);
        }
      }
    }
  }

  public static int main(string[] args) {
    ShishenSho ss=new ShishenSho();
    ss.board_size[0]=6+2;
    ss.board_size[1]=16+2;
    ss.newPlay();
    GuiGtk.gui_init(ref args);
    var gui=new GuiGtk();
    gui.app=ss;
    GuiGtk.gui_main();
    return 0;
  }
}
