
#ifndef __BOARD_H__
#define __BOARD_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "Point.h"

G_BEGIN_DECLS


#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;
typedef struct _BoardPrivate BoardPrivate;

struct _Board {
	GObject parent_instance;
	BoardPrivate * priv;
	gint difficulty;
	gboolean gravity;
	gint* board_size;
	gint board_size_length1;
	guchar* board;
	gint board_length1;
	gint board_length2;
	GQueue* history;
};

struct _BoardClass {
	GObjectClass parent_class;
};


void board_initialize (Board* self, gint size_i, gint size_j);
char* board_piece_to_string (guchar piece);
guchar board_string_to_piece (const char* piece);
char* board_to_string (Board* self);
Board* board_build_random_board (gint size_i, gint size_j, gint difficulty, gboolean gravity);
GList* board_get_path (Board* self, Point* a, Point* b);
guchar board_get_piece (Board* self, Point* p);
void board_set_piece (Board* self, Point* p, guchar piece);
char* board_get_str_piece (Board* self, Point* p);
void board_set_str_piece (Board* self, Point* p, const char* piece);
void board_play (Board* self, Point* a0, Point* b0);
gboolean board_get_can_undo (Board* self);
void board_undo (Board* self);
GList* board_get_pairs (Board* self, gint max_results);
gint board_getNumPieces (Board* self);
GType board_get_type (void);


G_END_DECLS

#endif
