
#include "Board.h"
#include "Line.h"
#include "Move.h"
#include <string.h>




enum  {
	BOARD_DUMMY_PROPERTY
};
static char* board_charpieces;
static gulong board_rndnext;
static void _g_list_free_g_object_unref (GList* self);
static void _g_list_free_g_list_free (GList* self);
static Board* board_new (void);
static gint board_myrand (Board* self);
static char* board_string_repeat (Board* self, const char* s, gint n);
static gint board_find_free_row (Board* self, gint j);
static GList* board_get_horizontal_lines (Board* self, Point* exclude_a, Point* exclude_b);
static GList* board_get_vertical_lines (Board* self, Point* exclude_a, Point* exclude_b);
static void board_process_gravity (Board* self, Point* p);
static void board_undo_gravity (Board* self, Point* p);
static gpointer board_parent_class = NULL;
static void board_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



void board_initialize (Board* self, gint size_i, gint size_j) {
	gint* _tmp0;
	guchar* _tmp3;
	gint _tmp2;
	gint _tmp1;
	GQueue* _tmp4;
	g_return_if_fail (IS_BOARD (self));
	_tmp0 = NULL;
	self->board_size = (_tmp0 = g_new0 (gint, 2), (self->board_size = (g_free (self->board_size), NULL)), self->board_size_length1 = 2, _tmp0);
	self->board_size[0] = size_i;
	self->board_size[1] = size_j;
	_tmp3 = NULL;
	self->board = (_tmp3 = g_new0 (guchar, (_tmp1 = self->board_size[0]) * (_tmp2 = self->board_size[1])), (self->board = (g_free (self->board), NULL)), self->board_length1 = _tmp1, self->board_length2 = _tmp2, _tmp3);
	{
		gint i;
		i = 0;
		for (; i < self->board_size[0]; i++) {
			{
				gint j;
				j = 0;
				for (; j < self->board_size[1]; j++) {
					self->board[(i) * self->board_length2 + (j)] = ((guchar) 0);
				}
			}
		}
	}
	_tmp4 = NULL;
	self->history = (_tmp4 = g_queue_new (), (self->history == NULL ? NULL : (self->history = (g_queue_free (self->history), NULL))), _tmp4);
}


char* board_piece_to_string (guchar piece) {
	char* _tmp0;
	_tmp0 = NULL;
	return (_tmp0 = g_utf8_offset_to_pointer (board_charpieces, ((glong) piece)), g_strndup (_tmp0, g_utf8_offset_to_pointer (_tmp0, ((glong) 1)) - _tmp0));
}


guchar board_string_to_piece (const char* piece) {
	guchar upiece;
	glong charpieces_len;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	g_return_val_if_fail (piece != NULL, '\0');
	upiece = '\0';
	charpieces_len = strlen (board_charpieces);
	_tmp1 = NULL;
	_tmp0 = NULL;
	for (upiece = ((guchar) 0); (_tmp2 = (upiece < charpieces_len && _vala_strcmp0 ((_tmp1 = g_utf8_offset_to_pointer (board_charpieces, ((glong) upiece)), g_strndup (_tmp1, g_utf8_offset_to_pointer (_tmp1, ((glong) 1)) - _tmp1)), piece) != 0), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2); upiece++) {
		;
	}
	if (upiece < charpieces_len) {
		return upiece;
	} else {
		return ((guchar) 0);
	}
}


char* board_to_string (Board* self) {
	char* result;
	char* _tmp5;
	char* _tmp4;
	char* _tmp3;
	char* _tmp20;
	char* _tmp19;
	char* _tmp18;
	char* _tmp17;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	result = g_strdup ("  ");
	{
		gint j;
		j = 0;
		for (; j < self->board_size[1]; j++) {
			char* _tmp2;
			char* _tmp1;
			if (j > 0) {
				char* _tmp0;
				_tmp0 = NULL;
				result = (_tmp0 = g_strconcat (result, (" "), NULL), (result = (g_free (result), NULL)), _tmp0);
			}
			_tmp2 = NULL;
			_tmp1 = NULL;
			result = (_tmp2 = g_strconcat (result, (_tmp1 = (g_strdup_printf ("%d", j % 10))), NULL), (result = (g_free (result), NULL)), _tmp2);
			_tmp1 = (g_free (_tmp1), NULL);
		}
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	result = (_tmp5 = g_strconcat (result, (_tmp4 = (g_strconcat ("\n  ", (_tmp3 = board_string_repeat (self, "--", self->board_size[1])), NULL))), NULL), (result = (g_free (result), NULL)), _tmp5);
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	{
		gint i;
		i = 0;
		for (; i < self->board_size[0]; i++) {
			char* _tmp7;
			char* _tmp6;
			char* _tmp12;
			_tmp7 = NULL;
			_tmp6 = NULL;
			result = (_tmp7 = g_strconcat (result, (_tmp6 = (g_strdup_printf ("\n%d|", i % 10))), NULL), (result = (g_free (result), NULL)), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			{
				gint j;
				j = 0;
				for (; j < self->board_size[1]; j++) {
					char* _tmp11;
					char* _tmp10;
					char* _tmp9;
					if (j > 0) {
						char* _tmp8;
						_tmp8 = NULL;
						result = (_tmp8 = g_strconcat (result, (" "), NULL), (result = (g_free (result), NULL)), _tmp8);
					}
					_tmp11 = NULL;
					_tmp10 = NULL;
					_tmp9 = NULL;
					result = (_tmp11 = g_strconcat (result, (_tmp10 = ((_tmp9 = g_utf8_offset_to_pointer (board_charpieces, ((glong) self->board[(i) * self->board_length2 + (j)])), g_strndup (_tmp9, g_utf8_offset_to_pointer (_tmp9, ((glong) 1)) - _tmp9)))), NULL), (result = (g_free (result), NULL)), _tmp11);
					_tmp10 = (g_free (_tmp10), NULL);
				}
			}
			_tmp12 = NULL;
			result = (_tmp12 = g_strconcat (result, (" |\n"), NULL), (result = (g_free (result), NULL)), _tmp12);
			if (i < self->board_size[0] - 1) {
				char* _tmp16;
				char* _tmp15;
				char* _tmp14;
				char* _tmp13;
				_tmp16 = NULL;
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				result = (_tmp16 = g_strconcat (result, (_tmp15 = (g_strconcat ((_tmp14 = g_strconcat (" |", (_tmp13 = board_string_repeat (self, "  ", self->board_size[1])), NULL)), "|", NULL))), NULL), (result = (g_free (result), NULL)), _tmp16);
				_tmp15 = (g_free (_tmp15), NULL);
				_tmp14 = (g_free (_tmp14), NULL);
				_tmp13 = (g_free (_tmp13), NULL);
			}
		}
	}
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	result = (_tmp20 = g_strconcat (result, (_tmp19 = (g_strconcat ((_tmp18 = g_strconcat ("  ", (_tmp17 = board_string_repeat (self, "--", self->board_size[1])), NULL)), "\n", NULL))), NULL), (result = (g_free (result), NULL)), _tmp20);
	_tmp19 = (g_free (_tmp19), NULL);
	_tmp18 = (g_free (_tmp18), NULL);
	_tmp17 = (g_free (_tmp17), NULL);
	return result;
}


Board* board_build_random_board (gint size_i, gint size_j, gint difficulty, gboolean gravity) {
	Board* b;
	gint num_different_pieces;
	b = board_new ();
	board_initialize (b, size_i, size_j);
	b->difficulty = difficulty;
	b->gravity = gravity;
	num_different_pieces = ((b->board_size[0] - 2) * (b->board_size[1] - 2) / ((b->difficulty + 1) * 2)) + 1;
	{
		gint n;
		n = 0;
		for (; n < ((b->difficulty + 1) * 2); n++) {
			{
				gchar k;
				k = ((gchar) 0);
				for (; k < num_different_pieces; k++) {
					gint i;
					gint j;
					i = 0;
					j = 0;
					do {
						j = (board_myrand (b) % (b->board_size[1] - 2)) + 1;
						i = board_find_free_row (b, j);
					} while (i < 1);
					b->board[(i) * b->board_length2 + (j)] = ((guchar) k);
				}
			}
		}
	}
	return b;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, ((GFunc) g_object_unref), NULL);
	g_list_free (self);
}


GList* board_get_path (Board* self, Point* a, Point* b) {
	GList* result;
	GList* h;
	GList* v;
	Line* ha;
	Line* va;
	Line* hb;
	Line* vb;
	Point* ab;
	Point* _tmp15;
	Point* _tmp20;
	gpointer _tmp37;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	g_return_val_if_fail (IS_POINT (a), NULL);
	g_return_val_if_fail (IS_POINT (b), NULL);
	result = NULL;
	if (board_get_piece (self, a) != board_get_piece (self, b)) {
		gpointer _tmp0;
		return (_tmp0 = NULL, (result == NULL ? NULL : (result = (_g_list_free_g_object_unref (result), NULL))), _tmp0);
	}
	h = board_get_horizontal_lines (self, a, b);
	v = board_get_vertical_lines (self, a, b);
	ha = NULL;
	va = NULL;
	hb = NULL;
	vb = NULL;
	{
		GList* l_collection;
		GList* l_it;
		l_collection = h;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Line* _tmp5;
			Line* l;
			_tmp5 = NULL;
			l = (_tmp5 = ((Line*) l_it->data), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
			{
				if (line_contains (l, a)) {
					Line* _tmp2;
					Line* _tmp1;
					_tmp2 = NULL;
					_tmp1 = NULL;
					ha = (_tmp2 = (_tmp1 = l, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), _tmp2);
				}
				if (line_contains (l, b)) {
					Line* _tmp4;
					Line* _tmp3;
					_tmp4 = NULL;
					_tmp3 = NULL;
					hb = (_tmp4 = (_tmp3 = l, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), _tmp4);
				}
				if (ha != NULL && hb != NULL) {
					(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
					break;
				}
				(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
			}
		}
	}
	{
		GList* l_collection;
		GList* l_it;
		l_collection = v;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Line* _tmp10;
			Line* l;
			_tmp10 = NULL;
			l = (_tmp10 = ((Line*) l_it->data), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
			{
				if (line_contains (l, a)) {
					Line* _tmp7;
					Line* _tmp6;
					_tmp7 = NULL;
					_tmp6 = NULL;
					va = (_tmp7 = (_tmp6 = l, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), _tmp7);
				}
				if (line_contains (l, b)) {
					Line* _tmp9;
					Line* _tmp8;
					_tmp9 = NULL;
					_tmp8 = NULL;
					vb = (_tmp9 = (_tmp8 = l, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), _tmp9);
				}
				if (va != NULL && vb != NULL) {
					(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
					break;
				}
				(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
			}
		}
	}
	if ((ha == NULL && va == NULL) || (hb == NULL && vb == NULL)) {
		gpointer _tmp11;
		return (_tmp11 = NULL, (result == NULL ? NULL : (result = (_g_list_free_g_object_unref (result), NULL))), (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), _tmp11);
	}
	if (line_equals (ha, hb) || line_equals (va, vb)) {
		Point* _tmp12;
		Point* _tmp13;
		GList* _tmp14;
		_tmp12 = NULL;
		result = g_list_append (result, (_tmp12 = a, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))));
		_tmp13 = NULL;
		result = g_list_append (result, (_tmp13 = b, (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))));
		_tmp14 = NULL;
		return (_tmp14 = result, (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), _tmp14);
	}
	ab = NULL;
	_tmp15 = NULL;
	ab = (_tmp15 = line_cuts (ha, vb), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp15);
	if (ab != NULL) {
		Point* _tmp16;
		Point* _tmp17;
		Point* _tmp18;
		GList* _tmp19;
		_tmp16 = NULL;
		result = g_list_append (result, (_tmp16 = a, (_tmp16 == NULL ? NULL : g_object_ref (_tmp16))));
		_tmp17 = NULL;
		result = g_list_append (result, (_tmp17 = ab, (_tmp17 == NULL ? NULL : g_object_ref (_tmp17))));
		_tmp18 = NULL;
		result = g_list_append (result, (_tmp18 = b, (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))));
		_tmp19 = NULL;
		return (_tmp19 = result, (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp19);
	}
	_tmp20 = NULL;
	ab = (_tmp20 = line_cuts (va, hb), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp20);
	if (ab != NULL) {
		Point* _tmp21;
		Point* _tmp22;
		Point* _tmp23;
		GList* _tmp24;
		_tmp21 = NULL;
		result = g_list_append (result, (_tmp21 = a, (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))));
		_tmp22 = NULL;
		result = g_list_append (result, (_tmp22 = ab, (_tmp22 == NULL ? NULL : g_object_ref (_tmp22))));
		_tmp23 = NULL;
		result = g_list_append (result, (_tmp23 = b, (_tmp23 == NULL ? NULL : g_object_ref (_tmp23))));
		_tmp24 = NULL;
		return (_tmp24 = result, (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp24);
	}
	{
		GList* l_collection;
		GList* l_it;
		l_collection = v;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Line* _tmp30;
			Line* l;
			_tmp30 = NULL;
			l = (_tmp30 = ((Line*) l_it->data), (_tmp30 == NULL ? NULL : g_object_ref (_tmp30)));
			{
				Point* al;
				Point* bl;
				al = line_cuts (l, ha);
				bl = line_cuts (l, hb);
				if (al != NULL && bl != NULL) {
					Point* _tmp25;
					Point* _tmp26;
					Point* _tmp27;
					Point* _tmp28;
					GList* _tmp29;
					_tmp25 = NULL;
					result = g_list_append (result, (_tmp25 = a, (_tmp25 == NULL ? NULL : g_object_ref (_tmp25))));
					_tmp26 = NULL;
					result = g_list_append (result, (_tmp26 = al, (_tmp26 == NULL ? NULL : g_object_ref (_tmp26))));
					_tmp27 = NULL;
					result = g_list_append (result, (_tmp27 = bl, (_tmp27 == NULL ? NULL : g_object_ref (_tmp27))));
					_tmp28 = NULL;
					result = g_list_append (result, (_tmp28 = b, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))));
					_tmp29 = NULL;
					return (_tmp29 = result, (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), (al == NULL ? NULL : (al = (g_object_unref (al), NULL))), (bl == NULL ? NULL : (bl = (g_object_unref (bl), NULL))), (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp29);
				}
				(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
				(al == NULL ? NULL : (al = (g_object_unref (al), NULL)));
				(bl == NULL ? NULL : (bl = (g_object_unref (bl), NULL)));
			}
		}
	}
	{
		GList* l_collection;
		GList* l_it;
		l_collection = h;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Line* _tmp36;
			Line* l;
			_tmp36 = NULL;
			l = (_tmp36 = ((Line*) l_it->data), (_tmp36 == NULL ? NULL : g_object_ref (_tmp36)));
			{
				Point* al;
				Point* bl;
				al = line_cuts (l, va);
				bl = line_cuts (l, vb);
				if (al != NULL && bl != NULL) {
					Point* _tmp31;
					Point* _tmp32;
					Point* _tmp33;
					Point* _tmp34;
					GList* _tmp35;
					_tmp31 = NULL;
					result = g_list_append (result, (_tmp31 = a, (_tmp31 == NULL ? NULL : g_object_ref (_tmp31))));
					_tmp32 = NULL;
					result = g_list_append (result, (_tmp32 = al, (_tmp32 == NULL ? NULL : g_object_ref (_tmp32))));
					_tmp33 = NULL;
					result = g_list_append (result, (_tmp33 = bl, (_tmp33 == NULL ? NULL : g_object_ref (_tmp33))));
					_tmp34 = NULL;
					result = g_list_append (result, (_tmp34 = b, (_tmp34 == NULL ? NULL : g_object_ref (_tmp34))));
					_tmp35 = NULL;
					return (_tmp35 = result, (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), (al == NULL ? NULL : (al = (g_object_unref (al), NULL))), (bl == NULL ? NULL : (bl = (g_object_unref (bl), NULL))), (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp35);
				}
				(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
				(al == NULL ? NULL : (al = (g_object_unref (al), NULL)));
				(bl == NULL ? NULL : (bl = (g_object_unref (bl), NULL)));
			}
		}
	}
	return (_tmp37 = NULL, (result == NULL ? NULL : (result = (_g_list_free_g_object_unref (result), NULL))), (h == NULL ? NULL : (h = (_g_list_free_g_object_unref (h), NULL))), (v == NULL ? NULL : (v = (_g_list_free_g_object_unref (v), NULL))), (ha == NULL ? NULL : (ha = (g_object_unref (ha), NULL))), (va == NULL ? NULL : (va = (g_object_unref (va), NULL))), (hb == NULL ? NULL : (hb = (g_object_unref (hb), NULL))), (vb == NULL ? NULL : (vb = (g_object_unref (vb), NULL))), (ab == NULL ? NULL : (ab = (g_object_unref (ab), NULL))), _tmp37);
}


guchar board_get_piece (Board* self, Point* p) {
	g_return_val_if_fail (IS_BOARD (self), '\0');
	g_return_val_if_fail (IS_POINT (p), '\0');
	return self->board[(point_get_i (p)) * self->board_length2 + (point_get_j (p))];
}


void board_set_piece (Board* self, Point* p, guchar piece) {
	g_return_if_fail (IS_BOARD (self));
	g_return_if_fail (IS_POINT (p));
	self->board[(point_get_i (p)) * self->board_length2 + (point_get_j (p))] = piece;
}


char* board_get_str_piece (Board* self, Point* p) {
	guchar piece;
	char* _tmp0;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	g_return_val_if_fail (IS_POINT (p), NULL);
	piece = self->board[(point_get_i (p)) * self->board_length2 + (point_get_j (p))];
	_tmp0 = NULL;
	return (_tmp0 = g_utf8_offset_to_pointer (board_charpieces, ((glong) piece)), g_strndup (_tmp0, g_utf8_offset_to_pointer (_tmp0, ((glong) 1)) - _tmp0));
}


void board_set_str_piece (Board* self, Point* p, const char* piece) {
	guchar upiece;
	glong charpieces_len;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	g_return_if_fail (IS_BOARD (self));
	g_return_if_fail (IS_POINT (p));
	g_return_if_fail (piece != NULL);
	upiece = '\0';
	charpieces_len = strlen (board_charpieces);
	_tmp1 = NULL;
	_tmp0 = NULL;
	for (upiece = ((guchar) 0); (_tmp2 = (upiece < charpieces_len && _vala_strcmp0 ((_tmp1 = g_utf8_offset_to_pointer (board_charpieces, ((glong) upiece)), g_strndup (_tmp1, g_utf8_offset_to_pointer (_tmp1, ((glong) 1)) - _tmp1)), piece) != 0), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2); upiece++) {
		;
	}
	if (upiece < charpieces_len) {
		self->board[(point_get_i (p)) * self->board_length2 + (point_get_j (p))] = upiece;
	}
}


void board_play (Board* self, Point* a0, Point* b0) {
	Point* _tmp0;
	Point* a;
	Point* _tmp1;
	Point* b;
	Move* m;
	Move* _tmp2;
	g_return_if_fail (IS_BOARD (self));
	g_return_if_fail (IS_POINT (a0));
	g_return_if_fail (IS_POINT (b0));
	_tmp0 = NULL;
	a = (_tmp0 = ((point_get_i (a0) < point_get_i (b0)) ? a0 : b0), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	b = (_tmp1 = ((point_get_i (a0) < point_get_i (b0)) ? b0 : a0), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	m = move_new (a, b, board_get_piece (self, a));
	_tmp2 = NULL;
	g_queue_push_head (self->history, (_tmp2 = m, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))));
	board_set_piece (self, a, ((guchar) 0));
	board_process_gravity (self, a);
	board_set_piece (self, b, ((guchar) 0));
	board_process_gravity (self, b);
	(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
}


gboolean board_get_can_undo (Board* self) {
	g_return_val_if_fail (IS_BOARD (self), FALSE);
	return !g_queue_is_empty (self->history);
}


void board_undo (Board* self) {
	Move* m;
	g_return_if_fail (IS_BOARD (self));
	if (!board_get_can_undo (self)) {
		return;
	}
	m = ((Move*) g_queue_pop_head (self->history));
	board_undo_gravity (self, move_get_b (m));
	board_set_piece (self, move_get_b (m), move_get_piece (m));
	board_undo_gravity (self, move_get_a (m));
	board_set_piece (self, move_get_a (m), move_get_piece (m));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
}


static void _g_list_free_g_list_free (GList* self) {
	g_list_foreach (self, ((GFunc) g_list_free), NULL);
	g_list_free (self);
}


GList* board_get_pairs (Board* self, gint max_results) {
	GList* result;
	GList* pieces;
	GList* piece_points;
	gint nresults;
	gint k;
	GList* _tmp6;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	result = NULL;
	pieces = NULL;
	piece_points = NULL;
	{
		gint i;
		i = 0;
		for (; i < self->board_size[0]; i++) {
			{
				gint j;
				j = 0;
				for (; j < self->board_size[1]; j++) {
					gint piece;
					gint key;
					Point* p;
					piece = ((gint) self->board[(i) * self->board_length2 + (j)]);
					if (piece == 0) {
						continue;
					}
					key = g_list_index (pieces, GINT_TO_POINTER (piece));
					p = point_new (i, j);
					if (key == -1) {
						GList* points0;
						Point* _tmp0;
						GList* _tmp1;
						GList* points1;
						points0 = NULL;
						points0 = g_list_append (points0, (_tmp0 = p, p = NULL, _tmp0));
						pieces = g_list_append (pieces, GINT_TO_POINTER (piece));
						_tmp1 = NULL;
						piece_points = g_list_append (piece_points, (_tmp1 = points0, points0 = NULL, _tmp1));
						key = g_list_index (pieces, GINT_TO_POINTER (piece));
						points1 = ((GList*) g_list_nth_data (piece_points, ((guint) key)));
						(points0 == NULL ? NULL : (points0 = (_g_list_free_g_object_unref (points0), NULL)));
					} else {
						GList* points1;
						Point* _tmp2;
						points1 = ((GList*) g_list_nth_data (piece_points, ((guint) key)));
						points1 = g_list_append (points1, (_tmp2 = p, (_tmp2 == NULL || g_object_ref == NULL ? ((gpointer) _tmp2) : g_object_ref (((gpointer) _tmp2)))));
					}
				}
			}
		}
	}
	nresults = 0;
	k = 0;
	{
		GList* points_collection;
		GList* points_it;
		points_collection = piece_points;
		for (points_it = points_collection; points_it != NULL; points_it = points_it->next) {
			GList* points;
			points = ((GList*) points_it->data);
			{
				gint n;
				n = ((gint) g_list_length (points));
				{
					gint i;
					i = 0;
					for (; i < n; i++) {
						Point* a;
						a = ((Point*) g_list_nth_data (points, ((guint) i)));
						{
							gint j;
							j = i + 1;
							for (; j < n; j++) {
								Point* b;
								Point* _tmp4;
								Point* _tmp3;
								GList* _tmp5;
								GList* path;
								b = ((Point*) g_list_nth_data (points, ((guint) j)));
								_tmp4 = NULL;
								_tmp3 = NULL;
								_tmp5 = NULL;
								path = (_tmp5 = board_get_path (self, (_tmp3 = point_copy (a)), (_tmp4 = point_copy (b))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
								if (path != NULL && g_list_length (path) > 0) {
									result = g_list_append (result, line_new (a, b));
									if (nresults++ == max_results) {
										(path == NULL ? NULL : (path = (_g_list_free_g_object_unref (path), NULL)));
										break;
									}
								}
								(path == NULL ? NULL : (path = (_g_list_free_g_object_unref (path), NULL)));
							}
						}
						if (nresults == max_results) {
							break;
						}
					}
				}
				k++;
				{
					GList* point_collection;
					GList* point_it;
					point_collection = points;
					for (point_it = point_collection; point_it != NULL; point_it = point_it->next) {
						Point* point;
						point = point_it->data;
						{
							g_object_unref (point);
						}
					}
				}
				if (nresults == max_results) {
					break;
				}
			}
		}
	}
	_tmp6 = NULL;
	return (_tmp6 = result, (pieces == NULL ? NULL : (pieces = (g_list_free (pieces), NULL))), (piece_points == NULL ? NULL : (piece_points = (_g_list_free_g_list_free (piece_points), NULL))), _tmp6);
}


gint board_getNumPieces (Board* self) {
	gint result;
	g_return_val_if_fail (IS_BOARD (self), 0);
	result = 0;
	{
		gint j;
		j = 0;
		for (; j < self->board_size[1]; j++) {
			{
				gint i;
				i = 0;
				for (; i < self->board_size[0]; i++) {
					if (self->board[(i) * self->board_length2 + (j)] != 0) {
						result++;
					}
				}
			}
		}
	}
	return result;
}


static Board* board_new (void) {
	Board * self;
	self = g_object_newv (TYPE_BOARD, 0, NULL);
	return self;
}


static gint board_myrand (Board* self) {
	g_return_val_if_fail (IS_BOARD (self), 0);
	if (board_rndnext == -1) {
		GTimeVal _tmp0 = {0};
		GTimeVal tv;
		tv = (memset (&_tmp0, 0, sizeof (GTimeVal)), _tmp0);
		g_get_current_time (&tv);
		board_rndnext = (((gulong) tv.tv_usec));
	}
	board_rndnext = board_rndnext * 1103515245 + 12345;
	return (((gint) (((gulong) (board_rndnext / 65536)) % 32768)));
}


static char* board_string_repeat (Board* self, const char* s, gint n) {
	char* result;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	g_return_val_if_fail (s != NULL, NULL);
	result = g_strdup ("");
	{
		gint i;
		i = 0;
		for (; i < n; i++) {
			char* _tmp0;
			_tmp0 = NULL;
			result = (_tmp0 = g_strconcat (result, (s), NULL), (result = (g_free (result), NULL)), _tmp0);
		}
	}
	return result;
}


static gint board_find_free_row (Board* self, gint j) {
	g_return_val_if_fail (IS_BOARD (self), 0);
	{
		gint i;
		i = 1;
		for (; i < self->board_size[0] - 1; i++) {
			if (self->board[(i) * self->board_length2 + (j)] != 0) {
				return (i - 1);
			}
		}
	}
	return (self->board_size[0] - 1 - 1);
}


static GList* board_get_horizontal_lines (Board* self, Point* exclude_a, Point* exclude_b) {
	GList* result;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	g_return_val_if_fail (IS_POINT (exclude_a), NULL);
	g_return_val_if_fail (IS_POINT (exclude_b), NULL);
	result = NULL;
	{
		gint i;
		i = 0;
		for (; i < self->board_size[0]; i++) {
			gint j0;
			gboolean empty;
			j0 = -1;
			empty = FALSE;
			{
				gint j;
				j = 0;
				for (; j < self->board_size[1]; j++) {
					empty = (self->board[(i) * self->board_length2 + (j)] == 0 || (i == point_get_i (exclude_a) && j == point_get_j (exclude_a)) || (i == point_get_i (exclude_b) && j == point_get_j (exclude_b)));
					if (j0 == -1 && empty) {
						j0 = j;
					} else {
						if (j0 != -1 && !empty) {
							Point* _tmp1;
							Point* _tmp0;
							_tmp1 = NULL;
							_tmp0 = NULL;
							result = g_list_append (result, line_new ((_tmp0 = point_new (i, j0)), (_tmp1 = point_new (i, j - 1))));
							(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
							(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
							j0 = -1;
						}
					}
				}
			}
			if (j0 != -1) {
				Point* _tmp3;
				Point* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				result = g_list_append (result, line_new ((_tmp2 = point_new (i, j0)), (_tmp3 = point_new (i, self->board_size[1] - 1))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			}
		}
	}
	return result;
}


static GList* board_get_vertical_lines (Board* self, Point* exclude_a, Point* exclude_b) {
	GList* result;
	g_return_val_if_fail (IS_BOARD (self), NULL);
	g_return_val_if_fail (IS_POINT (exclude_a), NULL);
	g_return_val_if_fail (IS_POINT (exclude_b), NULL);
	result = NULL;
	{
		gint j;
		j = 0;
		for (; j < self->board_size[1]; j++) {
			gint i0;
			gboolean empty;
			i0 = -1;
			empty = FALSE;
			{
				gint i;
				i = 0;
				for (; i < self->board_size[0]; i++) {
					empty = (self->board[(i) * self->board_length2 + (j)] == 0 || (i == point_get_i (exclude_a) && j == point_get_j (exclude_a)) || (i == point_get_i (exclude_b) && j == point_get_j (exclude_b)));
					if (i0 == -1 && empty) {
						i0 = i;
					} else {
						if (i0 != -1 && !empty) {
							Point* _tmp1;
							Point* _tmp0;
							_tmp1 = NULL;
							_tmp0 = NULL;
							result = g_list_append (result, line_new ((_tmp0 = point_new (i0, j)), (_tmp1 = point_new (i - 1, j))));
							(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
							(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
							i0 = -1;
						}
					}
				}
			}
			if (i0 != -1) {
				Point* _tmp3;
				Point* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				result = g_list_append (result, line_new ((_tmp2 = point_new (i0, j)), (_tmp3 = point_new (self->board_size[0] - 1, j))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			}
		}
	}
	return result;
}


static void board_process_gravity (Board* self, Point* p) {
	g_return_if_fail (IS_BOARD (self));
	g_return_if_fail (IS_POINT (p));
	if (self->gravity) {
		{
			gint i;
			i = point_get_i (p);
			for (; i > 0; i--) {
				self->board[(i) * self->board_length2 + (point_get_j (p))] = self->board[(i - 1) * self->board_length2 + (point_get_j (p))];
			}
		}
	}
}


static void board_undo_gravity (Board* self, Point* p) {
	g_return_if_fail (IS_BOARD (self));
	g_return_if_fail (IS_POINT (p));
	if (self->gravity) {
		{
			gint i;
			i = 0;
			for (; i < point_get_i (p); i++) {
				self->board[(i) * self->board_length2 + (point_get_j (p))] = self->board[(i + 1) * self->board_length2 + (point_get_j (p))];
			}
		}
	}
}


static void board_class_init (BoardClass * klass) {
	board_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->dispose = board_dispose;
	board_charpieces = g_strdup (" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
	board_rndnext = -1;
}


static void board_init (Board * self) {
	self->difficulty = 1;
	self->gravity = TRUE;
}


static void board_dispose (GObject * obj) {
	Board * self;
	self = BOARD (obj);
	self->board_size = (g_free (self->board_size), NULL);
	self->board = (g_free (self->board), NULL);
	(self->history == NULL ? NULL : (self->history = (g_queue_free (self->history), NULL)));
	G_OBJECT_CLASS (board_parent_class)->dispose (obj);
}


GType board_get_type (void) {
	static GType board_type_id = 0;
	if (G_UNLIKELY (board_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Board), 0, (GInstanceInitFunc) board_init };
		board_type_id = g_type_register_static (G_TYPE_OBJECT, "Board", &g_define_type_info, 0);
	}
	return board_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




