import gtk, _plugin_manager

class UI:

    def show_ui(self, dbpath, win):
        self.dbpath = dbpath
        dialog = gtk.Dialog(title='Settings', parent=win, flags=0, buttons=("Close", gtk.RESPONSE_CLOSE))
        dialog.set_size_request(500, 300)

        pluglist = _plugin_manager.get_names_and_icons()

        #If the plugin doesnt need settings, it isn shown in the UI.
        for i in pluglist:
            if i[3] == False:
                pluglist.remove(i)

        #print pluglist

        table = gtk.Table(len(pluglist)/2, len(pluglist)/2, True)

        for i in range(len(pluglist)):
            button = gtk.Button(pluglist[i][0])
            button.set_property("can_focus", False)
            button.connect("clicked", self.show_service_pref, pluglist[i][2], win)
            if i < len(pluglist)/2:
                top = 0
                bottom = 1
                left = i
                right = left + 1
            else:
                top = 1
                bottom = 2
                left = i - len(pluglist)/2
                right = left + 1

            table.attach(button, left, right, top, bottom)

        hbox = gtk.HBox()
        ind, thumbncb_act, lastpath = self.load_general_settings(dbpath)
        self.thumbn_cb = gtk.CheckButton("Don't use image thumbnails (faster)")
        self.thumbn_cb.set_active(int(thumbncb_act))
        hbox.pack_start(self.thumbn_cb, False, False, 5)

        dialog.vbox.pack_start(table, True, True, 0)
        dialog.vbox.pack_start(hbox, True, True, 0)

        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_CLOSE:
            thumbn = int(self.thumbn_cb.get_active())
            self.save_general_settings(thumbn, dbpath, lastpath)
            print 'tururu'
        dialog.destroy()

    def save_general_settings(self, thumbn, dbpath, lastpath):
        import sqlite3
        settings_db = sqlite3.connect(dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO General VALUES (?, ?, ?)', \
                            (1, thumbn, lastpath))
        settings_db.commit()
        cursor_sql.close()

    def load_general_settings(self, dbpath):
        import sqlite3
        settings_db = sqlite3.connect(dbpath)
        cursor_sql = settings_db.cursor()
        tables = []
        for table in cursor_sql.execute('select * from sqlite_master'):
            tables.append(table[1])

        if not 'General' in tables:
            print 'creating new'
            cursor_sql.execute('CREATE TABLE General (id INTEGER PRIMARY KEY, \
                            thumbnails_off text, lastpath text)')
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO General VALUES (?, ?, ?)', \
                            (1, '0', ''))
            settings_db.commit()

        settings = []
        for table in settings_db.execute('select * from General'):
            settings.append(table)

        if len(settings[0]) < 3:
            cursor_sql.execute('DROP TABLE General')
            settings_db.commit()
            cursor_sql.execute('CREATE TABLE General (id INTEGER PRIMARY KEY, \
                            thumbnails_off text, lastpath text)')
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO General VALUES (?, ?, ?)', \
                            (1, '0', ''))
            settings_db.commit()

            print 'Recreating general settings'

            settings = []
            for table in settings_db.execute('select * from General'):
                settings.append(table)

        settings_db.close()

        return settings[0]


    def show_service_pref(self, widget, service, win):
        print service
        _plugin_manager.show_settings(service, self.dbpath, win)
