#Some code is from the canola-flickr-plugin 
#License: GPL3

import flickrapi
import os

API_KEY = '1b2186454462f42d30850835ee7dc594'
API_SECRET = 'bd1752724be0fe03'

name = 'Flickr'
icon = 'flickr.png'
service = 'flickr'
has_settings = True


def get_initial_tags(filename):
    #[imgfile,title,summary,tags,public,friend,family,[sets]]
    tags = ['flickr', filename, '', '', '', 1, 0, 0, []]
    return tags
    
def test_upload_needs(settings, all_files):
    return True
        
def do_upload(image, dbpath, win):
    filename = image[1]
    title = image[2]
    desc = image[3]
    tags = image[4]
    public = image[5]
    friend = image[6]
    family = image[7]
    sets = image[8]
    myflickr = Flickr('')
    up = myflickr.upload(filename, title, desc, tags, public, friend, family, sets)
    return up

def get_allowed_ftypes():
    sf = {
        'jpeg': 'image/jpeg',
        'jpg': 'image/jpeg',
        'png': 'image/png',
        'gif': 'image/gif',
        'tiff': 'image/tiff',
        'tif': 'image/tiff',
        'bmp': 'image/x-ms-bmp',
        'mov': 'video/quicktime',
        'mpg': 'video/mpeg',
        'mpeg': 'video/mpeg',
        'mp4': 'video/mp4',
        'avi': 'video/x-msvideo',
        'wmv': 'video/x-ms-wmv',
        '3g2': 'video/3gpp2',
        '3gp': 'video/3gpp',
        'm4v': 'video/m4v',
        'asf': 'video/x-ms-asf'
        }    
    return sf
    
class Settings:
    def __init__(self, dbpath):
        self.dbpath = dbpath
        
    def show_ui(self, win):
        import hildon, gtk
        flickr = Flickr('')
        try:
            res = flickr.login()
        except:
            hildon.hildon_banner_show_information(gtk.VBox(), 'qgn_note_infoprint', "Error login to flickr. Please check your connection") 
            return
        if not res == True:        
            dialog = gtk.Dialog(title='Authorize Flickr', parent=None, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
            dialog.set_size_request(400, 300)
            label1 = gtk.Label('Press when authorize to Flickr')
            dialog.vbox.pack_start(label1, True, True, 0)

            dialog.show_all()
            result = dialog.run()
            if result == gtk.RESPONSE_ACCEPT:
                res = flickr.login()
                if not res == True:
                    hildon.hildon_banner_show_information(dialog, 'qgn_note_infoprint', "Error, could not get access to a flickr account!")         
                    return -1    
                else:
                    hildon.hildon_banner_show_information(dialog, 'qgn_note_infoprint', "You already have allowed Flickr access")
            
            dialog.destroy()
        else:
            hildon.hildon_banner_show_information(gtk.VBox(), 'qgn_note_infoprint', "You already have allowed Flickr access")    
        
class ADV_TAGS:
    def on_public_img_active(self, widget):
        if widget.get_active():
            self.do_private_img_widgets_insensitive()
        else:
            self.cbutton1.set_sensitive(True)
            self.cbutton2.set_sensitive(True)

    def do_private_img_widgets_insensitive(self):
        self.cbutton1.set_sensitive(False)
        self.cbutton2.set_sensitive(False)
        self.cbutton1.set_active(False)
        self.cbutton2.set_active(False)


    def on_get_flickr_sets(self, widget, sets_trv):
        import thread
        try:
            import hildon
            HILDON = True
        except:
            HILDON = False

        #FIXME: Desktop compability if not HILDON.        
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                                    'Getting Flickr sets')
        thread.start_new(self._do_get_flickr_sets, (banner, widget, sets_trv))      
    
    def _do_get_flickr_sets(self, banner, widget, sets_trv):
        try:
            myflickr = Flickr('')
            setlist = myflickr.get_set_list()
            banner.destroy()
        except Exception, e:
            banner.destroy()
            hildon.hildon_banner_show_information(gtk.VBox(), 'qgn_note_infoprint', 'Error getting Flickr sets')
            setlist = []
            
        self.sets_model.clear()
        #setlist = [(id, name)]
        self.save_temp_setlist(setlist)
        self.sets_model = self.__create_sets_model(setlist)
        sets_trv.set_model(self.sets_model)

    def __create_sets_model(self, setlist):
        import gobject, gtk
        lstore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, \
                    gobject.TYPE_STRING)
        for item in setlist:
            iter = lstore.append()
            lstore.set(iter, 0, False, 1, item[0], 2, item[1])
        return lstore     

    def _sets_trv_columns(self, treeview):
        import gtk
        renderer = gtk.CellRendererToggle()
        renderer.connect('toggled', self.sets_toggled)
        column = gtk.TreeViewColumn('', renderer, active=0)
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        column.set_fixed_width(50)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Id', gtk.CellRendererText(), text=1)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn("Set", gtk.CellRendererText(), text=2)            
        treeview.append_column(column)

    def sets_toggled(self, cell, path):
        seliter = self.sets_model.get_iter((int(path),))
        fixed = self.sets_model.get_value(seliter, 0)

        fixed = not fixed
        self.sets_model.set(seliter, 0, fixed)

    def show_ui(self, image, kind, win):
        import gtk

        try:
            import mokoui
            MOKO = True
        except:
            MOKO = False
        
        dialog = gtk.Dialog(title='Flickr advanced', parent=win, flags=0, buttons=("Save", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(600, 300)
        hbox1 = gtk.HBox()
        
        vbox1 = gtk.VBox()
        
        label_privacy = gtk.Label('Privacy')
        separator = gtk.HSeparator()
        
        rbutton1 = gtk.RadioButton(None, "Public")
        rbutton2 = gtk.RadioButton(None, "Private")
        rbutton2.set_group(rbutton1)
        if kind == 'simple':
            rbutton2.set_active(not image[5])
        else:        
            rbutton2.set_active(0)
            
        hbox2 = gtk.HBox()
        label1 = gtk.Label("")
        self.cbutton1 = gtk.CheckButton("Friends")
        if kind == 'simple':        
            self.cbutton1.set_active(image[6])
        else:
            self.cbutton1.set_active(0)
        hbox2.pack_start(label1, True, True, 0)
        hbox2.pack_start(self.cbutton1, True, True, 0)    
        
        hbox3 = gtk.HBox()
        label2 = gtk.Label("")
        
        self.cbutton2 = gtk.CheckButton("Family")
        if kind == 'simple':
            self.cbutton2.set_active(image[7])
        else:
            self.cbutton2.set_active(0)
        hbox3.pack_start(label2, True, True, 0)
        hbox3.pack_start(self.cbutton2, True, True, 0)

        if kind == 'simple':
            if image[5] == 1:
                self.do_private_img_widgets_insensitive()
        else:
            self.do_private_img_widgets_insensitive()

        rbutton1.connect('toggled', self.on_public_img_active)

        vbox1.pack_start(label_privacy, True, True, 0)
        vbox1.pack_start(separator, True, True, 0)
        vbox1.pack_start(rbutton1, True, True, 0)
        vbox1.pack_start(rbutton2, True, True, 0)
        vbox1.pack_start(hbox2, True, True, 0)
        vbox1.pack_start(hbox3, True, True, 0)
        
        vbox2 = gtk.VBox()
        
        if MOKO:
            swin = mokoui.FingerScroll()
        else:
            swin = gtk.ScrolledWindow() 
            
        sets_trv = gtk.TreeView()
        sets_trv.set_headers_visible(True)
        
        setlist = self.load_temp_setlist()
        if setlist is not []:
            self.sets_model = self.__create_sets_model(setlist)
            if kind == 'simple':
                #try:
                for j in range(len(self.sets_model)):
                    if self.sets_model[j][1] in image[8]:
                        self.sets_model[j][0] = True
                    else:
                        self.sets_model[j][0] = False
                #except:
                #    print 'Failed to get the sets.'
        else:
            self.sets_model = self.__create_sets_model('')
        
        sets_trv.set_model(self.sets_model)
        self._sets_trv_columns(sets_trv)
        
        swin.add(sets_trv)
        
        button1 = gtk.Button("Get Sets")
        button1.set_property("can-focus", False)
        button1.set_size_request(-1, 50)
        button1.connect("clicked", self.on_get_flickr_sets, sets_trv)
        
        vbox2.pack_start(swin, True, True, 0)
        vbox2.pack_start(button1, False, False, 0)
        
        hbox1.pack_start(vbox1, False, False, 25)
        hbox1.pack_start(vbox2, True, True, 0)
        
        dialog.vbox.pack_start(hbox1, True, True, 0)
        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_OK:
            #image = ['Flickr', 'filename', 'title', 'desc', 'tag1, tag2', 1, 0, 0, []]
            if kind == 'simple':
                if rbutton1.get_active():
                    image[5] = 1
                    image[6] = 0
                    image[7] = 0
                elif rbutton2.get_active():
                    image[5] = 0
                    if self.cbutton1.get_active():
                        image[6] = 1
                    else:
                        image[6] = 0
                    if self.cbutton2.get_active():
                        image[7] = 1
                    else:
                        image[7] = 0

                sets = []
                for i in range(len(self.sets_model)):
                    if self.sets_model[i][0] == True:        
                        #print self.sets_model[i][1]
                        sets.append(self.sets_model[i][1]) 

                image[8] = sets
            else:
                rbut1 = rbutton1.get_active()
                rbut2 = rbutton2.get_active()
                cbut1 = self.cbutton1.get_active()
                cbut2 = self.cbutton2.get_active()
                sets = []
                for i in range(len(self.sets_model)):
                    if self.sets_model[i][0] == True:        
                        #print self.sets_model[i][1]
                        sets.append(self.sets_model[i][1])                 
                             
                for i in image:
                    if rbut1:
                        i[5] = 1
                        i[6] = 0
                        i[7] = 0
                    elif rbut2:
                        i[5] = 0
                        if cbut1:
                            i[6] = 1
                        else:
                            i[6] = 0
                        if cbut2:
                            i[7] = 1
                        else:
                            i[7] = 0

                    i[8] = sets                
                
                
            dialog.hide()
            return image
        else:
            dialog.hide()
            return image
        
        dialog.hide()

    def save_temp_setlist(self, setlist):
        import tempfile
        tmpdir = tempfile.mkdtemp(prefix='sharepy-flickr') + "/"
        tmpfile = tmpdir + 'flickr_setlist'
        print 'Creating tempfile: ', tmpfile
        sets = ''
        for i in range(len(setlist)):
            if i < len(setlist)-1:
                sets = sets + setlist[i][0] + '|@|' + setlist[i][1] + '|||'
            else:
                sets = sets + setlist[i][0] + '|@|' + setlist[i][1]

        tmpalb = open(tmpfile, 'w')
        tmpalb.write(sets)
        tmpalb.close()

    def load_temp_setlist(self):
        import os
        setlist = []
        tmpfile = False
        for i in os.listdir("/var/tmp"):
            if i.find("sharepy-flickr") >= 0:
                tmpfile = "/var/tmp/"+i+"/flickr_setlist"
                break
        
        if tmpfile:
            albfile = open(tmpfile, 'r')
            sets = albfile.read()
            albfile.close()
            for i in sets.split('|||'):
                setlist.append(tuple(i.split('|@|')))

        return setlist


def attributesFromDict(d, obj=None, objName="self"):
    '''see http://code.activestate.com/recipes/280381/'''
    if obj is None:
        obj = d.pop(objName)
    for n, v in d.iteritems():
        setattr(obj, n, v)
      

class Flickr:
    def __init__(self, username, api_key=API_KEY, api_secret=API_SECRET):
        attributesFromDict(locals())

        self.flickr = flickrapi.FlickrAPI(api_key, api_secret)
        self.logged = False
        self.token  = None
        self.frob   = None

    def login(self):
        if not self.frob and not self.token:
            token, self.frob = self.flickr.get_token_part_one(perms='write')
            if not token:
                self.token = None
                return False
            else: self.token = token

        self.token = self.flickr.get_token_part_two((self.token, self.frob))
        if not self.token:
            self.logged = False
        else: self.logged = True
        return self.logged

    def delete_token(self):
        token = os.path.join(os.path.expanduser("~"), ".flickr", self.api_key, \
                             "auth.token")

        if os.path.exists(token):
            os.unlink(token)
            return True
        else:
            return False

    def upload(self, filename, title, summary, tags, public, friend, family, sets):
        photo_id = self.flickr.upload(filename=filename, title=title, \
                                    description=summary, tags=tags, \
                                    is_public=public, is_friend=friend, \
                                    is_family=family)
    
        upload_id = photo_id.find('photoid').text

        if sets != []:
            for j in range(len(sets)):
                self.flickr.photosets_addPhoto(photoset_id=sets[j], photo_id=upload_id)

        return upload_id

    def get_set_list(self):
        setlist = []
        lista = self.flickr.photosets_getList()
        sets_xml = lista.find('photosets').findall('photoset')
        
        for i in sets_xml:
            title = i.find('title').text
            set_id = i.attrib['id']
            one_set = (set_id, title)
            setlist.append(one_set)
        
        return setlist


