/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-13-0/engines/sword1/swordres.h $
 * $Id: swordres.h 30667 2008-01-28 00:14:17Z jvprat $
 *
 */

#ifndef SWORD1_SWORDRES_H
#define SWORD1_SWORDRES_H

namespace Sword1 {

// scripts
	// standard
#define SCRIPT0					 0x01000000
	// 1 entities in TXTs, 1 in datafiles.
	// megas
#define SCRIPT128				 0x01010000
#define SCRIPT129				 0x01010001
#define SCRIPT130				 0x01010002
#define SCRIPT131				 0x01010003
#define SCRIPT133				 0x01010004
#define SCRIPT134				 0x01010005
#define SCRIPT145				 0x01010006
#define SCRIPT146				 0x01010007
	// 8 entities in TXTs, 8 in datafiles.
	// maps
#define SCRIPT80				 0x01020000
#define SCRIPT86				 0x01020001
#define SCRIPT90				 0x01020002
	// 3 entities in TXTs, 3 in datafiles.
	// paris1
#define SCRIPT1					 0x01030000
#define SCRIPT2					 0x01030001
#define SCRIPT3					 0x01030002
#define SCRIPT4					 0x01030003
#define SCRIPT5					 0x01030004
#define SCRIPT6					 0x01030005
#define SCRIPT7					 0x01030006
#define SCRIPT8					 0x01030007
	// 8 entities in TXTs, 8 in datafiles.
	// paris2
#define SCRIPT9					 0x01040000
#define SCRIPT10				 0x01040001
#define SCRIPT11				 0x01040002
#define SCRIPT12				 0x01040003
#define SCRIPT13				 0x01040004
#define SCRIPT14				 0x01040005
#define SCRIPT15				 0x01040006
#define SCRIPT16				 0x01040007
#define SCRIPT17				 0x01040008
#define SCRIPT18				 0x01040009
#define SCRIPT46				 0x0104000A
	// 11 entities in TXTs, 11 in datafiles.
	// paris3
#define SCRIPT27				 0x01050000
#define SCRIPT28				 0x01050001
#define SCRIPT29				 0x01050002
#define SCRIPT31				 0x01050003
#define SCRIPT32				 0x01050004
#define SCRIPT33				 0x01050005
#define SCRIPT34				 0x01050006
#define SCRIPT35				 0x01050007
	// 8 entities in TXTs, 8 in datafiles.
	// paris4
#define SCRIPT36				 0x01060000
#define SCRIPT37				 0x01060001
#define SCRIPT38				 0x01060002
#define SCRIPT39				 0x01060003
#define SCRIPT40				 0x01060004
#define SCRIPT41				 0x01060005
#define SCRIPT42				 0x01060006
#define SCRIPT43				 0x01060007
#define SCRIPT48				 0x01060008
	// 9 entities in TXTs, 9 in datafiles.
	// ireland
#define SCRIPT19				 0x01070000
#define SCRIPT20				 0x01070001
#define SCRIPT21				 0x01070002
#define SCRIPT22				 0x01070003
#define SCRIPT23				 0x01070004
#define SCRIPT24				 0x01070005
#define SCRIPT25				 0x01070006
#define SCRIPT26				 0x01070007
	// 8 entities in TXTs, 8 in datafiles.
	// spain
#define SCRIPT56				 0x01080000
#define SCRIPT57				 0x01080001
#define SCRIPT58				 0x01080002
#define SCRIPT59				 0x01080003
#define SCRIPT60				 0x01080004
#define SCRIPT61				 0x01080005
#define SCRIPT62				 0x01080006
	// 7 entities in TXTs, 7 in datafiles.
	// syria
#define SCRIPT45				 0x01090000
#define SCRIPT47				 0x01090001
#define SCRIPT49				 0x01090002
#define SCRIPT50				 0x01090003
#define SCRIPT54				 0x01090004
#define SCRIPT55				 0x01090005
	// 6 entities in TXTs, 6 in datafiles.
	// train
#define SCRIPT63				 0x010A0000
#define SCRIPT65				 0x010A0001
#define SCRIPT66				 0x010A0002
#define SCRIPT67				 0x010A0003
#define SCRIPT69				 0x010A0004
	// 5 entities in TXTs, 5 in datafiles.
	// scotland
#define SCRIPT71				 0x010B0000
#define SCRIPT72				 0x010B0001
#define SCRIPT73				 0x010B0002
#define SCRIPT74				 0x010B0003
	// 4 entities in TXTs, 4 in datafiles.
// compacts
	// standard
#define TEXT_OBS				 0x02000000
	// 1 entities in TXTs, 1 in datafiles.
	// megas
#define MEGA_GEO				 0x02010000
#define GEO_TLK_TABLE			 0x02010001
#define WHT_TLK_TABLE			 0x02010002
#define GEO_SHRUG_TABLE			 0x02010003
#define GEO_GIVE_TABLE			 0x02010004
#define GEO_GIVER_TABLE			 0x02010005
#define GEO_CROUCH_TABLE		 0x02010006
#define GEO_CROUCHR_TABLE		 0x02010007
#define GEO_PICKUP_TABLE		 0x02010008
#define GEO_RELAX_TABLE			 0x02010009
#define GEO_RELAXR_TABLE		 0x0201000A
#define GEO_HAIR_TABLE			 0x0201000B
#define GEO_BLINK_TABLE			 0x0201000C
#define GEOPHN_TABLE			 0x0201000D
#define GEO_GAUGE_TABLE			 0x0201000E
#define GEO_SHOW_TABLE			 0x0201000F
#define GEO_SHOWR_TABLE			 0x02010010
#define GEOSTA_TABLE			 0x02010011
#define GEOMON_TABLE			 0x02010012
#define MEGA_DUANE				 0x02010013
#define DUA5_TABLE				 0x02010014
#define DUA6_TABLE				 0x02010015
#define DUA7_TABLE				 0x02010016
#define DUA8_TABLE				 0x02010017
#define DUA9_TABLE				 0x02010018
#define MEGA_NICO				 0x02010019
#define NIC_TLK_TABLE			 0x0201001A
#define NIC_PHOTO_TABLE			 0x0201001B
#define NICPHN_TABLE			 0x0201001C
#define MEGA_MUS				 0x0201001D
#define MUS_TLK_TABLE			 0x0201001E
#define MEGA_BENOIR				 0x0201001F
#define BEN_GAUGE_TABLE			 0x02010020
#define BEN_TLK_TABLE			 0x02010021
#define MEGA_ROSSO				 0x02010022
#define MEGA_MOUE				 0x02010023
#define MEGA_ALBERT				 0x02010024
	// 37 entities in TXTs, 37 in datafiles.
	// maps
#define COMP80					 0x02020000
#define COMP86					 0x02020001
#define COMP90					 0x02020002
#define COMP91					 0x02020003
#define COMP99					 0x02020004
	// 5 entities in TXTs, 5 in datafiles.
	// paris1
#define COMP1					 0x02030000
#define COMP2					 0x02030001
#define COMP3					 0x02030002
#define COMP4					 0x02030003
#define COMP5					 0x02030004
#define COMP6					 0x02030005
#define COMP7					 0x02030006
#define COMP8					 0x02030007
	// 8 entities in TXTs, 8 in datafiles.
	// paris2
#define COMP9					 0x02040000
#define COMP10					 0x02040001
#define COMP11					 0x02040002
#define COMP12					 0x02040003
#define COMP13					 0x02040004
#define COMP14					 0x02040005
#define COMP15					 0x02040006
#define COMP16					 0x02040007
#define COMP17					 0x02040008
#define COMP18					 0x02040009
#define COMP81					 0x0204000A
#define COMP46					 0x0204000B
	// 12 entities in TXTs, 12 in datafiles.
	// paris3
#define COMP27					 0x02050000
#define COMP28					 0x02050001
#define COMP29					 0x02050002
#define COMP30					 0x02050003
#define COMP31					 0x02050004
#define COMP32					 0x02050005
#define COMP33					 0x02050006
#define COMP34					 0x02050007
#define COMP35					 0x02050008
	// 9 entities in TXTs, 9 in datafiles.
	// paris4
#define COMP36					 0x02060000
#define COMP37					 0x02060001
#define COMP38					 0x02060002
#define COMP39					 0x02060003
#define COMP40					 0x02060004
#define COMP41					 0x02060005
#define COMP42					 0x02060006
#define COMP43					 0x02060007
#define COMP48					 0x02060008
	// 9 entities in TXTs, 9 in datafiles.
	// ireland
#define COMP19					 0x02070000
#define COMP20					 0x02070001
#define COMP21					 0x02070002
#define COMP22					 0x02070003
#define COMP23					 0x02070004
#define COMP24					 0x02070005
#define COMP25					 0x02070006
#define COMP26					 0x02070007
	// 8 entities in TXTs, 8 in datafiles.
	// spain
#define COMP56					 0x02080000
#define COMP57					 0x02080001
#define COMP58					 0x02080002
#define COMP59					 0x02080003
#define COMP60					 0x02080004
#define COMP61					 0x02080005
#define COMP62					 0x02080006
	// 7 entities in TXTs, 7 in datafiles.
	// syria
#define COMP45					 0x02090000
#define COMP47					 0x02090001
#define COMP49					 0x02090002
#define COMP50					 0x02090003
#define COMP53					 0x02090004
#define COMP54					 0x02090005
#define COMP55					 0x02090006
	// 7 entities in TXTs, 7 in datafiles.
	// train
#define COMP63					 0x020A0000
#define COMP65					 0x020A0001
#define COMP66					 0x020A0002
#define COMP67					 0x020A0003
#define COMP69					 0x020A0004
	// 5 entities in TXTs, 5 in datafiles.
	// scotland
#define COMP71					 0x020B0000
#define COMP72					 0x020B0001
#define COMP73					 0x020B0002
#define COMP74					 0x020B0003
#define COMP75					 0x020B0004
#define COMP76					 0x020B0005
#define COMP77					 0x020B0006
#define COMP78					 0x020B0007
#define COMP79					 0x020B0008
	// 9 entities in TXTs, 9 in datafiles.
// text
	// english
#define ENGLISH0				 0x03000000
#define ENGLISH1				 0x03000001
#define ENGLISH2				 0x03000002
#define ENGLISH3				 0x03000003
#define ENGLISH4				 0x03000004
#define ENGLISH5				 0x03000005
#define ENGLISH6				 0x03000006
#define ENGLISH7				 0x03000007
#define ENGLISH9				 0x03000008
#define ENGLISH11				 0x03000009
#define ENGLISH12				 0x0300000A
#define ENGLISH13				 0x0300000B
#define ENGLISH14				 0x0300000C
#define ENGLISH15				 0x0300000D
#define ENGLISH16				 0x0300000E
#define ENGLISH17				 0x0300000F
#define ENGLISH18				 0x03000010
#define ENGLISH19				 0x03000011
#define ENGLISH20				 0x03000012
#define ENGLISH21				 0x03000013
#define ENGLISH22				 0x03000014
#define ENGLISH23				 0x03000015
#define ENGLISH24				 0x03000016
#define ENGLISH25				 0x03000017
#define ENGLISH27				 0x03000018
#define ENGLISH28				 0x03000019
#define ENGLISH29				 0x0300001A
#define ENGLISH31				 0x0300001B
#define ENGLISH32				 0x0300001C
#define ENGLISH33				 0x0300001D
#define ENGLISH34				 0x0300001E
#define ENGLISH35				 0x0300001F
#define ENGLISH36				 0x03000020
#define ENGLISH37				 0x03000021
#define ENGLISH38				 0x03000022
#define ENGLISH39				 0x03000023
#define ENGLISH40				 0x03000024
#define ENGLISH41				 0x03000025
#define ENGLISH42				 0x03000026
#define ENGLISH43				 0x03000027
#define ENGLISH45				 0x03000028
#define ENGLISH47				 0x03000029
#define ENGLISH48				 0x0300002A
#define ENGLISH49				 0x0300002B
#define ENGLISH50				 0x0300002C
#define ENGLISH54				 0x0300002D
#define ENGLISH55				 0x0300002E
#define ENGLISH56				 0x0300002F
#define ENGLISH57				 0x03000030
#define ENGLISH58				 0x03000031
#define ENGLISH59				 0x03000032
#define ENGLISH60				 0x03000033
#define ENGLISH61				 0x03000034
#define ENGLISH63				 0x03000035
#define ENGLISH65				 0x03000036
#define ENGLISH66				 0x03000037
#define ENGLISH69				 0x03000038
#define ENGLISH71				 0x03000039
#define ENGLISH72				 0x0300003A
#define ENGLISH73				 0x0300003B
#define ENGLISH74				 0x0300003C
#define ENGLISH90				 0x0300003D
#define ENGLISH99				 0x0300003E
#define ENGLISH129				 0x0300003F
#define ENGLISH131				 0x03000040
#define ENGLISH133				 0x03000041
#define ENGLISH145				 0x03000042
#define ENGLISH146				 0x03000043
	// 68 entities in TXTs, 68 in datafiles.
	// french
#define FRENCH0					 0x03010000
#define FRENCH1					 0x03010001
#define FRENCH2					 0x03010002
#define FRENCH3					 0x03010003
#define FRENCH4					 0x03010004
#define FRENCH5					 0x03010005
#define FRENCH6					 0x03010006
#define FRENCH7					 0x03010007
#define FRENCH9					 0x03010008
#define FRENCH11				 0x03010009
#define FRENCH12				 0x0301000A
#define FRENCH13				 0x0301000B
#define FRENCH14				 0x0301000C
#define FRENCH15				 0x0301000D
#define FRENCH16				 0x0301000E
#define FRENCH17				 0x0301000F
#define FRENCH18				 0x03010010
#define FRENCH19				 0x03010011
#define FRENCH20				 0x03010012
#define FRENCH21				 0x03010013
#define FRENCH22				 0x03010014
#define FRENCH23				 0x03010015
#define FRENCH24				 0x03010016
#define FRENCH25				 0x03010017
#define FRENCH27				 0x03010018
#define FRENCH28				 0x03010019
#define FRENCH29				 0x0301001A
#define FRENCH31				 0x0301001B
#define FRENCH32				 0x0301001C
#define FRENCH33				 0x0301001D
#define FRENCH34				 0x0301001E
#define FRENCH35				 0x0301001F
#define FRENCH36				 0x03010020
#define FRENCH37				 0x03010021
#define FRENCH38				 0x03010022
#define FRENCH39				 0x03010023
#define FRENCH40				 0x03010024
#define FRENCH41				 0x03010025
#define FRENCH42				 0x03010026
#define FRENCH43				 0x03010027
#define FRENCH45				 0x03010028
#define FRENCH47				 0x03010029
#define FRENCH48				 0x0301002A
#define FRENCH49				 0x0301002B
#define FRENCH50				 0x0301002C
#define FRENCH54				 0x0301002D
#define FRENCH55				 0x0301002E
#define FRENCH56				 0x0301002F
#define FRENCH57				 0x03010030
#define FRENCH58				 0x03010031
#define FRENCH59				 0x03010032
#define FRENCH60				 0x03010033
#define FRENCH61				 0x03010034
#define FRENCH63				 0x03010035
#define FRENCH65				 0x03010036
#define FRENCH66				 0x03010037
#define FRENCH69				 0x03010038
#define FRENCH71				 0x03010039
#define FRENCH72				 0x0301003A
#define FRENCH73				 0x0301003B
#define FRENCH74				 0x0301003C
#define FRENCH90				 0x0301003D
#define FRENCH99				 0x0301003E
#define FRENCH129				 0x0301003F
#define FRENCH131				 0x03010040
#define FRENCH133				 0x03010041
#define FRENCH145				 0x03010042
#define FRENCH146				 0x03010043
	// 68 entities in TXTs, 68 in datafiles.
	// german
#define GERMAN0					 0x03020000
#define GERMAN1					 0x03020001
#define GERMAN2					 0x03020002
#define GERMAN3					 0x03020003
#define GERMAN4					 0x03020004
#define GERMAN5					 0x03020005
#define GERMAN6					 0x03020006
#define GERMAN7					 0x03020007
#define GERMAN9					 0x03020008
#define GERMAN11				 0x03020009
#define GERMAN12				 0x0302000A
#define GERMAN13				 0x0302000B
#define GERMAN14				 0x0302000C
#define GERMAN15				 0x0302000D
#define GERMAN16				 0x0302000E
#define GERMAN17				 0x0302000F
#define GERMAN18				 0x03020010
#define GERMAN19				 0x03020011
#define GERMAN20				 0x03020012
#define GERMAN21				 0x03020013
#define GERMAN22				 0x03020014
#define GERMAN23				 0x03020015
#define GERMAN24				 0x03020016
#define GERMAN25				 0x03020017
#define GERMAN27				 0x03020018
#define GERMAN28				 0x03020019
#define GERMAN29				 0x0302001A
#define GERMAN31				 0x0302001B
#define GERMAN32				 0x0302001C
#define GERMAN33				 0x0302001D
#define GERMAN34				 0x0302001E
#define GERMAN35				 0x0302001F
#define GERMAN36				 0x03020020
#define GERMAN37				 0x03020021
#define GERMAN38				 0x03020022
#define GERMAN39				 0x03020023
#define GERMAN40				 0x03020024
#define GERMAN41				 0x03020025
#define GERMAN42				 0x03020026
#define GERMAN43				 0x03020027
#define GERMAN45				 0x03020028
#define GERMAN47				 0x03020029
#define GERMAN48				 0x0302002A
#define GERMAN49				 0x0302002B
#define GERMAN50				 0x0302002C
#define GERMAN54				 0x0302002D
#define GERMAN55				 0x0302002E
#define GERMAN56				 0x0302002F
#define GERMAN57				 0x03020030
#define GERMAN58				 0x03020031
#define GERMAN59				 0x03020032
#define GERMAN60				 0x03020033
#define GERMAN61				 0x03020034
#define GERMAN63				 0x03020035
#define GERMAN65				 0x03020036
#define GERMAN66				 0x03020037
#define GERMAN69				 0x03020038
#define GERMAN71				 0x03020039
#define GERMAN72				 0x0302003A
#define GERMAN73				 0x0302003B
#define GERMAN74				 0x0302003C
#define GERMAN90				 0x0302003D
#define GERMAN99				 0x0302003E
#define GERMAN129				 0x0302003F
#define GERMAN131				 0x03020040
#define GERMAN133				 0x03020041
#define GERMAN145				 0x03020042
#define GERMAN146				 0x03020043
	// 68 entities in TXTs, 68 in datafiles.
	// italian
#define ITALIAN0				 0x03030000
#define ITALIAN1				 0x03030001
#define ITALIAN2				 0x03030002
#define ITALIAN3				 0x03030003
#define ITALIAN4				 0x03030004
#define ITALIAN5				 0x03030005
#define ITALIAN6				 0x03030006
#define ITALIAN7				 0x03030007
#define ITALIAN9				 0x03030008
#define ITALIAN11				 0x03030009
#define ITALIAN12				 0x0303000A
#define ITALIAN13				 0x0303000B
#define ITALIAN14				 0x0303000C
#define ITALIAN15				 0x0303000D
#define ITALIAN16				 0x0303000E
#define ITALIAN17				 0x0303000F
#define ITALIAN18				 0x03030010
#define ITALIAN19				 0x03030011
#define ITALIAN20				 0x03030012
#define ITALIAN21				 0x03030013
#define ITALIAN22				 0x03030014
#define ITALIAN23				 0x03030015
#define ITALIAN24				 0x03030016
#define ITALIAN25				 0x03030017
#define ITALIAN27				 0x03030018
#define ITALIAN28				 0x03030019
#define ITALIAN29				 0x0303001A
#define ITALIAN31				 0x0303001B
#define ITALIAN32				 0x0303001C
#define ITALIAN33				 0x0303001D
#define ITALIAN34				 0x0303001E
#define ITALIAN35				 0x0303001F
#define ITALIAN36				 0x03030020
#define ITALIAN37				 0x03030021
#define ITALIAN38				 0x03030022
#define ITALIAN39				 0x03030023
#define ITALIAN40				 0x03030024
#define ITALIAN41				 0x03030025
#define ITALIAN42				 0x03030026
#define ITALIAN43				 0x03030027
#define ITALIAN45				 0x03030028
#define ITALIAN47				 0x03030029
#define ITALIAN48				 0x0303002A
#define ITALIAN49				 0x0303002B
#define ITALIAN50				 0x0303002C
#define ITALIAN54				 0x0303002D
#define ITALIAN55				 0x0303002E
#define ITALIAN56				 0x0303002F
#define ITALIAN57				 0x03030030
#define ITALIAN58				 0x03030031
#define ITALIAN59				 0x03030032
#define ITALIAN60				 0x03030033
#define ITALIAN61				 0x03030034
#define ITALIAN63				 0x03030035
#define ITALIAN65				 0x03030036
#define ITALIAN66				 0x03030037
#define ITALIAN69				 0x03030038
#define ITALIAN71				 0x03030039
#define ITALIAN72				 0x0303003A
#define ITALIAN73				 0x0303003B
#define ITALIAN74				 0x0303003C
#define ITALIAN90				 0x0303003D
#define ITALIAN99				 0x0303003E
#define ITALIAN129				 0x0303003F
#define ITALIAN131				 0x03030040
#define ITALIAN133				 0x03030041
#define ITALIAN145				 0x03030042
#define ITALIAN146				 0x03030043
	// 68 entities in TXTs, 68 in datafiles.
	// spanish
#define SPANISH0				 0x03040000
#define SPANISH1				 0x03040001
#define SPANISH2				 0x03040002
#define SPANISH3				 0x03040003
#define SPANISH4				 0x03040004
#define SPANISH5				 0x03040005
#define SPANISH6				 0x03040006
#define SPANISH7				 0x03040007
#define SPANISH9				 0x03040008
#define SPANISH11				 0x03040009
#define SPANISH12				 0x0304000A
#define SPANISH13				 0x0304000B
#define SPANISH14				 0x0304000C
#define SPANISH15				 0x0304000D
#define SPANISH16				 0x0304000E
#define SPANISH17				 0x0304000F
#define SPANISH18				 0x03040010
#define SPANISH19				 0x03040011
#define SPANISH20				 0x03040012
#define SPANISH21				 0x03040013
#define SPANISH22				 0x03040014
#define SPANISH23				 0x03040015
#define SPANISH24				 0x03040016
#define SPANISH25				 0x03040017
#define SPANISH27				 0x03040018
#define SPANISH28				 0x03040019
#define SPANISH29				 0x0304001A
#define SPANISH31				 0x0304001B
#define SPANISH32				 0x0304001C
#define SPANISH33				 0x0304001D
#define SPANISH34				 0x0304001E
#define SPANISH35				 0x0304001F
#define SPANISH36				 0x03040020
#define SPANISH37				 0x03040021
#define SPANISH38				 0x03040022
#define SPANISH39				 0x03040023
#define SPANISH40				 0x03040024
#define SPANISH41				 0x03040025
#define SPANISH42				 0x03040026
#define SPANISH43				 0x03040027
#define SPANISH45				 0x03040028
#define SPANISH47				 0x03040029
#define SPANISH48				 0x0304002A
#define SPANISH49				 0x0304002B
#define SPANISH50				 0x0304002C
#define SPANISH54				 0x0304002D
#define SPANISH55				 0x0304002E
#define SPANISH56				 0x0304002F
#define SPANISH57				 0x03040030
#define SPANISH58				 0x03040031
#define SPANISH59				 0x03040032
#define SPANISH60				 0x03040033
#define SPANISH61				 0x03040034
#define SPANISH63				 0x03040035
#define SPANISH65				 0x03040036
#define SPANISH66				 0x03040037
#define SPANISH69				 0x03040038
#define SPANISH71				 0x03040039
#define SPANISH72				 0x0304003A
#define SPANISH73				 0x0304003B
#define SPANISH74				 0x0304003C
#define SPANISH90				 0x0304003D
#define SPANISH99				 0x0304003E
#define SPANISH129				 0x0304003F
#define SPANISH131				 0x03040040
#define SPANISH133				 0x03040041
#define SPANISH145				 0x03040042
#define SPANISH146				 0x03040043
	// 68 entities in TXTs, 68 in datafiles.
	// czech
#define CZECH0					 0x03050000
#define CZECH1					 0x03050001
#define CZECH2					 0x03050002
#define CZECH3					 0x03050003
#define CZECH4					 0x03050004
#define CZECH5					 0x03050005
#define CZECH6					 0x03050006
#define CZECH7					 0x03050007
#define CZECH9					 0x03050008
#define CZECH11					 0x03050009
#define CZECH12					 0x0305000A
#define CZECH13					 0x0305000B
#define CZECH14					 0x0305000C
#define CZECH15					 0x0305000D
#define CZECH16					 0x0305000E
#define CZECH17					 0x0305000F
#define CZECH18					 0x03050010
#define CZECH19					 0x03050011
#define CZECH20					 0x03050012
#define CZECH21					 0x03050013
#define CZECH22					 0x03050014
#define CZECH23					 0x03050015
#define CZECH24					 0x03050016
#define CZECH25					 0x03050017
#define CZECH27					 0x03050018
#define CZECH28					 0x03050019
#define CZECH29					 0x0305001A
#define CZECH31					 0x0305001B
#define CZECH32					 0x0305001C
#define CZECH33					 0x0305001D
#define CZECH34					 0x0305001E
#define CZECH35					 0x0305001F
#define CZECH36					 0x03050020
#define CZECH37					 0x03050021
#define CZECH38					 0x03050022
#define CZECH39					 0x03050023
#define CZECH40					 0x03050024
#define CZECH41					 0x03050025
#define CZECH42					 0x03050026
#define CZECH43					 0x03050027
#define CZECH45					 0x03050028
#define CZECH47					 0x03050029
#define CZECH48					 0x0305002A
#define CZECH49					 0x0305002B
#define CZECH50					 0x0305002C
#define CZECH54					 0x0305002D
#define CZECH55					 0x0305002E
#define CZECH56					 0x0305002F
#define CZECH57					 0x03050030
#define CZECH58					 0x03050031
#define CZECH59					 0x03050032
#define CZECH60					 0x03050033
#define CZECH61					 0x03050034
#define CZECH63					 0x03050035
#define CZECH65					 0x03050036
#define CZECH66					 0x03050037
#define CZECH69					 0x03050038
#define CZECH71					 0x03050039
#define CZECH72					 0x0305003A
#define CZECH73					 0x0305003B
#define CZECH74					 0x0305003C
#define CZECH90					 0x0305003D
#define CZECH99					 0x0305003E
#define CZECH129				 0x0305003F
#define CZECH131				 0x03050040
#define CZECH133				 0x03050041
#define CZECH145				 0x03050042
#define CZECH146				 0x03050043
	// 68 entities in TXTs, ??? in datafiles.
	// portugese
#define PORT0					 0x03060000
#define PORT1					 0x03060001
#define PORT2					 0x03060002
#define PORT3					 0x03060003
#define PORT4					 0x03060004
#define PORT5					 0x03060005
#define PORT6					 0x03060006
#define PORT7					 0x03060007
#define PORT9					 0x03060008
#define PORT11					 0x03060009
#define PORT12					 0x0306000A
#define PORT13					 0x0306000B
#define PORT14					 0x0306000C
#define PORT15					 0x0306000D
#define PORT16					 0x0306000E
#define PORT17					 0x0306000F
#define PORT18					 0x03060010
#define PORT19					 0x03060011
#define PORT20					 0x03060012
#define PORT21					 0x03060013
#define PORT22					 0x03060014
#define PORT23					 0x03060015
#define PORT24					 0x03060016
#define PORT25					 0x03060017
#define PORT27					 0x03060018
#define PORT28					 0x03060019
#define PORT29					 0x0306001A
#define PORT31					 0x0306001B
#define PORT32					 0x0306001C
#define PORT33					 0x0306001D
#define PORT34					 0x0306001E
#define PORT35					 0x0306001F
#define PORT36					 0x03060020
#define PORT37					 0x03060021
#define PORT38					 0x03060022
#define PORT39					 0x03060023
#define PORT40					 0x03060024
#define PORT41					 0x03060025
#define PORT42					 0x03060026
#define PORT43					 0x03060027
#define PORT45					 0x03060028
#define PORT47					 0x03060029
#define PORT48					 0x0306002A
#define PORT49					 0x0306002B
#define PORT50					 0x0306002C
#define PORT54					 0x0306002D
#define PORT55					 0x0306002E
#define PORT56					 0x0306002F
#define PORT57					 0x03060030
#define PORT58					 0x03060031
#define PORT59					 0x03060032
#define PORT60					 0x03060033
#define PORT61					 0x03060034
#define PORT63					 0x03060035
#define PORT65					 0x03060036
#define PORT66					 0x03060037
#define PORT69					 0x03060038
#define PORT71					 0x03060039
#define PORT72					 0x0306003A
#define PORT73					 0x0306003B
#define PORT74					 0x0306003C
#define PORT90					 0x0306003D
#define PORT99					 0x0306003E
#define PORT129					 0x0306003F
#define PORT131					 0x03060040
#define PORT133					 0x03060041
#define PORT145					 0x03060042
#define PORT146					 0x03060043
		// 68 entities in TXTs, ??? in datafiles.
// general
	// fonts
#define GAME_FONT				 0x04000000
#define OTHER_SR_FONT			 0x04000001
#define OTHER_SR_REDFONT		 0x04000002
#define SR_DEATHFONT			 0x04000003
#define CZECH_GAME_FONT			 0x04000004
#define CZECH_SR_FONT			 0x04000005
#define CZECH_SR_REDFONT		 0x04000006
#define CZECH_SR_DEATHFONT		 0x04000007
	// 8 entities in TXTs, 1 in datafiles.
	// pointers
#define MSE_POINTER				 0x04010000
#define MSE_OPERATE				 0x04010001
#define MSE_PICKUP				 0x04010002
#define MSE_EXAMINE				 0x04010003
#define MSE_MOUTH				 0x04010004
#define MSE_BECKON_L			 0x04010005
#define MSE_BECKON_R			 0x04010006
#define MSE_ARROW0				 0x04010007
#define MSE_ARROW1				 0x04010008
#define MSE_ARROW2				 0x04010009
#define MSE_ARROW3				 0x0401000A
#define MSE_ARROW4				 0x0401000B
#define MSE_ARROW5				 0x0401000C
#define MSE_ARROW6				 0x0401000D
#define MSE_ARROW7				 0x0401000E
#define MSE_ARROW8				 0x0401000F
#define MSE_ARROW9				 0x04010010
	// 17 entities in TXTs, 17 in datafiles.
	// luggage
#define LUGG_NEWSPAPER			 0x04020000
#define LUGG_HAZEL_WAND			 0x04020001
#define LUGG_BEER_TOWEL			 0x04020002
#define LUGG_HOTEL_KEY			 0x04020003
#define LUGG_BALL				 0x04020004
#define LUGG_STATUETTE			 0x04020005
#define LUGG_RED_NOSE			 0x04020006
#define LUGG_POLISHED_CHALICE	 0x04020007
#define LUGG_DOLLAR_BILL		 0x04020008
#define LUGG_PHOTOGRAPH			 0x04020009
#define LUGG_FLASHLIGHT			 0x0402000A
#define LUGG_FUSE_WIRE			 0x0402000B
#define LUGG_GEM				 0x0402000C
#define LUGG_STATUETTE_PAINT	 0x0402000D
#define LUGG_STICK				 0x0402000E
#define LUGG_EXCAV_KEY			 0x0402000F
#define LUGG_LAB_PASS			 0x04020010
#define LUGG_LIFTING_KEYS		 0x04020011
#define LUGG_MANUSCRIPT			 0x04020012
#define LUGG_MATCHBOOK			 0x04020013
#define LUGG_SUIT_MATERIAL		 0x04020014
#define LUGG_STICK_TOWEL		 0x04020015
#define LUGG_PLASTER			 0x04020016
#define LUGG_PRESSURE_GAUGE		 0x04020017
#define LUGG_RAILWAY_TICKET		 0x04020018
#define LUGG_BUZZER				 0x04020019
#define LUGG_ROSSO_CARD			 0x0402001A
#define LUGG_TOILET_KEY			 0x0402001B
#define LUGG_SOAP				 0x0402001C
#define LUGG_STONE_KEY			 0x0402001D
#define LUGG_CHALICE			 0x0402001E
#define LUGG_TISSUE				 0x0402001F
#define LUGG_TOILET_BRUSH		 0x04020020
#define LUGG_TOILET_CHAIN		 0x04020021
#define LUGG_TOWEL				 0x04020022
#define LUGG_TRIPOD				 0x04020023
#define LUGG_LENS				 0x04020024
#define LUGG_MIRROR				 0x04020025
#define LUGG_TOWEL_CUT			 0x04020026
#define LUGG_BIBLE				 0x04020027
#define LUGG_TISSUE_CHARRED		 0x04020028
#define LUGG_FALSE_KEY			 0x04020029
#define LUGG_KEYRING			 0x0402002A
#define LUGG_SOAP_IMP			 0x0402002B
#define LUGG_SOAP_PLAS			 0x0402002C
#define LUGG_COG_1				 0x0402002D
#define LUGG_COG_2				 0x0402002E
#define LUGG_HANDLE				 0x0402002F
#define LUGG_COIN				 0x04020030
#define LUGG_BIRO				 0x04020031
#define LUGG_PIPE				 0x04020032
#define LUGG_KING				 0x04020033
#define LUGG_KNIGHT				 0x04020034
#define LUGG_BISHOP				 0x04020035
	// 54 entities in TXTs, 54 in datafiles.
	// object_icons
#define ICON_LEFT_ARROW			 0x04030000
#define ICON_RIGHT_ARROW		 0x04030001
#define ICON_NEWSPAPER			 0x04030002
#define ICON_HAZEL_WAND			 0x04030003
#define ICON_BEER_TOWEL			 0x04030004
#define ICON_HOTEL_KEY			 0x04030005
#define ICON_BALL				 0x04030006
#define ICON_STATUETTE			 0x04030007
#define ICON_RED_NOSE			 0x04030008
#define ICON_POLISHED_CHALICE	 0x04030009
#define ICON_DOLLAR_BILL		 0x0403000A
#define ICON_PHOTOGRAPH			 0x0403000B
#define ICON_FLASHLIGHT			 0x0403000C
#define ICON_FUSE_WIRE			 0x0403000D
#define ICON_GEM				 0x0403000E
#define ICON_STATUETTE_PAINT	 0x0403000F
#define ICON_STICK				 0x04030010
#define ICON_EXCAV_KEY			 0x04030011
#define ICON_LAB_PASS			 0x04030012
#define ICON_LIFTING_KEYS		 0x04030013
#define ICON_MANUSCRIPT			 0x04030014
#define ICON_MATCHBOOK			 0x04030015
#define ICON_SUIT_MATERIAL		 0x04030016
#define ICON_STICK_TOWEL		 0x04030017
#define ICON_PLASTER			 0x04030018
#define ICON_PRESSURE_GAUGE		 0x04030019
#define ICON_RAILWAY_TICKET		 0x0403001A
#define ICON_BUZZER				 0x0403001B
#define ICON_ROSSO_CARD			 0x0403001C
#define ICON_TOILET_KEY			 0x0403001D
#define ICON_SOAP				 0x0403001E
#define ICON_STONE_KEY			 0x0403001F
#define ICON_CHALICE			 0x04030020
#define ICON_TISSUE				 0x04030021
#define ICON_TOILET_BRUSH		 0x04030022
#define ICON_TOILET_CHAIN		 0x04030023
#define ICON_TOWEL				 0x04030024
#define ICON_TRIPOD				 0x04030025
#define ICON_LENS				 0x04030026
#define ICON_MIRROR				 0x04030027
#define ICON_TOWEL_CUT			 0x04030028
#define ICON_BIBLE				 0x04030029
#define ICON_TISSUE_CHARRED		 0x0403002A
#define ICON_FALSE_KEY			 0x0403002B
#define ICON_KEYRING			 0x0403002C
#define ICON_SOAP_IMP			 0x0403002D
#define ICON_SOAP_PLAS			 0x0403002E
#define ICON_COG_1				 0x0403002F
#define ICON_COG_2				 0x04030030
#define ICON_HANDLE				 0x04030031
#define ICON_COIN				 0x04030032
#define ICON_BIRO				 0x04030033
#define ICON_PIPE				 0x04030034
	// 53 entities in TXTs, 53 in datafiles.
	// subject_icons
#define ICON_ALARM				 0x04040000
#define ICON_ARTO				 0x04040001
#define ICON_ASSASSIN			 0x04040002
#define ICON_AYUB				 0x04040003
#define ICON_BANANA				 0x04040004
#define ICON_BAPHOMET			 0x04040005
#define ICON_BEER				 0x04040006
#define ICON_BOOK				 0x04040007
#define ICON_BRIEFCASE			 0x04040008
#define ICON_BULL				 0x04040009
#define ICON_BULLS_HEAD			 0x0404000A
#define ICON_BUST				 0x0404000B
#define ICON_CANDLE				 0x0404000C
#define ICON_CAR				 0x0404000D
#define ICON_CASTLE				 0x0404000E
#define ICON_CAT				 0x0404000F
#define ICON_CHANTELLE			 0x04040010
#define ICON_CHESSBOARD			 0x04040011
#define ICON_CHESS_SET			 0x04040012
#define ICON_CHURCH				 0x04040013
#define ICON_CLOWN				 0x04040014
#define ICON_CLUB				 0x04040015
#define ICON_COINS				 0x04040016
#define ICON_COUNTESS			 0x04040017
#define ICON_CREST				 0x04040018
#define ICON_DIG				 0x04040019
#define ICON_DOG				 0x0404001A
#define ICON_DUANE				 0x0404001B
#define ICON_EKLUND				 0x0404001C
#define ICON_ERIC				 0x0404001D
#define ICON_FISH				 0x0404001E
#define ICON_FLOWERS			 0x0404001F
#define ICON_FORTUNE			 0x04040020
#define ICON_GEORGE				 0x04040021
#define ICON_GHOST				 0x04040022
#define ICON_GLASS_EYE			 0x04040023
#define ICON_GOAT				 0x04040024
#define ICON_GOODBYE			 0x04040025
#define ICON_GUARD				 0x04040026
#define ICON_HASH				 0x04040027
#define ICON_HENDERSONS			 0x04040028
#define ICON_JACKET				 0x04040029
#define ICON_JUGGLER			 0x0404002A
#define ICON_KLAUSNER			 0x0404002B
#define ICON_KNIGHT				 0x0404002C
#define ICON_LADDER				 0x0404002D
#define ICON_LEARY				 0x0404002E
#define ICON_LEPRECHAUN			 0x0404002F
#define ICON_LIE				 0x04040030
#define ICON_LOBINEAU			 0x04040031
#define ICON_MARQUET			 0x04040032
#define ICON_MARY				 0x04040033
#define ICON_MOB				 0x04040034
#define ICON_MONTFAUCON			 0x04040035
#define ICON_MOUE				 0x04040036
#define ICON_MR_SHINY			 0x04040037
#define ICON_NEJO				 0x04040038
#define ICON_NEJO_STALL			 0x04040039
#define ICON_NICO				 0x0404003A
#define ICON_NO					 0x0404003B
#define ICON_NURSE				 0x0404003C
#define ICON_PACKAGE			 0x0404003D
#define ICON_PAINTER			 0x0404003E
#define ICON_PEAGRAM			 0x0404003F
#define ICON_PEARL				 0x04040040
#define ICON_PHILIPPE			 0x04040041
#define ICON_PHONE				 0x04040042
#define ICON_PHRASE				 0x04040043
#define ICON_PIERMONT			 0x04040044
#define ICON_PLANTARD			 0x04040045
#define ICON_POTS				 0x04040046
#define ICON_PRIEST				 0x04040047
#define ICON_QUEEN				 0x04040048
#define ICON_RENEE				 0x04040049
#define ICON_ROSSO				 0x0404004A
#define ICON_ROZZER				 0x0404004B
#define ICON_SAFE				 0x0404004C
#define ICON_SCROLL				 0x0404004D
#define ICON_SEAN				 0x0404004E
#define ICON_SIGN				 0x0404004F
#define ICON_TAXI				 0x04040050
#define ICON_TEMPLARS			 0x04040051
#define ICON_THERMOSTAT			 0x04040052
#define ICON_TOILET				 0x04040053
#define ICON_TOMB				 0x04040054
#define ICON_TOOLBOX			 0x04040055
#define ICON_TRUTH				 0x04040056
#define ICON_ULTAR				 0x04040057
#define ICON_WEASEL				 0x04040058
#define ICON_WEAVER				 0x04040059
#define ICON_WELL				 0x0404005A
#define ICON_WELL2				 0x0404005B
#define ICON_WINDOW				 0x0404005C
#define ICON_YES				 0x0404005D
	// 94 entities in TXTs, 94 in datafiles.
	// save_menu
#define SR_FONT					 0x04050000
#define SR_BUTTON				 0x04050001
#define SR_REDFONT				 0x04050002
#define SR_PALETTE				 0x04050003
#define SR_PANEL_ENGLISH		 0x04050004
#define SR_PANEL_FRENCH			 0x04050005
#define SR_PANEL_GERMAN			 0x04050006
#define SR_PANEL_ITALIAN		 0x04050007
#define SR_PANEL_SPANISH		 0x04050008
#define SR_PANEL_AMERICAN		 0x04050009
#define SR_TEXT_BUTTON			 0x0405000A
#define SR_SPEED				 0x0405000B
#define SR_SCROLL1				 0x0405000C
#define SR_SCROLL2				 0x0405000D
#define SR_CONFIRM				 0x0405000E
#define SR_VOLUME				 0x0405000F
#define SR_VLIGHT				 0x04050010
#define SR_VKNOB				 0x04050011
#define SR_WINDOW				 0x04050012
#define SR_SLAB1				 0x04050013
#define SR_SLAB2				 0x04050014
#define SR_SLAB3				 0x04050015
#define SR_SLAB4				 0x04050016
#define SR_BUTUF				 0x04050017
#define SR_BUTUS				 0x04050018
#define SR_BUTDS				 0x04050019
#define SR_BUTDF				 0x0405001A
#define SR_DEATHPANEL			 0x0405001B // 0x04050019
	// 26 entities in TXTs, 29 in datafiles.
	// george
#define GEORGE_MEGA				 0x04060000
#define GEORGE_WLK				 0x04060001
#define GEOSHO1					 0x04060002
#define GEOSHO1CDT				 0x04060003
#define GEOSHO1CDR				 0x04060004
#define GEOSHO2					 0x04060005
#define GEOSHO2CDT				 0x04060006
#define GEOSHO2CDR				 0x04060007
#define GEOSHO3					 0x04060008
#define GEOSHO3CDT				 0x04060009
#define GEOSHO3CDR				 0x0406000A
#define GEOSHO5					 0x0406000B
#define GEOSHO5CDT				 0x0406000C
#define GEOSHO5CDR				 0x0406000D
#define GEOSHO6					 0x0406000E
#define GEOSHO6CDT				 0x0406000F
#define GEOSHO6CDR				 0x04060010
#define GEOSHO7					 0x04060011
#define GEOSHO7CDT				 0x04060012
#define GEOSHO7CDR				 0x04060013
#define GEOTLK0					 0x04060014
#define GEOTLK0CDT				 0x04060015
#define GEOTLK1					 0x04060016
#define GEOTLK1CDT				 0x04060017
#define GEOTLK2					 0x04060018
#define GEOTLK2CDT				 0x04060019
#define GEOTLK3					 0x0406001A
#define GEOTLK3CDT				 0x0406001B
#define GEOTLK4					 0x0406001C
#define GEOTLK4CDT				 0x0406001D
#define GEOTLK5					 0x0406001E
#define GEOTLK5CDT				 0x0406001F
#define GEOTLK6					 0x04060020
#define GEOTLK6CDT				 0x04060021
#define GEOTLK7					 0x04060022
#define GEOTLK7CDT				 0x04060023
#define XGEOCRW0				 0x04060024
#define XGEOCRW0CDT				 0x04060025
#define XGEOCRW0CDR				 0x04060026
#define XGEOCRW1				 0x04060027
#define XGEOCRW1CDT				 0x04060028
#define XGEOCRW1CDR				 0x04060029
#define XGEOCRW2				 0x0406002A
#define XGEOCRW2CDT				 0x0406002B
#define XGEOCRW2CDR				 0x0406002C
#define XGEOCRW3				 0x0406002D
#define XGEOCRW3CDT				 0x0406002E
#define XGEOCRW3CDR				 0x0406002F
#define XGEOCRW4				 0x04060030
#define XGEOCRW4CDT				 0x04060031
#define XGEOCRW4CDR				 0x04060032
#define XGEOCRW5				 0x04060033
#define XGEOCRW5CDT				 0x04060034
#define XGEOCRW5CDR				 0x04060035
#define XGEOCRW6				 0x04060036
#define XGEOCRW6CDT				 0x04060037
#define XGEOCRW6CDR				 0x04060038
#define XGEOCRW7				 0x04060039
#define XGEOCRW7CDT				 0x0406003A
#define XGEOCRW7CDR				 0x0406003B
#define XGEOGIV0				 0x0406003C
#define XGEOGIV0CDT				 0x0406003D
#define XGEOGIV0CDR				 0x0406003E
#define XGEOGIV1				 0x0406003F
#define XGEOGIV1CDT				 0x04060040
#define XGEOGIV1CDR				 0x04060041
#define XGEOGIV2				 0x04060042
#define XGEOGIV2CDT				 0x04060043
#define XGEOGIV2CDR				 0x04060044
#define XGEOGIV3				 0x04060045
#define XGEOGIV3CDT				 0x04060046
#define XGEOGIV3CDR				 0x04060047
#define XGEOGIV4				 0x04060048
#define XGEOGIV4CDT				 0x04060049
#define XGEOGIV4CDR				 0x0406004A
#define XGEOGIV5				 0x0406004B
#define XGEOGIV5CDT				 0x0406004C
#define XGEOGIV5CDR				 0x0406004D
#define XGEOGIV6				 0x0406004E
#define XGEOGIV6CDT				 0x0406004F
#define XGEOGIV6CDR				 0x04060050
#define XGEOGIV7				 0x04060051
#define XGEOGIV7CDT				 0x04060052
#define XGEOGIV7CDR				 0x04060053
#define XGEOLUK3				 0x04060054
#define XGEOLUK3CDT				 0x04060055
#define XGEOLUK5				 0x04060056
#define XGEOLUK5CDT				 0x04060057
#define XGEOPIC0				 0x04060058
#define XGEOPIC0CDT				 0x04060059
#define XGEOPIC1				 0x0406005A
#define XGEOPIC1CDT				 0x0406005B
#define XGEOPIC2				 0x0406005C
#define XGEOPIC2CDT				 0x0406005D
#define XGEOPIC3				 0x0406005E
#define XGEOPIC3CDT				 0x0406005F
#define XGEOPIC4				 0x04060060
#define XGEOPIC4CDT				 0x04060061
#define XGEOPIC5				 0x04060062
#define XGEOPIC5CDT				 0x04060063
#define XGEOPIC6				 0x04060064
#define XGEOPIC6CDT				 0x04060065
#define XGEOPIC7				 0x04060066
#define XGEOPIC7CDT				 0x04060067
#define XGEOSHG0				 0x04060068
#define XGEOSHG0CDT				 0x04060069
#define XGEOSHG1				 0x0406006A
#define XGEOSHG1CDT				 0x0406006B
#define XGEOSHG2				 0x0406006C
#define XGEOSHG2CDT				 0x0406006D
#define XGEOSHG3				 0x0406006E
#define XGEOSHG3CDT				 0x0406006F
#define XGEOSHG4				 0x04060070
#define XGEOSHG4CDT				 0x04060071
#define XGEOSHG5				 0x04060072
#define XGEOSHG5CDT				 0x04060073
#define XGEOSHG6				 0x04060074
#define XGEOSHG6CDT				 0x04060075
#define XGEOSHG7				 0x04060076
#define XGEOSHG7CDT				 0x04060077
#define XGHAIR2					 0x04060078
#define XGHAIR2CDT				 0x04060079
#define XGHAIR6					 0x0406007A
#define XGHAIR6CDT				 0x0406007B
#define GEOBLNK2				 0x0406007C
#define GEOBLNK2CDT				 0x0406007D
#define GEOBLNK3				 0x0406007E
#define GEOBLNK3CDT				 0x0406007F
#define GEOBLNK4				 0x04060080
#define GEOBLNK4CDT				 0x04060081
#define GEOBLNK5				 0x04060082
#define GEOBLNK5CDT				 0x04060083
#define GEOBLNK6				 0x04060084
#define GEOBLNK6CDT				 0x04060085
#define XGRELAX0				 0x04060086
#define XGRELAX0CDT				 0x04060087
#define XGRELAX0CDR				 0x04060088
#define XGRELAX1				 0x04060089
#define XGRELAX1CDT				 0x0406008A
#define XGRELAX1CDR				 0x0406008B
#define XGRELAX2				 0x0406008C
#define XGRELAX2CDT				 0x0406008D
#define XGRELAX2CDR				 0x0406008E
#define XGRELAX3				 0x0406008F
#define XGRELAX3CDT				 0x04060090
#define XGRELAX3CDR				 0x04060091
#define XGRELAX4				 0x04060092
#define XGRELAX4CDT				 0x04060093
#define XGRELAX4CDR				 0x04060094
#define XGRELAX5				 0x04060095
#define XGRELAX5CDT				 0x04060096
#define XGRELAX5CDR				 0x04060097
#define XGRELAX6				 0x04060098
#define XGRELAX6CDT				 0x04060099
#define XGRELAX6CDR				 0x0406009A
#define XGRELAX7				 0x0406009B
#define XGRELAX7CDT				 0x0406009C
#define XGRELAX7CDR				 0x0406009D
	// 158 entities in TXTs, 158 in datafiles.
	// nico
#define MEGANICO				 0x04070000
#define NICO_WLK				 0x04070001
#define NICTLK0					 0x04070002
#define NICTLK0CDT				 0x04070003
#define NICTLK1					 0x04070004
#define NICTLK1CDT				 0x04070005
#define NICTLK2					 0x04070006
#define NICTLK2CDT				 0x04070007
#define NICTLK3					 0x04070008
#define NICTLK3CDT				 0x04070009
#define NICTLK4					 0x0407000A
#define NICTLK4CDT				 0x0407000B
#define NICTLK5					 0x0407000C
#define NICTLK5CDT				 0x0407000D
#define NICTLK6					 0x0407000E
#define NICTLK6CDT				 0x0407000F
#define NICTLK7					 0x04070010
#define NICTLK7CDT				 0x04070011
	// 18 entities in TXTs, 18 in datafiles.
// maps
	// room80
#define room80_PAL				 0x05000000
#define room80_l0				 0x05000001
#define TEST_FLR				 0x05000002
#define SPRITE_PAL				 0x05000003
#define AEROPORTCDT				 0x05000004
#define AEROPORT				 0x05000005
#define APRTSTRTCDT				 0x05000006
#define APRTSTRT				 0x05000007
#define BAPHOMETCDT				 0x05000008
#define BAPHOMET				 0x05000009
#define CAFECDT					 0x0500000A
#define CAFE					 0x0500000B
#define COSTUMESCDT				 0x0500000C
#define COSTUMES				 0x0500000D
#define HOSPITALCDT				 0x0500000E
#define HOSPITAL				 0x0500000F
#define HOTELCDT				 0x05000010
#define HOTEL					 0x05000011
#define MONTFACNCDT				 0x05000012
#define MONTFACN				 0x05000013
#define MUSEUMCDT				 0x05000014
#define MUSEUM					 0x05000015
#define POLICECDT				 0x05000016
#define POLICE					 0x05000017
	// 24 entities in TXTs, 24 in datafiles.
	// room86
#define room86_PAL				 0x05010000
#define room86_l0				 0x05010001
#define BANNOCKCDT				 0x05010002
#define BANNOCK					 0x05010003
#define MARIBCDT				 0x05010004
#define MARIB					 0x05010005
#define LOCHMARNCDT				 0x05010006
#define LOCHMARN				 0x05010007
#define PARISCDT				 0x05010008
#define PARIS					 0x05010009
#define VILLAVASCDT				 0x0501000A
#define VILLAVAS				 0x0501000B
	// 12 entities in TXTs, 12 in datafiles.
	// room90
#define R90L0					 0x05020000
#define R90PAL					 0x05020001
#define PHONE_PAL				 0x05020002
#define GBLINK					 0x05020003
#define GBLINKCDT				 0x05020004
#define GRISE					 0x05020005
#define GRISECDT				 0x05020006
#define GRISECDR				 0x05020007
#define GTALK					 0x05020008
#define GTALKCDT				 0x05020009
#define NBLINK					 0x0502000A
#define NBLINKCDT				 0x0502000B
#define NRISE					 0x0502000C
#define NRISECDT				 0x0502000D
#define NRISECDR				 0x0502000E
#define NTALK					 0x0502000F
#define NTALKCDT				 0x05020010
#define TODTALK					 0x05020011
#define TODTALKCDT				 0x05020012
	// 19 entities in TXTs, 19 in datafiles.
	// room91
#define R91L0					 0x05030000
#define R91PAL					 0x05030001
#define CLOWN					 0x05030002
#define CLOWNCDT				 0x05030003
#define DESVAS					 0x05030004
#define DESVASCDT				 0x05030005
#define EIFTOWER				 0x05030006
#define EIFTOWERCDT				 0x05030007
#define HORSETIP				 0x05030008
#define HORSETIPCDT				 0x05030009
#define LOBIN91					 0x0503000A
#define LOBIN91CDT				 0x0503000B
#define MONTFCON				 0x0503000C
#define MONTFCONCDT				 0x0503000D
#define NICOADD					 0x0503000E
#define NICOADDCDT				 0x0503000F
#define NICOPHN					 0x05030010
#define NICOPHNCDT				 0x05030011
#define TAILOR					 0x05030012
#define TAILORCDT				 0x05030013
	// 20 entities in TXTs, 20 in datafiles.
	// room99
#define room99_PAL				 0x05040000
#define room99_l0				 0x05040001
	// 2 entities in TXTs, 2 in datafiles.
// paris_1
	// sound_fx
#define FX_CAMERA1				 0x06000000
#define FX_CAMERA2				 0x06000001
#define FX_CAMERA3				 0x06000002
#define FX_CANDO				 0x06000003
#define FX_CANUP				 0x06000004
#define FX_CAW1					 0x06000005
#define FX_DUST					 0x06000006
#define FX_HORN1				 0x06000007
#define FX_HORN2				 0x06000008
#define FX_HORN3				 0x06000009
#define FX_LVSFLY				 0x0600000A
#define FX_PAP1					 0x0600000B
#define FX_PAP2					 0x0600000C
#define FX_PICK1				 0x0600000D
#define FX_PICK2				 0x0600000E
#define FX_PICK3				 0x0600000F
#define FX_PICK4				 0x06000010
#define FX_PICK5				 0x06000011
#define FX_TRAFFIC2				 0x06000012
#define FX_TWEET1				 0x06000013
#define FX_TWEET2				 0x06000014
#define FX_TWEET3				 0x06000015
#define FX_TWEET4				 0x06000016
#define FX_TWEET5				 0x06000017
#define FX_BIN1					 0x06000018
#define FX_BIN2					 0x06000019
#define FX_BIN3					 0x0600001A
#define FX_CAT					 0x0600001B
#define FX_COVERON2				 0x0600001C
#define FX_CRATE				 0x0600001D
#define FX_DRAIN				 0x0600001E
#define FX_HOLE					 0x0600001F
#define FX_BODY					 0x06000020
#define FX_BOTDN				 0x06000021
#define FX_BOTUP				 0x06000022
#define FX_GULP					 0x06000023
#define FX_LIGHT				 0x06000024
#define FX_PIKUP				 0x06000025
#define FX_PAP3					 0x06000026
#define FX_PAP4					 0x06000027
#define FX_PAP5					 0x06000028
#define FX_PISTOL				 0x06000029
#define FX_TBOX					 0x0600002A
#define FX_KNOKKNOK				 0x0600002B
#define FX_ALBCLO				 0x0600002C
#define FX_ALBOP				 0x0600002D
#define FX_LADD1				 0x0600002E
#define FX_LADD2				 0x0600002F
#define FX_LADD3				 0x06000030
#define FX_RAT1					 0x06000031
#define FX_RAT2					 0x06000032
#define FX_SEWSTEP1				 0x06000033
#define FX_SEWSTEP2				 0x06000034
#define FX_SWATER3				 0x06000035
#define FX_DRIP1				 0x06000036
#define FX_DRIP2				 0x06000037
#define FX_DRIP3				 0x06000038
#define FX_SWATER1				 0x06000039
#define FX_SEWLADD7				 0x0600003A
#define FX_SEWLADU7				 0x0600003B
	// 60 entities in TXTs, 60 in datafiles.
	// room1
#define PARIS1_PAL				 0x06010000
#define room1_PAL				 0x06010001
#define room1_l0				 0x06010002
#define room1_l1				 0x06010003
#define room1_l2				 0x06010004
#define room1_gd1				 0x06010005
#define room1_gd2				 0x06010006
#define room1_flr				 0x06010007
#define room1_plx				 0x06010008
#define BIRDS					 0x06010009
#define BIRDSCDT				 0x0601000A
#define BIRDSA					 0x0601000B
#define BIRDSACDT				 0x0601000C
#define BIRDSB					 0x0601000D
#define BIRDSBCDT				 0x0601000E
#define BIRDSC					 0x0601000F
#define BIRDSCCDT				 0x06010010
#define BIRDSD					 0x06010011
#define BIRDSDCDT				 0x06010012
#define BIRDSE					 0x06010013
#define BIRDSECDT				 0x06010014
#define BIRDSF					 0x06010015
#define BIRDSFCDT				 0x06010016
#define BIRDSG					 0x06010017
#define BIRDSGCDT				 0x06010018
#define BIRDSH					 0x06010019
#define BIRDSHCDT				 0x0601001A
#define BIRDSI					 0x0601001B
#define BIRDSICDT				 0x0601001C
#define CANOPY					 0x0601001D
#define CANOPYCDT				 0x0601001E
#define GEOCAN					 0x0601001F
#define GEOCANCDT				 0x06010020
#define GEONIC					 0x06010021
#define GEONICCDT				 0x06010022
#define GEOPAP					 0x06010023
#define GEOPAPCDT				 0x06010024
#define GEOPAP2					 0x06010025
#define GEOPAP2CDT				 0x06010026
#define LVSFLY					 0x06010027
#define LVSFLYCDT				 0x06010028
#define MOUGRD					 0x06010029
#define MOUGRDCDT				 0x0601002A
#define MOUTLK01				 0x0601002B
#define MOUTLK01CDT				 0x0601002C
#define MOUWLK01				 0x0601002D
#define MOUWLK01CDT				 0x0601002E
#define NICPHT1CDT				 0x0601002F
#define NICPHT1					 0x06010030
#define NICPHT2CDT				 0x06010031
#define NICPHT2					 0x06010032
#define NICPHT3CDT				 0x06010033
#define NICPHT3					 0x06010034
#define NICPHT5CDT				 0x06010035
#define NICPHT5					 0x06010036
#define NICPHT6CDT				 0x06010037
#define NICPHT6					 0x06010038
#define NICPHT7CDT				 0x06010039
#define NICPHT7					 0x0601003A
#define NICWLK01				 0x0601003B
#define NICWLK01CDT				 0x0601003C
#define NWPAPER					 0x0601003D
#define NWPAPERCDT				 0x0601003E
#define WRKDIG01				 0x0601003F
#define WRKDIG01CDT				 0x06010040
#define XGEOPHN3				 0x06010041
#define XGEOPHN3CDT				 0x06010042
#define XGEOPHN5				 0x06010043
#define XGEOPHN5CDT				 0x06010044
#define XNICPHN3CDT				 0x06010045
#define XNICPHN3				 0x06010046
#define XNICPHN5CDT				 0x06010047
#define XNICPHN5				 0x06010048
	// 73 entities in TXTs, 73 in datafiles.
	// room2
#define room2_PAL				 0x06020000
#define room2_l0				 0x06020001
#define room2_l1				 0x06020002
#define room2_l2				 0x06020003
#define room2_gd1				 0x06020004
#define room2_gd2				 0x06020005
#define room2_flr				 0x06020006
#define BIN1					 0x06020007
#define BIN1CDT					 0x06020008
#define BIN2					 0x06020009
#define BIN2CDT					 0x0602000A
#define BIN3					 0x0602000B
#define BIN3CDT					 0x0602000C
#define CATJMP					 0x0602000D
#define CATJMPCDT				 0x0602000E
#define CRATE					 0x0602000F
#define CRATECDT				 0x06020010
#define DRNBRK					 0x06020011
#define DRNBRKCDT				 0x06020012
#define GEOBIN					 0x06020013
#define GEOBINCDT				 0x06020014
#define GEOBOX					 0x06020015
#define GEOBOXCDT				 0x06020016
#define GEOBRS					 0x06020017
#define GEOBRSCDT				 0x06020018
#define GEOCAT					 0x06020019
#define GEOCATCDT				 0x0602001A
#define GEOCATE					 0x0602001B
#define GEOCATECDT				 0x0602001C
#define GEOCLM02				 0x0602001D
#define GEOCLM02CDT				 0x0602001E
#define GEOCRT					 0x0602001F
#define GEOCRTCDT				 0x06020020
#define GEODWN					 0x06020021
#define GEODWNCDT				 0x06020022
#define GEOLID					 0x06020023
#define GEOLIDCDT				 0x06020024
#define GEOLIDCDR				 0x06020025
#define GEOMAN8					 0x06020026
#define GEOMAN8CDT				 0x06020027
#define GEOMAN9					 0x06020028
#define GEOMAN9CDT				 0x06020029
#define GEOOUT					 0x0602002A
#define GEOOUTCDT				 0x0602002B
#define GEOPLL02				 0x0602002C
#define GEOPLL02CDT				 0x0602002D
#define GEOTRY02				 0x0602002E
#define GEOTRY02CDT				 0x0602002F
#define MANCOV					 0x06020030
#define MANCOVCDT				 0x06020031
#define MANCVOFF				 0x06020032
#define MANCVOFFCDT				 0x06020033
	// 52 entities in TXTs, 52 in datafiles.
	// room3
#define room3_PAL				 0x06030000
#define room3_l0				 0x06030001
#define room3_l1				 0x06030002
#define room3_l2				 0x06030003
#define room3_gd1				 0x06030004
#define room3_gd2				 0x06030005
#define room3_flr				 0x06030006
#define BOTTLE					 0x06030007
#define BOTTLECDT				 0x06030008
#define BOTTLE1					 0x06030009
#define BOTTLE1CDT				 0x0603000A
#define CHNDRN					 0x0603000B
#define CHNDRNCDT				 0x0603000C
#define CHNFNT					 0x0603000D
#define CHNFNTCDT				 0x0603000E
#define CHNSITA					 0x0603000F
#define CHNSITACDT				 0x06030010
#define CHNSIT					 0x06030011
#define CHNSITCDT				 0x06030012
#define CHNTLK					 0x06030013
#define CHNTLKCDT				 0x06030014
#define CHNUPP					 0x06030015
#define CHNUPPCDT				 0x06030016
#define CHNUPPCDR				 0x06030017
#define CORPSE					 0x06030018
#define CORPSECDT				 0x06030019
#define FLICKER					 0x0603001A
#define FLICKERCDT				 0x0603001B
#define GEOBOT3					 0x0603001C
#define GEOBOT3CDT				 0x0603001D
#define GEOCARD3				 0x0603001E
#define GEOCARD3CDT				 0x0603001F
#define GEOCHN					 0x06030020
#define GEOCHNCDT				 0x06030021
#define GEOCPS					 0x06030022
#define GEOCPSCDT				 0x06030023
#define GEOCPSCDR				 0x06030024
#define MOUCHN					 0x06030025
#define MOUCHNCDT				 0x06030026
#define MOUCHN8					 0x06030027
#define MOUCHN8CDT				 0x06030028
#define MOUCPS					 0x06030029
#define MOUCPSCDT				 0x0603002A
#define MOUCPSTK				 0x0603002B
#define MOUCPSTKCDT				 0x0603002C
#define MOUDOR03				 0x0603002D
#define MOUDOR03CDT				 0x0603002E
#define MOUROS					 0x0603002F
#define MOUROSCDT				 0x06030030
#define MOUROS1					 0x06030031
#define MOUROS1CDT				 0x06030032
#define MOUROS1CDR				 0x06030033
#define MOUROS2					 0x06030034
#define MOUROS2CDT				 0x06030035
#define MOUSTD					 0x06030036
#define MOUSTDCDT				 0x06030037
#define MOUTALK					 0x06030038
#define MOUTALKCDT				 0x06030039
#define MOUTLK1					 0x0603003A
#define MOUTLK1CDT				 0x0603003B
#define MOUTRN03				 0x0603003C
#define MOUTRN03CDT				 0x0603003D
#define MOUTRN03CDR				 0x0603003E
#define MOUTRN2					 0x0603003F
#define MOUTRN2CDT				 0x06030040
#define MOUTRN2CDR				 0x06030041
#define MOUWLK					 0x06030042
#define MOUWLKCDT				 0x06030043
#define MOUWLK03				 0x06030044
#define MOUWLK03CDT				 0x06030045
#define ROSCARD					 0x06030046
#define ROSCARDCDT				 0x06030047
#define ROSCHN					 0x06030048
#define ROSCHNCDT				 0x06030049
#define ROSCHNCDR				 0x0603004A
#define ROSGEO					 0x0603004B
#define ROSGEOCDT				 0x0603004C
#define ROSGEOA					 0x0603004D
#define ROSGEOACDT				 0x0603004E
#define ROSGEOB					 0x0603004F
#define ROSGEOBCDT				 0x06030050
#define ROSGEOC					 0x06030051
#define ROSGEOCCDT				 0x06030052
#define ROSLIK					 0x06030053
#define ROSLIKCDT				 0x06030054
#define ROSLUK					 0x06030055
#define ROSLUKCDT				 0x06030056
#define ROSMOU					 0x06030057
#define ROSMOUCDT				 0x06030058
#define ROSNBK					 0x06030059
#define ROSNBKCDT				 0x0603005A
#define ROSNBK8					 0x0603005B
#define ROSNBK8CDT				 0x0603005C
#define ROSPKT					 0x0603005D
#define ROSPKTCDT				 0x0603005E
#define ROSTMP					 0x0603005F
#define ROSTMPCDT				 0x06030060
#define ROSTMP8					 0x06030061
#define ROSTMP8CDT				 0x06030062
#define ROSTURNA				 0x06030063
#define ROSTURNACDT				 0x06030064
#define ROSTURNB				 0x06030065
#define ROSTURNBCDT				 0x06030066
#define ROSTRN2					 0x06030067
#define ROSTRN2CDT				 0x06030068
#define ROSWRT					 0x06030069
#define ROSWRTCDT				 0x0603006A
	// 107 entities in TXTs, 107 in datafiles.
	// room4
#define room4_PAL				 0x06040000
#define room4_l0				 0x06040001
#define room4_l1				 0x06040002
#define room4_l2				 0x06040003
#define room4_gd1				 0x06040004
#define room4_gd2				 0x06040005
#define room4_flr				 0x06040006
#define ALBDOR					 0x06040007
#define ALBDORCDR				 0x06040008
#define ALBDORCDT				 0x06040009
#define ALBDOR8					 0x0604000A
#define ALBDOR8CDT				 0x0604000B
#define GEONOK					 0x0604000C
#define GEONOKCDT				 0x0604000D
#define GEONOKCDR				 0x0604000E
#define GEOTBX					 0x0604000F
#define GEOTBXCDT				 0x06040010
#define GEOWRK					 0x06040011
#define GEOWRKCDT				 0x06040012
#define GEOWRK8					 0x06040013
#define GEOWRK8CDT				 0x06040014
#define MOUENT					 0x06040015
#define MOUENTCDT				 0x06040016
#define MOUSHG					 0x06040017
#define MOUSHGCDT				 0x06040018
#define MOUSTR					 0x06040019
#define MOUSTRCDT				 0x0604001A
#define MOUTLK04				 0x0604001B
#define MOUTLK04CDT				 0x0604001C
#define MOUWLK04				 0x0604001D
#define MOUWLK04CDT				 0x0604001E
#define ROSENT					 0x0604001F
#define ROSENTCDT				 0x06040020
#define ROSTLK04				 0x06040021
#define ROSTLK04CDT				 0x06040022
#define ROSWLK					 0x06040023
#define ROSWLKCDT				 0x06040024
#define PHONE4					 0x06040025
#define PHONE4CDT				 0x06040026
#define WRKAXE					 0x06040027
#define WRKAXECDT				 0x06040028
#define WRKBLINK				 0x06040029
#define WRKBLINKCDT				 0x0604002A
#define WRKCLM					 0x0604002B
#define WRKCLMCDT				 0x0604002C
#define WRKDIG					 0x0604002D
#define WRKDIGCDT				 0x0604002E
#define WRKPPR					 0x0604002F
#define WRKPPRCDT				 0x06040030
#define WRKTLK					 0x06040031
#define WRKTLKCDT				 0x06040032
#define WRKTLK8					 0x06040033
#define WRKTLK8CDT				 0x06040034
#define WRKTLK9					 0x06040035
#define WRKTLK9CDT				 0x06040036
#define WRKTRN					 0x06040037
#define WRKTRNCDR				 0x06040038
#define WRKTRNCDT				 0x06040039
#define WRKXIT					 0x0604003A
#define WRKXITCDT				 0x0604003B
	// 60 entities in TXTs, 60 in datafiles.
	// room5
#define room5_PAL				 0x06050000
#define room5_l0				 0x06050001
#define room5_l1				 0x06050002
#define room5_l2				 0x06050003
#define room5_gd1				 0x06050004
#define room5_gd2				 0x06050005
#define room5_flr				 0x06050006
#define ALBAPT					 0x06050007
#define ALBAPTCDT				 0x06050008
#define ALBAPTCDR				 0x06050009
#define ALBCLOSECDT				 0x0605000A
#define ALBCLOSE				 0x0605000B
#define ALBCRD8					 0x0605000C
#define ALBCRD8CDT				 0x0605000D
#define ALBDORTKCDT				 0x0605000E
#define ALBDORTK				 0x0605000F
#define ALBDRTK2CDT				 0x06050010
#define ALBDRTK2				 0x06050011
#define ALBHND					 0x06050012
#define ALBHNDCDT				 0x06050013
#define ALBOBJ					 0x06050014
#define ALBOBJCDT				 0x06050015
#define ALBOPENCDT				 0x06050016
#define ALBOPEN					 0x06050017
#define ALBPKT					 0x06050018
#define ALBPKTCDT				 0x06050019
#define ALBTLK					 0x0605001A
#define ALBTLKCDT				 0x0605001B
#define ALBWLK9CDT				 0x0605001C
#define ALBWLK9					 0x0605001D
#define GEOCRD05				 0x0605001E
#define GEOCRD05CDT				 0x0605001F
#define GEODOR05CDT				 0x06050020
#define GEODOR05				 0x06050021
#define GEOEMG					 0x06050022
#define GEOEMGCDT				 0x06050023
#define GEOEMGCDR				 0x06050024
#define GEOEMGA					 0x06050025
#define GEOEMGACDT				 0x06050026
#define GEOEMGACDR				 0x06050027
#define GEOEMGB					 0x06050028
#define GEOEMGBCDT				 0x06050029
#define GEOEMGBCDR				 0x0605002A
#define GEOEXITCDT				 0x0605002B
#define GEOEXIT					 0x0605002C
#define GEOHND05				 0x0605002D
#define GEOHND05CDT				 0x0605002E
#define GEONOK05CDT				 0x0605002F
#define GEONOK05				 0x06050030
#define GEOTLK05				 0x06050031
#define GEOTLK05CDT				 0x06050032
	// 51 entities in TXTs, 51 in datafiles.
	// room6
#define SEWER_PAL				 0x06060000
#define room6_PAL				 0x06060001
#define room6_l0				 0x06060002
#define room6_l1				 0x06060003
#define room6_gd1				 0x06060004
#define room6_flr				 0x06060005
#define GEOASC06				 0x06060006
#define GEOASC06CDT				 0x06060007
#define GEODES06				 0x06060008
#define GEODES06CDT				 0x06060009
#define GEONOSE					 0x0606000A
#define GEONOSECDT				 0x0606000B
#define REDNOSE					 0x0606000C
#define REDNOSECDT				 0x0606000D
#define WATER06					 0x0606000E
#define WATER06CDT				 0x0606000F
	// 16 entities in TXTs, 16 in datafiles.
	// room7
#define room7_PAL				 0x06070000
#define room7_l0				 0x06070001
#define room7_l1				 0x06070002
#define room7_l2				 0x06070003
#define room7_gd1				 0x06070004
#define room7_gd2				 0x06070005
#define room7_flr				 0x06070006
#define GEOASC07				 0x06070007
#define GEOASC07CDT				 0x06070008
#define GEOASC07CDR				 0x06070009
#define GEOPLL07				 0x0607000A
#define GEOPLL07CDT				 0x0607000B
#define GEOPLL07CDR				 0x0607000C
#define GEOSPK					 0x0607000D
#define GEOSPKCDT				 0x0607000E
#define GEOTIS					 0x0607000F
#define GEOTISCDT				 0x06070010
#define MATERIAL				 0x06070011
#define MATERIALCDT				 0x06070012
#define TISSUE7					 0x06070013
#define TISSUE7CDT				 0x06070014
#define WATER07					 0x06070015
#define WATER07CDT				 0x06070016
	// 23 entities in TXTs, 23 in datafiles.
	// room8
#define room8_PAL				 0x06080000
#define room8_l0				 0x06080001
#define room8_l1				 0x06080002
#define room8_l2				 0x06080003
#define room8_gd1				 0x06080004
#define room8_gd2				 0x06080005
#define room8_flr				 0x06080006
#define room8_plx				 0x06080007
	// 8 entities in TXTs, 8 in datafiles.
// paris_2
	// sound_fx
#define FX_BIRD					 0x07000000
#define FX_BIRD2				 0x07000001
#define FX_CARLTON				 0x07000002
#define FX_CARS					 0x07000003
#define FX_DOORTRY				 0x07000004
#define FX_FIESTA				 0x07000005
#define FX_FLATDOOR				 0x07000006
#define FX_HVYVEHR				 0x07000007
#define FX_HVYVEHL				 0x07000008
#define FX_LITEVEHR				 0x07000009
#define FX_LITEVEHL				 0x0700000A
#define FX_FONEUP				 0x0700000B
#define FX_FONEDN				 0x0700000C
#define FX_GEOCCH				 0x0700000D
#define FX_GEOCHAIR				 0x0700000E
#define FX_GEOCHR9				 0x0700000F
#define FX_NICOPEN				 0x07000010
#define FX_NICLOSE				 0x07000011
#define FX_PHONICO1				 0x07000012
#define FX_GRAMOFON				 0x07000013
#define FX_SHOCK1				 0x07000014
#define FX_WINDUP11				 0x07000015
#define FX_FRISK				 0x07000016
#define FX_TRAFFIC3				 0x07000017
#define FX_DESKBELL				 0x07000018
#define FX_KEY13				 0x07000019
#define FX_PAPER6				 0x0700001A
#define FX_PHONEDN2				 0x0700001B
#define FX_PHONEUP2				 0x0700001C
#define FX_PIANO14				 0x0700001D
#define FX_TRYDOR14				 0x0700001E
#define FX_CABCLOSE				 0x0700001F
#define FX_CABOPEN				 0x07000020
#define FX_DORCLOSE				 0x07000021
#define FX_WINDOPEN				 0x07000022
#define FX_COO					 0x07000023
#define FX_COO2					 0x07000024
#define FX_LEDGE1				 0x07000025
#define FX_LEDGE2				 0x07000026
#define FX_BRIEFOFF				 0x07000027
#define FX_BRIEFON				 0x07000028
#define FX_JUMPIN				 0x07000029
#define FX_WARDIN				 0x0700002A
#define FX_WARDOUT				 0x0700002B
#define FX_CLIMBIN				 0x0700002C
#define FX_CLIMBOUT				 0x0700002D
	// 46 entities in TXTs, 46 in datafiles.
	// room9
#define PARIS2_PAL				 0x07010000
#define room9_PAL				 0x07010001
#define room9_l0				 0x07010002
#define room9_l1				 0x07010003
#define room9_l2				 0x07010004
#define room9_gd1				 0x07010005
#define room9_gd2				 0x07010006
#define room9_flr				 0x07010007
#define CARA9CDT				 0x07010008
#define CARA9					 0x07010009
#define CARB9CDT				 0x0701000A
#define CARB9					 0x0701000B
#define CARC9CDT				 0x0701000C
#define CARC9					 0x0701000D
#define DOROPN09CDR				 0x0701000E
#define DOROPN09CDT				 0x0701000F
#define DOROPN09				 0x07010010
#define FLWLUKCDR				 0x07010011
#define FLWLUKCDT				 0x07010012
#define FLWLUK					 0x07010013
#define FLWNITCDT				 0x07010014
#define FLWNIT					 0x07010015
#define FLWTLKCDT				 0x07010016
#define FLWTLK					 0x07010017
#define GEODOOR9				 0x07010018
#define GEODOOR9CDT				 0x07010019
#define GEOSTPCDT				 0x0701001A
#define GEOSTP					 0x0701001B
#define GEOSTP8CDT				 0x0701001C
#define GEOSTP8					 0x0701001D
#define GEOTRY					 0x0701001E
#define GEOTRYCDT				 0x0701001F
#define TRUCKA9CDT				 0x07010020
#define TRUCKA9					 0x07010021
#define TRUCKB9CDT				 0x07010022
#define TRUCKB9					 0x07010023
#define TRUCKC9CDT				 0x07010024
#define TRUCKC9					 0x07010025
	// 38 entities in TXTs, 38 in datafiles.
	// room10
#define R10SPRPAL				 0x07020000
#define room10_PAL				 0x07020001
#define room10_l0				 0x07020002
#define room10_l1				 0x07020003
#define room10_gd1				 0x07020004
#define room10_flr				 0x07020005
#define DOORCDT					 0x07020006
#define DOOR					 0x07020007
#define GEOCCHCDT				 0x07020008
#define GEOCCHCDR				 0x07020009
#define GEOCCH					 0x0702000A
#define GEOCCH8CDT				 0x0702000B
#define GEOCCH8					 0x0702000C
#define GEOCCH9CDT				 0x0702000D
#define GEOCCH9					 0x0702000E
#define GEOCHRCDT				 0x0702000F
#define GEOCHR					 0x07020010
#define GEOCHR8CDT				 0x07020011
#define GEOCHR8					 0x07020012
#define GEOCHR9CDT				 0x07020013
#define GEOCHR9					 0x07020014
#define GEODWN10CDT				 0x07020015
#define GEODWN10				 0x07020016
#define GEOENT10CDT				 0x07020017
#define GEOENT10				 0x07020018
#define GEOGEM10CDT				 0x07020019
#define GEOGEM10				 0x0702001A
#define GEOGEMBCDT				 0x0702001B
#define GEOGEMB					 0x0702001C
#define GEOLUK10CDT				 0x0702001D
#define GEOLUK10				 0x0702001E
#define GEOLVS10CDT				 0x0702001F
#define GEOLVS10				 0x07020020
#define GEOMAGTKCDT				 0x07020021
#define GEOMAGTK				 0x07020022
#define GEOMAT10CDT				 0x07020023
#define GEOMAT10				 0x07020024
#define GEOMATBCDT				 0x07020025
#define GEOMATB					 0x07020026
#define GEOMATCCDT				 0x07020027
#define GEOMATC					 0x07020028
#define GEONIC10CDR				 0x07020029
#define GEONIC10CDT				 0x0702002A
#define GEONIC10				 0x0702002B
#define GEONOSCDT				 0x0702002C
#define GEONOS					 0x0702002D
#define GEONOS10CDT				 0x0702002E
#define GEONOS10				 0x0702002F
#define GEONWPAPCDT				 0x07020030
#define GEONWPAP				 0x07020031
#define GEOPHN10CDT				 0x07020032
#define GEOPHN10				 0x07020033
#define GEOPHTCDT				 0x07020034
#define GEOPHT					 0x07020035
#define GEOPHT10CDT				 0x07020036
#define GEOPHT10				 0x07020037
#define GEOPHTLKCDT				 0x07020038
#define GEOPHTLK				 0x07020039
#define GEOPPR10CDT				 0x0702003A
#define GEOPPR10				 0x0702003B
#define GEOPRDCDT				 0x0702003C
#define GEOPRD					 0x0702003D
#define GEOREDCDT				 0x0702003E
#define GEORED					 0x0702003F
#define GEORELCDR				 0x07020040
#define GEORELCDT				 0x07020041
#define GEOREL					 0x07020042
#define GEORXTCDT				 0x07020043
#define GEORXT					 0x07020044
#define GEOTIS10CDT				 0x07020045
#define GEOTIS10				 0x07020046
#define GEOTISBCDT				 0x07020047
#define GEOTISB					 0x07020048
#define GEOTRIP1CDT				 0x07020049
#define GEOTRIP1				 0x0702004A
#define GEOTRIP2CDT				 0x0702004B
#define GEOTRIP2				 0x0702004C
#define LOBTLK10CDT				 0x0702004D
#define LOBTLK10				 0x0702004E
#define MANUCDT					 0x0702004F
#define MANU					 0x07020050
#define NICCHR9CDR				 0x07020051
#define NICCHR9CDT				 0x07020052
#define NICCHR9					 0x07020053
#define NICDWN10CDT				 0x07020054
#define NICDWN10				 0x07020055
#define NICLUK10CDT				 0x07020056
#define NICLUK10				 0x07020057
#define NICMAGCDR				 0x07020058
#define NICMAGCDT				 0x07020059
#define NICMAG					 0x0702005A
#define NICNOSCDT				 0x0702005B
#define NICNOS					 0x0702005C
#define NICNOS10CDT				 0x0702005D
#define NICNOS10				 0x0702005E
#define NICNOSBCDT				 0x0702005F
#define NICNOSB					 0x07020060
#define NICPHN10CDT				 0x07020061
#define NICPHN10				 0x07020062
#define NICPHT10CDT				 0x07020063
#define NICPHT10				 0x07020064
#define NICPPRCDT				 0x07020065
#define NICPPR					 0x07020066
#define NICPPR2CDT				 0x07020067
#define NICPPR2					 0x07020068
#define NICREDCDT				 0x07020069
#define NICRED					 0x0702006A
#define NICRED2CDR				 0x0702006B
#define NICRED2CDT				 0x0702006C
#define NICRED2					 0x0702006D
#define NICSIT					 0x0702006E
#define NICSITCDT				 0x0702006F
#define NICTLK10CDT				 0x07020070
#define NICTLK10				 0x07020071
#define NICTLKL					 0x07020072
#define NICTLKLCDT				 0x07020073
#define NICTLKR					 0x07020074
#define NICTLKRCDT				 0x07020075
#define NICTLKX					 0x07020076
#define NICTLKXCDT				 0x07020077
#define NICTLKXCDR				 0x07020078
#define NICTRIPCDT				 0x07020079
#define NICTRIP					 0x0702007A
#define NICTURN					 0x0702007B
#define NICTURNCDT				 0x0702007C
#define NICTURNCDR				 0x0702007D
#define NICWRT					 0x0702007E
#define NICWRTCDT				 0x0702007F
#define PHONE10CDT				 0x07020080
#define PHONE10					 0x07020081
#define PEAPAGECDT				 0x07020082
#define PEAPAGE					 0x07020083
#define PEAPAGE_PAL				 0x07020084
#define MANUSCRPCDT				 0x07020085
#define MANUSCRP				 0x07020086
#define MANUSCRP_PAL			 0x07020087
#define TRIPOD10CDT				 0x07020088
#define TRIPOD10				 0x07020089
	// 138 entities in TXTs, 138 in datafiles.
	// room11
#define room11_PAL				 0x07030000
#define room11_l0				 0x07030001
#define room11_l1				 0x07030002
#define room11_l2				 0x07030003
#define room11_gd1				 0x07030004
#define room11_gd2				 0x07030005
#define room11_flr				 0x07030006
#define COSGIVCDR				 0x07030007
#define COSGIVCDT				 0x07030008
#define COSGIV					 0x07030009
#define COSLOOPCDT				 0x0703000A
#define COSLOOP					 0x0703000B
#define COSSHKCDT				 0x0703000C
#define COSSHK					 0x0703000D
#define COSSNFCDT				 0x0703000E
#define COSSNF					 0x0703000F
#define COSTLKCDT				 0x07030010
#define COSTLK					 0x07030011
#define DISCSPINCDT				 0x07030012
#define DISCSPIN				 0x07030013
#define GEOPIC11CDR				 0x07030014
#define GEOPIC11CDT				 0x07030015
#define GEOPIC11				 0x07030016
#define GEOSHK11CDT				 0x07030017
#define GEOSHK11				 0x07030018
#define GEOTURDCDT				 0x07030019
#define GEOTURD					 0x0703001A
#define GEOTIS11CDT				 0x0703001B
#define GEOTIS11				 0x0703001C
#define GEOWINDCDT				 0x0703001D
#define GEOWIND					 0x0703001E
#define WINDUPCDT				 0x0703001F
#define WINDUP					 0x07030020
	// 33 entities in TXTs, 33 in datafiles.
	// room12
#define room12_PAL				 0x07040000
#define room12_l0				 0x07040001
#define room12_l1				 0x07040002
#define room12_gd1				 0x07040003
#define room12_flr				 0x07040004
#define FLAGSCDT				 0x07040005
#define FLAGS					 0x07040006
#define GEOAPPCDT				 0x07040007
#define GEOAPP					 0x07040008
#define GEOARMCDT				 0x07040009
#define GEOARM					 0x0704000A
#define GEOASC12CDT				 0x0704000B
#define GEOASC12				 0x0704000C
#define GEODES12CDT				 0x0704000D
#define GEODES12				 0x0704000E
#define GORCOINCDT				 0x0704000F
#define GORCOIN					 0x07040010
#define GORFRKCDT				 0x07040011
#define GORFRK					 0x07040012
#define GORMANCDT				 0x07040013
#define GORMAN					 0x07040014
#define GORTALKCDT				 0x07040015
#define GORTALK					 0x07040016
#define GORTLKCDT				 0x07040017
#define GORTLK					 0x07040018
#define GORTURNCDR				 0x07040019
#define GORTURNCDT				 0x0704001A
#define GORTURN					 0x0704001B
#define LATVIAN12CDT			 0x0704001C
#define LATVIAN12				 0x0704001D
#define WEABAKCDT				 0x0704001E
#define WEABAK					 0x0704001F
#define WEASMKCDT				 0x07040020
#define WEASMK					 0x07040021
#define WEATLKCDT				 0x07040022
#define WEATLK					 0x07040023
#define WEATLK12CDT				 0x07040024
#define WEATLK12				 0x07040025
#define WEATRNCDR				 0x07040026
#define WEATRNCDT				 0x07040027
#define WEATRN					 0x07040028
	// 41 entities in TXTs, 41 in datafiles.
	// room13
#define R13SPRPAL				 0x07050000
#define room13_PAL				 0x07050001
#define room13_l0				 0x07050002
#define room13_l1				 0x07050003
#define room13_l2				 0x07050004
#define room13_gd1				 0x07050005
#define room13_gd2				 0x07050006
#define room13_flr				 0x07050007
#define CLKIDLCDT				 0x07050008
#define CLKIDL					 0x07050009
#define CLKMANCDT				 0x0705000A
#define CLKMAN					 0x0705000B
#define CLKTAKCDT				 0x0705000C
#define CLKTAK					 0x0705000D
#define CLKTLKCDT				 0x0705000E
#define CLKTLK					 0x0705000F
#define CLKTLK2CDT				 0x07050010
#define CLKTLK2					 0x07050011
#define CLKTLK3CDT				 0x07050012
#define CLKTLK3					 0x07050013
#define CLKTURNCDR				 0x07050014
#define CLKTURNCDT				 0x07050015
#define CLKTURN					 0x07050016
#define CLKWLKCDT				 0x07050017
#define CLKWLK					 0x07050018
#define CLKWLK2CDT				 0x07050019
#define CLKWLK2					 0x0705001A
#define CLKWLK3CDT				 0x0705001B
#define CLKWLK3					 0x0705001C
#define CLKWULCDT				 0x0705001D
#define CLKWUL					 0x0705001E
#define GEOASC13CDT				 0x0705001F
#define GEOASC13				 0x07050020
#define GEODES13CDT				 0x07050021
#define GEODES13				 0x07050022
#define GEOKEYCDT				 0x07050023
#define GEOKEY					 0x07050024
#define GEOKEY13CDT				 0x07050025
#define GEOKEY13				 0x07050026
#define GEOMAN13CDT				 0x07050027
#define GEOMAN13				 0x07050028
#define GEOTELCDT				 0x07050029
#define GEOTEL					 0x0705002A
#define GEOTEL9CDT				 0x0705002B
#define GEOTEL9					 0x0705002C
#define KEY13CDT				 0x0705002D
#define KEY13					 0x0705002E
#define LATLUKCDR				 0x0705002F
#define LATLUKCDT				 0x07050030
#define LATLUK					 0x07050031
#define LATRDSCDT				 0x07050032
#define LATRDS					 0x07050033
#define LATTLKCDT				 0x07050034
#define LATTLK					 0x07050035
#define PMTGIVCDT				 0x07050036
#define PMTGIV					 0x07050037
#define PMTPNOCDT				 0x07050038
#define PMTPNO					 0x07050039
#define PMTSTDCDT				 0x0705003A
#define PMTSTD					 0x0705003B
#define PMTTLKCDT				 0x0705003C
#define PMTTLK					 0x0705003D
#define PMTTLK8CDT				 0x0705003E
#define PMTTLK8					 0x0705003F
#define PMTTLK9CDT				 0x07050040
#define PMTTLK9					 0x07050041
#define PMTTOTLKCDR				 0x07050042
#define PMTTOTLKCDT				 0x07050043
#define PMTTOTLK				 0x07050044
#define PMTTURNCDR				 0x07050045
#define PMTTURNCDT				 0x07050046
#define PMTTURN					 0x07050047
#define PMTWLK1CDT				 0x07050048
#define PMTWLK1					 0x07050049
#define PMTWLK2CDT				 0x0705004A
#define PMTWLK2					 0x0705004B
	// 76 entities in TXTs, 76 in datafiles.
	// room14
#define room14_PAL				 0x07060000
#define room14_l0				 0x07060001
#define room14_l1				 0x07060002
#define room14_gd1				 0x07060003
#define room14_flr				 0x07060004
#define GEOASC14CDT				 0x07060005
#define GEOASC14				 0x07060006
#define GEODES14CDT				 0x07060007
#define GEODES14				 0x07060008
#define GEODORCDR				 0x07060009
#define GEODORCDT				 0x0706000A
#define GEODOR					 0x0706000B
	// 12 entities in TXTs, 12 in datafiles.
	// room15
#define room15_PAL				 0x07070000
#define room15_l0				 0x07070001
#define room15_l1				 0x07070002
#define room15_l2				 0x07070003
#define room15_gd1				 0x07070004
#define room15_gd2				 0x07070005
#define room15_flr				 0x07070006
#define DOROPN15CDT				 0x07070007
#define DOROPN15				 0x07070008
#define GEOBEDCDR				 0x07070009
#define GEOBEDCDT				 0x0707000A
#define GEOBED					 0x0707000B
#define GEODOR15CDT				 0x0707000C
#define GEODOR15				 0x0707000D
#define GEOENT15CDT				 0x0707000E
#define GEOENT15				 0x0707000F
#define GEOWIN1CDT				 0x07070010
#define GEOWIN1					 0x07070011
#define GEOWIN15CDT				 0x07070012
#define GEOWIN15				 0x07070013
#define GEOWIN2CDT				 0x07070014
#define GEOWIN2					 0x07070015
#define GEOWRBCDR				 0x07070016
#define GEOWRBCDT				 0x07070017
#define GEOWRB					 0x07070018
#define WINDOWCDT				 0x07070019
#define WINDOW					 0x0707001A
	// 27 entities in TXTs, 27 in datafiles.
	// room16
#define room16_PAL				 0x07080000
#define R16L0					 0x07080001
#define R16L1					 0x07080002
#define R16G1					 0x07080003
#define GEOILWCDT				 0x07080004
#define GEOILW					 0x07080005
#define GEOIRWCDT				 0x07080006
#define GEOIRW					 0x07080007
#define GEOMANLCDT				 0x07080008
#define GEOMANL					 0x07080009
#define GEOMANRCDT				 0x0708000A
#define GEOMANR					 0x0708000B
#define GEOMLWCDT				 0x0708000C
#define GEOMLW					 0x0708000D
#define GEOMRWCDT				 0x0708000E
#define GEOMRW					 0x0708000F
#define GEOOLWCDT				 0x07080010
#define GEOOLWCDR				 0x07080011
#define GEOOLW					 0x07080012
#define GEOORWCDT				 0x07080013
#define GEOORWCDR				 0x07080014
#define GEOORW					 0x07080015
#define MANLCDT					 0x07080016
#define MANL					 0x07080017
#define MANRCDT					 0x07080018
#define MANR					 0x07080019
	// 26 entities in TXTs, 26 in datafiles.
	// room17
#define room17_PAL				 0x07090000
#define room17_l0				 0x07090001
#define room17_l1				 0x07090002
#define room17_l2				 0x07090003
#define room17_gd1				 0x07090004
#define room17_gd2				 0x07090005
#define room17_flr				 0x07090006
#define IBACK17					 0x07090007
#define IBACK17PAL				 0x07090008
#define GEOINQ17				 0x07090009
#define GEOINQ17CDT				 0x0709000A
#define SBACK17					 0x0709000B
#define SBACK17PAL				 0x0709000C
#define GEOSUR17				 0x0709000D
#define GEOSUR17CDT				 0x0709000E
#define ASSTAIR2_PAL			 0x0709000F
#define ASSTAIR2				 0x07090010
#define ASSTAIRCDT				 0x07090011
#define ASSTAIR					 0x07090012
#define ASSDORCDT				 0x07090013
#define ASSDOR					 0x07090014
#define ASSDOR2CDT				 0x07090015
#define ASSDOR2					 0x07090016
#define ASSTRWCDT				 0x07090017
#define ASSTRW					 0x07090018
#define ASSWRBCDT				 0x07090019
#define ASSWRB					 0x0709001A
#define ASWLK17CDT				 0x0709001B
#define ASWLK17					 0x0709001C
#define BRFCASECDT				 0x0709001D
#define BRFCASE					 0x0709001E
#define GEOBCBCDR				 0x0709001F
#define GEOBCBCDT				 0x07090020
#define GEOBCB					 0x07090021
#define GEOBED17CDT				 0x07090022
#define GEOBED17				 0x07090023
#define GEOBFCCDR				 0x07090024
#define GEOBFCCDT				 0x07090025
#define GEOBFC					 0x07090026
#define GEODOR17CDT				 0x07090027
#define GEODOR17				 0x07090028
#define GEODOR2CDR				 0x07090029
#define GEODOR2CDT				 0x0709002A
#define GEODOR2					 0x0709002B
#define GEOPANTSCDT				 0x0709002C
#define GEOPANTS				 0x0709002D
#define GEOWIN8CDT				 0x0709002E
#define GEOWIN8					 0x0709002F
#define GEOWIN9CDT				 0x07090030
#define GEOWIN9					 0x07090031
#define GEOWRB1CDR				 0x07090032
#define GEOWRB1CDT				 0x07090033
#define GEOWRB1					 0x07090034
#define GEOWRB2CDT				 0x07090035
#define GEOWRB2					 0x07090036
#define GEOWRB3CDR				 0x07090037
#define GEOWRB3CDT				 0x07090038
#define GEOWRB3					 0x07090039
#define GEOWRB4CDT				 0x0709003A
#define GEOWRB4					 0x0709003B
#define PANTS2CDT				 0x0709003C
#define PANTS2					 0x0709003D
#define PANTWRBCDT				 0x0709003E
#define PANTWRB					 0x0709003F
#define STATDOORCDT				 0x07090040
#define STATDOOR				 0x07090041
#define WRBDOR17CDT				 0x07090042
#define WRBDOR17				 0x07090043
	// 68 entities in TXTs, 68 in datafiles.
	// room18
#define R18SPRPAL				 0x070A0000
#define room18_PAL				 0x070A0001
#define room18_l0				 0x070A0002
#define room18_l1				 0x070A0003
#define room18_l2				 0x070A0004
#define room18_gd1				 0x070A0005
#define room18_gd2				 0x070A0006
#define room18_flr				 0x070A0007
#define FAN18CDT				 0x070A0008
#define FAN18					 0x070A0009
#define GENBNDCDT				 0x070A000A
#define GENBND					 0x070A000B
#define GENSTRCDT				 0x070A000C
#define GENSTR					 0x070A000D
#define GENTLK18CDT				 0x070A000E
#define GENTLK18				 0x070A000F
#define GEOLVE18CDT				 0x070A0010
#define GEOLVE18				 0x070A0011
#define MOUBAK18CDT				 0x070A0012
#define MOUBAK18				 0x070A0013
#define MOUBUSYCDT				 0x070A0014
#define MOUBUSY					 0x070A0015
#define MOUTKROSCDT				 0x070A0016
#define MOUTKROS				 0x070A0017
#define MOUTLK18CDT				 0x070A0018
#define MOUTLK18				 0x070A0019
#define MOUWLK18CDT				 0x070A001A
#define MOUWLK18				 0x070A001B
#define ROSBAK18CDT				 0x070A001C
#define ROSBAK18				 0x070A001D
#define ROSBUSYCDT				 0x070A001E
#define ROSBUSY					 0x070A001F
#define ROSSTDCDT				 0x070A0020
#define ROSSTD					 0x070A0021
#define ROSTLK18CDT				 0x070A0022
#define ROSTLK18				 0x070A0023
#define ROSTLKXCDT				 0x070A0024
#define ROSTLKX					 0x070A0025
#define ROSTURNCDR				 0x070A0026
#define ROSTURNCDT				 0x070A0027
#define ROSTURN					 0x070A0028
#define ROSWLK18CDT				 0x070A0029
#define ROSWLK18				 0x070A002A
	// 43 entities in TXTs, 43 in datafiles.
	// room46
#define room46_PAL				 0x070B0000
#define room46_l0				 0x070B0001
#define room46_l1				 0x070B0002
#define room46_l2				 0x070B0003
#define room46_gd1				 0x070B0004
#define room46_gd2				 0x070B0005
#define room46_flr				 0x070B0006
#define MANU46CDT				 0x070B0007
#define MANU46					 0x070B0008
	// 9 entities in TXTs, 9 in datafiles.
// paris_3
	// sound_fx
#define FX_MUESEXT				 0x08000000
#define FX_AIRCON28				 0x08000001
#define FX_SARCO28A				 0x08000002
#define FX_SARCO28B				 0x08000003
#define FX_SARCO28C				 0x08000004
#define FX_TOTEM28A				 0x08000005
#define FX_ALARM				 0x08000006
#define FX_CARABINE				 0x08000007
#define FX_DOOR29				 0x08000008
#define FX_FISHFALL				 0x08000009
#define FX_GDROP29				 0x0800000A
#define FX_GUI_HIT				 0x0800000B
#define FX_GUN1					 0x0800000C
#define FX_ROPEDOWN				 0x0800000D
#define FX_SARCO29				 0x0800000E
#define FX_SMASHGLA				 0x0800000F
#define FX_TOTEM29A				 0x08000010
#define FX_TOTEM29B				 0x08000011
#define FX_HOSPEXT				 0x08000012
#define FX_GRAVEL1				 0x08000013
#define FX_GRAVEL2				 0x08000014
#define FX_HOSPNOIS				 0x08000015
#define FX_CUPBOPEN				 0x08000016
#define FX_CUPBCLOS				 0x08000017
#define FX_KIKSHINY				 0x08000018
#define FX_SHINY				 0x08000019
#define FX_SHINYOFF				 0x0800001A
#define FX_SHINYON				 0x0800001B
#define FX_BLOODPRE				 0x0800001C
#define FX_GUN34				 0x0800001D
#define FX_PULSE2				 0x0800001E
#define FX_PULSE3				 0x0800001F
	// 32 entities in TXTs, 32 in datafiles.
	// benoir
#define MEGABEN					 0x08010000
#define BEN_WLK					 0x08010001
#define STDTAL1					 0x08010002
#define STDTAL1CDT				 0x08010003
#define STDTAL3					 0x08010004
#define STDTAL3CDT				 0x08010005
#define STDTAL5					 0x08010006
#define STDTAL5CDT				 0x08010007
#define XBENPG3					 0x08010008
#define XBENPG3CDT				 0x08010009
#define XBENPG5					 0x0801000A
#define XBENPG5CDT				 0x0801000B
	// 12 entities in TXTs, 12 in datafiles.
	// mus
#define MEGAMUS					 0x08020000
#define MUS_WLK					 0x08020001
#define MUSTLK0					 0x08020002
#define MUSTLK0CDT				 0x08020003
#define MUSTLK1					 0x08020004
#define MUSTLK1CDT				 0x08020005
#define MUSTLK2					 0x08020006
#define MUSTLK2CDT				 0x08020007
#define MUSTLK3					 0x08020008
#define MUSTLK3CDT				 0x08020009
#define MUSTLK4					 0x0802000A
#define MUSTLK4CDT				 0x0802000B
#define MUSTLK5					 0x0802000C
#define MUSTLK5CDT				 0x0802000D
#define MUSTLK6					 0x0802000E
#define MUSTLK6CDT				 0x0802000F
#define MUSTLK7					 0x08020010
#define MUSTLK7CDT				 0x08020011
	// 18 entities in TXTs, 18 in datafiles.
	// white
#define MEGA_WHITE				 0x08030000
#define WHTTLK0					 0x08030001
#define WHTTLK0CDT				 0x08030002
#define WHTTLK1					 0x08030003
#define WHTTLK1CDT				 0x08030004
#define WHTTLK2					 0x08030005
#define WHTTLK2CDT				 0x08030006
#define WHTTLK3					 0x08030007
#define WHTTLK3CDT				 0x08030008
#define WHTTLK4					 0x08030009
#define WHTTLK4CDT				 0x0803000A
#define WHTTLK5					 0x0803000B
#define WHTTLK5CDT				 0x0803000C
#define WHTTLK6					 0x0803000D
#define WHTTLK6CDT				 0x0803000E
#define WHTTLK7					 0x0803000F
#define WHTTLK7CDT				 0x08030010
#define WHTSHRUG				 0x08030011
#define WHTSHRUGCDT				 0x08030012
#define XGEOPG3					 0x08030013
#define XGEOPG3CDT				 0x08030014
#define XGEOPG5					 0x08030015
#define XGEOPG5CDT				 0x08030016
	// 23 entities in TXTs, 23 in datafiles.
	// room27
#define PARIS3_PAL				 0x08040000
#define room27_PAL				 0x08040001
#define R27L0					 0x08040002
#define R27L1					 0x08040003
#define R27L2					 0x08040004
#define R27G1					 0x08040005
#define R27G2					 0x08040006
#define room27_flr				 0x08040007
#define GEOWIN27CDR				 0x08040008
#define GEOWIN27CDT				 0x08040009
#define GEOWIN27				 0x0804000A
	// 11 entities in TXTs, 11 in datafiles.
	// room28
#define R28SPRPAL				 0x08050000
#define R28PAL					 0x08050001
#define R28L0					 0x08050002
#define R28L1					 0x08050003
#define R28L2					 0x08050004
#define R28G1					 0x08050005
#define R28G2					 0x08050006
#define room28_flr				 0x08050007
#define GEOALMCDT				 0x08050008
#define GEOALM					 0x08050009
#define GEOSARCDT				 0x0805000A
#define GEOSAR					 0x0805000B
#define GEOSAR1CDT				 0x0805000C
#define GEOSAR1					 0x0805000D
#define GEOSAR2CDR				 0x0805000E
#define GEOSAR2CDT				 0x0805000F
#define GEOSAR2					 0x08050010
#define GEOSHK28CDT				 0x08050011
#define GEOSHK28				 0x08050012
#define GEOTOTCDT				 0x08050013
#define GEOTOT					 0x08050014
#define GEOWINCDT				 0x08050015
#define GEOWIN					 0x08050016
#define GUAWINCDT				 0x08050017
#define GUAWIN					 0x08050018
#define LOBEXITCDT				 0x08050019
#define LOBEXIT					 0x0805001A
#define LOBMANCDT				 0x0805001B
#define LOBMAN					 0x0805001C
#define LOBSTUCDT				 0x0805001D
#define LOBSTU					 0x0805001E
#define LOBTLKCDT				 0x0805001F
#define LOBTLK					 0x08050020
#define LOBTURN1CDT				 0x08050021
#define LOBTURN1				 0x08050022
#define LOBTURN2CDT				 0x08050023
#define LOBTURN2				 0x08050024
#define MUSOPNCDT				 0x08050025
#define MUSOPN					 0x08050026
#define SARDOR28CDT				 0x08050027
#define SARDOR28				 0x08050028
#define TOTEM28CDT				 0x08050029
#define TOTEM28					 0x0805002A
#define TRIPOD28CDT				 0x0805002B
#define TRIPOD28				 0x0805002C
#define WINDO28CDR				 0x0805002D
#define WINDO28CDT				 0x0805002E
#define WINDO28					 0x0805002F
#define WINROD28CDT				 0x08050030
#define WINROD28				 0x08050031
	// 50 entities in TXTs, 50 in datafiles.
	// room29
#define R29SPRPAL				 0x08060000
#define BBACK29SPRPAL			 0x08060001
#define R29PAL					 0x08060002
#define R29L0					 0x08060003
#define R29L1					 0x08060004
#define R29G1					 0x08060005
#define room29_flr				 0x08060006
#define BBACK29					 0x08060007
#define BBACK29PAL				 0x08060008
#define GEOSUR29CDT				 0x08060009
#define GEOSUR29				 0x0806000A
#define CASECDT					 0x0806000B
#define CASE					 0x0806000C
#define DOOR29CDT				 0x0806000D
#define DOOR29					 0x0806000E
#define FISH29CDT				 0x0806000F
#define FISH29					 0x08060010
#define FLAPENTCDT				 0x08060011
#define FLAPENT					 0x08060012
#define FLAPTLK1CDT				 0x08060013
#define FLAPTLK1				 0x08060014
#define FLAPTLK3CDT				 0x08060015
#define FLAPTLK3				 0x08060016
#define FLAPTOR1CDR				 0x08060017
#define FLAPTOR1CDT				 0x08060018
#define FLAPTOR1				 0x08060019
#define FLAPTOR4CDT				 0x0806001A
#define FLAPTOR4				 0x0806001B
#define FLAPWLKCDT				 0x0806001C
#define FLAPWLK					 0x0806001D
#define GEODEDCDT				 0x0806001E
#define GEODED					 0x0806001F
#define GEOFISHCDT				 0x08060020
#define GEOFISH					 0x08060021
#define GEOFWDCDT				 0x08060022
#define GEOFWD					 0x08060023
#define GEOPEEKCDT				 0x08060024
#define GEOPEEK					 0x08060025
#define GEOSAR6CDT				 0x08060026
#define GEOSAR6					 0x08060027
#define GEOTOT29CDT				 0x08060028
#define GEOTOT29				 0x08060029
#define GEOTOTBCDT				 0x0806002A
#define GEOTOTB					 0x0806002B
#define GEOTPTOCDT				 0x0806002C
#define GEOTPTO					 0x0806002D
#define GUIENTCDT				 0x0806002E
#define GUIENT					 0x0806002F
#define GUIGUNCDT				 0x08060030
#define GUIGUN					 0x08060031
#define GUIKNECDT				 0x08060032
#define GUIKNE					 0x08060033
#define GUIKNE1CDT				 0x08060034
#define GUIKNE1					 0x08060035
#define GUITLK1CDT				 0x08060036
#define GUITLK1					 0x08060037
#define GUITLK3CDT				 0x08060038
#define GUITLK3					 0x08060039
#define GUITLK4CDT				 0x0806003A
#define GUITLK4					 0x0806003B
#define GUIWLKCDT				 0x0806003C
#define GUIWLK					 0x0806003D
#define NICPUS1CDT				 0x0806003E
#define NICPUS1					 0x0806003F
#define ROPE29CDT				 0x08060040
#define ROPE29					 0x08060041
#define SARDOORCDT				 0x08060042
#define SARDOOR					 0x08060043
#define TOR1CDT					 0x08060044
#define TOR1					 0x08060045
#define TOR3CDR					 0x08060046
#define TOR3CDT					 0x08060047
#define TOR3					 0x08060048
#define TOR4CDT					 0x08060049
#define TOR4					 0x0806004A
#define TOR6CDT					 0x0806004B
#define TOR6					 0x0806004C
#define TOR7CDT					 0x0806004D
#define TOR7					 0x0806004E
#define TOTFALLCDT				 0x0806004F
#define TOTFALL					 0x08060050
	// 81 entities in TXTs, 81 in datafiles.
	// room31
#define room31_PAL				 0x08070000
#define room31_l0				 0x08070001
#define room31_flr				 0x08070002
#define GEOAMBCDT				 0x08070003
#define GEOAMB					 0x08070004
#define GEODOR31CDT				 0x08070005
#define GEODOR31				 0x08070006
	// 7 entities in TXTs, 7 in datafiles.
	// room32
#define room32_PAL				 0x08080000
#define room32_l0				 0x08080001
#define room32_l1				 0x08080002
#define room32_l2				 0x08080003
#define room32_gd1				 0x08080004
#define room32_gd2				 0x08080005
#define room32_flr				 0x08080006
#define CONSTPCDT				 0x08080007
#define CONSTP					 0x08080008
#define CONTLKCDT				 0x08080009
#define CONTLK					 0x0808000A
#define CONTLK2CDT				 0x0808000B
#define CONTLK2					 0x0808000C
#define CONWLKCDT				 0x0808000D
#define CONWLK					 0x0808000E
#define RECCOMCDT				 0x0808000F
#define RECCOM					 0x08080010
#define RECKEYCDT				 0x08080011
#define RECKEY					 0x08080012
#define RECTLKCDT				 0x08080013
#define RECTLK					 0x08080014
#define RECTLK2CDT				 0x08080015
#define RECTLK2					 0x08080016
#define RECTRNCDT				 0x08080017
#define RECTRN					 0x08080018
	// 25 entities in TXTs, 25 in datafiles.
	// room33
#define room33_PAL				 0x08090000
#define room33_l0				 0x08090001
#define room33_l1				 0x08090002
#define room33_l2				 0x08090003
#define room33_gd1				 0x08090004
#define room33_gd2				 0x08090005
#define room33_flr				 0x08090006
#define DOMDRNCDT				 0x08090007
#define DOMDRN					 0x08090008
#define DOMDUHCDT				 0x08090009
#define DOMDUH					 0x0809000A
#define DOMKIKCDT				 0x0809000B
#define DOMKIK					 0x0809000C
#define DOMPLGCDT				 0x0809000D
#define DOMPLG					 0x0809000E
#define DOMTLKCDT				 0x0809000F
#define DOMTLK					 0x08090010
#define DOMVACCDT				 0x08090011
#define DOMVAC					 0x08090012
#define DOMWLKCDT				 0x08090013
#define DOMWLK					 0x08090014
#define DOMWLK2CDT				 0x08090015
#define DOMWLK2					 0x08090016
#define DOMWLK3CDT				 0x08090017
#define DOMWLK3					 0x08090018
#define DOMWLK4CDT				 0x08090019
#define DOMWLK4					 0x0809001A
#define GEOCOTCDT				 0x0809001B
#define GEOCOT					 0x0809001C
#define GEOPLG33CDT				 0x0809001D
#define GEOPLG33				 0x0809001E
#define GEOWATCDT				 0x0809001F
#define GEOWAT					 0x08090020
#define GEOWWATCDT				 0x08090021
#define GEOWWAT					 0x08090022
#define LEAD1CDT				 0x08090023
#define LEAD1					 0x08090024
#define LEAD2CDT				 0x08090025
#define LEAD2					 0x08090026
#define SHINY33CDT				 0x08090027
#define SHINY33					 0x08090028
	// 41 entities in TXTs, 41 in datafiles.
	// room34
#define room34_PAL				 0x080A0000
#define room34_l0				 0x080A0001
#define room34_l1				 0x080A0002
#define room34_l2				 0x080A0003
#define room34_l3				 0x080A0004
#define room34_gd1				 0x080A0005
#define room34_gd2				 0x080A0006
#define room34_gd3				 0x080A0007
#define room34_flr				 0x080A0008
#define R34PLX					 0x080A0009
#define BENBP1CDT				 0x080A000A
#define BENBP1					 0x080A000B
#define BENBP2CDT				 0x080A000C
#define BENBP2					 0x080A000D
#define DOOR34CDR				 0x080A000E
#define DOOR34CDT				 0x080A000F
#define DOOR34					 0x080A0010
#define GENDTLKCDT				 0x080A0011
#define GENDTLK					 0x080A0012
#define GENENTCDT				 0x080A0013
#define GENENT					 0x080A0014
#define GENSHOTCDT				 0x080A0015
#define GENSHOT					 0x080A0016
#define GENSTLKCDT				 0x080A0017
#define GENSTLK					 0x080A0018
#define GENSUPCDT				 0x080A0019
#define GENSUP					 0x080A001A
#define GENTRNCDT				 0x080A001B
#define GENTRN					 0x080A001C
#define GEOBAKCDT				 0x080A001D
#define GEOBAK					 0x080A001E
#define GEOBP2CDT				 0x080A001F
#define GEOBP2					 0x080A0020
#define GEOCH1CDR				 0x080A0021
#define GEOCH1CDT				 0x080A0022
#define GEOCH1					 0x080A0023
#define GEOCH2CDR				 0x080A0024
#define GEOCH2CDT				 0x080A0025
#define GEOCH2					 0x080A0026
#define GEOCH3CDR				 0x080A0027
#define GEOCH3CDT				 0x080A0028
#define GEOCH3					 0x080A0029
#define GEODOR34CDT				 0x080A002A
#define GEODOR34				 0x080A002B
#define GEOENT34CDT				 0x080A002C
#define GEOENT34				 0x080A002D
#define GEONURBPCDT				 0x080A002E
#define GEONURBP				 0x080A002F
#define GEOTAKCDT				 0x080A0030
#define GEOTAK					 0x080A0031
#define GEOTRYDCDT				 0x080A0032
#define GEOTRYD					 0x080A0033
#define GEOTRYTKCDT				 0x080A0034
#define GEOTRYTK				 0x080A0035
#define HATGIVCDT				 0x080A0036
#define HATGIV					 0x080A0037
#define HATSTPCDT				 0x080A0038
#define HATSTP					 0x080A0039
#define HATTLKCDT				 0x080A003A
#define HATTLK					 0x080A003B
#define HATWLKCDT				 0x080A003C
#define HATWLK					 0x080A003D
#define HATWLK2CDT				 0x080A003E
#define HATWLK2					 0x080A003F
#define MONITOR					 0x080A0040
#define MONITOR_PAL				 0x080A0041
#define PULSE1CDT				 0x080A0042
#define PULSE1					 0x080A0043
#define PULSE2CDT				 0x080A0044
#define PULSE2					 0x080A0045
#define PULSE3CDT				 0x080A0046
#define PULSE3					 0x080A0047
#define RENTLKCDT				 0x080A0048
#define RENTLK					 0x080A0049
#define SMARMCDR				 0x080A004A
#define SMARMCDT				 0x080A004B
#define SMARM					 0x080A004C
#define SMSTPCDR				 0x080A004D
#define SMSTPCDT				 0x080A004E
#define SMSTP					 0x080A004F
#define SMTALKCDT				 0x080A0050
#define SMTALK					 0x080A0051
#define SMTALK2CDT				 0x080A0052
#define SMTALK2					 0x080A0053
#define STUDENTCDT				 0x080A0054
#define STUDENT					 0x080A0055
#define STUDGIVCDT				 0x080A0056
#define STUDGIV					 0x080A0057
#define STUDMOVCDT				 0x080A0058
#define STUDMOV					 0x080A0059
	// 90 entities in TXTs, 90 in datafiles.
	// room35
#define room35_PAL				 0x080B0000
#define room35_l0				 0x080B0001
#define room35_l1				 0x080B0002
#define room35_gd1				 0x080B0003
#define room35_flr				 0x080B0004
#define ALSHOCKCDT				 0x080B0005
#define ALSHOCK					 0x080B0006
#define CURFLATCDT				 0x080B0007
#define CURFLAT					 0x080B0008
#define EKLBED35CDT				 0x080B0009
#define EKLBED35				 0x080B000A
#define EKLTLK35CDT				 0x080B000B
#define EKLTLK35				 0x080B000C
#define EKLWLK35CDT				 0x080B000D
#define EKLWLK35				 0x080B000E
#define GEORCT35CDT				 0x080B000F
#define GEORCT35				 0x080B0010
#define GEOSIT35CDR				 0x080B0011
#define GEOSIT35CDT				 0x080B0012
#define GEOSIT35				 0x080B0013
#define GEOTLKCDT				 0x080B0014
#define GEOTLK					 0x080B0015
#define GEOTLK35CDT				 0x080B0016
#define GEOTLK35				 0x080B0017
#define GEOTRN35CDT				 0x080B0018
#define GEOTRN35				 0x080B0019
#define JAQTLK1CDT				 0x080B001A
#define JAQTLK1					 0x080B001B
#define JAQTLK2CDT				 0x080B001C
#define JAQTLK2					 0x080B001D
	// 30 entities in TXTs, 30 in datafiles.
// paris_4
	// sound_fx
#define FX_COVDWN				 0x09000000
#define FX_KEYIN				 0x09000001
#define FX_MANOP36				 0x09000002
#define FX_MONTAMB				 0x09000003
#define FX_OOH					 0x09000004
#define FX_PULLUP36				 0x09000005
#define FX_REPLCE36				 0x09000006
#define FX_AMBIEN37				 0x09000007
#define FX_CHAIN37				 0x09000008
#define FX_CHAIN37B				 0x09000009
#define FX_DOOR37				 0x0900000A
#define FX_HOLE37				 0x0900000B
#define FX_KNOCK37				 0x0900000C
#define FX_KNOCK37B				 0x0900000D
#define FX_WINCH37				 0x0900000E
#define FX_AIRCON41				 0x0900000F
#define FX_FONEDN41				 0x09000010
#define FX_FONEUP41				 0x09000011
#define FX_PHONCALL				 0x09000012
#define FX_THERMO1				 0x09000013
#define FX_TAPDRIP				 0x09000014
#define FX_DRIER1				 0x09000015
#define FX_CHURCHFX				 0x09000016
	// 23 entities in TXTs, 23 in datafiles.
	// room36
#define R36SPRPAL				 0x09010000
#define R36L0					 0x09010001
#define R36L1					 0x09010002
#define R36G1					 0x09010003
#define room36_PAL				 0x09010004
#define room36_flr				 0x09010005
#define R36PLX					 0x09010006
#define BAL36CDT				 0x09010007
#define BAL36					 0x09010008
#define CRO36APPCDT				 0x09010009
#define CRO36APP				 0x0901000A
#define CRO36GEOCDT				 0x0901000B
#define CRO36GEO				 0x0901000C
#define CRO36IDLCDT				 0x0901000D
#define CRO36IDL				 0x0901000E
#define CRO36JUGCDT				 0x0901000F
#define CRO36JUG				 0x09010010
#define CRO36UNICDT				 0x09010011
#define CRO36UNI				 0x09010012
#define GEN36DRICDT				 0x09010013
#define GEN36DRI				 0x09010014
#define GEN36FEHCDT				 0x09010015
#define GEN36FEH				 0x09010016
#define GEN36HURCDT				 0x09010017
#define GEN36HUR				 0x09010018
#define GEN36LEACDT				 0x09010019
#define GEN36LEA				 0x0901001A
#define GEN36POICDR				 0x0901001B
#define GEN36POICDT				 0x0901001C
#define GEN36POI				 0x0901001D
#define GEN36SPECDT				 0x0901001E
#define GEN36SPE				 0x0901001F
#define GEN36TALCDT				 0x09010020
#define GEN36TAL				 0x09010021
#define GEO36CLOCDT				 0x09010022
#define GEO36CLO				 0x09010023
#define GEO36ENTCDT				 0x09010024
#define GEO36ENT				 0x09010025
#define GEO36EXTCDT				 0x09010026
#define GEO36EXT				 0x09010027
#define GEO36JUGCDT				 0x09010028
#define GEO36JUG				 0x09010029
#define GEO36KNECDR				 0x0901002A
#define GEO36KNECDT				 0x0901002B
#define GEO36KNE				 0x0901002C
#define GEO36LUKCDR				 0x0901002D
#define GEO36LUKCDT				 0x0901002E
#define GEO36LUK				 0x0901002F
#define GEO36NOSCDT				 0x09010030
#define GEO36NOS				 0x09010031
#define GEO36OPECDT				 0x09010032
#define GEO36OPE				 0x09010033
#define GEO36POPCDT				 0x09010034
#define GEO36POP				 0x09010035
#define GEO36SHOCDR				 0x09010036
#define GEO36SHOCDT				 0x09010037
#define GEO36SHO				 0x09010038
#define GEO36SNTCDT				 0x09010039
#define GEO36SNT				 0x0901003A
#define GEO36STDCDT				 0x0901003B
#define GEO36STD				 0x0901003C
#define GEO36STUCDT				 0x0901003D
#define GEO36STU				 0x0901003E
#define GEO36TAKCDT				 0x0901003F
#define GEO36TAK				 0x09010040
#define HAT36CDT				 0x09010041
#define HAT36					 0x09010042
#define JUG36FINCDT				 0x09010043
#define JUG36FIN				 0x09010044
#define JUG36FURCDT				 0x09010045
#define JUG36FUR				 0x09010046
#define JUG36GIVCDT				 0x09010047
#define JUG36GIV				 0x09010048
#define JUG36GOCDT				 0x09010049
#define JUG36GO					 0x0901004A
#define JUG36JUGCDT				 0x0901004B
#define JUG36JUG				 0x0901004C
#define JUG36LAFCDT				 0x0901004D
#define JUG36LAF				 0x0901004E
#define JUG36STACDT				 0x0901004F
#define JUG36STA				 0x09010050
#define JUG36TAKCDT				 0x09010051
#define JUG36TAK				 0x09010052
#define JUG36TALCDT				 0x09010053
#define JUG36TAL				 0x09010054
#define MANCOV36CDT				 0x09010055
#define MANCOV36				 0x09010056
#define MANOFF36CDT				 0x09010057
#define MANOFF36				 0x09010058
#define VIN36CDT				 0x09010059
#define VIN36					 0x0901005A
	// 91 entities in TXTs, 91 in datafiles.
	// room37
#define room37_PAL				 0x09020000
#define R37L0					 0x09020001
#define R37L1					 0x09020002
#define R37G1					 0x09020003
#define room37_flr				 0x09020004
#define DOR37COLCDT				 0x09020005
#define DOR37COL				 0x09020006
#define GEO37ASCCDT				 0x09020007
#define GEO37ASC				 0x09020008
#define GEO37COGCDT				 0x09020009
#define GEO37COG				 0x0902000A
#define GEO37DESCDT				 0x0902000B
#define GEO37DES				 0x0902000C
#define GEO37HUKCDR				 0x0902000D
#define GEO37HUKCDT				 0x0902000E
#define GEO37HUK				 0x0902000F
#define GEO37INBCDT				 0x09020010
#define GEO37INB				 0x09020011
#define GEO37LEVCDT				 0x09020012
#define GEO37LEV				 0x09020013
#define GEO37OUTCDT				 0x09020014
#define GEO37OUT				 0x09020015
#define GEO37RUNCDT				 0x09020016
#define GEO37RUN				 0x09020017
#define GEO37TA1CDT				 0x09020018
#define GEO37TA1				 0x09020019
#define GEO37TA2CDT				 0x0902001A
#define GEO37TA2				 0x0902001B
#define GEO37TA3CDT				 0x0902001C
#define GEO37TA3				 0x0902001D
#define GEO37TA4CDT				 0x0902001E
#define GEO37TA4				 0x0902001F
#define GEO37TU1CDR				 0x09020020
#define GEO37TU1CDT				 0x09020021
#define GEO37TU1				 0x09020022
#define GEO37TU2CDT				 0x09020023
#define GEO37TU2				 0x09020024
#define GEO37WLCDR				 0x09020025
#define GEO37WLCDT				 0x09020026
#define GEO37WL					 0x09020027
#define HOO37LBOCDR				 0x09020028
#define HOO37LBOCDT				 0x09020029
#define HOO37LBO				 0x0902002A
#define HOO37PULCDT				 0x0902002B
#define HOO37PUL				 0x0902002C
#define ROCKS1CDT				 0x0902002D
#define ROCKS1					 0x0902002E
#define WAL37BRECDT				 0x0902002F
#define WAL37BRE				 0x09020030
#define WAL37SLICDT				 0x09020031
#define WAL37SLI				 0x09020032
#define WATER37CDT				 0x09020033
#define WATER37					 0x09020034
#define WATER37ACDT				 0x09020035
#define WATER37A				 0x09020036
#define WHEEL37CDT				 0x09020037
#define WHEEL37					 0x09020038
	// 57 entities in TXTs, 57 in datafiles.
	// room38
#define R38SPRPAL				 0x09030000
#define room38_PAL				 0x09030001
#define R38L0					 0x09030002
#define R38L1					 0x09030003
#define R38G1					 0x09030004
#define room38_flr				 0x09030005
#define BBACK38					 0x09030006
#define BBACK38PAL				 0x09030007
#define GEOINQ38CDT				 0x09030008
#define GEOINQ38				 0x09030009
#define GEO38AS1CDT				 0x0903000A
#define GEO38AS1				 0x0903000B
#define GEO38AS2CDT				 0x0903000C
#define GEO38AS2				 0x0903000D
#define GEO38DE1CDT				 0x0903000E
#define GEO38DE1				 0x0903000F
#define GEO38DE2CDT				 0x09030010
#define GEO38DE2				 0x09030011
#define GEO38LUKCDR				 0x09030012
#define GEO38LUKCDT				 0x09030013
#define GEO38LUK				 0x09030014
	// 21 entities in TXTs, 21 in datafiles.
	// room39
#define R39SPRPAL				 0x09040000
#define R39L0					 0x09040001
#define R39L1					 0x09040002
#define R39G1					 0x09040003
#define room39_PAL				 0x09040004
#define room39_flr				 0x09040005
#define R39PLX					 0x09040006
#define BOA39GOACDT				 0x09040007
#define BOA39GOA				 0x09040008
#define BOA39SPRCDT				 0x09040009
#define BOA39SPR				 0x0904000A
#define CIV391T2CDR				 0x0904000B
#define CIV391T2CDT				 0x0904000C
#define CIV391T2				 0x0904000D
#define CIV391T3CDR				 0x0904000E
#define CIV391T3CDT				 0x0904000F
#define CIV391T3				 0x09040010
#define CIV392T3CDR				 0x09040011
#define CIV392T3CDT				 0x09040012
#define CIV392T3				 0x09040013
#define CIV39T1CDT				 0x09040014
#define CIV39T1					 0x09040015
#define CIV39T2CDT				 0x09040016
#define CIV39T2					 0x09040017
#define CIV39T3CDT				 0x09040018
#define CIV39T3					 0x09040019
#define CIVLIST1CDT				 0x0904001A
#define CIVLIST1				 0x0904001B
#define CIVLIST2CDT				 0x0904001C
#define CIVLIST2				 0x0904001D
#define CIVLIST3CDT				 0x0904001E
#define CIVLIST3				 0x0904001F
#define COL391T2CDR				 0x09040020
#define COL391T2CDT				 0x09040021
#define COL391T2				 0x09040022
#define COL391T3CDR				 0x09040023
#define COL391T3CDT				 0x09040024
#define COL391T3				 0x09040025
#define COL392T3CDR				 0x09040026
#define COL392T3CDT				 0x09040027
#define COL392T3				 0x09040028
#define COL39T1CDT				 0x09040029
#define COL39T1					 0x0904002A
#define COL39T2CDT				 0x0904002B
#define COL39T2					 0x0904002C
#define COL39T3CDT				 0x0904002D
#define COL39T3					 0x0904002E
#define COLLIST2CDT				 0x0904002F
#define COLLIST2				 0x09040030
#define COLLIST3CDT				 0x09040031
#define COLLIST3				 0x09040032
#define CON39TALCDT				 0x09040033
#define CON39TAL				 0x09040034
#define EKL391T2CDR				 0x09040035
#define EKL391T2CDT				 0x09040036
#define EKL391T2				 0x09040037
#define EKL391T3CDR				 0x09040038
#define EKL391T3CDT				 0x09040039
#define EKL391T3				 0x0904003A
#define EKL392T3CDR				 0x0904003B
#define EKL392T3CDT				 0x0904003C
#define EKL392T3				 0x0904003D
#define EKL39T1CDT				 0x0904003E
#define EKL39T1					 0x0904003F
#define EKL39T2CDT				 0x09040040
#define EKL39T2					 0x09040041
#define EKL39T3CDT				 0x09040042
#define EKL39T3					 0x09040043
#define EKLLIST1CDT				 0x09040044
#define EKLLIST1				 0x09040045
#define EKLLIST2CDT				 0x09040046
#define EKLLIST2				 0x09040047
#define EKLLIST3CDT				 0x09040048
#define EKLLIST3				 0x09040049
#define EXE391T2CDR				 0x0904004A
#define EXE391T2CDT				 0x0904004B
#define EXE391T2				 0x0904004C
#define EXE391T3CDR				 0x0904004D
#define EXE391T3CDT				 0x0904004E
#define EXE391T3				 0x0904004F
#define EXE392T3CDR				 0x09040050
#define EXE392T3CDT				 0x09040051
#define EXE392T3				 0x09040052
#define EXE39T1CDT				 0x09040053
#define EXE39T1					 0x09040054
#define EXE39T2CDT				 0x09040055
#define EXE39T2					 0x09040056
#define EXE39T3CDT				 0x09040057
#define EXE39T3					 0x09040058
#define GEO39ENTCDT				 0x09040059
#define GEO39ENT				 0x0904005A
#define GEO39EXTCDT				 0x0904005B
#define GEO39EXT				 0x0904005C
#define GEO39GEMCDR				 0x0904005D
#define GEO39GEMCDT				 0x0904005E
#define GEO39GEM				 0x0904005F
#define GEO39TRICDR				 0x09040060
#define GEO39TRICDT				 0x09040061
#define GEO39TRI				 0x09040062
#define LAT391T2CDR				 0x09040063
#define LAT391T2CDT				 0x09040064
#define LAT391T2				 0x09040065
#define LAT391T3CDR				 0x09040066
#define LAT391T3CDT				 0x09040067
#define LAT391T3				 0x09040068
#define LAT392T3CDR				 0x09040069
#define LAT392T3CDT				 0x0904006A
#define LAT392T3				 0x0904006B
#define LAT39T1CDT				 0x0904006C
#define LAT39T1					 0x0904006D
#define LAT39T2CDT				 0x0904006E
#define LAT39T2					 0x0904006F
#define LAT39T3CDT				 0x09040070
#define LAT39T3					 0x09040071
#define LATLIST1CDT				 0x09040072
#define LATLIST1				 0x09040073
#define LATLIST2CDT				 0x09040074
#define LATLIST2				 0x09040075
#define LATLIST3CDT				 0x09040076
#define LATLIST3				 0x09040077
#define MAS391T2CDR				 0x09040078
#define MAS391T2CDT				 0x09040079
#define MAS391T2				 0x0904007A
#define MAS391T3CDR				 0x0904007B
#define MAS391T3CDT				 0x0904007C
#define MAS391T3				 0x0904007D
#define MAS392T3CDR				 0x0904007E
#define MAS392T3CDT				 0x0904007F
#define MAS392T3				 0x09040080
#define MAS39T1CDT				 0x09040081
#define MAS39T1					 0x09040082
#define MAS39T2CDT				 0x09040083
#define MAS39T2					 0x09040084
#define MAS39T3CDT				 0x09040085
#define MAS39T3					 0x09040086
#define MASLIST1CDT				 0x09040087
#define MASLIST1				 0x09040088
#define MASLIST2CDT				 0x09040089
#define MASLIST2				 0x0904008A
#define MASLIST3CDT				 0x0904008B
#define MASLIST3				 0x0904008C
#define RAYS39CDT				 0x0904008D
#define RAYS39					 0x0904008E
#define TRI39ALOCDT				 0x0904008F
#define TRI39ALO				 0x09040090
#define TRI39GEMCDT				 0x09040091
#define TRI39GEM				 0x09040092
	// 147 entities in TXTs, 147 in datafiles.
	// room40
#define R40L0					 0x09050000
#define room40_PAL				 0x09050001
#define room40_flr				 0x09050002
#define GEO40ASCCDT				 0x09050003
#define GEO40ASC				 0x09050004
#define GEO40DESCDT				 0x09050005
#define GEO40DES				 0x09050006
#define GEO40DIPCDT				 0x09050007
#define GEO40DIP				 0x09050008
#define GUA40ENTCDT				 0x09050009
#define GUA40ENT				 0x0905000A
#define GUA40STACDT				 0x0905000B
#define GUA40STA				 0x0905000C
#define GUA40TALCDT				 0x0905000D
#define GUA40TAL				 0x0905000E
#define PAI40FAGCDT				 0x0905000F
#define PAI40FAG				 0x09050010
#define PAI40IDLCDT				 0x09050011
#define PAI40IDL				 0x09050012
#define PAI40LEACDT				 0x09050013
#define PAI40LEA				 0x09050014
#define PAI40STACDR				 0x09050015
#define PAI40STACDT				 0x09050016
#define PAI40STA				 0x09050017
#define PAI40TALCDT				 0x09050018
#define PAI40TAL				 0x09050019
	// 26 entities in TXTs, 26 in datafiles.
	// room41
#define R41L0					 0x09060000
#define R41L1					 0x09060001
#define R41G1					 0x09060002
#define room41_PAL				 0x09060003
#define room41_flr				 0x09060004
#define GEO41ENTCDT				 0x09060005
#define GEO41ENT				 0x09060006
#define GEO41OP2CDT				 0x09060007
#define GEO41OP2				 0x09060008
#define GEO41OPECDT				 0x09060009
#define GEO41OPE				 0x0906000A
#define GEO41THECDR				 0x0906000B
#define GEO41THECDT				 0x0906000C
#define GEO41THE				 0x0906000D
#define GLO41IDLCDT				 0x0906000E
#define GLO41IDL				 0x0906000F
#define GLO41KEYCDR				 0x09060010
#define GLO41KEYCDT				 0x09060011
#define GLO41KEY				 0x09060012
#define GLO41TALCDT				 0x09060013
#define GLO41TAL				 0x09060014
#define GUA41ANSCDT				 0x09060015
#define GUA41ANS				 0x09060016
#define GUA41GLOCDT				 0x09060017
#define GUA41GLO				 0x09060018
#define GUA41IDLCDT				 0x09060019
#define GUA41IDL				 0x0906001A
#define GUA41KEYCDR				 0x0906001B
#define GUA41KEYCDT				 0x0906001C
#define GUA41KEY				 0x0906001D
#define GUA41PHOCDT				 0x0906001E
#define GUA41PHO				 0x0906001F
#define GUA41TALCDT				 0x09060020
#define GUA41TAL				 0x09060021
#define PAI41HANCDT				 0x09060022
#define PAI41HAN				 0x09060023
#define PAI41LEACDT				 0x09060024
#define PAI41LEA				 0x09060025
#define PAI41TALCDT				 0x09060026
#define PAI41TAL				 0x09060027
#define PHONE41CDT				 0x09060028
#define PHONE41					 0x09060029
	// 42 entities in TXTs, 42 in datafiles.
	// room42
#define room42_PAL				 0x09070000
#define R42L0					 0x09070001
#define R42L1					 0x09070002
#define R42L2					 0x09070003
#define R42G1					 0x09070004
#define R42G2					 0x09070005
#define room42_flr				 0x09070006
#define CHALICE42				 0x09070007
#define CHALICE42_PAL			 0x09070008
#define GEO42CHACDT				 0x09070009
#define GEO42CHA				 0x0907000A
#define GEO42DESCDR				 0x0907000B
#define GEO42DESCDT				 0x0907000C
#define GEO42DES				 0x0907000D
	// 14 entities in TXTs, 14 in datafiles.
	// room43
#define room43_PAL				 0x09080000
#define R43L0					 0x09080001
#define R43L1					 0x09080002
#define R43G1					 0x09080003
#define room43_flr				 0x09080004
#define GEO43DR2CDT				 0x09080005
#define GEO43DR2				 0x09080006
#define GEO43DRYCDT				 0x09080007
#define GEO43DRY				 0x09080008
#define GEO43HAN				 0x09080009
#define GEO43HANCDT				 0x0908000A
#define GEO43KEYCDT				 0x0908000B
#define GEO43KEY				 0x0908000C
#define GEO43PLACDT				 0x0908000D
#define GEO43PLA				 0x0908000E
#define GEO43PRECDT				 0x0908000F
#define GEO43PRE				 0x09080010
#define GEO43SOACDT				 0x09080011
#define GEO43SOA				 0x09080012
#define GEO43SWPCDT				 0x09080013
#define GEO43SWP				 0x09080014
#define GEO43WATCDT				 0x09080015
#define GEO43WAT				 0x09080016
#define SOAP43CDT				 0x09080017
#define SOAP43					 0x09080018
#define WATER43CDT				 0x09080019
#define WATER43					 0x0908001A
	// 27 entities in TXTs, 27 in datafiles.
	// room48
#define R48SPRPAL				 0x09090000
#define R48L0					 0x09090001
#define R48L1					 0x09090002
#define R48L2					 0x09090003
#define R48G1					 0x09090004
#define R48G2					 0x09090005
#define R48PAL					 0x09090006
#define room48_flr				 0x09090007
#define R48PLX					 0x09090008
#define GEO48BENCDR				 0x09090009
#define GEO48BENCDT				 0x0909000A
#define GEO48BEN				 0x0909000B
#define GEO48GIVCDR				 0x0909000C
#define GEO48GIVCDT				 0x0909000D
#define GEO48GIV				 0x0909000E
#define GEO48LENCDT				 0x0909000F
#define GEO48LEN				 0x09090010
#define PRI48CANCDR				 0x09090011
#define PRI48CANCDT				 0x09090012
#define PRI48CAN				 0x09090013
#define PRI48IDLCDT				 0x09090014
#define PRI48IDL				 0x09090015
#define PRI48PO1CDT				 0x09090016
#define PRI48PO1				 0x09090017
#define PRI48PO2CDT				 0x09090018
#define PRI48PO2				 0x09090019
#define PRI48RETCDT				 0x0909001A
#define PRI48RET				 0x0909001B
#define PRI48TAKCDT				 0x0909001C
#define PRI48TAK				 0x0909001D
#define PRI48TALCDT				 0x0909001E
#define PRI48TAL				 0x0909001F
#define PRI48TURCDR				 0x09090020
#define PRI48TURCDT				 0x09090021
#define PRI48TUR				 0x09090022
#define WINDOW1					 0x09090023
#define WINDOW1_PAL				 0x09090024
#define WINDOW2					 0x09090025
#define WINDOW2_PAL				 0x09090026
	// 39 entities in TXTs, 39 in datafiles.
// ireland
	// sound_fx
#define FX_EIRBIRD3				 0x0A000000
#define FX_SHOCK2				 0x0A000001
#define FX_EIRBIRD1				 0x0A000002
#define FX_EIRBIRD2				 0x0A000003
#define FX_SWITCH19				 0x0A000004
#define FX_TRAPOPEN				 0x0A000005
#define FX_VIOLIN19				 0x0A000006
#define FX_WHISTLE				 0x0A000007
#define FX_BARFLAP				 0x0A000008
#define FX_DORCLOSE20			 0x0A000009
#define FX_DRINK				 0x0A00000A
#define FX_FITZHIT				 0x0A00000B
#define FX_FITZRUN				 0x0A00000C
#define FX_FITZUP				 0x0A00000D
#define FX_FUSE20				 0x0A00000E
#define FX_PULLPINT				 0x0A00000F
#define FX_SNEEZE1				 0x0A000010
#define FX_SNEEZE2				 0x0A000011
#define FX_WASHER				 0x0A000012
#define FX_CELTAP				 0x0A000013
#define FX_DRIPIRE				 0x0A000014
#define FX_DRIPIRE2				 0x0A000015
#define FX_TAP					 0x0A000016
#define FX_TAP2					 0x0A000017
#define FX_CLIMBHAY				 0x0A000018
#define FX_FARMERGO				 0x0A000019
#define FX_CASTLWAL				 0x0A00001A
#define FX_CLIMBFAL				 0x0A00001B
#define FX_KEYSTEP				 0x0A00001C
#define FX_WIND					 0x0A00001D
#define FX_GEOGOAT				 0x0A00001E
#define FX_GOATBAA				 0x0A00001F
#define FX_GOATCHEW				 0x0A000020
#define FX_GOATDOH				 0x0A000021
#define FX_PLOUGH				 0x0A000022
#define FX_EIRDRIP1				 0x0A000023
#define FX_EIRDRIP2				 0x0A000024
#define FX_LADDWN25				 0x0A000025
#define FX_LADDUP25				 0x0A000026
#define FX_SECDOR25				 0x0A000027
#define FX_SLABFALL				 0x0A000028
#define FX_SLABUP				 0x0A000029
#define FX_TRIGER25				 0x0A00002A
#define FX_WRING				 0x0A00002B
#define FX_LEVER				 0x0A00002C
#define FX_LEVER2				 0x0A00002D
#define FX_RAT3A				 0x0A00002E
#define FX_RAT3B				 0x0A00002F
#define FX_RAT3C				 0x0A000030
#define FX_RAT3D				 0x0A000031
	// 50 entities in TXTs, 50 in datafiles.
	// room19
#define R19SPRPAL				 0x0A010000
#define R19L0					 0x0A010001
#define R19L1					 0x0A010002
#define R19L2					 0x0A010003
#define R19G1					 0x0A010004
#define R19G2					 0x0A010005
#define R19PAL					 0x0A010006
#define R19FLR					 0x0A010007
#define ASSTAP					 0x0A010008
#define ASSTAPCDT				 0x0A010009
#define ASSTLK19				 0x0A01000A
#define ASSTLK19CDT				 0x0A01000B
#define ASSWLK2					 0x0A01000C
#define ASSWLK2CDT				 0x0A01000D
#define ASSWLK6					 0x0A01000E
#define ASSWLK6CDT				 0x0A01000F
#define BOXCVR					 0x0A010010
#define BOXCVRCDT				 0x0A010011
#define GEODRN					 0x0A010012
#define GEODRNCDT				 0x0A010013
#define GEOMAG					 0x0A010014
#define GEOMAGCDT				 0x0A010015
#define GEORCT					 0x0A010016
#define GEORCTCDT				 0x0A010017
#define GEOTRP					 0x0A010018
#define GEOTRPCDT				 0x0A010019
#define GEOTRP8					 0x0A01001A
#define GEOTRP8CDT				 0x0A01001B
#define GEOWRN					 0x0A01001C
#define GEOWRNCDT				 0x0A01001D
#define LID19					 0x0A01001E
#define LID19CDT				 0x0A01001F
#define MAGCON					 0x0A010020
#define MAGCONCDT				 0x0A010021
#define MAGCONCDR				 0x0A010022
#define MAGMOV					 0x0A010023
#define MAGMOVCDT				 0x0A010024
#define MAGMOVCDR				 0x0A010025
#define MAGSHK					 0x0A010026
#define MAGSHKCDT				 0x0A010027
#define MAGSHY					 0x0A010028
#define MAGSHYCDT				 0x0A010029
#define MAGSHYCDR				 0x0A01002A
#define MAGSLK					 0x0A01002B
#define MAGSLKCDT				 0x0A01002C
#define MAGTALK					 0x0A01002D
#define MAGTALKCDT				 0x0A01002E
#define MAGTLK					 0x0A01002F
#define MAGTLKCDT				 0x0A010030
#define MAGTLK8					 0x0A010031
#define MAGTLK8CDT				 0x0A010032
#define TRPOPN					 0x0A010033
#define TRPOPNCDT				 0x0A010034
	// 53 entities in TXTs, 53 in datafiles.
	// room20
#define R20SPRPAL				 0x0A020000
#define R20L0					 0x0A020001
#define R20L1					 0x0A020002
#define R20L2					 0x0A020003
#define R20L3					 0x0A020004
#define R20G1					 0x0A020005
#define R20G2					 0x0A020006
#define R20G3					 0x0A020007
#define R20PAL					 0x0A020008
#define R20FLR					 0x0A020009
#define BARTPS					 0x0A02000A
#define BARTPSCDT				 0x0A02000B
#define BARTWL					 0x0A02000C
#define BARTWLCDT				 0x0A02000D
#define BRIDRN					 0x0A02000E
#define BRIDRNCDT				 0x0A02000F
#define BRIDRNCDR				 0x0A020010
#define BRIFTZ					 0x0A020011
#define BRIFTZCDT				 0x0A020012
#define BRIFTZCDR				 0x0A020013
#define BRITLK					 0x0A020014
#define BRITLKCDT				 0x0A020015
#define BRITLK8					 0x0A020016
#define BRITLK8CDT				 0x0A020017
#define BRITLK9					 0x0A020018
#define BRITLK9CDT				 0x0A020019
#define BRITRN					 0x0A02001A
#define BRITRNCDT				 0x0A02001B
#define BRITRNCDR				 0x0A02001C
#define DOROPN20				 0x0A02001D
#define DOROPN20CDT				 0x0A02001E
#define DOROPN20CDR				 0x0A02001F
#define DOYDRN					 0x0A020020
#define DOYDRNCDT				 0x0A020021
#define DOYDRNCDR				 0x0A020022
#define DOYFTZ					 0x0A020023
#define DOYFTZCDT				 0x0A020024
#define DOYFTZCDR				 0x0A020025
#define DOYTLK					 0x0A020026
#define DOYTLKCDT				 0x0A020027
#define DOYTLK20				 0x0A020028
#define DOYTLK20CDT				 0x0A020029
#define DOYTLK8					 0x0A02002A
#define DOYTLK8CDT				 0x0A02002B
#define DOYTLK9					 0x0A02002C
#define DOYTLK9CDT				 0x0A02002D
#define DOYTRN					 0x0A02002E
#define DOYTRNCDT				 0x0A02002F
#define DOYTRNCDR				 0x0A020030
#define DOYTRN20				 0x0A020031
#define DOYTRN20CDT				 0x0A020032
#define DOYTRN20CDR				 0x0A020033
#define DOYTRN8					 0x0A020034
#define DOYTRN8CDT				 0x0A020035
#define DOYTRN8CDR				 0x0A020036
#define DOYTRN9					 0x0A020037
#define DOYTRN9CDT				 0x0A020038
#define DOYTRN9CDR				 0x0A020039
#define FIDPLY					 0x0A02003A
#define FIDPLYCDT				 0x0A02003B
#define FLPOPN					 0x0A02003C
#define FLPOPNCDT				 0x0A02003D
#define FRMTLK20				 0x0A02003E
#define FRMTLK20CDT				 0x0A02003F
#define FTZAGT					 0x0A020040
#define FTZAGTCDT				 0x0A020041
#define FTZGET					 0x0A020042
#define FTZGETCDT				 0x0A020043
#define FTZGETCDR				 0x0A020044
#define FTZRUN					 0x0A020045
#define FTZRUNCDT				 0x0A020046
#define FTZSTD					 0x0A020047
#define FTZSTDCDT				 0x0A020048
#define FTZTALK					 0x0A020049
#define FTZTALKCDT				 0x0A02004A
#define FTZTLK					 0x0A02004B
#define FTZTLKCDT				 0x0A02004C
#define FTZTLK8					 0x0A02004D
#define FTZTLK8CDT				 0x0A02004E
#define GEODRN20				 0x0A02004F
#define GEODRN20CDT				 0x0A020050
#define GEOPHN20				 0x0A020051
#define GEOPHN20CDT				 0x0A020052
#define GEOPHN20CDR				 0x0A020053
#define GEOPLG					 0x0A020054
#define GEOPLGCDT				 0x0A020055
#define GEOPLG8					 0x0A020056
#define GEOPLG8CDT				 0x0A020057
#define GEOSEE					 0x0A020058
#define GEOSEECDT				 0x0A020059
#define GEOSNR					 0x0A02005A
#define GEOSNRCDT				 0x0A02005B
#define GEOSNR8					 0x0A02005C
#define GEOSNR8CDT				 0x0A02005D
#define GEOTWL20				 0x0A02005E
#define GEOTWL20CDT				 0x0A02005F
#define GEOXIT20				 0x0A020060
#define GEOXIT20CDT				 0x0A020061
#define GLSGEO					 0x0A020062
#define GLSGEOCDT				 0x0A020063
#define GLSWSH					 0x0A020064
#define GLSWSHCDT				 0x0A020065
#define LESDOR					 0x0A020066
#define LESDORCDT				 0x0A020067
#define LESDOY					 0x0A020068
#define LESDOYCDT				 0x0A020069
#define LESFLP					 0x0A02006A
#define LESFLPCDT				 0x0A02006B
#define LESFTZ					 0x0A02006C
#define LESFTZCDT				 0x0A02006D
#define LESFTZCDR				 0x0A02006E
#define LESGLS					 0x0A02006F
#define LESGLSCDT				 0x0A020070
#define LESGLSCDR				 0x0A020071
#define LESLNS					 0x0A020072
#define LESLNSCDT				 0x0A020073
#define LESLNSCDR				 0x0A020074
#define LESMOV					 0x0A020075
#define LESMOVCDT				 0x0A020076
#define LESMOVCDR				 0x0A020077
#define LESPMP					 0x0A020078
#define LESPMPCDT				 0x0A020079
#define LESPNT					 0x0A02007A
#define LESPNTCDT				 0x0A02007B
#define LESPNT20				 0x0A02007C
#define LESPNT20CDT				 0x0A02007D
#define LESPNT8					 0x0A02007E
#define LESPNT8CDT				 0x0A02007F
#define LESPNT8CDR				 0x0A020080
#define LESTALK					 0x0A020081
#define LESTALKCDT				 0x0A020082
#define LESTLK					 0x0A020083
#define LESTLKCDT				 0x0A020084
#define LESTLK20				 0x0A020085
#define LESTLK20CDT				 0x0A020086
#define LESTLK8					 0x0A020087
#define LESTLK8CDT				 0x0A020088
#define LESTLK9					 0x0A020089
#define LESTLK9CDT				 0x0A02008A
#define LESTURN					 0x0A02008B
#define LESTURNCDT				 0x0A02008C
#define LESTURNCDR				 0x0A02008D
#define LESWLK					 0x0A02008E
#define LESWLKCDT				 0x0A02008F
#define LESWLK8					 0x0A020090
#define LESWLK8CDT				 0x0A020091
#define LESWSH					 0x0A020092
#define LESWSHCDT				 0x0A020093
#define LESWSHCDR				 0x0A020094
#define MAGENT					 0x0A020095
#define MAGENTCDT				 0x0A020096
#define MAGEXIT					 0x0A020097
#define MAGEXITCDT				 0x0A020098
#define MAGMOV20				 0x0A020099
#define MAGMOV20CDT				 0x0A02009A
#define MAGTEST					 0x0A02009B
#define MAGTESTCDT				 0x0A02009C
#define MAGTLK20				 0x0A02009D
#define MAGTLK20CDT				 0x0A02009E
#define PLGWLL					 0x0A02009F
#define PLGWLLCDT				 0x0A0200A0
#define RONDRN					 0x0A0200A1
#define RONDRNCDT				 0x0A0200A2
#define RONDRNCDR				 0x0A0200A3
#define RONDRP					 0x0A0200A4
#define RONDRPCDT				 0x0A0200A5
#define RONFTZ					 0x0A0200A6
#define RONFTZCDT				 0x0A0200A7
#define RONFTZCDR				 0x0A0200A8
#define RONGEO					 0x0A0200A9
#define RONGEOCDT				 0x0A0200AA
#define RONGEOCDR				 0x0A0200AB
#define RONGLS					 0x0A0200AC
#define RONGLSCDT				 0x0A0200AD
#define RONGLSCDR				 0x0A0200AE
#define RONGLS8					 0x0A0200AF
#define RONGLS8CDT				 0x0A0200B0
#define RONPIK					 0x0A0200B1
#define RONPIKCDT				 0x0A0200B2
#define RONPKT					 0x0A0200B3
#define RONPKTCDT				 0x0A0200B4
#define RONPKTCDR				 0x0A0200B5
#define RONSNR					 0x0A0200B6
#define RONSNRCDT				 0x0A0200B7
#define RONSNZ					 0x0A0200B8
#define RONSNZCDT				 0x0A0200B9
#define RONSNZ2					 0x0A0200BA
#define RONSNZ2CDT				 0x0A0200BB
#define RONTLK					 0x0A0200BC
#define RONTLKCDT				 0x0A0200BD
#define RONTLK2					 0x0A0200BE
#define RONTLK2CDT				 0x0A0200BF
#define RONWIR					 0x0A0200C0
#define RONWIRCDT				 0x0A0200C1
#define RONWIRCDR				 0x0A0200C2
#define SNRTBL					 0x0A0200C3
#define SNRTBLCDT				 0x0A0200C4
	// 197 entities in TXTs, 197 in datafiles.
	// room21
#define R21L0					 0x0A030000
#define R21L1					 0x0A030001
#define R21L2					 0x0A030002
#define R21G1					 0x0A030003
#define R21G2					 0x0A030004
#define R21PAL					 0x0A030005
#define R21FLR					 0x0A030006
#define CALBLO					 0x0A030007
#define CALBLOCDT				 0x0A030008
#define GEMSHN					 0x0A030009
#define GEMSHNCDT				 0x0A03000A
#define GEOGEM					 0x0A03000B
#define GEOGEMCDT				 0x0A03000C
#define GEOGEM8					 0x0A03000D
#define GEOGEM8CDT				 0x0A03000E
#define GEOLVR					 0x0A03000F
#define GEOLVRCDT				 0x0A030010
#define GEOLVR21				 0x0A030011
#define GEOLVR21CDT				 0x0A030012
#define GEOLVR8					 0x0A030013
#define GEOLVR8CDT				 0x0A030014
#define GEOTAP					 0x0A030015
#define GEOTAPCDT				 0x0A030016
#define GEOTLK21				 0x0A030017
#define GEOTLK21CDT				 0x0A030018
#define GEOTORCH				 0x0A030019
#define GEOTORCHCDT				 0x0A03001A
#define GEOTRN21				 0x0A03001B
#define GEOTRN21CDT				 0x0A03001C
#define GEOTRN21CDR				 0x0A03001D
#define GEOTWL21				 0x0A03001E
#define GEOTWL21CDT				 0x0A03001F
#define LVRPSH					 0x0A030020
#define LVRPSHCDT				 0x0A030021
#define MAGCEL					 0x0A030022
#define MAGCELCDT				 0x0A030023
#define MAGCELCDR				 0x0A030024
#define MAGTLK21				 0x0A030025
#define MAGTLK21CDT				 0x0A030026
#define TAPDRP					 0x0A030027
#define TAPDRPCDT				 0x0A030028
#define TAPRUN					 0x0A030029
#define TAPRUNCDT				 0x0A03002A
#define TORCH21					 0x0A03002B
#define TORCH21CDT				 0x0A03002C
	// 45 entities in TXTs, 45 in datafiles.
	// room22
#define R22SPRPAL				 0x0A040000
#define R22L0					 0x0A040001
#define R22L1					 0x0A040002
#define R22G1					 0x0A040003
#define R22PAL					 0x0A040004
#define R22FLR					 0x0A040005
#define FRMBUK					 0x0A040006
#define FRMBUKCDT				 0x0A040007
#define FRMSTD					 0x0A040008
#define FRMSTDCDT				 0x0A040009
#define FRMTLK					 0x0A04000A
#define FRMTLKCDT				 0x0A04000B
#define FRMWLK					 0x0A04000C
#define FRMWLKCDT				 0x0A04000D
#define GEOCLM					 0x0A04000E
#define GEOCLMCDT				 0x0A04000F
#define GEOCLMCDR				 0x0A040010
#define GEOPSH22				 0x0A040011
#define GEOPSH22CDT				 0x0A040012
	// 19 entities in TXTs, 19 in datafiles.
	// room23
#define R23L0					 0x0A050000
#define R23PAL					 0x0A050001
#define GEOCLM23				 0x0A050002
#define GEOCLM23CDT				 0x0A050003
#define GEOCLM23CDR				 0x0A050004
#define GEOKEY23				 0x0A050005
#define GEOKEY23CDT				 0x0A050006
#define GEOTOP					 0x0A050007
#define GEOTOPCDT				 0x0A050008
#define GEOTOPCDR				 0x0A050009
#define GEOTRY23				 0x0A05000A
#define GEOTRY23CDT				 0x0A05000B
#define GEOTUG23				 0x0A05000C
#define GEOTUG23CDT				 0x0A05000D
#define LFTKEY23				 0x0A05000E
#define LFTKEY23CDT				 0x0A05000F
	// 16 entities in TXTs, 16 in datafiles.
	// room24
#define R24L0					 0x0A060000
#define R24L1					 0x0A060001
#define R24G1					 0x0A060002
#define R24PLX					 0x0A060003
#define R24PAL					 0x0A060004
#define R24FLR					 0x0A060005
#define GEOASC24				 0x0A060006
#define GEOASC24CDT				 0x0A060007
#define GEODES24				 0x0A060008
#define GEODES24CDT				 0x0A060009
#define GEOHITL					 0x0A06000A
#define GEOHITLCDT				 0x0A06000B
#define GEOHITR					 0x0A06000C
#define GEOHITRCDT				 0x0A06000D
#define GEOLAD					 0x0A06000E
#define GEOLADCDT				 0x0A06000F
#define GEOLAD8					 0x0A060010
#define GEOLAD8CDT				 0x0A060011
#define GEOPLW					 0x0A060012
#define GEOPLWCDT				 0x0A060013
#define GEORUN					 0x0A060014
#define GEORUNCDT				 0x0A060015
#define GEOUPL24				 0x0A060016
#define GEOUPL24CDT				 0x0A060017
#define GEOUPR24				 0x0A060018
#define GEOUPR24CDT				 0x0A060019
#define GOTBAKL					 0x0A06001A
#define GOTBAKLCDT				 0x0A06001B
#define GOTBAKR					 0x0A06001C
#define GOTBAKRCDT				 0x0A06001D
#define GOTCL					 0x0A06001E
#define GOTCLCDT				 0x0A06001F
#define GOTCR					 0x0A060020
#define GOTCRCDT				 0x0A060021
#define GOTEAT					 0x0A060022
#define GOTEATCDT				 0x0A060023
#define GOTPLW					 0x0A060024
#define GOTPLWCDT				 0x0A060025
#define GOTPLW1					 0x0A060026
#define GOTPLW1CDT				 0x0A060027
#define GOTRIS					 0x0A060028
#define GOTRISCDT				 0x0A060029
#define GOTRISCDR				 0x0A06002A
#define PLWMOV					 0x0A06002B
#define PLWMOVCDT				 0x0A06002C
	// 45 entities in TXTs, 45 in datafiles.
	// room25
#define R25SPRPAL				 0x0A070000
#define R25L0					 0x0A070001
#define R25L1					 0x0A070002
#define R25G1					 0x0A070003
#define R25PAL					 0x0A070004
#define R25FLR					 0x0A070005
#define ALTOPN					 0x0A070006
#define ALTOPNCDT				 0x0A070007
#define GEOASC25				 0x0A070008
#define GEOASC25CDT				 0x0A070009
#define GEOCLM25				 0x0A07000A
#define GEOCLM25CDT				 0x0A07000B
#define GEODES25				 0x0A07000C
#define GEODES25CDT				 0x0A07000D
#define GEODRY25				 0x0A07000E
#define GEODRY25CDT				 0x0A07000F
#define GEOFIN25				 0x0A070010
#define GEOFIN25CDT				 0x0A070011
#define GEOPLAS					 0x0A070012
#define GEOPLASCDT				 0x0A070013
#define GEOPLASCDR				 0x0A070014
#define GEOPLS					 0x0A070015
#define GEOPLSCDT				 0x0A070016
#define GEOPSH25				 0x0A070017
#define GEOPSH25CDT				 0x0A070018
#define GEOPUT					 0x0A070019
#define GEOPUTCDT				 0x0A07001A
#define GEOSAC					 0x0A07001B
#define GEOSACCDT				 0x0A07001C
#define GEOSAC25				 0x0A07001D
#define GEOSAC25CDT				 0x0A07001E
#define GEOSTD25				 0x0A07001F
#define GEOSTD25CDT				 0x0A070020
#define GEOSTN					 0x0A070021
#define GEOSTNCDT				 0x0A070022
#define GEOSTN8					 0x0A070023
#define GEOSTN8CDT				 0x0A070024
#define GEOTWL25				 0x0A070025
#define GEOTWL25CDT				 0x0A070026
#define GEOWALF2				 0x0A070027
#define GEOWALF2CDT				 0x0A070028
#define IMPFLR					 0x0A070029
#define IMPFLRCDT				 0x0A07002A
#define IMPPLS					 0x0A07002B
#define IMPPLSCDT				 0x0A07002C
#define PLASWALL				 0x0A07002D
#define PLASWALLCDT				 0x0A07002E
#define STNFALL					 0x0A07002F
#define STNFALLCDT				 0x0A070030
	// 49 entities in TXTs, 49 in datafiles.
	// room26
#define R26SPRPAL				 0x0A080000
#define R26L0					 0x0A080001
#define R26L1					 0x0A080002
#define R26L2					 0x0A080003
#define R26G1					 0x0A080004
#define R26G2					 0x0A080005
#define R26PAL					 0x0A080006
#define R26FLR					 0x0A080007
#define GEOLVR08				 0x0A080008
#define GEOLVR08CDT				 0x0A080009
#define GEOLVR26				 0x0A08000A
#define GEOLVR26CDT				 0x0A08000B
#define LVRDRK					 0x0A08000C
#define LVRDRKCDT				 0x0A08000D
#define RATJMP					 0x0A08000E
#define RATJMPCDT				 0x0A08000F
	// 16 entities in TXTs, 16 in datafiles.
// spain
	// sound_fx
#define FX_SPNBIRD1				 0x0B000000
#define FX_SPNBIRD2				 0x0B000001
#define FX_AMBIEN56				 0x0B000002
#define FX_DOGS56				 0x0B000003
#define FX_PENDULUM				 0x0B000004
#define FX_CANFALL				 0x0B000005
#define FX_HOSE57				 0x0B000006
#define FX_HOSE57B				 0x0B000007
#define FX_SPAIN				 0x0B000008
#define FX_CHESS				 0x0B000009
#define FX_SECDOR59				 0x0B00000A
#define FX_WINDOW59				 0x0B00000B
#define FX_LIONFALL				 0x0B00000C
#define FX_LIONFAL2				 0x0B00000D
#define FX_TOOTHPUL				 0x0B00000E
#define FX_SECDOR61				 0x0B00000F
#define FX_WELLDRIP				 0x0B000010
	// 17 entities in TXTs, 17 in datafiles.
	// room56
#define SPAIN_PAL				 0x0B010000
#define R56L0					 0x0B010001
#define R56L1					 0x0B010002
#define R56L2					 0x0B010003
#define R56G1					 0x0B010004
#define R56G2					 0x0B010005
#define R56PAL					 0x0B010006
#define R56FLR					 0x0B010007
#define CHALIC56				 0x0B010008
#define CHALIC56CDT				 0x0B010009
#define GARD20					 0x0B01000A
#define GARD20CDT				 0x0B01000B
#define GARD21					 0x0B01000C
#define GARD21CDT				 0x0B01000D
#define GARD22					 0x0B01000E
#define GARD22CDT				 0x0B01000F
#define GEOSPA10				 0x0B010010
#define GEOSPA10CDT				 0x0B010011
#define GEOSPA10CDR				 0x0B010012
#define GEOSPA11				 0x0B010013
#define GEOSPA11CDT				 0x0B010014
#define GEOSPA13				 0x0B010015
#define GEOSPA13CDT				 0x0B010016
#define GEOSPA13CDR				 0x0B010017
#define GEOSPA19				 0x0B010018
#define GEOSPA19CDT				 0x0B010019
#define GEOSPA44				 0x0B01001A
#define GEOSPA44CDT				 0x0B01001B
#define GEOSPA48				 0x0B01001C
#define GEOSPA48CDT				 0x0B01001D
#define PENDULUM				 0x0B01001E
#define PENDULUMCDT				 0x0B01001F
#define PIECE56					 0x0B010020
#define PIECE56CDT				 0x0B010021
#define VASC01					 0x0B010022
#define VASC01CDT				 0x0B010023
#define VASC02					 0x0B010024
#define VASC02CDT				 0x0B010025
#define VASC04					 0x0B010026
#define VASC04CDT				 0x0B010027
#define VASC05					 0x0B010028
#define VASC05CDT				 0x0B010029
#define VASC05CDR				 0x0B01002A
#define VASC06					 0x0B01002B
#define VASC06CDT				 0x0B01002C
#define VASC26					 0x0B01002D
#define VASC26CDT				 0x0B01002E
#define VASC26CDR				 0x0B01002F
#define VASC27					 0x0B010030
#define VASC27CDT				 0x0B010031
#define VASC28					 0x0B010032
#define VASC28CDT				 0x0B010033
#define VASC29					 0x0B010034
#define VASC29CDT				 0x0B010035
#define VASC29CDR				 0x0B010036
#define VASC30					 0x0B010037
#define VASC30CDT				 0x0B010038
#define VASC30CDR				 0x0B010039
#define VASC32					 0x0B01003A
#define VASC32CDT				 0x0B01003B
	// 60 entities in TXTs, 60 in datafiles.
	// room57
#define R57L0					 0x0B020000
#define R57L1					 0x0B020001
#define R57G1					 0x0B020002
#define R57PAL					 0x0B020003
#define R57FLR					 0x0B020004
#define R57PLX					 0x0B020005
#define MEGA_DOWSE				 0x0B020006
#define GAR57GOB				 0x0B020007
#define GAR57GOBCDT				 0x0B020008
#define GARD01					 0x0B020009
#define GARD01CDT				 0x0B02000A
#define GARD02					 0x0B02000B
#define GARD02CDT				 0x0B02000C
#define GARD03					 0x0B02000D
#define GARD03CDT				 0x0B02000E
#define GARD04					 0x0B02000F
#define GARD04CDT				 0x0B020010
#define GARD04CDR				 0x0B020011
#define GARD05					 0x0B020012
#define GARD05CDT				 0x0B020013
#define GARD06					 0x0B020014
#define GARD06CDT				 0x0B020015
#define GARD07					 0x0B020016
#define GARD07CDT				 0x0B020017
#define GARD07CDR				 0x0B020018
#define GARD08					 0x0B020019
#define GARD08CDT				 0x0B02001A
#define GARD09					 0x0B02001B
#define GARD09CDT				 0x0B02001C
#define GARD17					 0x0B02001D
#define GARD17CDT				 0x0B02001E
#define GARD17CDR				 0x0B02001F
#define GARD18					 0x0B020020
#define GARD18CDT				 0x0B020021
#define GARD31					 0x0B020022
#define GARD31CDT				 0x0B020023
#define GARD31CDR				 0x0B020024
#define GARD32					 0x0B020025
#define GARD32CDT				 0x0B020026
#define GARD34					 0x0B020027
#define GARD34CDT				 0x0B020028
#define GARD35					 0x0B020029
#define GARD35CDT				 0x0B02002A
#define GARD36					 0x0B02002B
#define GARD36CDT				 0x0B02002C
#define GARD37					 0x0B02002D
#define GARD37CDT				 0x0B02002E
#define GARD38					 0x0B02002F
#define GARD38CDT				 0x0B020030
#define GARD39					 0x0B020031
#define GARD39CDT				 0x0B020032
#define GARD40					 0x0B020033
#define GARD40CDT				 0x0B020034
#define GARD40CDR				 0x0B020035
#define GARD41					 0x0B020036
#define GARD41CDT				 0x0B020037
#define GARD42					 0x0B020038
#define GARD42CDT				 0x0B020039
#define GARD43					 0x0B02003A
#define GARD43CDT				 0x0B02003B
#define GARD44					 0x0B02003C
#define GARD44CDT				 0x0B02003D
#define GARD44CDR				 0x0B02003E
#define GARD45					 0x0B02003F
#define GARD45CDT				 0x0B020040
#define GARDKNE					 0x0B020041
#define GARDKNECDT				 0x0B020042
#define GAUGE57					 0x0B020043
#define GAUGE57CDT				 0x0B020044
#define GEOSPA01				 0x0B020045
#define GEOSPA01CDT				 0x0B020046
#define GEOSPA20				 0x0B020047
#define GEOSPA20CDT				 0x0B020048
#define GEOSPA22				 0x0B020049
#define GEOSPA22CDT				 0x0B02004A
#define GEOSPA42				 0x0B02004B
#define GEOSPA42CDT				 0x0B02004C
#define GEOSPA47				 0x0B02004D
#define GEOSPA47CDT				 0x0B02004E
#define HOLE57					 0x0B02004F
#define HOLE57CDT				 0x0B020050
#define HOSE57					 0x0B020051
#define HOSE57CDT				 0x0B020052
	// 83 entities in TXTs, 83 in datafiles.
	// room58
#define R58L0					 0x0B030000
#define R58L1					 0x0B030001
#define R58G1					 0x0B030002
#define R58PAL					 0x0B030003
#define R58FLR					 0x0B030004
#define R58PLX					 0x0B030005
#define GARD24					 0x0B030006
#define GARD24CDT				 0x0B030007
#define GARD25					 0x0B030008
#define GARD25CDT				 0x0B030009
#define GARD26					 0x0B03000A
#define GARD26CDT				 0x0B03000B
#define MAUSDOOR				 0x0B03000C
#define MAUSDOORCDT				 0x0B03000D
#define VASC07					 0x0B03000E
#define VASC07CDT				 0x0B03000F
#define VASC08					 0x0B030010
#define VASC08CDT				 0x0B030011
#define VASC09					 0x0B030012
#define VASC09CDT				 0x0B030013
#define VASC10					 0x0B030014
#define VASC10CDT				 0x0B030015
#define VASC11					 0x0B030016
#define VASC11CDT				 0x0B030017
#define VASC12					 0x0B030018
#define VASC12CDT				 0x0B030019
	// 26 entities in TXTs, 26 in datafiles.
	// room59
#define R59L0					 0x0B040000
#define R59L1					 0x0B040001
#define R59L2					 0x0B040002
#define R59G1					 0x0B040003
#define R59G2					 0x0B040004
#define R59PAL					 0x0B040005
#define R59FLR					 0x0B040006
#define BIBLE59					 0x0B040007
#define BIBLE59CDT				 0x0B040008
#define BLOWOUT					 0x0B040009
#define BLOWOUTCDT				 0x0B04000A
#define CANDLE59				 0x0B04000B
#define CANDLE59CDT				 0x0B04000C
#define CHAL59					 0x0B04000D
#define CHAL59CDT				 0x0B04000E
#define FLAMEL59				 0x0B04000F
#define FLAMEL59CDT				 0x0B040010
#define FLAMER59				 0x0B040011
#define FLAMER59CDT				 0x0B040012
#define FLAMET59				 0x0B040013
#define FLAMET59CDT				 0x0B040014
#define GARD27					 0x0B040015
#define GARD27CDT				 0x0B040016
#define GARD28					 0x0B040017
#define GARD28CDT				 0x0B040018
#define GARD29					 0x0B040019
#define GARD29CDT				 0x0B04001A
#define GARD30					 0x0B04001B
#define GARD30CDT				 0x0B04001C
#define GEOBIBLE				 0x0B04001D
#define GEOBIBLECDT				 0x0B04001E
#define GEOSPA12				 0x0B04001F
#define GEOSPA12CDT				 0x0B040020
#define GEOSPA16				 0x0B040021
#define GEOSPA16CDT				 0x0B040022
#define GEOSPA17				 0x0B040023
#define GEOSPA17CDT				 0x0B040024
#define GEOSPA18				 0x0B040025
#define GEOSPA18CDT				 0x0B040026
#define GEOSPA18CDR				 0x0B040027
#define GEOSPA23				 0x0B040028
#define GEOSPA23CDT				 0x0B040029
#define GEOSPA23CDR				 0x0B04002A
#define GEOSPA37				 0x0B04002B
#define GEOSPA37CDT				 0x0B04002C
#define GEOSPA37CDR				 0x0B04002D
#define GEOSPA38				 0x0B04002E
#define GEOSPA38CDT				 0x0B04002F
#define GEOSPA39				 0x0B040030
#define GEOSPA39CDT				 0x0B040031
#define GEOSPA40				 0x0B040032
#define GEOSPA40CDT				 0x0B040033
#define GEOSPA41				 0x0B040034
#define GEOSPA41CDT				 0x0B040035
#define GEOSPA43				 0x0B040036
#define GEOSPA43CDT				 0x0B040037
#define GEOSPA45				 0x0B040038
#define GEOSPA45CDT				 0x0B040039
#define GEOSPA46				 0x0B04003A
#define GEOSPA46CDT				 0x0B04003B
#define SECDOR59				 0x0B04003C
#define SECDOR59CDT				 0x0B04003D
#define SNUFF59					 0x0B04003E
#define SNUFF59CDT				 0x0B04003F
#define TISSUE59				 0x0B040040
#define TISSUE59CDT				 0x0B040041
#define VASC13					 0x0B040042
#define VASC13CDT				 0x0B040043
#define VASC14					 0x0B040044
#define VASC14CDT				 0x0B040045
#define VASC15					 0x0B040046
#define VASC15CDT				 0x0B040047
#define VASC16					 0x0B040048
#define VASC16CDT				 0x0B040049
#define VASC17					 0x0B04004A
#define VASC17CDT				 0x0B04004B
#define VASC18					 0x0B04004C
#define VASC18CDT				 0x0B04004D
#define VASC19					 0x0B04004E
#define VASC19CDT				 0x0B04004F
#define VASC20					 0x0B040050
#define VASC20CDT				 0x0B040051
#define VASC20CDR				 0x0B040052
#define VASC21					 0x0B040053
#define VASC21CDT				 0x0B040054
#define VASC22					 0x0B040055
#define VASC22CDT				 0x0B040056
#define VASC23					 0x0B040057
#define VASC23CDT				 0x0B040058
#define VASC24					 0x0B040059
#define VASC24CDT				 0x0B04005A
#define VASC25					 0x0B04005B
#define VASC25CDT				 0x0B04005C
#define VASC31					 0x0B04005D
#define VASC31CDT				 0x0B04005E
#define WINDSHUT				 0x0B04005F
#define WINDSHUTCDT				 0x0B040060
#define WINDSHUTCDR				 0x0B040061
	// 98 entities in TXTs, 98 in datafiles.
	// room60
#define R60L0					 0x0B050000
#define R60L1					 0x0B050001
#define R60L2					 0x0B050002
#define R60G1					 0x0B050003
#define R60G2					 0x0B050004
#define R60PAL					 0x0B050005
#define R60FLR					 0x0B050006
#define GARD10					 0x0B050007
#define GARD10CDT				 0x0B050008
#define GARD11					 0x0B050009
#define GARD11CDT				 0x0B05000A
#define GARD13					 0x0B05000B
#define GARD13CDT				 0x0B05000C
#define GARD16					 0x0B05000D
#define GARD16CDT				 0x0B05000E
#define GARD19					 0x0B05000F
#define GARD19CDT				 0x0B050010
#define GEOSPA05				 0x0B050011
#define GEOSPA05CDT				 0x0B050012
#define GEOSPA05CDR				 0x0B050013
#define GEOSPA08				 0x0B050014
#define GEOSPA08CDT				 0x0B050015
#define GEOSPA09				 0x0B050016
#define GEOSPA09CDT				 0x0B050017
#define GEOSPA09CDR				 0x0B050018
#define GEOSPA21				 0x0B050019
#define GEOSPA21CDT				 0x0B05001A
#define MIRROR60				 0x0B05001B
#define MIRROR60CDT				 0x0B05001C
	// 29 entities in TXTs, 29 in datafiles.
	// room61
#define R61L0					 0x0B060000
#define R61L1					 0x0B060001
#define R61G1					 0x0B060002
#define R61PAL					 0x0B060003
#define R61FLR					 0x0B060004
#define DUST					 0x0B060005
#define DUSTCDT					 0x0B060006
#define GEOSPA24				 0x0B060007
#define GEOSPA24CDT				 0x0B060008
#define GEOSPA25				 0x0B060009
#define GEOSPA25CDT				 0x0B06000A
#define GEOSPA26				 0x0B06000B
#define GEOSPA26CDT				 0x0B06000C
#define GEOSPA27				 0x0B06000D
#define GEOSPA27CDT				 0x0B06000E
#define GEOSPA30				 0x0B06000F
#define GEOSPA30CDT				 0x0B060010
#define GEOSPA31				 0x0B060011
#define GEOSPA31CDT				 0x0B060012
#define GEOSPA32				 0x0B060013
#define GEOSPA32CDT				 0x0B060014
#define GEOSPA33				 0x0B060015
#define GEOSPA33CDT				 0x0B060016
#define GEOSPA35				 0x0B060017
#define GEOSPA35CDT				 0x0B060018
#define LION1					 0x0B060019
#define LION1CDT				 0x0B06001A
#define LION2					 0x0B06001B
#define LION2CDT				 0x0B06001C
#define LIONDOOR				 0x0B06001D
#define LIONDOORCDT				 0x0B06001E
#define LIONFLOR				 0x0B06001F
#define LIONFLORCDT				 0x0B060020
#define ROPE61					 0x0B060021
#define ROPE61CDT				 0x0B060022
#define SECDOR61				 0x0B060023
#define SECDOR61CDT				 0x0B060024
	// 37 entities in TXTs, 37 in datafiles.
	// room62
#define R62L0					 0x0B070000
#define R62PAL					 0x0B070001
#define BISHOP62				 0x0B070002
#define BISHOP62CDT				 0x0B070003
#define KING62					 0x0B070004
#define KING62CDT				 0x0B070005
#define KNIGHT62				 0x0B070006
#define KNIGHT62CDT				 0x0B070007
	// 8 entities in TXTs, 8 in datafiles.
// syria
	// sound_fx
#define FX_CAMERA45				 0x0C000000
#define FX_SHOCK3				 0x0C000001
#define FX_STALLBEL				 0x0C000002
#define FX_AYUBDOOR				 0x0C000003
#define FX_BALLPLAY				 0x0C000004
#define FX_CATHIT				 0x0C000005
#define FX_MARIB				 0x0C000006
#define FX_NEWTON				 0x0C000007
#define FX_STALLCAT				 0x0C000008
#define FX_STATBREK				 0x0C000009
#define FX_KEYS49				 0x0C00000A
#define FX_MANG1				 0x0C00000B
#define FX_MANG2				 0x0C00000C
#define FX_MANG3				 0x0C00000D
#define FX_UNLOCK49				 0x0C00000E
#define FX_WCCHAIN				 0x0C00000F
#define FX_CUBDOR				 0x0C000010
#define FX_BREKSTIK				 0x0C000011
#define FX_CLIMBDWN				 0x0C000012
#define FX_CRICKET				 0x0C000013
#define FX_GEOFAL54				 0x0C000014
#define FX_KHANDOWN				 0x0C000015
#define FX_RINGPULL				 0x0C000016
#define FX_SECDOR54				 0x0C000017
#define FX_SHOTKHAN				 0x0C000018
#define FX_SYRIWIND				 0x0C000019
#define FX_THUMP1				 0x0C00001A
#define FX_SECDOR55				 0x0C00001B
	// 28 entities in TXTs, 28 in datafiles.
	// duane
#define DUANE_MEGA				 0x0C010000
#define DUANE_WLK				 0x0C010001
#define DNETLK3					 0x0C010002
#define DNETLK3CDT				 0x0C010003
#define DNETLK5					 0x0C010004
#define DNETLK5CDT				 0x0C010005
#define XDNEMON3				 0x0C010006
#define XDNEMON3CDT				 0x0C010007
#define XDNEMON5				 0x0C010008
#define XDNEMON5CDT				 0x0C010009
#define XDNESTA3				 0x0C01000A
#define XDNESTA3CDT				 0x0C01000B
#define XDNESTA5				 0x0C01000C
#define XDNESTA5CDT				 0x0C01000D
#define XDNEPHO3				 0x0C01000E
#define XDNEPHO3CDT				 0x0C01000F
#define XDNEPHO5				 0x0C010010
#define XDNEPHO5CDT				 0x0C010011
	// 18 entities in TXTs, 18 in datafiles.
	// room45
#define SYRIA_PAL				 0x0C020000
#define R45SPRPAL				 0x0C020001
#define R45L0					 0x0C020002
#define R45L1					 0x0C020003
#define R45G1					 0x0C020004
#define R45PAL					 0x0C020005
#define R45FLR					 0x0C020006
#define R45PLX					 0x0C020007
#define ART1					 0x0C020008
#define ART1CDT					 0x0C020009
#define ART2					 0x0C02000A
#define ART2CDT					 0x0C02000B
#define ART3A					 0x0C02000C
#define ART3ACDT				 0x0C02000D
#define ART3ACDR				 0x0C02000E
#define ART4					 0x0C02000F
#define ART4CDT					 0x0C020010
#define ART5					 0x0C020011
#define ART5CDT					 0x0C020012
#define ART6					 0x0C020013
#define ART6CDT					 0x0C020014
#define ART7					 0x0C020015
#define ART7CDT					 0x0C020016
#define AYU1					 0x0C020017
#define AYU1CDT					 0x0C020018
#define AYU1A					 0x0C020019
#define AYU1ACDT				 0x0C02001A
#define AYU1B					 0x0C02001B
#define AYU1BCDT				 0x0C02001C
#define AYU5					 0x0C02001D
#define AYU5CDT					 0x0C02001E
#define BRUSH					 0x0C02001F
#define BRUSHCDT				 0x0C020020
#define CAT1					 0x0C020021
#define CAT1CDT					 0x0C020022
#define CAT3					 0x0C020023
#define CAT3CDT					 0x0C020024
#define CAT4					 0x0C020025
#define CAT4CDT					 0x0C020026
#define CAT5					 0x0C020027
#define CAT5CDT					 0x0C020028
#define GEOCHA					 0x0C020029
#define GEOCHACDT				 0x0C02002A
#define GEOSYR1					 0x0C02002B
#define GEOSYR1CDT				 0x0C02002C
#define GEOSYR10				 0x0C02002D
#define GEOSYR10CDT				 0x0C02002E
#define GEOSYR10CDR				 0x0C02002F
#define GEOSYR18				 0x0C020030
#define GEOSYR18CDT				 0x0C020031
#define GEOSYR2					 0x0C020032
#define GEOSYR2CDT				 0x0C020033
#define GEOSYR5					 0x0C020034
#define GEOSYR5CDT				 0x0C020035
#define GEOSYR6					 0x0C020036
#define GEOSYR6CDT				 0x0C020037
#define GEOSYR7					 0x0C020038
#define GEOSYR7CDT				 0x0C020039
#define NEJ1					 0x0C02003A
#define NEJ1CDT					 0x0C02003B
#define NEJ10					 0x0C02003C
#define NEJ10CDT				 0x0C02003D
#define NEJ12					 0x0C02003E
#define NEJ12CDT				 0x0C02003F
#define NEJ13					 0x0C020040
#define NEJ13CDT				 0x0C020041
#define NEJ13CDR				 0x0C020042
#define NEJ2					 0x0C020043
#define NEJ2CDT					 0x0C020044
#define NEJ2B					 0x0C020045
#define NEJ2BCDT				 0x0C020046
#define NEJ4					 0x0C020047
#define NEJ4CDT					 0x0C020048
#define NEJ6					 0x0C020049
#define NEJ6CDT					 0x0C02004A
#define NEJ7					 0x0C02004B
#define NEJ7CDT					 0x0C02004C
#define NEJ7B					 0x0C02004D
#define NEJ7BCDT				 0x0C02004E
#define NEJ8					 0x0C02004F
#define NEJ8CDT					 0x0C020050
#define NEJ9					 0x0C020051
#define NEJ9CDT					 0x0C020052
#define NEWTON					 0x0C020053
#define NEWTONCDT				 0x0C020054
#define PRL1					 0x0C020055
#define PRL1CDT					 0x0C020056
#define PRL2					 0x0C020057
#define PRL2CDT					 0x0C020058
#define PRL6					 0x0C020059
#define PRL6CDT					 0x0C02005A
#define PRL7					 0x0C02005B
#define PRL7CDT					 0x0C02005C
#define PRL8					 0x0C02005D
#define PRL8CDT					 0x0C02005E
#define SHO1					 0x0C02005F
#define SHO1CDT					 0x0C020060
#define SHO2					 0x0C020061
#define SHO2CDT					 0x0C020062
#define SHT1					 0x0C020063
#define SHT1CDT					 0x0C020064
#define SHT2					 0x0C020065
#define SHT2CDT					 0x0C020066
#define SHT3					 0x0C020067
#define SHT3CDT					 0x0C020068
#define STA2					 0x0C020069
#define STA2CDT					 0x0C02006A
#define STEAM45					 0x0C02006B
#define STEAM45CDT				 0x0C02006C
#define TRUCK45					 0x0C02006D
#define TRUCK45CDT				 0x0C02006E
#define TRUCKEMP				 0x0C02006F
#define TRUCKEMPCDT				 0x0C020070
#define ULT6					 0x0C020071
#define ULT6CDT					 0x0C020072
#define ULT7					 0x0C020073
#define ULT7CDT					 0x0C020074
#define ULT8					 0x0C020075
#define ULT8CDT					 0x0C020076
#define ULT9					 0x0C020077
#define ULT9CDT					 0x0C020078
#define XGEOMON3				 0x0C020079
#define XGEOMON3CDT				 0x0C02007A
#define XGEOMON5				 0x0C02007B
#define XGEOMON5CDT				 0x0C02007C
#define XGEOSTA3				 0x0C02007D
#define XGEOSTA3CDT				 0x0C02007E
#define XGEOSTA5				 0x0C02007F
#define XGEOSTA5CDT				 0x0C020080
#define XGEOSTAT				 0x0C020081
#define XGEOSTATCDT				 0x0C020082
	// 131 entities in TXTs, 131 in datafiles.
	// room47
#define R47L0					 0x0C030000
#define R47L1					 0x0C030001
#define R47L2					 0x0C030002
#define R47G1					 0x0C030003
#define R47G2					 0x0C030004
#define R47PAL					 0x0C030005
#define R47FLR					 0x0C030006
#define CAR1					 0x0C030007
#define CAR1CDT					 0x0C030008
#define CAR2					 0x0C030009
#define CAR2CDT					 0x0C03000A
#define CAR3					 0x0C03000B
#define CAR3CDT					 0x0C03000C
#define CAR4					 0x0C03000D
#define CAR4CDT					 0x0C03000E
#define CAR5					 0x0C03000F
#define CAR5CDT					 0x0C030010
#define CAR6					 0x0C030011
#define CAR6CDT					 0x0C030012
#define CRPMOV					 0x0C030013
#define CRPMOVCDT				 0x0C030014
#define GEOSYR3					 0x0C030015
#define GEOSYR3CDT				 0x0C030016
#define GEOSYR3A				 0x0C030017
#define GEOSYR3ACDT				 0x0C030018
#define GEOSYR4					 0x0C030019
#define GEOSYR4CDT				 0x0C03001A
#define GEOSYR4A				 0x0C03001B
#define GEOSYR4ACDT				 0x0C03001C
	// 29 entities in TXTs, 29 in datafiles.
	// room49
#define R49L0					 0x0C040000
#define R49L1					 0x0C040001
#define R49L2					 0x0C040002
#define R49G1					 0x0C040003
#define R49G2					 0x0C040004
#define R49PAL					 0x0C040005
#define R49FLR					 0x0C040006
#define DOOR49					 0x0C040007
#define DOOR49CDT				 0x0C040008
#define DOOR49CDR				 0x0C040009
#define GEOKEYS1				 0x0C04000A
#define GEOKEYS1CDT				 0x0C04000B
#define GEOSYR43				 0x0C04000C
#define GEOSYR43CDT				 0x0C04000D
#define KEYS					 0x0C04000E
#define KEYSCDT					 0x0C04000F
#define MAN1					 0x0C040010
#define MAN1CDT					 0x0C040011
#define MAN2					 0x0C040012
#define MAN2CDT					 0x0C040013
#define MAN3					 0x0C040014
#define MAN3CDT					 0x0C040015
#define MAN4					 0x0C040016
#define MAN4CDT					 0x0C040017
#define MAN4A					 0x0C040018
#define MAN4ACDT				 0x0C040019
#define ULT10					 0x0C04001A
#define ULT10CDT				 0x0C04001B
#define ULT15					 0x0C04001C
#define ULT15CDT				 0x0C04001D
#define ULT3					 0x0C04001E
#define ULT3CDT					 0x0C04001F
#define ULTTAK					 0x0C040020
#define ULTTAKCDT				 0x0C040021
	// 34 entities in TXTs, 34 in datafiles.
	// room50
#define R50L0					 0x0C050000
#define R50L1					 0x0C050001
#define R50L2					 0x0C050002
#define R50L3					 0x0C050003
#define R50G1					 0x0C050004
#define R50G2					 0x0C050005
#define R50G3					 0x0C050006
#define R50PAL					 0x0C050007
#define R50FLR					 0x0C050008
#define CHAIN50					 0x0C050009
#define CHAIN50CDT				 0x0C05000A
#define CUBDOR50				 0x0C05000B
#define CUBDOR50CDT				 0x0C05000C
#define DOOR50					 0x0C05000D
#define DOOR50CDT				 0x0C05000E
#define DOOR50CDR				 0x0C05000F
#define GEOSYR48				 0x0C050010
#define GEOSYR48CDT				 0x0C050011
#define GEOSYR49				 0x0C050012
#define GEOSYR49CDT				 0x0C050013
#define GEOSYR50				 0x0C050014
#define GEOSYR50CDT				 0x0C050015
#define GEOSYR51				 0x0C050016
#define GEOSYR51CDT				 0x0C050017
#define GEOSYR51CDR				 0x0C050018
#define GEOSYR52				 0x0C050019
#define GEOSYR52CDT				 0x0C05001A
#define GEOSYR53				 0x0C05001B
#define GEOSYR53CDT				 0x0C05001C
#define GEOSYR54				 0x0C05001D
#define GEOSYR54CDT				 0x0C05001E
#define TOWEL1					 0x0C05001F
#define TOWEL1CDT				 0x0C050020
#define TOWEL4					 0x0C050021
#define TOWEL4CDT				 0x0C050022
	// 35 entities in TXTs, 35 in datafiles.
	// room53
#define R53L0					 0x0C060000
#define R53PAL					 0x0C060001
#define BACK53PLX				 0x0C060002
#define FRONT53PLX				 0x0C060003
#define R53SPRPAL				 0x0C060004
	// 5 entities in TXTs, 5 in datafiles.
	// room54
#define R54L0					 0x0C070000
#define R54L1					 0x0C070001
#define R54G1					 0x0C070002
#define R54PAL					 0x0C070003
#define R54FLR					 0x0C070004
#define R54PLX					 0x0C070005
#define GEOSYR19				 0x0C070006
#define GEOSYR19CDT				 0x0C070007
#define GEOSYR20				 0x0C070008
#define GEOSYR20CDT				 0x0C070009
#define GEOSYR22				 0x0C07000A
#define GEOSYR22CDT				 0x0C07000B
#define GEOSYR23				 0x0C07000C
#define GEOSYR23CDT				 0x0C07000D
#define GEOSYR25				 0x0C07000E
#define GEOSYR25CDT				 0x0C07000F
#define GEOSYR26				 0x0C070010
#define GEOSYR26CDT				 0x0C070011
#define GEOSYR27				 0x0C070012
#define GEOSYR27CDT				 0x0C070013
#define GEOSYR37				 0x0C070014
#define GEOSYR37CDT				 0x0C070015
#define GEOSYR39				 0x0C070016
#define GEOSYR39CDT				 0x0C070017
#define GEOSYR40				 0x0C070018
#define GEOSYR40CDT				 0x0C070019
#define GEOSYR41				 0x0C07001A
#define GEOSYR41CDT				 0x0C07001B
#define GEOSYR42				 0x0C07001C
#define GEOSYR42CDT				 0x0C07001D
#define GEOSYR99				 0x0C07001E
#define GEOSYR99CDT				 0x0C07001F
#define GUN54					 0x0C070020
#define GUN54CDT				 0x0C070021
#define KHS10					 0x0C070022
#define KHS10CDT				 0x0C070023
#define KHS12					 0x0C070024
#define KHS12CDT				 0x0C070025
#define KHS5					 0x0C070026
#define KHS5CDT					 0x0C070027
#define KHS7					 0x0C070028
#define KHS7CDT					 0x0C070029
#define KHS8					 0x0C07002A
#define KHS8CDT					 0x0C07002B
#define KHS9					 0x0C07002C
#define KHS9CDT					 0x0C07002D
#define KHSTLK54				 0x0C07002E
#define KHSTLK54CDT				 0x0C07002F
#define SECDOR					 0x0C070030
#define SECDORCDT				 0x0C070031
#define STCKTREE				 0x0C070032
#define STCKTREECDT				 0x0C070033
#define STICKIN					 0x0C070034
#define STICKINCDT				 0x0C070035
#define XGEOSY21				 0x0C070036
#define XGEOSY21CDT				 0x0C070037
	// 56 entities in TXTs, 56 in datafiles.
	// room55
#define R55SPRPAL				 0x0C080000
#define R55L0					 0x0C080001
#define R55PAL					 0x0C080002
#define R55FLR					 0x0C080003
#define R55PLX					 0x0C080004
#define BODY55					 0x0C080005
#define BODY55CDT				 0x0C080006
#define BRITMAP					 0x0C080007
#define BRITMAP_PAL				 0x0C080008
#define DOOR55					 0x0C080009
#define DOOR55CDT				 0x0C08000A
#define DOOR55CDR				 0x0C08000B
#define GEOSY30T				 0x0C08000C
#define GEOSY30TCDT				 0x0C08000D
#define GEOSY30U				 0x0C08000E
#define GEOSY30UCDT				 0x0C08000F
#define GEOSYR29				 0x0C080010
#define GEOSYR29CDT				 0x0C080011
#define GEOSYR30				 0x0C080012
#define GEOSYR30CDT				 0x0C080013
#define GEOSYR31				 0x0C080014
#define GEOSYR31CDT				 0x0C080015
#define GEOSYR33				 0x0C080016
#define GEOSYR33CDT				 0x0C080017
#define GEOSYR34				 0x0C080018
#define GEOSYR34CDT				 0x0C080019
#define GEOSYR34CDR				 0x0C08001A
#define GEOSYR35				 0x0C08001B
#define GEOSYR35CDT				 0x0C08001C
#define GEOSYR56				 0x0C08001D
#define GEOSYR56CDT				 0x0C08001E
#define KHS2					 0x0C08001F
#define KHS2CDT					 0x0C080020
#define KHS3					 0x0C080021
#define KHS3CDT					 0x0C080022
#define KHS6					 0x0C080023
#define KHS6CDT					 0x0C080024
	// 37 entities in TXTs, 37 in datafiles.
// train
	// sound_fx
#define FX_SHOCK63				 0x0D000000
#define FX_TRAINEXT				 0x0D000001
#define FX_TRAININT				 0x0D000002
#define FX_DOOR65				 0x0D000003
#define FX_WIND66				 0x0D000004
#define FX_WINDOW66				 0x0D000005
#define FX_BRAKES				 0x0D000006
#define FX_DOOR69				 0x0D000007
#define FX_EKSHOOT				 0x0D000008
#define FX_FIGHT69				 0x0D000009
#define FX_PNEUMO69				 0x0D00000A
#define FX_TICK69				 0x0D00000B
#define FX_TRNPASS				 0x0D00000C
	// 13 entities in TXTs, 13 in datafiles.
	// room63
#define TRAIN_PAL				 0x0D010000
#define R63L0					 0x0D010001
#define R63L1					 0x0D010002
#define R63G1					 0x0D010003
#define R63PAL					 0x0D010004
#define R63FLR					 0x0D010005
#define GEOTRAIN_MEGA			 0x0D010006
#define GEOTRAIN_WLK			 0x0D010007
#define BASHER63				 0x0D010008
#define BASHER63CDT				 0x0D010009
#define BOXDOR64				 0x0D01000A
#define BOXDOR64CDT				 0x0D01000B
#define BUSHA63					 0x0D01000C
#define BUSHA63CDT				 0x0D01000D
#define BUSHB63					 0x0D01000E
#define BUSHB63CDT				 0x0D01000F
#define BUSHC63					 0x0D010010
#define BUSHC63CDT				 0x0D010011
#define DOOR63C1				 0x0D010012
#define DOOR63C1CDT				 0x0D010013
#define DOOR63C1CDR				 0x0D010014
#define DOOR63C2				 0x0D010015
#define DOOR63C2CDT				 0x0D010016
#define DOOR63C2CDR				 0x0D010017
#define DOOR63C3				 0x0D010018
#define DOOR63C3CDT				 0x0D010019
#define DOOR63C3CDR				 0x0D01001A
#define GEOCLI64				 0x0D01001B
#define GEOCLI64CDT				 0x0D01001C
#define GEOJGL64				 0x0D01001D
#define GEOJGL64CDT				 0x0D01001E
#define GEOJGR64				 0x0D01001F
#define GEOJGR64CDT				 0x0D010020
#define GEOLAD64				 0x0D010021
#define GEOLAD64CDT				 0x0D010022
#define GEOSHK64				 0x0D010023
#define GEOSHK64CDT				 0x0D010024
#define GEOSTDL					 0x0D010025
#define GEOSTDLCDT				 0x0D010026
#define GEOSTDR					 0x0D010027
#define GEOSTDRCDT				 0x0D010028
#define GUIDOR63				 0x0D010029
#define GUIDOR63CDT				 0x0D01002A
#define GUIDSM63				 0x0D01002B
#define GUIDSM63CDT				 0x0D01002C
#define LADY63					 0x0D01002D
#define LADY63CDT				 0x0D01002E
#define LIGHT63A				 0x0D01002F
#define LIGHT63ACDT				 0x0D010030
#define LIGHT63B				 0x0D010031
#define LIGHT63BCDT				 0x0D010032
#define LIGHT63C				 0x0D010033
#define LIGHT63CCDT				 0x0D010034
#define LIGHT63D				 0x0D010035
#define LIGHT63DCDT				 0x0D010036
#define LIGHT63E				 0x0D010037
#define LIGHT63ECDT				 0x0D010038
#define NICO63					 0x0D010039
#define NICO63CDT				 0x0D01003A
#define POLE63					 0x0D01003B
#define POLE63CDT				 0x0D01003C
#define WHEELA63				 0x0D01003D
#define WHEELA63CDT				 0x0D01003E
#define WHEELB63				 0x0D01003F
#define WHEELB63CDT				 0x0D010040
#define WHEELC63				 0x0D010041
#define WHEELC63CDT				 0x0D010042
#define WHEELD63				 0x0D010043
#define WHEELD63CDT				 0x0D010044
#define WHEELE63				 0x0D010045
#define WHEELE63CDT				 0x0D010046
#define WHEELF63				 0x0D010047
#define WHEELF63CDT				 0x0D010048
	// 73 entities in TXTs, 73 in datafiles.
	// room65
#define R65L0					 0x0D020000
#define R65L1					 0x0D020001
#define R65G1					 0x0D020002
#define R65PAL					 0x0D020003
#define R65FLR					 0x0D020004
#define DOOR65					 0x0D020005
#define DOOR65CDT				 0x0D020006
#define DOOR65CDR				 0x0D020007
#define GEOGUA					 0x0D020008
#define GEOGUACDT				 0x0D020009
#define GEOLNK3					 0x0D02000A
#define GEOLNK3CDT				 0x0D02000B
#define GEONIC65				 0x0D02000C
#define GEONIC65CDT				 0x0D02000D
#define GEOSIT					 0x0D02000E
#define GEOSITCDT				 0x0D02000F
#define GEOSIT65				 0x0D020010
#define GEOSIT65CDT				 0x0D020011
#define GEOSTD65				 0x0D020012
#define GEOSTD65CDT				 0x0D020013
#define GEOSTD65CDR				 0x0D020014
#define GEOTIK					 0x0D020015
#define GEOTIKCDT				 0x0D020016
#define GEOTN652				 0x0D020017
#define GEOTN652CDT				 0x0D020018
#define GEOTN652CDR				 0x0D020019
#define GEOTRN65				 0x0D02001A
#define GEOTRN65CDT				 0x0D02001B
#define GEOTRN65CDR				 0x0D02001C
#define GUADOR65				 0x0D02001D
#define GUADOR65CDT				 0x0D02001E
#define GUALEA65				 0x0D02001F
#define GUALEA65CDT				 0x0D020020
#define GUATGN					 0x0D020021
#define GUATGNCDT				 0x0D020022
#define GUATGNCDR				 0x0D020023
#define GUATIK1					 0x0D020024
#define GUATIK1CDT				 0x0D020025
#define GUATIK2					 0x0D020026
#define GUATIK2CDT				 0x0D020027
#define GUATLK1					 0x0D020028
#define GUATLK1CDT				 0x0D020029
#define GUATLK2					 0x0D02002A
#define GUATLK2CDT				 0x0D02002B
#define NICGEO65				 0x0D02002C
#define NICGEO65CDT				 0x0D02002D
#define NICSIT65				 0x0D02002E
#define NICSIT65CDT				 0x0D02002F
#define NICTRN65				 0x0D020030
#define NICTRN65CDT				 0x0D020031
#define NICTRN65CDR				 0x0D020032
#define OLDREAD					 0x0D020033
#define OLDREADCDT				 0x0D020034
#define OLDREADCDR				 0x0D020035
#define OLDTIK1					 0x0D020036
#define OLDTIK1CDT				 0x0D020037
#define OLDTLK1					 0x0D020038
#define OLDTLK1CDT				 0x0D020039
	// 58 entities in TXTs, 58 in datafiles.
	// room66
#define R66L0					 0x0D030000
#define R66PAL					 0x0D030001
#define R66FLR					 0x0D030002
#define BASHBURP				 0x0D030003
#define BASHBURPCDT				 0x0D030004
#define BASHCAN					 0x0D030005
#define BASHCANCDT				 0x0D030006
#define BASHCLA					 0x0D030007
#define BASHCLACDT				 0x0D030008
#define BASHDRI					 0x0D030009
#define BASHDRICDT				 0x0D03000A
#define BASHSTD					 0x0D03000B
#define BASHSTDCDT				 0x0D03000C
#define BASHTLK1				 0x0D03000D
#define BASHTLK1CDT				 0x0D03000E
#define CAN66					 0x0D03000F
#define CAN66CDT				 0x0D030010
#define GEOLEA					 0x0D030011
#define GEOLEACDT				 0x0D030012
#define GEOOPN1					 0x0D030013
#define GEOOPN1CDT				 0x0D030014
#define GEOOUT66				 0x0D030015
#define GEOOUT66CDT				 0x0D030016
#define SLEEPY1					 0x0D030017
#define SLEEPY1CDT				 0x0D030018
#define SLEEPY1CDR				 0x0D030019
#define SLEEPY2					 0x0D03001A
#define SLEEPY2CDT				 0x0D03001B
	// 28 entities in TXTs, 28 in datafiles.
	// room67
#define R67L0					 0x0D040000
#define R67L1					 0x0D040001
#define R67G1					 0x0D040002
#define R67PAL					 0x0D040003
#define R67FLR					 0x0D040004
#define DOOR67					 0x0D040005
#define DOOR67CDT				 0x0D040006
#define DOOR67CDR				 0x0D040007
	// 8 entities in TXTs, 8 in datafiles.
	// room69
#define R69SPRPAL				 0x0D050000
#define R69L0					 0x0D050001
#define R69L1					 0x0D050002
#define R69G1					 0x0D050003
#define R69PAL					 0x0D050004
#define R69FLR					 0x0D050005
#define ASSDIE69				 0x0D050006
#define ASSDIE69CDT				 0x0D050007
#define ASSDWN69				 0x0D050008
#define ASSDWN69CDT				 0x0D050009
#define ASSLIFT					 0x0D05000A
#define ASSLIFTCDT				 0x0D05000B
#define ASSTLK69				 0x0D05000C
#define ASSTLK69CDT				 0x0D05000D
#define BOXES69					 0x0D05000E
#define BOXES69CDT				 0x0D05000F
#define EKLBOX69				 0x0D050010
#define EKLBOX69CDT				 0x0D050011
#define EKLGUN					 0x0D050012
#define EKLGUNCDT				 0x0D050013
#define EKLGUN69				 0x0D050014
#define EKLGUN69CDT				 0x0D050015
#define EKLTLK69				 0x0D050016
#define EKLTLK69CDT				 0x0D050017
#define EKLFIGHT				 0x0D050018
#define EKLFIGHTCDT				 0x0D050019
#define FIGHT69					 0x0D05001A
#define FIGHT69CDT				 0x0D05001B
#define GEODIE69				 0x0D05001C
#define GEODIE69CDT				 0x0D05001D
#define GEOENT69				 0x0D05001E
#define GEOENT69CDT				 0x0D05001F
#define GEOSTD69				 0x0D050020
#define GEOSTD69CDT				 0x0D050021
#define GEOSTP69				 0x0D050022
#define GEOSTP69CDT				 0x0D050023
#define GEOTLK69				 0x0D050024
#define GEOTLK69CDT				 0x0D050025
#define GEOUNTIE				 0x0D050026
#define GEOUNTIECDT				 0x0D050027
#define GEOXIT69				 0x0D050028
#define GEOXIT69CDT				 0x0D050029
#define NICTKB69				 0x0D05002A
#define NICTKB69CDT				 0x0D05002B
#define NICTLK69				 0x0D05002C
#define NICTLK69CDT				 0x0D05002D
#define NICTRN69				 0x0D05002E
#define NICTRN69CDT				 0x0D05002F
#define NICTRN69CDR				 0x0D050030
#define NICTUG69				 0x0D050031
#define NICTUG69CDT				 0x0D050032
#define NICWLK69				 0x0D050033
#define NICWLK69CDT				 0x0D050034
#define NICXIT69				 0x0D050035
#define NICXIT69CDT				 0x0D050036
#define RGTDOR69				 0x0D050037
#define RGTDOR69CDT				 0x0D050038
	// 57 entities in TXTs, 57 in datafiles.
// scotland
	// sound_fx
#define FX_WIND71				 0x0E000000
#define FX_GUST71				 0x0E000001
#define FX_OWL71A				 0x0E000002
#define FX_OWL71B				 0x0E000003
#define FX_COG72A				 0x0E000004
#define FX_PING					 0x0E000005
#define FX_RUMMAGE1				 0x0E000006
#define FX_RUMMAGE2				 0x0E000007
#define FX_SECDOR72				 0x0E000008
#define FX_CHANT				 0x0E000009
#define FX_DAGGER1				 0x0E00000A
#define FX_GDROP73				 0x0E00000B
#define FX_GUNPOWDR				 0x0E00000C
#define FX_STAFF				 0x0E00000D
#define FX_TORCH73				 0x0E00000E
#define FX_BAPHAMB				 0x0E00000F
#define FX_FIGHT1				 0x0E000010
#define FX_REFORGE2				 0x0E000011
#define FX_ROSSODIE				 0x0E000012
#define FX_GKSWORD				 0x0E000013
#define FX_REFORGE1				 0x0E000014
#define FX_REFORGE4				 0x0E000015
#define FX_CHOKE1				 0x0E000016
#define FX_CHOKE2				 0x0E000017
#define FX_EKDIES				 0x0E000018
#define FX_FIGHT2				 0x0E000019
#define FX_GUN79				 0x0E00001A
	// 27 entities in TXTs, 27 in datafiles.
	// room71
#define R71L0					 0x0E010000
#define R71L1					 0x0E010001
#define R71G1					 0x0E010002
#define R71PAL					 0x0E010003
#define R71FLR					 0x0E010004
#define R71PLX					 0x0E010005
	// 6 entities in TXTs, 6 in datafiles.
	// room72
#define R72L0					 0x0E020000
#define R72L1					 0x0E020001
#define R72G1					 0x0E020002
#define R72PAL					 0x0E020003
#define R72FLR					 0x0E020004
#define COGL72					 0x0E020005
#define COGL72CDT				 0x0E020006
#define COGR72					 0x0E020007
#define COGR72CDT				 0x0E020008
#define GEOJMP72				 0x0E020009
#define GEOJMP72CDT				 0x0E02000A
#define GEOPIPE					 0x0E02000B
#define GEOPIPECDT				 0x0E02000C
#define GEOPIPECDR				 0x0E02000D
#define GEOPSH72				 0x0E02000E
#define GEOPSH72CDT				 0x0E02000F
#define GEOPUT72				 0x0E020010
#define GEOPUT72CDT				 0x0E020011
#define GEOTAK72				 0x0E020012
#define GEOTAK72CDT				 0x0E020013
#define GEOTAK72CDR				 0x0E020014
#define GEOTRY72				 0x0E020015
#define GEOTRY72CDT				 0x0E020016
#define GEOWIND2				 0x0E020017
#define GEOWIND2CDT				 0x0E020018
#define GEOWIND3				 0x0E020019
#define GEOWIND3CDT				 0x0E02001A
#define GEOWIND4				 0x0E02001B
#define GEOWIND4CDT				 0x0E02001C
#define GEOWND72				 0x0E02001D
#define GEOWND72CDT				 0x0E02001E
#define HANDLE72				 0x0E02001F
#define HANDLE72CDT				 0x0E020020
#define NICGEO72				 0x0E020021
#define NICGEO72CDT				 0x0E020022
#define NICJMP72				 0x0E020023
#define NICJMP72CDT				 0x0E020024
#define NICLNK72				 0x0E020025
#define NICLNK72CDT				 0x0E020026
#define NICLNK72CDR				 0x0E020027
#define NICOPY72				 0x0E020028
#define NICOPY72CDT				 0x0E020029
#define NICOPY72CDR				 0x0E02002A
#define NICTLK72				 0x0E02002B
#define NICTLK72CDT				 0x0E02002C
#define NOSE72					 0x0E02002D
#define NOSE72CDT				 0x0E02002E
#define PANEL72					 0x0E02002F
#define PANEL72CDT				 0x0E020030
#define PIPE72					 0x0E020031
#define PIPE72CDT				 0x0E020032
#define SPINDL72				 0x0E020033
#define SPINDL72CDT				 0x0E020034
#define WHEEL72					 0x0E020035
#define WHEEL72CDT				 0x0E020036
	// 55 entities in TXTs, 55 in datafiles.
	// room73
#define R73SPRPAL				 0x0E030000
#define R73L0					 0x0E030001
#define R73L1					 0x0E030002
#define R73L2					 0x0E030003
#define R73G1					 0x0E030004
#define R73G2					 0x0E030005
#define R73PAL					 0x0E030006
#define R73FLR					 0x0E030007
#define DAGGER1					 0x0E030008
#define DAGGER1CDT				 0x0E030009
#define DAGGER2					 0x0E03000A
#define DAGGER2CDT				 0x0E03000B
#define DARKWALL				 0x0E03000C
#define DARKWALLCDT				 0x0E03000D
#define FLAME73					 0x0E03000E
#define FLAME73CDT				 0x0E03000F
#define GEOCRCH					 0x0E030010
#define GEOCRCHCDT				 0x0E030011
#define GEOCREEP				 0x0E030012
#define GEOCREEPCDT				 0x0E030013
#define GEODIE1					 0x0E030014
#define GEODIE1CDT				 0x0E030015
#define GEODIE2					 0x0E030016
#define GEODIE2CDT				 0x0E030017
#define GEOTHROW				 0x0E030018
#define GEOTHROWCDT				 0x0E030019
#define GEOTLK73				 0x0E03001A
#define GEOTLK73CDT				 0x0E03001B
#define GEOTN73					 0x0E03001C
#define GEOTN73CDT				 0x0E03001D
#define GEOTN73CDR				 0x0E03001E
#define GMENTER					 0x0E03001F
#define GMENTERCDT				 0x0E030020
#define GMSPEAK					 0x0E030021
#define GMSPEAKCDT				 0x0E030022
#define GUIDLE					 0x0E030023
#define GUIDLECDT				 0x0E030024
#define GUITALK					 0x0E030025
#define GUITALKCDT				 0x0E030026
#define GUITHROW				 0x0E030027
#define GUITHROWCDT				 0x0E030028
#define GUITURN7				 0x0E030029
#define GUITURN7CDT				 0x0E03002A
#define GUITURN7CDR				 0x0E03002B
#define NICENT73				 0x0E03002C
#define NICENT73CDT				 0x0E03002D
#define NICEX73					 0x0E03002E
#define NICEX73CDT				 0x0E03002F
#define NICOTHRO				 0x0E030030
#define NICOTHROCDT				 0x0E030031
#define NICPANIC				 0x0E030032
#define NICPANICCDT				 0x0E030033
#define NICTLK73				 0x0E030034
#define NICTLK73CDT				 0x0E030035
#define NICTRN73				 0x0E030036
#define NICTRN73CDT				 0x0E030037
#define NICTRN73CDR				 0x0E030038
#define NITALK73				 0x0E030039
#define NITALK73CDT				 0x0E03003A
#define SPARKING				 0x0E03003B
#define SPARKINGCDT				 0x0E03003C
#define TORCH1					 0x0E03003D
#define TORCH1CDT				 0x0E03003E
#define TORCH2					 0x0E03003F
#define TORCH2CDT				 0x0E030040
#define TORCH3					 0x0E030041
#define TORCH3CDT				 0x0E030042
	// 67 entities in TXTs, 67 in datafiles.
	// room74
#define ENDSPRPAL				 0x0E040000
#define R74L0					 0x0E040001
#define R74L1					 0x0E040002
#define R74G1					 0x0E040003
#define R74PAL					 0x0E040004
#define R74APAL					 0x0E040005
#define R74BPAL					 0x0E040006
#define R74CPAL					 0x0E040007
#define R74DPAL					 0x0E040008
#define CHANT74					 0x0E040009
#define CHANT74CDT				 0x0E04000A
#define EKFIGHT					 0x0E04000B
#define EKFIGHTCDT				 0x0E04000C
#define EKGUN74					 0x0E04000D
#define EKGUN74CDT				 0x0E04000E
#define GEOFIGHT				 0x0E04000F
#define GEOFIGHTCDT				 0x0E040010
#define GEOLUK74				 0x0E040011
#define GEOLUK74CDT				 0x0E040012
#define GEOLUK74CDR				 0x0E040013
#define GEORCT74				 0x0E040014
#define GEORCT74CDT				 0x0E040015
#define GEORUN74				 0x0E040016
#define GEORUN74CDT				 0x0E040017
#define GEOSTND					 0x0E040018
#define GEOSTNDCDT				 0x0E040019
#define GEOTLK74				 0x0E04001A
#define GEOTLK74CDT				 0x0E04001B
#define GKKNEE					 0x0E04001C
#define GKKNEECDT				 0x0E04001D
#define GMGUN					 0x0E04001E
#define GMGUNCDT				 0x0E04001F
#define GMMOV1					 0x0E040020
#define GMMOV1CDT				 0x0E040021
#define GMMOV2					 0x0E040022
#define GMMOV2CDT				 0x0E040023
#define GMMOV3					 0x0E040024
#define GMMOV3CDT				 0x0E040025
#define GMMOV4					 0x0E040026
#define GMMOV4CDT				 0x0E040027
#define GMMOV5					 0x0E040028
#define GMMOV5CDT				 0x0E040029
#define GMMOV6					 0x0E04002A
#define GMMOV6CDT				 0x0E04002B
#define GMTLK1					 0x0E04002C
#define GMTLK1CDT				 0x0E04002D
#define GMTLK2					 0x0E04002E
#define GMTLK2CDT				 0x0E04002F
#define GMTLK3					 0x0E040030
#define GMTLK3CDT				 0x0E040031
#define GMTLK4					 0x0E040032
#define GMTLK4CDT				 0x0E040033
#define GMTLK5					 0x0E040034
#define GMTLK5CDT				 0x0E040035
#define GMTLK6					 0x0E040036
#define GMTLK6CDT				 0x0E040037
#define GMTLK7					 0x0E040038
#define GMTLK7CDT				 0x0E040039
#define GMTLK74					 0x0E04003A
#define GMTLK74CDT				 0x0E04003B
#define GMWLK					 0x0E04003C
#define GMWLKCDT				 0x0E04003D
#define GMWRIT74				 0x0E04003E
#define GMWRIT74CDT				 0x0E04003F
#define MONKFALL				 0x0E040040
#define MONKFALLCDT				 0x0E040041
#define MONKRISE				 0x0E040042
#define MONKRISECDT				 0x0E040043
#define MONKSTRS				 0x0E040044
#define MONKSTRSCDT				 0x0E040045
#define MONKTURN				 0x0E040046
#define MONKTURNCDT				 0x0E040047
#define NICFIGHT				 0x0E040048
#define NICFIGHTCDT				 0x0E040049
#define NICLUK74				 0x0E04004A
#define NICLUK74CDT				 0x0E04004B
#define NICLUK74CDR				 0x0E04004C
#define NICRCVR					 0x0E04004D
#define NICRCVRCDT				 0x0E04004E
#define NICRUN74				 0x0E04004F
#define NICRUN74CDT				 0x0E040050
#define NICSTND					 0x0E040051
#define NICSTNDCDT				 0x0E040052
#define NICTLK74				 0x0E040053
#define NICTLK74CDT				 0x0E040054
#define ROSSFALL				 0x0E040055
#define ROSSFALLCDT				 0x0E040056
#define ROSSTAIR				 0x0E040057
#define ROSSTAIRCDT				 0x0E040058
#define ROSSTND					 0x0E040059
#define ROSSTNDCDT				 0x0E04005A
#define ROSSWLK					 0x0E04005B
#define ROSSWLKCDT				 0x0E04005C
#define RUBBLE					 0x0E04005D
#define RUBBLECDT				 0x0E04005E
#define STONLIT1				 0x0E04005F
#define STONLIT1CDT				 0x0E040060
#define STONLIT2				 0x0E040061
#define STONLIT2CDT				 0x0E040062
#define STONWHT1				 0x0E040063
#define STONWHT1CDT				 0x0E040064
#define STONWHT2				 0x0E040065
#define STONWHT2CDT				 0x0E040066
	// 103 entities in TXTs, 103 in datafiles.
	// room75
#define R75L0					 0x0E050000
#define R75PAL					 0x0E050001
#define R75APAL					 0x0E050002
#define R75BPAL					 0x0E050003
#define R75CPAL					 0x0E050004
#define R75DPAL					 0x0E050005
#define EKGUN					 0x0E050006
#define EKGUNCDT				 0x0E050007
#define EKGUN2					 0x0E050008
#define EKGUN2CDT				 0x0E050009
#define EKLITE					 0x0E05000A
#define EKLITECDT				 0x0E05000B
#define EKRELAX					 0x0E05000C
#define EKRELAXCDT				 0x0E05000D
#define EKTLK75					 0x0E05000E
#define EKTLK75CDT				 0x0E05000F
#define GEOLUK75				 0x0E050010
#define GEOLUK75CDT				 0x0E050011
#define GEOLUK75CDR				 0x0E050012
#define GTMP					 0x0E050013
#define GTMPCDT					 0x0E050014
#define NICLUK75				 0x0E050015
#define NICLUK75CDT				 0x0E050016
#define NICLUK75CDR				 0x0E050017
#define NTMP					 0x0E050018
#define NTMPCDT					 0x0E050019
#define TORCH75					 0x0E05001A
#define TORCH75CDT				 0x0E05001B
	// 28 entities in TXTs, 28 in datafiles.
	// room76
#define R76L0					 0x0E060000
#define R76PAL					 0x0E060001
#define CHANT76					 0x0E060002
#define CHANT76CDT				 0x0E060003
#define EKGUN76					 0x0E060004
#define EKGUN76CDT				 0x0E060005
#define GKBAK					 0x0E060006
#define GKBAKCDT				 0x0E060007
#define GKKNEE76				 0x0E060008
#define GKKNEE76CDT				 0x0E060009
#define GKLOWER					 0x0E06000A
#define GKLOWERCDT				 0x0E06000B
#define GKSWORD					 0x0E06000C
#define GKSWORDCDT				 0x0E06000D
#define GKTLK					 0x0E06000E
#define GKTLKCDT				 0x0E06000F
#define GKTLK2					 0x0E060010
#define GKTLK2CDT				 0x0E060011
#define GMARMS					 0x0E060012
#define GMARMSCDT				 0x0E060013
#define GMSTONES				 0x0E060014
#define GMSTONESCDT				 0x0E060015
#define GMTLK76					 0x0E060016
#define GMTLK76CDT				 0x0E060017
#define GMTRN76					 0x0E060018
#define GMTRN76CDT				 0x0E060019
#define LSTONE76				 0x0E06001A
#define LSTONE76CDT				 0x0E06001B
#define MONKNEE					 0x0E06001C
#define MONKNEECDT				 0x0E06001D
#define ROSSTND76				 0x0E06001E
#define ROSSTND76CDT			 0x0E06001F
#define RSTONE76				 0x0E060020
#define RSTONE76CDT				 0x0E060021
	// 34 entities in TXTs, 34 in datafiles.
	// room77
#define R77L0					 0x0E070000
#define R77PAL					 0x0E070001
#define CHANT77					 0x0E070002
#define CHANT77CDT				 0x0E070003
#define GEOPEER					 0x0E070004
#define GEOPEERCDT				 0x0E070005
#define GMHEAD					 0x0E070006
#define GMHEADCDT				 0x0E070007
#define NICPEER					 0x0E070008
#define NICPEERCDT				 0x0E070009
#define NICTLK77				 0x0E07000A
#define NICTLK77CDT				 0x0E07000B
#define ROSLUK77				 0x0E07000C
#define ROSLUK77CDT				 0x0E07000D
	// 14 entities in TXTs, 14 in datafiles.
	// room78
#define R78L0					 0x0E080000
#define R78PAL					 0x0E080001
#define R78APAL					 0x0E080002
#define R78BPAL					 0x0E080003
#define R78CPAL					 0x0E080004
#define R78DPAL					 0x0E080005
#define R78EPAL					 0x0E080006
#define R78FPAL					 0x0E080007
#define LSTONE78				 0x0E080008
#define LSTONE78CDT				 0x0E080009
#define LSTONE78CDR				 0x0E08000A
#define GMPOWER					 0x0E08000B
#define GMPOWERCDT				 0x0E08000C
#define GMWRITH					 0x0E08000D
#define GMWRITHCDT				 0x0E08000E
#define RSTONE78				 0x0E08000F
#define RSTONE78CDT				 0x0E080010
#define RSTONE78CDR				 0x0E080011
	// 18 entities in TXTs, 18 in datafiles.
	// room79
#define R79L0					 0x0E090000
#define R79PAL					 0x0E090001
#define EKSTD79					 0x0E090002
#define EKSTD79CDT				 0x0E090003
#define FIGHT79					 0x0E090004
#define FIGHT79CDT				 0x0E090005
#define GEOANG79				 0x0E090006
#define GEOANG79CDT				 0x0E090007
#define GEOTLK79				 0x0E090008
#define GEOTLK79CDT				 0x0E090009
#define NICSTD79				 0x0E09000A
#define NICSTD79CDT				 0x0E09000B
#define ROSENT79				 0x0E09000C
#define ROSENT79CDT				 0x0E09000D
#define ROSSHOT					 0x0E09000E
#define ROSSHOTCDT				 0x0E09000F
#define ROSTLK79				 0x0E090010
#define ROSTLK79CDT				 0x0E090011
	// 18 entities in TXTs, 18 in datafiles.

} // End of namespace Sword1

#endif //SWORDRES_H
