#ifndef PLAYERJUDGE_H
#define PLAYERJUDGE_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Player.h"

#include <list>

class JudgePlayer : public Player
{
private:
  std::vector<Card> myCards;
  std::vector<Card> yourCards;

private:
  int GetRating(const SolutionSet& solution) const;
  int GetRatingForSolution(const SolutionSet& solution,
                           const std::vector<Card>& table,
                           const std::vector<std::vector<size_t> >& combinations,
                           const std::map<size_t,std::vector<size_t> >& points,
                           const std::vector<Card>& hand,
                           const std::vector<Card>& myCards,
                           const std::vector<Card>& yourCards,
                           size_t recursion,
                           size_t maxRecursion,
                           bool isme) const;

public:
  JudgePlayer();

  void Initialize();


  SolutionSet PlayCard(const Table& table, size_t round);

  void CardsPlayed(std::vector<Card>& cards, bool ownCards, size_t round);

  void PrintStatistics();
};


#endif

