#ifndef CHOOSEMOVEDIALOG_H
#define CHOOSEMOVEDIALOG_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <vector>

#include <Lum/Images/Image.h>

#include <Lum/Model/Selection.h>

#include <Lum/Dialog.h>

#include "Card.h"

class ChooseMoveDialog : public Lum::Dialog
{
private:
  Card                               card;
  std::vector <std::vector<Card> >   moves;
  std::vector<Lum::Images::ImageRef> images;

  Lum::Model::SingleLineSelectionRef selection;

public:
  ChooseMoveDialog(const Card& card,
                   const std::vector <std::vector<Card> >& moves,
                   const std::vector<Lum::Images::ImageRef>& images);
  ~ChooseMoveDialog();

  void PreInit();
  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);

  size_t GetMove() const;
};

extern size_t GetMove(Lum::Dialog *parent,
                      const Card& card,
                      const std::vector <std::vector<Card> >& moves,
                      const std::vector<Lum::Images::ImageRef>& images);

#endif

