#!/usr/bin/python
# -*- coding: utf-8 -*-
# Sayhoo: an audio navigation help for velib' like projects.
# Copyright 2008 Pierre Amadio
# pierre.amadio@libertysurf.fr
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import threading
import os
import time

from sayhooGlobals import _
import sayhooGlobals as G

class sayhooTts(threading.Thread):
    def __init__(self,qq_to_tts,qq_from_tts):
        self.qq_from_controller=qq_to_tts
        self.qq_to_controller=qq_from_tts
        self.busy=False
        threading.Thread.__init__(self,name="tts thread")
        self.running=True
        self.start()

    def pull_request(self):
        out=[]
        while self.qq_from_controller.qsize():
            try:
                curEvent=self.qq_from_controller.get(0)
                #print "sayhooRouter curEvent=",curEvent
            except:
                raise
            out.append(curEvent)

        return out

    def tts(self,args):
        """
        /home/user/espeak-binary/speak -v de --stdout "Wie mussen in die doner zu gehen" |gst-launch -v fdsrc ! wavparse ! audioconvert!autoaudiosink

        """
        lock=threading.Lock()

        lock.acquire()
        self.busy=True
        lock.release()

        lang=args['lang']
        txt=args['snt']
        if G.is_maemo():
            snt='/usr/bin/espeak -v %s --stdout "%s" |gst-launch -v fdsrc ! wavparse ! audioconvert!autoaudiosink >/dev/null 2>&1'%(lang,txt)
        else:
            snt='/usr/bin/espeak -v %s "%s" >/dev/null 2>&1'%(lang,txt) 
        try:
            print "tts (%s) '%s'"%(lang,txt.encode('utf8'))

            os.system(snt)
            #time.sleep(0.1)
        except:
            print "cannot say '%s'"%txt
            raise

        lock.acquire()
        self.busy=False
        lock.release()

        return
    
    def handle_route_info(self,route_info):
        print route_info
        if route_info['on_the_route_flag']:
            snt=_("You are on ")
        else:
            snt=_("You should be on ")
        self.tts({"lang":G.user_lang["application"],"snt":snt})
        self.tts({"lang":G.user_lang["map"],"snt":route_info["current_road"]})

        if not route_info["last_road_flag"]:

            if route_info['turn_type']=="left":
                local_turn=_("left")
            else:
                local_turn=_("right")


            snt=_("In %s meters, turn %s at %s o clock.")%(route_info["distance_to_change"],\
                                                               local_turn,\
                                                               route_info['clock_angle'])
            self.tts({"lang":G.user_lang["application"],"snt":snt})
            snt=_("You will be in")
            self.tts({"lang":G.user_lang["application"],"snt":snt})
            self.tts({"lang":G.user_lang["map"],"snt":route_info["next_road"]})
            snt=_("for %s meters")%route_info["lenght_next_segment"]
            self.tts({"lang":G.user_lang["application"],"snt":snt})
        else:
            snt=_("Destination in reach at %s meters")%route_info["distance_to_change"]
            self.tts({"lang":G.user_lang["application"],"snt":snt})

    def run(self):
        import time
        while self.running:
            for req in self.pull_request():

                if isinstance(req,G.StopEvent):
                    self.running=False
                    args={"lang":"es","snt":"Hasta la vista"}
                    self.tts(args)
                    print "tts bye bye"

                if isinstance(req,G.StartEvent):
                    args={"lang":G.user_lang['application'],"snt":_("Starting")}
                    self.tts(args)

                if isinstance(req,G.TtsEvent):
                    if req.args['type']=="tts":
                        self.tts(req.args)
                    if req.args['type']=="route_info":
                        #print "in tts what can we do with",req.args['info']
                        self.handle_route_info(req.args['info'])

                if isinstance(req,G.MapAnswer):
                    if req.args["type"]=="route-found":
                        if len(req.answer):
                            self.tts({"lang":G.user_lang['application'],"snt":_("Route is found")})
                        else:
                            self.tts({"lang":G.user_lang['application'],"snt":_("No Route found")})
                            
                #if isinstance(req,G.MapRequest):
                #    if req.args["type"]=="city_data_dir_ready":
                #        self.tts({"lang":G.user_lang,"snt":_("City is loaded.")})
                
            time.sleep(1)


                    
