#!/usr/bin/python2.5
# -*- coding: utf-8 -*-
# Sayhoo: an audio navigation help for velib' like projects.
# Copyright 2008 Pierre Amadio
# pierre.amadio@libertysurf.fr
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import gtk
import gtk.glade
import gettext
gettext.textdomain('sayhoo')
from sayhooGlobals import _
import sayhooGlobals as G
import sayhooMap
import tilenames as tn
import os
if G.is_maemo():
    import hildon
    superClass=hildon.Program
else:
    class FakeClass:
        def __init__(self):
            return 

    superClass=FakeClass


import pango
import gobject
import re
import math


"""
import locale
locale.setlocale(locale.LC_ALL,G.supported_lang[G.user_lang["application"]][1])
os.environ["LANGUAGE"]=G.supported_lang[G.user_lang["application"]][1]
"""

class SayhooGui(superClass):
    
    def __init__(self,qq_to_gui,qq_from_gui):
        self.fullScreen=False
        self.qq_from_controller=qq_to_gui
        self.qq_to_controller=qq_from_gui
        
        if G.is_maemo():
            self.program=hildon.Program()
            self.program.__init__()
            self.hildon_window = hildon.Window()
        else:
            self.hildon_window=gtk.Window()

        gladefile=G.glade_file_location


        self.hildon_window.connect("destroy",self.end_application)

        self.timeoutHandler=gobject.timeout_add(1000,self.monitor_controller_qq)
        self.hildon_window.connect("key-press-event",self.on_key_press)

        self.velib_stations=[]
        self.route=[]
        self.start_node=False
        self.destination_node=False
        #self.start_node_query=False
        #self.destination_node_query=False

        self.last_position=False
        self.gps_signal=False
        self.rent_a_bike=False
        self.timer_clock=G.SimpleTimer()
        self.timeoutHandler=gobject.timeout_add(1000,self.clock_tick)        
        
        """
        ####################################################################
                                   Main Window
        ####################################################################
        """
        self.main_xml=gtk.glade.XML(gladefile,"mainWindow","sayhoo")
        self.vbox1=self.main_xml.get_widget("vbox1")
        self.vbox1.reparent(self.hildon_window)
        self.seconds_timer_label=self.main_xml.get_widget("timerLabel")
        self.seconds_timer_label.modify_font(pango.FontDescription("sans 24"))
        self.seconds_timer_label.set_text("0:00")
        self.main_start_stop_button=self.main_xml.get_widget("mainStartStopB")
        self.main_start_stop_button_label=self.main_start_stop_button.\
                                           child
        self.main_start_stop_button_label.set_text(_("Start"))
        self.main_reset_timer_button=self.main_xml.get_widget(\
            "mainResetTimerB")
        self.main_reset_timer_label=self.main_reset_timer_button.child
        self.main_reset_timer_label.set_text(_("Reset timer"))

        self.clear_route_button=self.main_xml.get_widget("clearRouteB")
        self.clear_route_button_label=self.clear_route_button.child
        self.clear_route_button_label.set_text(_('Clear route'))

        self.main_map_status_icon=self.main_xml.get_widget("mapStatus_i")
        self.go_icon="/usr/share/sayhoo/data/start.png"
        self.wait_icon="/usr/share/sayhoo/data/stop.png"
        self.waiting_for_map=True
        self.wait_for_map(True)
        

        self.main_xml.get_widget("mainWindow").destroy()
        main_dic = { 
            "on_mainStartStopB_clicked":self.start_b_clicked,
            "on_mainResetTimerB_clicked":self.reset_timer_b_clicked,
            "on_clearRouteB_clicked":self.clear_route_button_clicked,
            "on_mapview_expose_event":self.mapview_expose_event,
            "on_mapview_size_allocate":self.mapview_size_allocate,
            "on_mapview_button_press_event":self.mapview_button_press_event,
            "on_mapview_button_release_event":self.mapview_button_release_event
               
                     }
        self.main_xml.signal_autoconnect(main_dic)

        self.mapview=self.main_xml.get_widget("mapview")        
        self.mapview.set_events(gtk.gdk.BUTTON_PRESS_MASK
                                |gtk.gdk.BUTTON_RELEASE_MASK    
                                )
        self.mapview_width=0
        self.mapview_height=0
        self.mapview_zoom=15
        self.mapview_center_lat=G.start_view_lat
        self.mapview_center_lon=G.start_view_lon
        self.mapview_button_pressed=False
        self.mapview_mouse={"x":0,"y":0}
        

        """
        https://garage.maemo.org/plugins/wiki/index.php?TapAndHold&id=40&type=g
        https://garage.maemo.org/svn/pymaemo/packages/pygtk/trunk/examples/tap/tap_example.py
        """
        self.mapview_m_xml=gtk.glade.XML(gladefile,"mapview_m","sayhoo")
        self.mapview_m=self.mapview_m_xml.get_widget('mapview_m')
        if G.is_maemo():
            self.mapview.tap_and_hold_setup(menu=self.mapview_m, callback=self.mapview_tap_and_hold)
        else:
            self.hildon_window.resize(600,480)


        self.mapview_m_dic={"on_mapview_m_set_destination_activate":self.mapview_m_set_destination_activate,
                            "on_mapview_m_set_location_activate":self.mapview_m_set_location_activate,
                            "on_mapview_m_set_start_point_activate":self.mapview_m_set_start_point_activate
                            }
        self.mapview_m_xml.signal_autoconnect(self.mapview_m_dic)        

        self.hildon_window.show_all()

        self.mapview_context=self.mapview.window.cairo_create()
        self.route_styles={
            "default":{"w":2,"color":(.8,.8,.8,.5)},
            "train":{"w":1,"color":(.4,.7,.7,.1)},
            "subway":{"w":1,"color":(.4,.7,.7,.1)},
            "footway":{"w":1,"color":(.0,.9,.0,.3)},
            "water":{"w":1,"color":(.0,.0,.9,.2)},
            "route":{"color":(1,0,0,.5)}
            }

        
        self.main_menu_xml=gtk.glade.XML(gladefile,"mainmenu_m","sayhoo")
        self.main_menu=self.main_menu_xml.get_widget("mainmenu_m")

        self.main_menu_dic={"on_preferences_m_activate":self.preferences_m_activate,
                            "on_about_m_activate":self.about_m_activate
                            }
        self.main_menu_xml.signal_autoconnect(self.main_menu_dic)        

        if G.is_maemo():
            self.hildon_window.set_menu(self.main_menu)
        else:
            for child in self.main_menu.get_children():
                child.reparent(self.mapview_m)

        """
        ####################################################################
                                   Preferences Window
        ####################################################################
        """
        self.pref_window_xml=gtk.glade.XML(gladefile,"prefWindow","sayhoo")
        self.pref_window=self.pref_window_xml.get_widget("prefWindow")
        self.pref_data_location_q_label=self.pref_window_xml.get_widget("pref_nb_files_label_q")
        self.pref_data_location_a_label=self.pref_window_xml.get_widget("pref_nb_files_label_a")

        if G.gconf_default.get_string(G.gconf_root+"/city_data_dir"):
                        self.pref_data_location_a_label.set_label(G.gconf_default.get_string(G.gconf_root+"/city_data_dir"))



        
        self.pref_dic={
            "on_pref_ok_b_clicked":self.pref_ok_b_clicked,
            "on_pref_cancel_b_clicked":self.pref_cancel_b_clicked,
            "on_pref_nb_change_data_location_b_clicked":self.pref_nb_change_data_location_b_clicked
            }
        self.pref_window_xml.signal_autoconnect(self.pref_dic)

        self.pref_lang_sorted=[]
        for lang_id in G.supported_lang.keys():
            self.pref_lang_sorted.append(lang_id)
        self.pref_lang_sorted.sort()
        
        self.pref_lang_map_combo=self.pref_window_xml.get_widget("pref_lang_map_combo")
        self.pref_lang_app_combo=self.pref_window_xml.get_widget("pref_lang_app_combo")
        

        self.pref_lang_app_combo_model=gtk.ListStore(str)
        self.pref_lang_app_combo.set_model(self.pref_lang_app_combo_model)        
        self.pref_lang_app_combo_cell=gtk.CellRendererText()
        self.pref_lang_app_combo.pack_start(self.pref_lang_app_combo_cell, True)
        self.pref_lang_app_combo.add_attribute(self.pref_lang_app_combo_cell,'text',0)
        self.pref_lang_map_combo_model=gtk.ListStore(str)
        self.pref_lang_map_combo.set_model(self.pref_lang_map_combo_model)        
        self.pref_lang_map_combo_cell=gtk.CellRendererText()
        self.pref_lang_map_combo.pack_start(self.pref_lang_map_combo_cell, True)
        self.pref_lang_map_combo.add_attribute(self.pref_lang_map_combo_cell,'text',0)

        for lang_id in self.pref_lang_sorted:
            lang_label=G.supported_lang[lang_id][0]
            lang_index=self.pref_lang_sorted.index(lang_id)
            self.pref_lang_map_combo_model.append([lang_label])
            self.pref_lang_app_combo_model.append([lang_label])

        self.pref_lang_map_combo.set_active(self.pref_lang_sorted.index(G.user_lang['map']))
        self.pref_lang_app_combo.set_active(self.pref_lang_sorted.index(G.user_lang['application']))
        


        self.pref_window.set_title(_("Preferences"))
        self.pref_window.set_modal(True)
        self.pref_window.set_transient_for(self.hildon_window)
        self.pref_selection={}
        self.pref_window.hide()

        """
        ####################################################################
                                   About Window
        ####################################################################
        """
        
        self.about_window_xml=gtk.glade.XML(gladefile,"aboutWindow","sayhoo")
        self.about_window=self.about_window_xml.get_widget("aboutWindow")
        self.about_window.hide()
        return


    def start_application(self):
        if G.db_location:
            request=G.GuiRequest(args={"type":"list_velib_stations"})
            self.qq_to_controller.put(request)

    def end_application(self,widget=False):
        gtk.main_quit()

    def treatAnswer(self,event):
        args=event.args
        answer=event.answer
        if args['type']=='list_velib_stations':
            self.velib_stations=answer
    
    def clock_tick(self):
        if not self.rent_a_bike:
            return True
        self.seconds_timer_label.set_text(self.timer_clock.time_spent())

        min_spent=self.timer_clock.minutes_spent()
        sec_spent=self.timer_clock.seconds_spent()
        if min_spent%5==0 and min_spent*60==sec_spent:
            snt=_("%s minutes spent since last relay"%min_spent)
            event=G.TtsEvent(args={"type":"tts","lang":G.user_lang['application'],"snt":snt})
            self.qq_to_controller.put(event)
        return True


    def show_dialog(self,title="",message="",buttons=[ (_("Ok"),True)]):
        dial_xml=gtk.glade.XML(G.glade_file_location,"mainDialog","sayhoo")
        dial_w=dial_xml.get_widget("mainDialog")
        dial_w_label=dial_xml.get_widget("mainDialog_label")
        dial_w.set_title(title)
        dial_w_label.set_text(message)
        for (b,a) in buttons:
            dial_w.add_buttons(b,a)
        answer=dial_w.run()
        dial_w.destroy()
        return answer

    def start_b_clicked(self,widget):
        #answer=self.show_dialog(title="Blab bla",message="Coin coin",buttons=[( _("OK"),True ) , ( _("Nope"),False)] )
        #print "answer=",answer
        #G.system_info("la reponse est %s"%answer)
        if not self.rent_a_bike:
            self.timer_clock.reset()
            self.rent_a_bike=True
            self.main_start_stop_button_label.set_text(_("Stop"))
        else:
            self.rent_a_bike=False
            self.main_start_stop_button_label.set_text(_("Start"))
        return

    def reset_timer_b_clicked(self,widget):
        self.timer_clock.reset()
        return

    def clear_route_button_clicked(self,widget):
        print "clear route"

        a=self.show_dialog(title="Clearing route",\
                           message=_("Are you sure you want to clear\nthe current route ?"),\
                           buttons=[( _("Yes"),True ) , ( _("No"),False)])
        if not a:
            return
        
        self.route=[]
        self.start_node=False
        self.destination_node=False
        #self.start_node_query=False
        #self.destination_node_query=False
        request=G.GuiRequest(args={"type":"clear_route"})
        self.qq_to_controller.put(request)

    def mapview_expose_event(self,darea,event):
        w=event.area.width
        h=event.area.height
        self.display_tiles(event.area)
        return
    
    def mapview_size_allocate(self,widget,allocation):
        self.mapview_width=allocation.width
        self.mapview_height=allocation.height

    def mark_dot(self,x,y,r,g,b,a=0,type="square",size=6):
        self.mapview_context.set_source_rgba(r,g,b,a)
        if type=="circle":
            self.mapview_context.arc(x,y,size, 0,2*math.pi)
        else:
            self.mapview_context.rectangle(x-size/2,y-size/2,size,size)
        self.mapview_context.fill()


    def latlon2xy_in_tile(self,lat,lon):
        z=self.mapview_zoom
        center_lat=self.mapview_center_lat
        center_lon=self.mapview_center_lon
        #tx,ty are x,y (int) value for the top left corner of the tile containg
        #the point lat,lon
        (tx,ty)=tn.tileXY(center_lat,center_lon,z)
        #cx,cy are x,y, (float) value for the same point within the tile.
        (cx,cy)=tn.latlon2xy(center_lat,center_lon,z)
        x=255*(cx-tx)
        y=255*(cy-ty)
        return (x,y) 


    def globalxy2mapviewxy(self,gx,gy):
        "print not sure about globalxy2mapviewxy"
        (cgx,cgy)=tn.latlon2xy(self.mapview_center_lat,self.mapview_center_lon,self.mapview_zoom)
        diff_x=256*(cgx-gx)
        diff_y=256*(cgy-gy)
        return (self.mapview_width/2-diff_x,self.mapview_height/2-diff_y)

    def mapviewxy2globalsxy(self,mx,my):
        (center_g_x,center_g_y)=tn.latlon2xy(self.mapview_center_lat, self.mapview_center_lon, self.mapview_zoom)        
        g_mouse_x_to_mv_c_x=(self.mapview_width/2.0-mx)/256.0
        g_mouse_y_to_mv_c_y=(self.mapview_height/2.0-my)/256.0
        gx=center_g_x-g_mouse_x_to_mv_c_x
        gy=center_g_y-g_mouse_y_to_mv_c_y
        return (gx,gy)
        
    def mapview2latlon(self,mx,my):
        (gx,gy)=self.mapviewxy2globalsxy(mx,my)
        (lat,lon)=tn.xy2latlon(gx,gy,self.mapview_zoom)
        return (lat,lon)

    def display_tiles(self,rectangle=False):
        """
        http://wiki.openstreetmap.org/index.php/Slippy_map_tilenames
        """
        #print self.last_position
        if not G.tiles_location:
            return
        self.mapview_context=self.mapview.window.cairo_create()

        if not rectangle:
            self.mapview_context.rectangle(0,0,self.mapview_width,self.mapview_height)
        else:
            self.mapview_context.rectangle(rectangle.x,rectangle.y,rectangle.width,rectangle.height)

        self.mapview_context.clip()


        #self.mapview_context.rectangle(0,0,self.mapview_width,self.mapview_height)
        #self.mapview_context.clip()

        self.mapview_context.set_source_rgb(0,0,0)
        self.mapview_context.rectangle(0,0,self.mapview_width,self.mapview_height)
        self.mapview_context.fill()
        #self.mapview_context.stroke()
        

        #heading=self.last_position["track"]


        
        """

                           offset tile                        
                             oft_x
                          -----------  
                         ._________________________________________
                         |0,0                                     |  |
                         |                                        |  |
                         |                                        |  |  oft_y
                         |                                        |  |
                         |            (ox,oy)                     |  |
                         |           .---------                   | 
                         |           |         |              | lyo 
                         |           |       . | (wc_x,wc_y)  |   |
                         |           |         |                  |
                         |           |         |                  |
                         |            ---------                   |
                         |             lxo                        |
                         |            -------                     |
                         |       local x offset                   |
                         |                                        |
                         |                                        |
                          ________________________________________

                         --------------------
                                  wcx
        

        


          ox+lxo=wc_x
          ox=wc_x-lxo
          
          


        """
        (center_tile_x,center_tile_y)=tn.tileXY(self.mapview_center_lat, self.mapview_center_lon, self.mapview_zoom)        
        wc_x=self.mapview_width/2
        wc_y=self.mapview_height/2

        (lxo,lyo)=self.latlon2xy_in_tile(self.mapview_center_lat,self.mapview_center_lon)
        ox=wc_x-lxo
        oy=wc_y-lyo

        (center_tile_slippy_x,center_tile_slippy_y)=tn.tileXY(self.mapview_center_lat,self.mapview_center_lon,self.mapview_zoom)

        start_tile_wx=int(ox)
        cnt_tile_x=0
        while start_tile_wx>0:
            start_tile_wx-=256
            cnt_tile_x+=1


        start_tile_wy=int(oy)
        cnt_tile_y=0
        while start_tile_wy>0:
            start_tile_wy-=256
            cnt_tile_y+=1
        start_cnt_tile_y=cnt_tile_y
        
        cur_tile_wx=start_tile_wx

        while cur_tile_wx<self.mapview_width:
            cur_slippy_x=center_tile_slippy_x-cnt_tile_x
            cnt_tile_y=start_cnt_tile_y
            cur_tile_wy=start_tile_wy
            
            
            while cur_tile_wy<self.mapview_height:
                cur_slippy_y=center_tile_slippy_y-cnt_tile_y
                filename=G.tiles_location%(self.mapview_zoom,cur_slippy_x,cur_slippy_y)
                if os.path.isfile(filename):
                    pixa=gtk.gdk.pixbuf_new_from_file(filename)
                    self.mapview_context.set_source_pixbuf(pixa,cur_tile_wx,cur_tile_wy)
                    self.mapview_context.paint()
                    self.mapview_context.stroke()
                #else:
                #    self.mapview_context.rectangle(cur_tile_wx,cur_tile_wy,256,256)
                #    self.mapview_context.fill()

                cur_tile_wy+=256
                cnt_tile_y-=1
    
            cur_tile_wx+=256
            cnt_tile_x-=1
                

        if len(self.route):
            self.mapview_context.set_source_rgba(1,.843,0,.7)      
            self.mapview_context.set_line_width(10)               
 
            prev_node_dic=self.route[0]
            prev_node=sayhooMap.Node(id_node=prev_node_dic["id_node"],lat=prev_node_dic['lat'],lon=prev_node_dic['lon'])
            for cur_node_dic in self.route[1:]:
                cur_node=sayhooMap.Node(id_node=cur_node_dic["id_node"],lat=cur_node_dic['lat'],lon=cur_node_dic['lon'])
                (pgx,pgy)=tn.latlon2xy(prev_node.lat,prev_node.lon,self.mapview_zoom)
                (px,py)=self.globalxy2mapviewxy(pgx,pgy)
                (cgx,cgy)=tn.latlon2xy(cur_node.lat,cur_node.lon,self.mapview_zoom)
                (cx,cy)=self.globalxy2mapviewxy(cgx,cgy)
                #print "px,py",px,py
                #print "cx,cy",cx,cy
                #self.mark_dot(cx,cy,0,0,1,1,"circle",2)
                #self.mapview_context.set_source_rgba(1,.843,0,.7)      
                self.mapview_context.move_to(px,py)
                self.mapview_context.line_to(cx,cy)
                self.mapview_context.stroke()
                prev_node=cur_node


        for line in self.velib_stations:
            lat=line[1]
            lon=line[2]
            (gx,gy)=tn.latlon2xy(lat,lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0.2,0.2,.2,1)


        #self.mark_dot(wc_x,wc_y,0,1,1,.5)
        if self.destination_node:
            (gx,gy)=tn.latlon2xy(self.destination_node.lat,self.destination_node.lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0,1,0,1)            

        if self.start_node:
            (gx,gy)=tn.latlon2xy(self.start_node.lat,self.start_node.lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0,0,1,1)            
            

        if self.last_position:
            #print "last_poistion=",self.last_position
            lat=self.last_position['lat']
            lon=self.last_position['lon']
            (gx,gy)=tn.latlon2xy(lat,lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0,.5,0,.5,"circle",8)            


    def adjust_zoom(self,step):
        if self.mapview_zoom+step<18 and self.mapview_zoom+step>9:
            self.mapview_zoom+=step
            self.display_tiles()


    def on_key_press(self,widget,event):
        if event.keyval ==gtk.keysyms.F6:
            """Full screen key"""
            if self.fullScreen:
                self.hildon_window.unfullscreen()
                self.fullScreen=False
            else:
                self.hildon_window.fullscreen()
                self.fullScreen=True

        zoom_step=1
        if event.keyval == gtk.keysyms.F7:
            self.adjust_zoom(zoom_step)

        if event.keyval ==gtk.keysyms.F8:
            self.adjust_zoom(-zoom_step)

    def mapview_button_press_event(self,widget,event):
        self.mapview_mouse={"x":event.x,"y":event.y}
        if event.button==3:
            self.mapview_m.popup(None,None,None,event.button,event.time)

    def mapview_button_release_event(self,widget,event):
        delta_x=(event.x-self.mapview_mouse["x"])/256.0
        delta_y=(event.y-self.mapview_mouse["y"])/256.0
        (cur_x,cur_y)=tn.latlon2xy(self.mapview_center_lat,self.mapview_center_lon,self.mapview_zoom)
        new_x=cur_x-delta_x
        new_y=cur_y-delta_y
        (lat,lon)=tn.xy2latlon(new_x,new_y,self.mapview_zoom)
        self.mapview_center_lat=lat
        self.mapview_center_lon=lon
        self.display_tiles()
        return

    def mapview_tap_and_hold(self,menu,widget):
        req_w, req_h = menu.size_request()        
        top = widget.get_toplevel()

        w_x, w_y = top.window.get_origin()
        point_x, point_y, mods = top.window.get_pointer()
        menu_x = point_x + w_x
        menu_y = point_y + w_y - req_h
        scr_w = widget.get_screen().get_width()

        if (menu_x < w_x):
            menu_x = w_x
        elif (menu_x + req_w) > scr_w:
            menu_x -= ((menu_x + req_w) - scr_w)

        if menu_y < w_y:
                meny_y = w_y

        return menu_x, menu_y, True

    def mapview_m_set_destination_activate(self,menuitem):
        #self.mapview_mouse={"x":event.x,"y":event.y}
        #print "destination requested"
        if self.waiting_for_map:
            return
            
        mx=self.mapview_mouse['x']
        my=self.mapview_mouse['y']
        (dest_lat,dest_lon)=self.mapview2latlon(mx,my)
        
        request=G.GuiRequest(args={"type":"new_destination","lat":dest_lat,"lon":dest_lon})
        self.qq_to_controller.put(request)
        #print "new dest should be ",dest_lat,dest_lon
        G.system_info(_("Destination is set."))


    def mapview_m_set_start_point_activate(self,menuitem):
        #print "start_ activate"
        if self.waiting_for_map:
            return

        mx=self.mapview_mouse['x']
        my=self.mapview_mouse['y']
        (lat,lon)=self.mapview2latlon(mx,my)
        arg={"type":"new_start_point","lat":lat,"lon":lon}
        event=G.GuiRequest(args=arg)
        self.qq_to_controller.put(event)
        G.system_info(_("Starting point set."))


    def mapview_m_set_location_activate(self,menuitem):
        mx=self.mapview_mouse['x']
        my=self.mapview_mouse['y']
        (lat,lon)=self.mapview2latlon(mx,my)
        #print "new location should be",lat,lon
        
        arg={"type":"new_location","lat":lat,"lon":lon,"track":0}
        event=G.GpsEvent(args=arg)
	#print "Putting a new gps event in mapview_m_set_location_activate"
        self.qq_to_controller.put(event)

    def preferences_m_activate(self,menuitem):
        #print "preference activated"
        self.pref_window.show()
        
    def about_m_activate(self,menuitem):
        #print "about activated"
        #self.about_window.show()
        self.about_window.run()
        self.about_window.hide()

    def pref_ok_b_clicked(self,button):
        reload_needed=False
        new_city_data_dir=self.pref_selection.get('city_data_dir')
        if new_city_data_dir!=None and new_city_data_dir!=G.city_data_dir:
            G.gconf_default.set_string(G.gconf_root+"/city_data_dir",new_city_data_dir)
            request=G.GuiRequest(args={"type":"new_city_data_dir","data_dir":new_city_data_dir})
            self.qq_to_controller.put(request)
            if G.city_data_dir:
                reload_needed=True

        selected_lang_map=self.pref_lang_sorted[self.pref_lang_map_combo.get_active()]
        if selected_lang_map!=G.user_lang['map']:
            G.gconf_default.set_string(G.gconf_root+"/lang/map",selected_lang_map)
            reload_needed=True


        selected_lang_app=self.pref_lang_sorted[self.pref_lang_app_combo.get_active()]
        if selected_lang_app!=G.user_lang['application']:
            G.gconf_default.set_string(G.gconf_root+"/lang/application",selected_lang_app)
            reload_needed=True

        if reload_needed:
            self.show_dialog(title="New City",message=_("You will have to restart Sayhoo to see\n all your change taken care of."))
        self.pref_window.hide()

    def city_data_dir_looks_ok(self,target):
        out=True
        if not os.path.isfile(target+"/osm.db"):
            out=False
        if not os.path.isdir(target+"/tiles"):
            out=False
        if not os.path.isdir(target+"/pickle-jar"):
            out=False
        return out
        
    def pref_cancel_b_clicked(self,button):
        #print "b_cancel"
        if G.gconf_default.get_string(G.gconf_root+"/city_data_dir"):
            self.pref_data_location_a_label.set_label(G.gconf_default.get_string(G.gconf_root+"/city_data_dir"))
        else:
            self.pref_data_location_a_label.set_label("")

        self.pref_selection['city_data_dir']=''
        self.pref_window.hide()

    def pref_nb_change_data_location_b_clicked(self,button):
        """
        http://www.pygtk.org/docs/pygtk/class-gtkfilechooserdialog.html
        http://www.pygtk.org/pygtk2tutorial/sec-FileChoosers.html
        """

        """
        if G.is_maemo():
            chooser=hildon.FileChooserDialog(self.pref_window,gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
        else:
            chooser = gtk.FileChooserDialog(title="City data",action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
                                            buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
        """

        #I cannot manage to have filechooser translation working with hildon
        #So, this is a dirty workaround.

        chooser = gtk.FileChooserDialog(title="City data",action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
                                        buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
        
        if G.gconf_default.get_string(G.gconf_root+"/city_data_dir"):
            chooser.set_current_folder(G.gconf_default.get_string(G.gconf_root+"/city_data_dir"))
            
        response=chooser.run()
        target=chooser.get_filename()
        
        if response==gtk.RESPONSE_OK:
            if self.city_data_dir_looks_ok(target):
                self.pref_data_location_a_label.set_label(target)
                self.pref_selection['city_data_dir']=target
            else:
                G.system_info(_("%s is not valid."%target))

        chooser.destroy()

    def handle_gps_event(self,curEvent):
        #print "Gui got new location"
        lat=float(curEvent.args['lat'])
        lon=float(curEvent.args['lon'])
        heading=float(curEvent.args['track'])
        self.last_position={"lat":lat,"lon":lon,"track":heading}
        self.gps_signal=True
        #self.display_tiles()

    def wait_for_map(self,bool):
        self.waiting_for_map=bool
        if bool==True:
            #print "icon",self.main_map_status_icon
            self.main_map_status_icon.set_from_file(self.wait_icon)
        else:
            self.main_map_status_icon.set_from_file(self.go_icon)

        
    def monitor_controller_qq(self):
        """gdk-pixbuf-query-loaders | grep gtk20"""
        while self.qq_from_controller.qsize():
            try:
                curEvent=self.qq_from_controller.get(0)
            except:
                raise

            if isinstance(curEvent,G.StartEvent):
                self.start_application()
                continue
            
            if isinstance(curEvent,G.GuiAnswer):
                self.treatAnswer(curEvent)
                continue
            
            if isinstance(curEvent,G.MapAnswer):
                if curEvent.args['type']=="route-found":
                    route=curEvent.answer
                    #print route
                    self.route=route
                    self.display_tiles()
                    #self.start_node_query=False
                    #self.destination_node_query=False
                    #self.start_node=False
                    #self.destination_node=False
                    self.wait_for_map(False)

                if curEvent.args['type']=="new-destination-node":
                    self.destination_node=curEvent.answer


                if curEvent.args['type']=="new-start-node":
                    #print "Sayhoogui got a new start node info"
                    #print curEvent.answer
                    self.start_node=curEvent.answer


            if isinstance(curEvent,G.MapRequest):
                if curEvent.args['type']=="map-computing":
                    if curEvent.args['computing']:
                        self.wait_for_map(True)
                    else:
                        self.wait_for_map(False)

                if curEvent.args['type']=="city_data_dir_ready":
                    #print "in sayhooGui: got to load new tiles"
                    #print "tiles_location",G.tiles_location
                    #print "x,y",G.start_view_lat,G.start_view_lon
                    self.mapview_center_lat=G.start_view_lat
                    self.mapview_center_lon=G.start_view_lon
                    request=G.GuiRequest(args={"type":"list_velib_stations"})
                    self.qq_to_controller.put(request)

            if isinstance(curEvent,G.GpsEvent):
                if curEvent.args["type"]=="new_location":
                    self.handle_gps_event(curEvent)

        return True
