#!/usr/bin/python2.5
# -*- coding: utf-8 -*-
# Sayhoo: an audio navigation help for velib' like projects.
# Copyright 2008 Pierre Amadio
# pierre.amadio@libertysurf.fr
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import gettext
import math
import os
import locale
try:
     from gnome import gconf
except:
     import gconf

try:
    import sqlite3
except:
    from pysqlite2 import dbapi2 as sqlite3
import time
import datetime

gconf_default=gconf.client_get_default()
gconf_root="/apps/osso/sayhoo"


EARTH_RADIUS=3443.91847


def is_maemo():
     if os.name=="posix" and os.path.exists('/media/mmc1'):
         return True
     else:
         return False
    
def deg2rad(deg):
    out = (deg) * (math.pi / 180.0)
    return out

def rad2deg(rad):
    out=(rad) * (180.0 / math.pi)
    return out

"""
distancePointToLine comes from pyrender.
x,y : local point
x1,y1: beginning of the segment.
x2,y2: end of the segment.
"""

def distancePointToLine(x,y,x1,y1,x2,y2):
  """http://www.allegro.cc/forums/thread/589720"""
  A = x - x1
  B = y - y1
  C = x2 - x1
  D = y2 - y1
  
  dot = A * C + B * D
  len_sq = C * C + D * D
  if len_sq==0:
     dist= A*A +B*B
     return(dist)

  param = dot / len_sq

  if(param < 0):
    xx = x1
    yy = y1
  elif(param > 1):
    xx = x2
    yy = y2
  else:
    xx = x1 + param * C
    yy = y1 + param * D

  dx = x - xx
  dy = y - yy
  dist = dx * dx + dy * dy
  return(dist)

def vertex_angle(a,b,c):
     """
     This function return the gamma angle on a triangle vertex (the one
     opposit to the c border).

     Ideally, we should use the spherical one:
     http://en.wikipedia.org/wiki/Law_of_cosines_(spherical)

     As the triangle will always be small compared to the size of the earth globe,
     lets be lazy and pretend the earth is flat.
     http://en.wikipedia.org/wiki/Law_of_cosines

     a,b and c are border's lenght.
     
     """
     cos_gamma=(a*a+b*b-c*c)/(2.0*a*b)
     gamma=math.degrees(math.acos(cos_gamma))
     return gamma


def rotate(cx,cy,ox,oy,rotation_angle):
     """
     http://homepages.inf.ed.ac.uk/rbf/HIPR2/rotate.htm
     The rotation operator performs a transformation
     cx,cy the centre or rotation
     ox,oy the point to be rotated
     """
     angle=-rotation_angle
     #http://homepages.inf.ed.ac.uk/rbf/HIPR2/rotate.htm
     x=math.cos(deg2rad(angle))*(ox-cx)-math.sin(deg2rad(angle))*(oy-cy)+cx
     y=math.sin(deg2rad(angle))*(ox-cx)+math.cos(deg2rad(angle))*(oy-cy)+cy
     return (x,y)

class Event:
    """this is a superclass for any events that might be generated by an
    object and sent to the EventManager
    """
    def __init__(self,name="Generic Event"):
        self.name = name

class TickEvent(Event):
    def __init__(self,name="TickEvent"):
        Event.__init__(self,name=name)

class StartEvent(Event):
    def __init__(self,name="StartEvent"):
        Event.__init__(self,name=name)

class StopEvent(Event):
    def __init__(self,name="StopEvent"):
        Event.__init__(self,name=name)

class GuiRequest(Event):
    def __init__(self,name="GuiRequest",args={}):
        Event.__init__(self,name=name)
        self.args=args

class GuiAnswer(Event):
    def __init__(self,name="GuiAnswer",args={},answer=False):
        Event.__init__(self,name=name)
        self.args=args
        self.answer=answer
        
class MapRequest(Event):
    def __init__(self,name="MapRequest",args={}):
        Event.__init__(self,name=name)
        self.args=args

class MapAnswer(Event):
    def __init__(self,name="MapAnswer",args={},answer=False):
        Event.__init__(self,name=name)
        self.args=args
        self.answer=answer

class GpsEvent(Event):
    def __init__(self,name="GpsEvent",args={}):
        Event.__init__(self,name=name)
        self.args=args
        

class TtsEvent(Event):
    def __init__(self,name="TtsEvent",args={}):
        Event.__init__(self,name=name)
        self.args=args
        
class SimpleTimer:
    def __init__(self):
        self.start_time=int(time.time())
        return
    
    def reset(self):
        self.start_time=int(time.time())

    def seconds_spent(self):
        sec=int(time.time())-self.start_time
        return datetime.timedelta(seconds=sec).seconds

    def minutes_spent(self):
        return int(self.seconds_spent()/60)
    
    def hours_spent(self):
        return int(self.minutes_spent()/60)

    def time_spent(self):
        s=self.seconds_spent()
        while s>59:
            s=s-60
        s=str(s)
        while len(s)<2:
            s="0"+s
        
        m=self.minutes_spent()
        while m>59:
            m=m-60

        m=str(m)
        while len(m)<2:
            m="0"+m

        h=str(self.hours_spent())
        while len(h)<2:
            h="0"+h

        
        return h+":"+m+":"+s 




tick_per_sec=10.0

if is_maemo():
     import osso
     osso_context = osso.Context("org.maemo.sayhoo", "0.0.1", False)
     osso_rpc=osso.Rpc(osso_context)

     #db_location="/media/mmc2/data-sayhoo/osm.db"
     #tiles_location="/media/mmc2/data-sayhoo/tiles/%s/%s/%s.png"
     glade_file_location="/usr/share/sayhoo/data/sayhoo.glade"
     #pickle_jar="/media/mmc2/data-sayhoo/pickle-jar"

     def system_info(message):
          sysnote=osso.SystemNote(osso_context)
          sysnote.system_note_infoprint(message)

else:
     osso_context=False
     osso_rpc=False
     #db_location="/media/mmc2/data-sayhoo/osm.db"
     #tiles_location="/media/mmc2/data-sayhoo/tiles/%s/%s/%s.png"
     #glade_file_location="/home/user/scratchome/dev/sayhoo/branches/pamadio/data/sayhoo.glade"
     glade_file_location="/usr/share/sayhoo/data/sayhoo.glade"
     #pickle_jar="/media/mmc2/data-sayhoo/pickle-jar"

     def system_info(message):
          print "System Info: '%s'"%message



def find_center_point(db_loc):
     print "find_center_point for",db_loc
     db=sqlite3.connect(db_loc)
     cursor=db.cursor()
     snt="select min(lat),max(lat),min(lon),max(lon) from nodes"
     cursor.execute(snt)
     line=cursor.fetchone()
     min_lat=line[0]
     max_lat=line[1]
     min_lon=line[2]
     max_lon=line[3]
     lat=min_lat+(max_lat-min_lat)/2.0
     lon=min_lon+(max_lon-min_lon)/2.0
     db.close()
     return (lat,lon)

          
if gconf_default.get_string(gconf_root+"/city_data_dir"):
     """
     gconftool-2 -t string -s '/apps/osso/sayhoo/city_data_dir' '/media/mmc2/data-sayhoo'
     gconftool-2 -u '/apps/osso/sayhoo' --recursive-unset
     """
     city_data_dir=gconf_default.get_string(gconf_root+"/city_data_dir")
     db_location=city_data_dir+"/osm.db"
     tiles_location=city_data_dir+"/tiles/%s/%s/%s.png"
     pickle_jar=city_data_dir+"/pickle-jar"
     #start_view_lat=48.8587771
     #start_view_lon=2.293387

     (start_view_lat,start_view_lon)=find_center_point(db_location)
     
else:
     city_data_dir=False     
     db_location=city_data_dir
     tiles_location=city_data_dir
     pickle_jar=city_data_dir
     start_view_lat=False
     start_view_lon=False


cur_locale=locale.getdefaultlocale()
#print cur_locale
user_lang={"application":False,"map":False}

#locale.setlocale(locale.LC_ALL, "fr_FR")
#os.environ["LANGUAGE"]="fr_FR"

"""
No utf8 locales on maemo (at least on mine).
To generate non utf8 locales on Ubuntu Dapper:
https://lists.ubuntu.com/archives/ubuntu-devel/2006-March/016081.html
"""

gettext.textdomain('sayhoo')
_ = gettext.gettext
print _('This is a translatable string.')


supported_lang={"en":[False,"en_US"],
                "fr":[False,"fr_FR"]
                }

for cur in ["application","map"]:
     if gconf_default.get_string(gconf_root+"/lang/"+cur):
          user_lang[cur]=gconf_default.get_string(gconf_root+"/lang/"+cur)
     else:
          try:
               user_lang[cur]=cur_locale[0][:2]
          except:
               user_lang[cur]="en"

     if user_lang[cur] not in supported_lang.keys():
          user_lang[cur]="en"

#print "user_lang=",user_lang
#{'application': 'en', 'map': 'fr'}
#print "yo,",


locale.setlocale(locale.LC_ALL,supported_lang[user_lang["application"]][1])
os.environ["LANGUAGE"]=supported_lang[user_lang["application"]][1]
supported_lang={"en":[_("English"),"en_US"],
                "fr":[_("French"),"fr_FR"]
                }





