#include <libosso.h>
#include "appdata.h"
#include "state.h"


struct StateData statedata;

gboolean state_load(void)
{
    osso_state_t osso_state;
    osso_return_t ret;

    osso_state.state_size = sizeof(struct StateData);
    osso_state.state_data = &statedata;

    ret = osso_state_read(appdata.osso_context, &osso_state);
    if (ret != OSSO_OK)
        return FALSE;
    return TRUE;
}

gboolean state_save(void)
{
    osso_state_t osso_state;
    osso_return_t ret;

    osso_state.state_size = sizeof(struct StateData);
    osso_state.state_data = &statedata;

    ret = osso_state_write(appdata.osso_context, &osso_state);

    if (ret != OSSO_OK)
        return FALSE;
    return TRUE;
}

void state_clear(void)
{
   // Clean up prefs 
   // state_save();
}
