# -*- coding: UTF8 -*-
import gtk
import hildon
import os
import pyrecipe_utils
import gobject
import osso, osso.alarmd
import time

#If running in scratchbox it has other directories than in the device
if os.path.exists('/scratchbox'):
    scratchbox = True
else:
    scratchbox = False
    
if scratchbox:
    glade_file = "timer.glade" 
else:
    glade_file = "/usr/share/pyrecipe/timer.glade" 

class Timer:
    def __init__(self, imagesdir, osso_c):
        self.window = hildon.Window()
        self.window.set_default_size(800, 480)
        self.window.set_title('Pyrecipe - Timer')
        self.window.connect("delete-event", self.hide_window)
               
        self.osso_c = osso_c
        
        self.running = False
		
        glade=gtk.glade.XML(glade_file)
        vbox1 = glade.get_widget("vbox1")
        vbox1.reparent(self.window)
        
        hbox6 = glade.get_widget("hbox6")
        
        gobject.type_register(pyrecipe_utils.FingerNE)
        
        self.hours = pyrecipe_utils.FingerNE('vertical')        
        self.minutes = pyrecipe_utils.FingerNE('vertical')
        self.seconds = pyrecipe_utils.FingerNE('vertical') 
        self.minutes.set_maximum(59)
        self.seconds.set_maximum(59)
        self.minutes.set_tap_and_hold()
        self.seconds.set_tap_and_hold()

        NE_list = [self.hours, self.minutes, self.seconds]
        for i in range(len(NE_list)):
            NE_list[i].set_minimum(0)
            NE_list[i].set_size([50, 30, 60, 60])
            NE_list[i].set_image_buttons(imagesdir + 'add.png', imagesdir + \
                                        'remove.png')
                                              
        self.minutes.set_value(10)
                
        hbox6.pack_start(self.hours, False, False, 0)
        hbox6.pack_start(self.minutes, False, False, 0)        
        hbox6.pack_start(self.seconds, False, False, 0) 
                
        hbox6.reorder_child(self.hours, 1)
        hbox6.reorder_child(self.minutes, 3)        
        hbox6.reorder_child(self.seconds, 5)

        reset_btn = glade.get_widget("reset_btn")
        reset_btn.connect('clicked', self.on_reset)                
        pause_btn = glade.get_widget("pause_btn")
        
        start_btn = glade.get_widget("start_btn")
        start_btn.connect('clicked', self.on_start)        

        self.note_entry = glade.get_widget("note_entry")

        self.hide_btn = glade.get_widget("hide_btn")
        self.hide_btn.connect('clicked', self.only_hide)        
        self.delete_btn = glade.get_widget("delete_btn")
        self.delete_btn.connect('clicked', self.hide_window)

        reset_img = glade.get_widget("reset_img")
        reset_img.set_from_file(imagesdir + 'reset.png')
        play_img = glade.get_widget("play_img")
        play_img.set_from_file(imagesdir + 'play.png')
        pause_img = glade.get_widget("pause_img")
        pause_img.set_from_file(imagesdir + 'pause.png')

      		
        self.window.show_all()

    #Show the window if it isn' running
    def show(self):
        self.window.show()
        self.window.present()
        return True

    #Hide window and reset value, clicking in 'Delete' button or closing window        
    def hide_window(self, widget, ev=None):
        self.on_reset(widget)
        self.window.hide()
        return True

    #Only hide the window, clicking in 'Hide' button
    def only_hide(self, widget):
        self.window.hide()
        return True

    #Set timer to default values        
    def on_reset(self, widget):
        self.running = False
        self.note_entry.set_text('')
        self.hours.set_value(0)
        self.minutes.set_value(10)
        self.seconds.set_value(0)
        try:
            osso.alarmd.cancel_alarm(self.alarm_id)
        except:
            print 'no alarm setted'

    #Start the timer        
    def on_start(self, widget):
        self.running = True
        self.timer_id = gobject.timeout_add(1000, self.do_timer)

    #Update the timer values            
    def do_timer(self):
        if self.running:
            ##This code is from eggtimer app. Thank you axique.
            svalue=int(self.seconds.get_value())
            mvalue=int(self.minutes.get_value())
            hvalue=int(self.hours.get_value())

            if ((svalue==0)and(mvalue==0)and(hvalue==0)): return True
            svalue-=1
            if (svalue<0):
                svalue=0
                if ((mvalue>0)or(hvalue>0)): svalue=59
                mvalue-=1
                if (mvalue<0):
                    mvalue=0
                    if (hvalue>0): mvalue=59
                    hvalue-=1
                    if (hvalue<1):
                        hvalue=0
						
            if ((svalue==0)and(mvalue==0)and(hvalue==0)): 
                self.timefinished()
                return False
						
			
            self.hours.set_value(hvalue)
            self.minutes.set_value(mvalue)	
            self.seconds.set_value(svalue)
        else:
            return False
        return True # run again in one second  

    #Run when the timer is finished                
    def timefinished(self):
        devstat = osso.DeviceState(self.osso_c)
        devstat.display_state_on()
		
        note_txt = self.note_entry.get_text()        
        self.window.present()

        #run the alarm dialog
        alarm_time=long(time.time())
        title='Pyrecipe alarm'
        message=note_txt
        sound="/dev/null"

        self.alarm_id=osso.alarmd.add_alarm(alarm_time, snooze=1, title=title, \
                                message=message, sound=sound)

                        
