## This module contains some functions reused in the pyrecipe application ##

import gtk
import os
import hildon

##Return a ingredient list from the ingredients database
##ingredients database is "amount1||unit1||item1\namount2||unit2||item2\n"
##this function return [(amount1, unit1, item1), (amount2, unit2, item2)]
def ingredients_to_inglist(ingredients):
    if ingredients != '':
        il_l = ingredients.split('\n')
        ing_list = []        
        for i in range(len(il_l)):
            new = il_l[i].split('||')
            if new == ['']:
                pass
            else:
                li_l = (new[0], new[1], new[2])
                ing_list.append(li_l)
    else:
        ing_list = []
    
    return ing_list 

##Return the titles and ids of the all recipes in the database
##return a list similar to [(1, 'recipe1'), (2, 'recipe2')]
def get_recipe_list(sqlite_conn):
    lista = []
    for row in sqlite_conn.execute('select id, title from recipes'):
        lista.append(row)

    recipe_list=[]

    for i in range(len(lista)):
        ids = lista[i][0]
        titles = lista[i][1]
        recipe_ids = (ids, titles)
        recipe_list.append(recipe_ids)
        
    return recipe_list

##Show a hildon.filechooser save dialog ##    
def show_save_dialog(window, title, format, EXT):
    file_dialog = hildon.FileChooserDialog(window, action=gtk.FILE_CHOOSER_ACTION_SAVE)
    if format == 'backup':
        file_dialog.set_title("Pyrecipe backup")    
    else:
        file_dialog.set_title("Save recipe as "+ format)
    file_dialog.set_default_response(gtk.RESPONSE_CANCEL)
    file_dialog.set_current_name(title)
    file_dialog.set_current_folder('/home/user/MyDocs/.documents')

    result = file_dialog.run()
    if result == gtk.RESPONSE_OK:
        namefile = file_dialog.get_filename()
        namefile, extension = os.path.splitext(namefile)
        namefile = namefile + "." + EXT

    else:
        namefile = None                
    file_dialog.destroy()

    return namefile

##Save a file from a xml document ##    
def save_xml_file(namefile, xml_document):
    success = False
    try:
        save_file = open(namefile, 'w')
        xml_document.documentElement.writexml(save_file)
        save_file.close()
    except IOError, (errno, strerror):
        print "Error saving post(%s): %s" % (errno, strerror)
    else:
        success = True

    return success

##Show a confirmation dialog deleting recipes
def on_confirmation(window, msg):
    dialog = gtk.MessageDialog(parent=window, type=gtk.MESSAGE_QUESTION, buttons=gtk.BUTTONS_YES_NO, message_format=msg)
    dialog.show_all()
    result = dialog.run()
    if result == -8:
        dialog.destroy()
        return True

    dialog.destroy()
    return False

#Show a information dialog
def info_dialog(window, msg, msg2):
    dialog = gtk.MessageDialog(parent=window, type=gtk.MESSAGE_INFO, buttons=gtk.BUTTONS_CLOSE, message_format=msg)
    dialog.format_secondary_text(msg2)
    dialog.show_all()
    result = dialog.run()
    dialog.destroy()   

##Show a hildon.filechooser open dialog ##    
def show_open_dialog(window, title):
    file_dialog = hildon.FileChooserDialog(window, action=gtk.FILE_CHOOSER_ACTION_OPEN)
    file_dialog.set_title(title)
    file_dialog.set_default_response(gtk.RESPONSE_CANCEL)
    file_dialog.set_current_folder('/home/user/MyDocs/.documents')

    result = file_dialog.run()
    if result == gtk.RESPONSE_OK:
        namefile = file_dialog.get_filename()

    else:
        namefile = None                
    file_dialog.destroy()

    return namefile

#This is a finger friendly number editor
#It's a simple gtk.Entry with two gtk.Button
class FingerNE(gtk.HBox):
    def __init__ (self, orientation):
        gtk.HBox.__init__ (self)

        self.step = 1
        self.minimum = False
        self.maximum = False
        self.entry = gtk.Entry()
        self.entry.grab_focus()
        self.entry.set_property('editable', False)
        self.entry.set_property('xalign', 0.5)
        self.entry.set_text(str(0))

        self.plus = gtk.Button()
        self.plus.set_property('focus-on-click', False)
        self.plus.connect('clicked', self.plus_clicked)
              
        self.minus = gtk.Button()
        self.minus.set_property('focus-on-click', False)        
        self.minus.connect('clicked', self.minus_clicked)
        
        mybox = self.set_orientation(orientation)
        
        self.add(mybox)

    #Set the image for the buttons, generally + and -
    def set_image_buttons(self, plus_imgfile, minus_imgfile):
        minus_img = gtk.Image()
        minus_img.set_from_file(minus_imgfile)     
        self.minus.set_image(minus_img)
        
        plus_img = gtk.Image()
        plus_img.set_from_file(plus_imgfile)
        self.plus.set_image(plus_img)        

        minus_img.show()
        plus_img.show()
        self.minus.show()
        self.plus.show()
        
    def do_realize (self):
        gtk.HBox.do_realize (self)

    #When the + button is clicked
    def plus_clicked(self, widget):
        if self.maximum is not False:
            if int(self.get_value()) >= self.maximum:
                hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                            'Maximum value reached')
            else:
                try:            
                    self.set_value(int(self.get_value())+self.step)
                except ValueError:
                    self.set_value(0)
                    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                                'Invalid literal value')    
        else:
            try:        
                self.set_value(int(self.get_value())+self.step)
            except ValueError:
                self.set_value(0)
                hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                                'Invalid literal value')              
 
    #When the - button is clicked
    def minus_clicked(self, widget):    
        if self.minimum is not False:
            if int(self.get_value()) <= self.minimum:
                hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                            'Minimum value reached')                    
            else:
                try:
                    self.set_value(int(self.get_value())-self.step)
                except ValueError:
                    self.set_value(self.minimum)
                    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                                'Invalid literal value')                   
        else:
            try:
                self.set_value(int(self.get_value())-self.step)
            except ValueError:
                self.set_value(0)
                hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                                'Invalid literal value')              
            
    #Maximum value for the widget
    def set_maximum(self, maximum):
        self.maximum = maximum

    #Minimum value for the widget    
    def set_minimum(self, minimum):
        self.minimum = minimum
        self.set_value(minimum)

    #Step for the widget           
    def set_step(self, step):
        self.step = step

    #Set the size for the entry and the buttons
    def set_size(self, size):
        self.entry.set_size_request(size[0], size[1])
        self.plus.set_size_request(size[2], size[3])
        self.minus.set_size_request(size[2], size[3])

    #Set the value for the entry
    def set_value(self, value):
        self.entry.set_text(str(value))

    #Return the value for the entry
    def get_value(self):
        value = self.entry.get_text()
        return value

    #Orientation for the widget, vertical or horizontal
    def set_orientation(self, orientation):
        if orientation == 'horizontal':
            mybox = gtk.HBox()
            mybox.pack_start(self.minus, False, False, 0)
            mybox.pack_start(self.entry, False, False, 0)  
            mybox.pack_start(self.plus, False, False, 0)              
            
        elif orientation == 'vertical':
            mybox = gtk.VBox()
            mybox.pack_start(self.plus, False, False, 0)
            mybox.pack_start(self.entry, False, False, 0) 
            mybox.pack_start(self.minus, False, False, 0)             

        return mybox

    #Tap and hold in the buttons for set specials values                    
    def set_tap_and_hold(self):
        minus_menu = gtk.Menu()
        plus_menu = gtk.Menu()
        plus_numbers = [10, 20, 30, 40, 50, 60]
        minus_numbers = [0, 5, 10, 15, 20, 30]
        
        for i in range(len(plus_numbers)):
            item = gtk.MenuItem("Add %d" % plus_numbers[i])
            item.set_size_request(-1, 45)
            item.connect('activate', self.add_numbers_to_entry, plus_numbers[i])
            plus_menu.append(item)
            item.show()

        for i in range(len(minus_numbers)):
            item = gtk.MenuItem("Set %d" % minus_numbers[i])
            item.set_size_request(-1, 45)
            item.connect('activate', self.set_value_from_menu, minus_numbers[i])
            minus_menu.append(item)
            item.show()
        
        minus_menu.show()
        plus_menu.show()        
               
        self.plus.tap_and_hold_setup(menu=plus_menu, callback=None, data=None)
        self.minus.tap_and_hold_setup(menu=minus_menu, callback=None, data=None)

    #Add value to the entry value from the tap and hold menu
    def add_numbers_to_entry(self, widget, numbers):
        old_value = self.get_value()
        new_value = int(old_value) + int(numbers)    
        if self.maximum is not False:
            if new_value > self.maximum:
                self.set_value(self.maximum)
            else:
                self.set_value(new_value)
        else:
            self.set_value(new_value)            

    #Set value for the entry from the tap and hold menu
    def set_value_from_menu(self, widget, value):
        self.set_value(value)
                    
