import hildon
from xml.dom import minidom
import pyrecipe_utils

class KRecipes:
    def __init__ (self, exp_recipe_list, window, widget):      
        for recipe in range(len(exp_recipe_list)):
        
            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            imagesrc = exp_recipe_list[recipe][9]

            if recipe == 0:
                xml_document = self.write_xml(title, instructions, category, \
                         preptime, cooktime, servings, notes, ingredients, None)
            else:
                xml_document = self.write_xml(title, instructions, category, \
                 preptime, cooktime, servings, notes, ingredients, xml_document)              

        if len(exp_recipe_list) > 1:
            title = 'recipes'
       
        namefile = pyrecipe_utils.show_save_dialog(window, title, 'KRecipes format',\
                                                   'kreml')
        if namefile == None:
            print 'No saving recipe.'
            return
        
        success = pyrecipe_utils.save_xml_file(namefile, xml_document)
        
        if success == True:
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint',\
                                             'Recipes saved')
        else:
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint',\
                                             'Error ocurred while exporting the file')

    def write_xml(self, title, instructions, category, preptime, \
                 cooktime, servings, notes, ingredients, xml_document):
        impl = minidom.getDOMImplementation()
        if xml_document is None:
            xml_document = impl.createDocument(None, 'krecipes', None)

        recipe_element = xml_document.createElement('krecipes-recipe')

        desc_element = xml_document.createElement('krecipes-description')

        title_element = xml_document.createElement('title')
        title_element.appendChild(xml_document.createTextNode(title))
 
        category_element = xml_document.createElement('category')        
        cats_element = xml_document.createElement('cat')
        cats_element.appendChild(xml_document.createTextNode(category))        
        category_element.appendChild(cats_element) 
        
        preptime_element = xml_document.createElement('preparation-time')
        preptime_element.appendChild(xml_document.createTextNode(preptime))
                 
        servings_element = xml_document.createElement('serving')
        servings_element.appendChild(xml_document.createTextNode(servings))  

        desc_element.appendChild(title_element)
        desc_element.appendChild(category_element) 
        desc_element.appendChild(preptime_element)                
        desc_element.appendChild(servings_element)

        #TODO: import the image        
        
        ing_list_element = xml_document.createElement('krecipes-ingredients') 

        ing_list = pyrecipe_utils.ingredients_to_inglist(ingredients)

        for i in range(len(ing_list)):
            ingredient_element = xml_document.createElement('ingredient')
            amount_element = xml_document.createElement('amount')
            amount_element.appendChild(xml_document.createTextNode(ing_list[i][0]))

            units_element = xml_document.createElement('unit')
            units_element.appendChild(xml_document.createTextNode(ing_list[i][1]))
    
            items_element = xml_document.createElement('name')
            items_element.appendChild(xml_document.createTextNode(ing_list[i][2]))
            
            ingredient_element.appendChild(items_element)
            ingredient_element.appendChild(amount_element)            
            ingredient_element.appendChild(units_element)            
                        
            ing_list_element.appendChild(ingredient_element) 
                       
        instructions_element = xml_document.createElement('krecipes-instructions')
        instructions_element.appendChild(xml_document.createTextNode(instructions))

        recipe_element.appendChild(desc_element)		               
        recipe_element.appendChild(ing_list_element)		
        recipe_element.appendChild(instructions_element)       			

        xml_document.documentElement.appendChild(recipe_element)

        return xml_document


