import hildon
from xml.dom import minidom
import pyrecipe_utils

class GourmetXML:
    def __init__ (self, exp_recipe_list, window, widget):      
        for recipe in range(len(exp_recipe_list)):
        
            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            imagesrc = exp_recipe_list[recipe][9]

            if recipe == 0:
                xml_document = self.write_xml(title, instructions, category, \
                         ingredients, preptime, cooktime, servings, notes, None)
            else:
                xml_document = self.write_xml(title, instructions, category, \
                  ingredients, preptime, cooktime, servings, notes, xml_document)               

        if len(exp_recipe_list) > 1:
            title = 'recipes'
            
        namefile = pyrecipe_utils.show_save_dialog(window, title, 'Gourmet XML',\
                                                     'grmt')

        if namefile == None:
            print 'No saving recipe.'
            return
        
        success = pyrecipe_utils.save_xml_file(namefile, xml_document)
        
        if success == True:
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint',\
                                             'Recipes saved')
        else:
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint',\
                                             'Error ocurred while exporting the file')

    def write_xml(self, title, instructions, category, ingredients, \
                  preptime, cooktime, servings, notes, xml_document):
        impl = minidom.getDOMImplementation()
        if xml_document is None:
            xml_document = impl.createDocument(None, 'gourmetDoc', None)

        id_element = xml_document.createElement('recipe')

        title_element = xml_document.createElement('title')
        title_element.appendChild(xml_document.createTextNode(title))
        
        category_element = xml_document.createElement('category')
        category_element.appendChild(xml_document.createTextNode(category))
        
        preptime_element = xml_document.createElement('preptime')
        preptime_element.appendChild(xml_document.createTextNode(preptime))
        
        cooktime_element = xml_document.createElement('cooktime')
        cooktime_element.appendChild(xml_document.createTextNode(cooktime))
                 
        servings_element = xml_document.createElement('servings')
        servings_element.appendChild(xml_document.createTextNode(servings))         

        #TODO: export the image
        
        ing_list_element = xml_document.createElement('ingredient-list')
        
        ing_list = pyrecipe_utils.ingredients_to_inglist(ingredients)

        for i in range(len(ing_list)):
            ingredient_element = xml_document.createElement('ingredient')
            amount_element = xml_document.createElement('amount')
            amount_element.appendChild(xml_document.createTextNode(ing_list[i][0]))

            units_element = xml_document.createElement('unit')
            units_element.appendChild(xml_document.createTextNode(ing_list[i][1]))
    
            items_element = xml_document.createElement('item')
            items_element.appendChild(xml_document.createTextNode(ing_list[i][2]))
            
            ingredient_element.appendChild(amount_element)
            ingredient_element.appendChild(units_element)
            ingredient_element.appendChild(items_element)
                        
            ing_list_element.appendChild(ingredient_element) 
                       
        instructions_element = xml_document.createElement('instructions')
        instructions_element.appendChild(xml_document.createTextNode(instructions))

        notes_element = xml_document.createElement('modifications')
        notes_element.appendChild(xml_document.createTextNode(notes))

		        
        id_element.appendChild(title_element)
        id_element.appendChild(category_element)        
        id_element.appendChild(preptime_element)        
        id_element.appendChild(cooktime_element)
        id_element.appendChild(servings_element)                     
        id_element.appendChild(ing_list_element)		
        id_element.appendChild(instructions_element)       
        id_element.appendChild(notes_element)				

        xml_document.documentElement.appendChild(id_element)

        return xml_document

