#ifndef GAMEAREA_H
#define GAMEAREA_H

/*
  PushIt - A simple Sokoban solving game
  Copyright (C) 2006  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Model/Boolean.h>

#include <Lum/OS/Bitmap.h>

#include "Sokoban.h"
#include "Configuration.h"

class GameArea : public Lum::Object
{
public:
  class Prefs : public Lum::Object::Prefs
  {
  };

private:
  size_t                 themeIndex;
  size_t                 xOff;
  size_t                 yOff;
  Sokoban                sokoban;
  Lum::Model::BooleanRef finished;
  Lum::OS::Bitmap        *gameBackground; //! The game background
  Lum::OS::Bitmap        *game;           //! The game background including game foreground
  Lum::OS::ColorRef      sokobanColor;
  Lum::OS::ColorRef      frameShineColor;
  Lum::OS::ColorRef      frameShadowColor;

private:
  size_t GetBoxSize() const;
  Lum::Images::Image* GetImage(Image image) const;

  size_t GetSokobanXPos() const;
  size_t GetSokobanYPos() const;

  bool IsAreaCompletelyVisible() const;
  bool CanScrollLeft() const;
  bool CanScrollUp() const;
  bool CanScrollRight() const;
  bool CanScrollDown() const;

  void MakeSokobanVisible();

  void ScrollLeft();
  void ScrollUp();
  void ScrollRight();
  void ScrollDown();

  void MoveLeft();
  void MoveUp();
  void MoveRight();
  void MoveDown();

  void DrawSokobanInternal(Lum::OS::DrawInfo *draw, size_t x, size_t y, size_t size);
  void DrawPackageInternal(Lum::OS::DrawInfo *draw, size_t x, size_t y, size_t size);
  void DrawGoalInternal(Lum::OS::DrawInfo *draw, size_t x, size_t y, size_t size);
  void DrawFloorInternal(Lum::OS::DrawInfo *draw, size_t x, size_t y, size_t size);
  void DrawWallInternal(Lum::OS::DrawInfo *draw,
                        size_t x, size_t y, size_t size, size_t cx,
                        size_t cy);

  void RebuildGameBackground();
  void RebuildGame();

public:
  GameArea();
  ~GameArea();

  void EvaluateThemeName();
  void SetSokoban(const Sokoban& sokoban);

  void CalcSize();

  void Draw(int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);
  bool HandleKeyEvent(const Lum::OS::KeyEvent& event);

  Lum::Model::Boolean* GetFinishedModel() const;

  void Undo();
};

#endif
