#!/usr/bin/python
#

#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of pidgin-carman.
#
#  pidgin-carman is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  pidgin-carman is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with pidgin-carman.  If not, see <http://www.gnu.org/licenses/>.

import gobject

import sys
import dbus
import dbus.service
import dbus.mainloop.glib

class Rejected(dbus.DBusException):
    _dbus_error_name = "org.indt.carmanplugin.Agent.Error.Rejected"

class Agent(dbus.service.Object):
    released = False
    @dbus.service.method("org.indt.carmanplugin.Agent",
            in_signature="ss", out_signature="")
    def Authorize(self, email, name):
        print "Authorize (%s, %s)" % (email, name)

    @dbus.service.method("org.indt.carmanplugin.Agent",
                in_signature="", out_signature="")
    def Cancel(self):
        print "Cancel"

    @dbus.service.method("org.indt.carmanplugin.Agent",
                in_signature="", out_signature="")
    def Release(self):
        self.released = True
        mainloop.quit()

if __name__ == '__main__':
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

    bus = dbus.bus.BusConnection("unix:path=/var/run/carmand-dbus-path")
    manager = dbus.Interface(bus.get_object("org.indt.carmanplugin", "/"),
            "org.indt.carmanplugin.Manager")

    path = "/test/agent"
    agent = Agent(bus, path)

    mainloop = gobject.MainLoop()

    manager.RegisterAgent(path)
    print "Agent registered"

    mainloop.run()

    if agent.released == False:
        manager.UnregisterAgent(path)
        print "Agent unregistered"
