/*
  PackageView - Show debian package details
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "PackageDetails.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/ButtonRow.h>
#include <Lum/Edit/Edit.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>
#include <Lum/Tab.h>
#include <Lum/Text.h>
#include <Lum/View.h>

PackageDetails::PackageDetails(Package& package)
 : package(package)
{
  Observe(GetClosedAction());
}

Lum::Object* PackageDetails::GetTextField(const std::wstring& text) const
{
  Lum::Text *t;

  t=new Lum::Text(text);
  t->SetFlex(true,false);
  t->SetMaxWidth(Lum::Base::Size::stdCharWidth,20);

  return t;
}

void PackageDetails::PreInit()
{
  Lum::ButtonRow  *row;
  Lum::Edit::Edit *edit;
  Lum::Edit::Text *editContent;
  Lum::Panel      *vPanel;
  Lum::Tab        *tab;
  Lum::View       *view;

  vPanel=new Lum::VPanel();
  vPanel->SetFlex(true,true);

  tab=new Lum::Tab();
  tab->SetFlex(true,true);

  editContent=new Lum::Edit::Text();
  editContent->SetText(L"Package: "+package.GetName()+L" "+package.GetVersion()+ L" ("+package.GetSection()+L")\n"+
                       L"Description: "+(package.GetShortDescription().empty() ? L"<no description>" : package.GetShortDescription())+L"\n"+
                       L"Maintainer: "+(package.GetMaintainer().empty() ? L"<no maintainer>" : package.GetMaintainer())+L"\n"+
                       L"Homepage: "+(package.GetHomepage().empty() ? L"<no homepage> " : package.GetHomepage())+L"\n"+
                       L"Size (deb/inst.): "+Lum::Base::NumberToWString(package.GetPackageSize())+L"/"+
                  Lum::Base::NumberToWString(package.GetInstalledSize()));
  editContent->Disable();

  view=new Lum::View();
  view->SetFlex(true,true);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,40);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  view->SetObject(edit);

  tab->Add(L"Data",view);

  editContent=new Lum::Edit::Text();
  editContent->SetText(package.GetDescription());
  editContent->Disable();

  view=new Lum::View();
  view->SetFlex(true,true);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,40);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  view->SetObject(edit);

  tab->Add(L"Description",view);

  editContent=new Lum::Edit::Text();
  editContent->SetText(package.GetDependencies());
  editContent->Disable();

  view=new Lum::View();
  view->SetFlex(true,true);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,40);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  view->SetObject(edit);

  tab->Add(L"Dependencies",view);

  vPanel->Add(tab);

  vPanel->Add(new Lum::VSpace());

  row=Lum::ButtonRow::CreateClose(GetClosedAction());
  row->SetFlex(true,false);
  vPanel->Add(row);

  SetMain(vPanel);

  Lum::Dialog::PreInit();
}

void PackageDetails::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }

  Lum::Dialog::Resync(model,msg);
}
