/*
 * Copyright: (C) 2010 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */


#include "otrplayer_thread.h"

#include "aflib/aflibConfig.h"
#include "aflib/aflibFile.h"
#include "aflib/aflibData.h"
#include "aflib/aflibFile.h"
#include "aflib/aflibAudioFile.h"

#include "mad.h"
#include <sys/types.h>
#include <sys/stat.h>


// Constructor
otrplayer_thread::otrplayer_thread()
{
}

// Destructor
otrplayer_thread::~otrplayer_thread()
{
}

void
otrplayer_thread::setName(QString str)
{
   name = str;
}

QString&
otrplayer_thread::getName()
{
   return name;
}

void
otrplayer_thread::setOffset(long offset)
{
   long_offset = offset;
}

int
otrplayer_thread::getKBPS()
{
   return kbps;
}

int
otrplayer_thread::getTotalSec()
{
   return total_sec;
}

int
otrplayer_thread::getSeconds()
{
   return sec;
}

int
otrplayer_thread::getSamplesPerSecond()
{
   return samplespersecond;
}

void
otrplayer_thread::run()
{
   std::string str = name.toStdString();
   aflibFile  *temp;
   aflibConfig  input_config;
   aflibStatus  status;
   bool         ret_value;
   struct mad_stream stream;
   struct mad_header header;
   unsigned char buf[10240];
   const unsigned char *ptr = NULL;
   unsigned long len = 0;
   FILE *fd;
   long long samples;
   struct stat  stat_buf;

   kbps = 0;
   total_sec = 0;
   sec = 0;
   samplespersecond = 0;
   if (name.endsWith(".mp3", Qt::CaseInsensitive) == true)
   {
      fd = fopen(str.c_str(), "r");
      len = fread(buf, 1, 4000, fd);
      fclose(fd);
      ptr = buf;

      mad_stream_init(&stream);
      mad_header_init(&header);

      mad_stream_buffer(&stream, ptr, len);

      while (header.samplerate == 0)
      {
         if (mad_header_decode(&header, &stream) == -1)
         {
           if (MAD_RECOVERABLE(stream.error))
              continue;
           else
              break;
         }
      }

      kbps = header.bitrate / 1000;
      samplespersecond = header.samplerate;

      if (header.samplerate != 0)
      {
         stat(str.c_str(), &stat_buf);
         samples = (long long)((double)stat_buf.st_size / kbps * 8.0 /
                 1000.0 * header.samplerate);

         total_sec = samples/header.samplerate;
         // round up to next second
         total_sec++;
      }

      if (header.samplerate != 0)
      {
         // IF -1 we are at end of file
         if (long_offset == -1)
            sec = total_sec;
         else
            sec = long_offset / header.samplerate;
      }

      mad_header_finish(&header);
      mad_stream_finish(&stream);
  }
  else
  {
      temp = aflibFile::open(AFLIB_AUTO_TYPE, str,
               &input_config, &status);

      if (temp)
      {
         ret_value = temp->getItem("kbps", (void *)&kbps);
         if (ret_value == FALSE)
            kbps = 0;
      }

      if (input_config.getSamplesPerSecond() != 0)
      {
         samplespersecond = input_config.getSamplesPerSecond();
         total_sec = input_config.getTotalSamples()/input_config.getSamplesPerSecond();
         // round up to next second
         total_sec++;
      }

      if (input_config.getSamplesPerSecond() != 0)
      {
         // IF -1 we are at end of file
         if (long_offset == -1)
            sec = total_sec;
         else
            sec = long_offset / input_config.getSamplesPerSecond();
      }

      delete temp;
  }
}

