/*
 * Copyright: (C) 2009 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */

#ifndef OTRPLAYER_AUDIO_H
#define OTRPLAYER_AUDIO_H

#include <qwidget.h>
#include <qstring.h>

class QStringList;
class Q3ListView;
class QSlider;
class QMultiLineEdit;
class QApplication;
class aflibAudioFile;
class aflibAudioPitch;

class otrplayer_audio : public QObject
{ 

public:
   otrplayer_audio(
      Q3ListView *lst,
      QSlider   *slider,
      QMultiLineEdit* edit,
      QApplication  *app);
   ~otrplayer_audio();

   void
   play();

   void
   stop();

   void
   setPitchEnabled(bool value);

   bool
   getPitchEnabled();

   void
   pitchFactor(double val);

   void
   getData(
      QString&   filepath,
      long long& sams_per_sec,
      long long& total_sams,
      int&       kbps);

   void
   setup(
      QString& file,
      int&       samples_per_second,
      int&       channels);

   void
   setStop(bool stop);

   bool
   getStop();

   void
   seekSeconds(int sec);

   long long
   getTotalSize();

   void
   setCurrentPosition(long long pos);

   long long
   getCurrentPosition();

   aflibAudioFile *
   getOutput();

   Q3ListView *
   getPlayList();

   QSlider *
   getSlider();

   long long
   getSamplesSecond();

   void
   secondsToQString(
      int sec,
      QString&  str);

   QApplication *
   getApp();

   QMultiLineEdit *
   getInfoEdit();

   void
   displayID3(QString& file_str);


private:

//   void *
//   run(void *parm);



aflibAudioFile   *_input;
aflibAudioFile   *_output;
aflibAudioPitch  *_pitch;
bool              _pitch_enabled;
bool              _stop;
Q3ListView        *_playList;
QSlider          *_timeSlider;
QMultiLineEdit   *_infoEdit;
long long         _current_position;
long long         _total_size;
int               _samples_per_second;
int               _channels;
QApplication     *_app;


};

#endif // OTRPLAYER_AUDIO_H
