/*
 * Copyright: (C) 2009 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */

#ifndef MYQ3LISTVIEWITEM_H
#define MYQ3LISTVIEWITEM_H

#include <q3listview.h>

class MyQ3ListViewItem : public Q3ListViewItem
{
public:
   MyQ3ListViewItem(Q3ListView * parent);
   MyQ3ListViewItem(MyQ3ListViewItem * parent);
   MyQ3ListViewItem(Q3ListView * parent, MyQ3ListViewItem * after);
   MyQ3ListViewItem(MyQ3ListViewItem * parent, MyQ3ListViewItem * after);
   MyQ3ListViewItem(Q3ListView * parent,
          const QString&, const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString());
   MyQ3ListViewItem(MyQ3ListViewItem * parent,
          const QString&,             const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString());
   MyQ3ListViewItem(Q3ListView * parent, MyQ3ListViewItem * after,
          const QString&,             const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString());
   MyQ3ListViewItem(MyQ3ListViewItem * parent, MyQ3ListViewItem * after,
          const QString&,             const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString(),
          const QString& = QString(), const QString& = QString());
   virtual ~MyQ3ListViewItem();

    // We override this method for sorting
   int
   compare(Q3ListViewItem * i, int col, bool ascending) const;

};

#endif
