import gtk

class AdjustmentWindow:

     def __init__(self):
         self.smalllist = ['A', 'List', 'of', 'short', 'data']
         self.largelist = ['This list has much wider rows.', 'Notice how the horizontal scrollbar appears.', 'This scrollbar should go away when we reload the short list.']
         self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
         self.window.connect('delete_event', self.delete_event)
         self.windowbox = gtk.VBox(False, 0)
         self.buttonbox = gtk.HBox(True, 0)
         
         self.smalllistbutton = gtk.Button('Small List')
         self.smalllistbutton.connect('clicked', self.populate, self.smalllist)
         self.largelistbutton = gtk.Button('Large List')
         self.largelistbutton.connect('clicked', self.populate, self.largelist)
         
         self.scrollwindow = gtk.ScrolledWindow()
         self.scrollwindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
         self.scrollwindow.set_size_request(200,200)
         
         self.listdata = gtk.ListStore(str)
         self.listview = gtk.TreeView(self.listdata)
         self.listcell = gtk.CellRendererText()
         self.listcolumn = gtk.TreeViewColumn('List', self.listcell, markup=0)
         self.listview.append_column(self.listcolumn)
         
         self.buttonbox.pack_start(self.smalllistbutton)
         self.buttonbox.pack_start(self.largelistbutton)
         self.windowbox.pack_start(self.buttonbox, False)
         self.scrollwindow.add(self.listview)
         self.windowbox.pack_start(self.scrollwindow)
         self.window.add(self.windowbox)
         self.window.show_all()
         
     def populate(self, widget, list):
         self.listdata.clear()
         for row in list:
             self.listdata.append([row])
     
     def delete_event(self, widget, event, data=None):
         gtk.main_quit()
         return False
         
def main():
     gtk.main()

if __name__ == "__main__":
     window = AdjustmentWindow()
     main()
