import gtk

class Ui(gtk.Dialog):
    """
    Simple UI interface for tag management
    """
    def __init__(self, title="Confirm", msg="Are you sure?"):
        gtk.Dialog.__init__(self, title,
                 None,#somewidget.get_toplevel(),  #the toplevel wgt of your app
                 gtk.DIALOG_DESTROY_WITH_PARENT,  #binary flags or'ed together gtk.MODAL_DIALOG
                 (
                  "OK", gtk.RESPONSE_OK, 
                  "Cancel", gtk.RESPONSE_CANCEL))
        label = gtk.Label(msg)
        self.vbox.pack_start(label, True, True, 0)
        label.show()
        #self.show()
        
def showDialog(title="Confirm"):
    dialog = Ui(title)
    result = dialog.run()
    dialog.destroy()
    return result == gtk.RESPONSE_OK

if __name__ == "__main__":
    import sys
    sys.path.append("..")
    from lgc import mutils
    mutils.enableBtnImages(gtk.Button())
    print showDialog()