import os, gtk, sys, traceback

THUMB_W = 90



def getImgPath(filename):
    if os.path.isfile("/usr/share/pixmaps/"+filename):
        return "/usr/share/pixmaps/"+filename
    if os.path.isfile("../images/"+filename):
        return "../images/"+filename
    print "failed to get resource "+filename
    return ""

def loadPixbuf(filename, w, h):
    try:
        img = gtk.gdk.pixbuf_new_from_file_at_size(getImgPath(filename), w, h)
        if img == None: #OS2007?
            img = gtk.gdk.pixbuf_new_from_file(getImgPath(filename))
        return img
    except:
        print "error: cannot find pixbuf "+filename
        return None

def deleteStored(video):
    url = video.url
    storeDir = Cfg.VIDEO_DIR + os.path.sep + video.getVideoId()
    try:
        print "rmdir "+storeDir
        #os.rmdir(storeDir)
        if sys.platform != "win32":
            os.system("rm -rf -- \"%s\" " %storeDir)
        else:
            os.system("rd /Q /S \"%s\" " %storeDir)
            print "rd /Q /S \"%s\" " %storeDir
        return True
    except:
        print "failed to delete the folder %s" %(storeDir)
        return False

def storeCachedVideo(video):
    cache = Cfg.CACHE_DIR+os.path.sep+video.getVideoId()
    store = Cfg.VIDEO_DIR+os.path.sep+video.getVideoId()
    try:
        cmd = "mv  \""+cache+"\" \""+store+"\""
        #if sys.platform == "win32":
        #    cmd = "md /Q /S \"%s\" \"%s\"" %(cache,store)
        print cmd
        os.system(cmd)
        return True
    except:
        mutils.log("failed to store cached  %s" %(cache))
        return False

def safeFsString(string):
    #does vfat support utf?
    string1 = string.encode('ascii', 'ignore')
    #TODO: check here
    for c in [" ", "\"", "\'", "/", "?", "!", ":"]:
        string1 = string1.replace(c, ".")
    #remove multiple dots
    string1 = string1.split(".")
    string1 = ".".join([tok for tok in string1 if len(tok) > 0])
    string1 = string1.strip(".")
    return string1

def getVideoStoragePath(video):
        url = video.url
        title = safeFsString(video.title)
        #try first with legacy storage location
        storePath = Cfg.VIDEO_DIR+os.path.sep+video.getVideoId()+os.path.sep+"vid.flv"
        #try the new filename
        if not os.path.exists(storePath):
            storePath = Cfg.VIDEO_DIR+os.path.sep+video.getVideoId()+os.path.sep+title+".flv"
        return storePath

def getVideoCachePath(video):
    url = video.url
    title = safeFsString(video.title)
    cachePath = Cfg.CACHE_DIR+os.path.sep+video.getVideoId()+os.path.sep+title+".flv"
    return cachePath


def storeVideo(video, cached):
    try:
        url = video.url
        storeDir = Cfg.VIDEO_DIR+os.path.sep+video.getVideoId()
        if (cached):
            storeDir = Cfg.CACHE_DIR+os.path.sep+video.getVideoId()
        if not os.path.exists(storeDir):
            os.makedirs(storeDir)
        video.thumbpix.save(storeDir + os.path.sep + "thumb.png", "png")
        file = open(storeDir + os.path.sep + "info", "w")
        file.write(video.serializeToString())
        file.close()
    except:
        traceback.print_exc(file=sys.stdout)
        return False
    return True

#load an youtube entry from the fs
def loadVideoFromFile(path):
    videoId = path
    fentry = Cfg.VIDEO_DIR + os.path.sep + path
    try:
        thumbPixbuf =  gtk.gdk.pixbuf_new_from_file_at_size(fentry+os.path.sep+"thumb.png", THUMB_W, -1)
    except:
        print sys.exc_info()[1]
        thumbPixbuf = THUMB_LOAD        
    
    #read from file
    duration = 0;
    title = "[default]";
    href_url = "http://www.youtube.com/watch?v="+videoId;
    rating = 1;
    finfo = None;
    yentry = YEntry(title, href_url , "authoR", "tagS", None, "file://"+fentry+"/thumb.png");
    yentry.setThumbPix(thumbPixbuf);
    
    try:
        finfo = open(fentry+"/info", "r");
        data = finfo.read(-1);
        yentry.deserializeFromString(data);
        finfo.close();
        updateEntrySize(yentry);
    except:
        if finfo != None:
            finfo.close();
        print sys.exc_info();
    
    return yentry




def loadImage(filename, w, h):
    pb = loadPixbuf(filename, w, h)
    if pb == None:
        return None
    img = gtk.Image();
    img.set_from_pixbuf(pb)
    return img

def loadPixbufMem(data):
    pixbufLoader = gtk.gdk.PixbufLoader()
    id = pixbufLoader.connect("size-prepared", cb_sizePrepared, None)
    pixbufLoader.write(data)
    pixbufLoader.close()
    pixbuf = pixbufLoader.get_pixbuf()
    return pixbuf

def cb_sizePrepared(pixbufloader, w, h, param1 = None):
    pixbufloader.set_size(THUMB_W, (int)(h*THUMB_W/w))

def updateEntrySize(yentry):
    filenames = [getVideoStoragePath(yentry), getVideoCachePath(yentry)]
    for filename in filenames:
        if os.path.isfile(filename):
            yentry.downloadedKb = os.path.getsize(filename) >> 10
            yentry.percentDl = 100
            return True
    return False

THUMB_LOAD = loadPixbuf("mytubeload.png", THUMB_W, -1)


    
#i'm allowed to do that :), python n00b
from conf import Cfg
from yentry import YEntry
from string import atoi
from string import atof
