import gtk
from ..lgc import mutils

"""
Simple UI interface for tag management
"""
class Ui(gtk.Dialog):
    def __init__(self, ext_add=None, ext_del=None):
        gtk.Dialog.__init__(self, 'Manage tags',
                 None,#somewidget.get_toplevel(),  #the toplevel wgt of your app
                 gtk.DIALOG_DESTROY_WITH_PARENT,  #binary flags or'ed together gtk.MODAL_DIALOG
                 (
                  #"Play Now", 77, 
                  ))
        self.ext_add = ext_add
        self.ext_del = ext_del
        self.set_default_size(360, -1)
        
        hbox = gtk.HBox(False, 0)
        vbox = gtk.VBox(False, 0)
        
        self.liststore = gtk.ListStore(str)
        self.treeView = gtk.TreeView(self.liststore)
        self.treeView.set_headers_visible(False)
        treeColumn = gtk.TreeViewColumn("tags");
        cell = gtk.CellRendererText();
        treeColumn.pack_start(cell, True)
        treeColumn.set_attributes(cell, text=0)
        self.treeView.append_column(treeColumn);
        self.treeView.set_size_request(120, -1)
        self.treeView.show()
        
        table = gtk.Table(3,1,False)
        
        self.txtTag = gtk.Entry()
        self.txtTag.set_size_request(120, -1)
        
        btnAdd = gtk.Button("Add+")
        btnAdd.set_size_request(-1, 60)
        btnDel = gtk.Button("Del-")
        btnDel.set_size_request(-1, 60)
        btnCls = gtk.Button("Close")
        btnCls.set_size_request(-1, 60)
        
        table.attach(btnAdd, 0, 1, 0, 1)
        table.attach(btnDel, 0, 1, 1, 2)
        table.attach(btnCls, 0, 1, 2, 3)
        
        #scroll view
        scrollview = gtk.ScrolledWindow()
        mutils.enableFriendlyScroll(scrollview, True)
        scrollview.show()
        scrollview.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrollview.add(self.treeView)

        #pack into the dialog
        
        vbox.pack_start(self.txtTag, False, False, 0)
        vbox.pack_end(scrollview, True, True, 0)
        
        hbox.pack_start(vbox, True, True, 0)
        hbox.pack_end(table, False, False, 0)
        
        self.vbox.pack_start(hbox)
        self.show_all()
        self.show()
        
        #setup callbacks
        btnAdd.connect("clicked", self.cb_add)
        btnDel.connect("clicked", self.cb_del)
        btnCls.connect("clicked", self.cb_close)
        
    def getSelectedTag(self):
        try:
            treeSelection = self.treeView.get_selection()
            list,paths = treeSelection.get_selected_rows()
            tagname = list[paths[0][0]][0]  
            return tagname
        except:
            return None  
    
    def cb_add(self, widget):
        from ..lgc import mutils
        newtag = self.txtTag.get_text()
        if len(newtag) < 1:
            mutils.info("enter a tag name")
            return
        #no callback
        if self.ext_add == None:
            return
        if not self.ext_add(newtag):
            mutils.info("error adding tag")
            return
        self.liststore.prepend([newtag])
    
    def cb_del(self, widget):
        from ..lgc import mutils
        import confirm
        if not confirm.showDialog("delete tag"):
            lgc.mutils.info("you should be sure")
            return
        deltag = self.getSelectedTag()
        
        if self.ext_del == None or deltag == None:
            return
        
        if not self.ext_del(deltag):
            lgc.mutils.info("error deleting tag")
            return
        iter = self.liststore.get_iter_first()
        
        while iter != None:
            val = self.liststore.get_value(iter, 0)
            if deltag == val:
                self.liststore.remove(iter)
                return
            iter = self.liststore.iter_next(iter)
        lgc.mutils.info("something wrong deleting tag")
    
    def cb_close(self, widget):
        self.response(gtk.RESPONSE_NONE)
            

def showDialog(list, ext_add, ext_del):
    dialog = Ui(ext_add, ext_del)
    for listname in list:
        if listname != None:
            dialog.liststore.append([listname])
    result = dialog.run()
    dialog.destroy()