import sys, os, os.path, urllib, urllib2, gtk
from threading import Thread, Semaphore
from yclient import YClient
from conf import Cfg
from yentry import YEntry
import mutils,session,ystorage
#import thread

class YBgWorker(Thread):    
    def __init__(self, gui):
        Thread.__init__(self)
        self.gui = gui
        self.mustExit = False
        self.mustCancel = False
        self.waitCmd = Semaphore(0)
        self.doneCmd = Semaphore(1)
        self.requestCrt = []
        self.requestLast = None
        self.urlThumb = None
    
    def run(self):
        #TODO: lower priority
        #print "bg worker id  ",thread.get_ident()
        while not self.mustExit:
            self.waitCmd.acquire()
            print "bgworker got a job "
            if len(self.requestCrt) == 0:
                continue #do nothing
            elif self.requestCrt == None:
                print "bg worker fired as well"
                return
            else:
                try:
                    self.work()
                except:
                    mutils.log(sys.exc_info()[1])
                #cleanup working request
                self.requestLast = self.requestCrt
                self.requestCrt = []
                self.doneCmd.release()
                
    def work(self):
        gui = self.gui
        
        requestType = self.requestCrt[0]
        searchString = self.requestCrt[1]
        startIdx = self.requestCrt[2]
        maxResuls = self.requestCrt[3]
        date = self.requestCrt[4]
        sort = self.requestCrt[5]
        videos = list()

        cli = YClient(date)
        #create entries fast
        if requestType == session.TYPE_SEARCH:
            if (searchString.startswith("http://www.youtube.com/watch") or searchString.startswith("http://youtube.com/watch")):
                vid = searchString.split("=")[1].split("&")[0]
                print "searching by id = " + vid
                receivedVideos = cli.search_video_by_id(vid);
            else:
                print "searching some string"
                receivedVideos = cli.search_video(urllib.quote(searchString), startIdx, maxResuls);            
        elif requestType == session.TYPE_TOPRATED:
            print "searching top rated"
            receivedVideos = cli.get_toprated(startIdx, maxResuls);
        elif requestType == session.TYPE_MOSTVIEWED:
            print "searching most viewed"
            receivedVideos = cli.get_mostviewed(startIdx, maxResuls);
        elif requestType == session.TYPE_FEATURED:
            print "searching featured"
            receivedVideos = cli.get_recentlyfeatured(startIdx, maxResuls);
        elif requestType == session.TYPE_DIRECT_FEED:
            print "searching direct feed"
            receivedVideos = cli.search_direct_feed(searchString, startIdx, maxResuls); #search string is used to carry the feed url
        elif requestType == session.TYPE_BY_AUTHOR:
            print "searching by author"
            receivedVideos = cli.videos_upload_by(searchString, startIdx, maxResuls);
        elif requestType == session.TYPE_BY_CAT:
            print "searching category"
            receivedVideos = cli.get_by_category(searchString, startIdx, maxResuls);
        elif requestType == session.TYPE_LOCAL:
            print "searching local ",searchString," ",startIdx," ",maxResuls
            receivedVideo = self.work_get_local(searchString, startIdx, maxResuls, sort)
            return
    
        else:
            print "unknown search"
            return
        
        for video in receivedVideos:
            yentry = YEntry.loadVideoFromResp(video, cli)
            videos.append(yentry)
            gui.addEntry([yentry])
        
        #start adding images
        for idx in range(len(videos)):
            if self.mustCancel:
                break
            video = videos[idx]
            thumb_url = video.thumburl
            print "bgworker -> %s" %thumb_url
            self.urlThumb = urllib2.urlopen(thumb_url)
            data = self.urlThumb.read()
            thumb_pixbuf = ystorage.loadPixbufMem(data)
            #os.remove(file_tmpname)
            video.setThumbPix(thumb_pixbuf)
            gui.updateEntry(idx, video)
        return
    
    def work_get_local(self, listname, startIdx, maxResults, sort=session.SORT_NONE):
        if not os.path.exists(Cfg.VIDEO_DIR):
            return
        index = 0
        
        from . import mtags
        
        for fentry in mtags.getMTag(listname).getList(sort):
            #to be a valid record some files must be there
            if not os.path.isfile(Cfg.VIDEO_DIR+os.path.sep+fentry+os.path.sep+"info"):
                print "---skipping (no info) ", fentry
                continue
            index += 1
            if index >= startIdx and index < startIdx+maxResults:
                pass #create entries
            else:
                continue
            yentry = ystorage.loadVideoFromFile(fentry)
            self.gui.addEntry([yentry])
        return
    
    def isBusy(self):
        if self.requestCrt != None and len(self.requestCrt) > 0:
            return True
        return False
    
    def addRequest(self, requestInfo):
        if self.isBusy():
            print "worker is busy, cancel current request"
            self.cancelCrtRequest()
            #return False
        print "worker adding request"
        self.doneCmd.acquire()
        #self.gui.treeColumn.set_title("videos ["+str(requestInfo[2])+"-"+str(requestInfo[2]+requestInfo[3])+"]")
        self.gui.window.set_title("("+str(requestInfo[2])+"-"+str(requestInfo[2]+requestInfo[3])+")")
        self.mustCancel = self.mustExit = False
        self.requestCrt = requestInfo
        self.waitCmd.release()
        
        return True
    
    def addRequestNext(self, maxResults):
        if (self.requestLast == None):
            print "make a request first"
            return
        requestNext = self.requestLast
        requestNext[2] += requestNext[3]
        requestNext[3] = maxResults
        self.addRequest(requestNext)
        
    def addRequestPrev(self, maxResults):
        if (self.requestLast == None):
            print "make a request first"
            return
        requestPrev = self.requestLast
        requestPrev[2] = max(requestPrev[2] - requestPrev[3], 1)
        requestPrev[3] = maxResults
        self.addRequest(requestPrev)
   
    def cancelCrtRequest(self):
        self.mustCancel = True
        self.urlThumb.close()

    #TODO: make a request to cancel the previous one
    def repeatRequest(self, date):
        if (self.requestLast == None):
            print "make a request first"
            return
        self.requestLast[4] = date
        self.addRequest(self.requestLast)
    
    def terminate(self):
        self.mustExit = True
        self.waitCmd.release()
        self.join(1000)
        print "bgworker terminated"
