import gtk
class ComboBox(gtk.ComboBox):
             "A combobox"
     
             def __init__(self, model = None):
                     gtk.ComboBox.__init__(self, model)
     
                     self.model = model
     
                     self.connect("realize", self.__cb_realize)
     
     
             def __cb_realize(self, widget, data = None):
                     "Callback for when the combobox is realized"
     
                     if self.get_active() == -1:
                             self.set_active(0)
     
     
             def clear(self):
                     "Clears the combobox"
     
                     self.model.clear()
     
     
             def get_size(self):
                     "Returns the size (number of rows) in the combobox"
     
                     if self.model:
                             return self.model.iter_n_children(None)
     
                     else:
                             return 0
     
     
             def set_model(self, model = None):
                     "Sets the model for the combobox"
     
                     gtk.ComboBox.set_model(self, model)
     
                     self.model = model
                     
     
class SimpleComboBox(ComboBox):
             "A simple combo box with text and optionally icons"
     
             def __init__(self, use_icons = False):
                     ComboBox.__init__(self)
     
                     self.use_icons = use_icons
     
                     # FIXME we should use shinygnome ListStore when implemented
                     self.set_model(gtk.ListStore(str, gtk.gdk.Pixbuf, object, object))
     
                     # FIXME we should use cellrenderers from shinygnome when implemented
                     if use_icons:
                             cr = gtk.CellRendererPixbuf()
                             #cr.set_fixed_size(gtk.icon_size_lookup(gtk.ICON_SIZE_SMALL_TOOLBAR)[0], -1)
                             self.pack_start(cr, False)
                             self.add_attribute(cr, "pixbuf", 1)
     
                     cr = gtk.CellRendererText()
                     self.pack_start(cr, True)
                     self.add_attribute(cr, "text", 0)
                     
                     self.connect("changed", self.cb_changed)
             
             def cb_changed(self, widget):
                     txt, pixbuf, cb, param1 = self.get_active_item()
                     print "changed "+txt
                     cb(self, param1)
     
             def append_item(self, text, pixbuf = None, data = None,  param1 = None):
                     "Appends an item to the combobox"
     
                     self.model.append(( text, pixbuf, data, param1))
     
     
             def get_active_item(self):
                     "Returns a tuple with data for the current item"
     
                     iter = self.model.iter_nth_child(None, self.get_active())
     
                     return self.model.get(iter, 0, 1, 2, 3)
     
     
             def get_item(self, index):
                     "Returns a tuple with data for the current item"
     
                     return self.model.get(self.model.iter_nth_child(None, index), 0, 1, 2)
     
     
             def insert_item(self, index, text, stock = None, data = None):
                     "Inserts an item in the dropdown"
     
                     self.model.insert(index, ( text, stock, data ))
     
     
             def prepend_item(self, text, stock = None, data = None):
                     "Prepends an item to the dropdown"
     
                     self.insert_item(0, text, stock, data)
     
     
             def remove_item(self, index):
                     "Removes an item from the dropdown"
     
                     if self.get_size() > index:
                             self.model.remove(self.model.iter_nth_child(None, index))